/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.phonehome.google.analytics;

import com.blackduck.integration.phonehome.request.PhoneHomeRequestBody;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class GoogleAnalyticsRequestTransformer {
    private final List<NameValuePair> parameters = new ArrayList<NameValuePair>();
    private JsonObject payload = new JsonObject();
    private final PhoneHomeRequestBody phoneHomeRequestBody;
    private final String measurementId;
    private final String apiSecret;
    private final Gson gson;

    public GoogleAnalyticsRequestTransformer(Gson gson, String apiSecret, String measurementId, PhoneHomeRequestBody phoneHomeRequestBody) {
        this.gson = gson;
        this.phoneHomeRequestBody = phoneHomeRequestBody;
        this.apiSecret = apiSecret;
        this.measurementId = measurementId;
    }

    public List<NameValuePair> getParameters() {
        this.addParameter("api_secret", this.apiSecret);
        this.addParameter("measurement_id", this.measurementId);
        return this.parameters;
    }

    private String getFormattedHitDate() {
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        return currentDate.format(dateTimeFormatter);
    }

    public JsonObject getPayload() {
        String clientId = this.generateClientId(this.phoneHomeRequestBody.getCustomerId(), this.phoneHomeRequestBody.getHostName());
        JsonObject eventParams = new JsonObject();
        eventParams.addProperty("customer_id", this.phoneHomeRequestBody.getCustomerId());
        eventParams.addProperty("artifact_id", this.phoneHomeRequestBody.getArtifactId());
        eventParams.addProperty("artifact_version", this.phoneHomeRequestBody.getArtifactVersion());
        eventParams.addProperty("host_name", this.phoneHomeRequestBody.getHostName());
        eventParams.addProperty("metadata", this.gson.toJson(this.phoneHomeRequestBody.getMetaData()));
        eventParams.addProperty("product_id", this.phoneHomeRequestBody.getProductName());
        eventParams.addProperty("product_version", this.phoneHomeRequestBody.getProductVersion());
        eventParams.addProperty("hit_date", this.getFormattedHitDate());
        JsonObject eventObject = new JsonObject();
        eventObject.addProperty("name", "bd_hit");
        eventObject.add("params", (JsonElement)eventParams);
        JsonArray eventsArray = new JsonArray();
        eventsArray.add((JsonElement)eventObject);
        this.payload.addProperty("client_id", clientId);
        this.payload.add("events", (JsonElement)eventsArray);
        return this.payload;
    }

    private void addParameter(String key, String value) {
        BasicNameValuePair parameter = new BasicNameValuePair(key, value);
        this.parameters.add((NameValuePair)parameter);
    }

    private String generateClientId(String customerId, String hostName) {
        String clientId = !"<unknown>".equals(customerId) ? customerId : (!"<unknown>".equals(hostName) ? hostName : "<unknown>");
        byte[] bytesFromString = clientId.getBytes();
        return UUID.nameUUIDFromBytes(bytesFromString).toString();
    }
}

