/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.phonehome.google.analytics;

import com.blackduck.integration.phonehome.google.analytics.GoogleAnalyticsRequestTransformer;
import com.blackduck.integration.phonehome.request.PhoneHomeRequestBody;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;

public class GoogleAnalyticsRequestHelper {
    private final Gson gson;

    public GoogleAnalyticsRequestHelper(Gson gson) {
        this.gson = gson;
    }

    public HttpPost createRequest(PhoneHomeRequestBody phoneHomeRequestBody, String overrideUrl, String apiSecret, String measurementId) throws UnsupportedEncodingException, URISyntaxException {
        String requestUrl = overrideUrl;
        if (StringUtils.isBlank((CharSequence)requestUrl)) {
            requestUrl = "https://www.google-analytics.com/mp/collect";
        }
        URIBuilder uriBuilder = new URIBuilder(requestUrl);
        GoogleAnalyticsRequestTransformer transformer = new GoogleAnalyticsRequestTransformer(this.gson, apiSecret, measurementId, phoneHomeRequestBody);
        List<NameValuePair> parameters = transformer.getParameters();
        uriBuilder.addParameters(parameters);
        HttpPost httpPost = new HttpPost(uriBuilder.build());
        httpPost.setHeader("Content-Type", "application/json");
        JsonObject payloadJson = transformer.getPayload();
        StringEntity payload = new StringEntity(payloadJson.toString());
        httpPost.setEntity((HttpEntity)payload);
        return httpPost;
    }

    private List<NameValuePair> createModuleParameters(List<NameValuePair> parameters, String module) {
        BasicNameValuePair parameter = new BasicNameValuePair("module_id", module);
        ArrayList<NameValuePair> newParameters = new ArrayList<NameValuePair>(parameters);
        newParameters.add((NameValuePair)parameter);
        return newParameters;
    }
}

