/*
 * Decompiled with CFR 0.152.
 */
package com.mwdle.bitwarden.cli;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.mwdle.bitwarden.BitwardenConfig;
import com.mwdle.bitwarden.BitwardenCredentialsProvider;
import com.mwdle.bitwarden.cli.BitwardenCLI;
import com.mwdle.bitwarden.model.BitwardenStatus;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.Secret;
import java.io.IOException;
import java.util.Collections;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class BitwardenSessionManager {
    private static final BitwardenSessionManager INSTANCE = new BitwardenSessionManager();
    private static final Logger LOGGER = Logger.getLogger(BitwardenSessionManager.class.getName());
    private final Object lock = new Object();
    private volatile Secret sessionToken;

    private BitwardenSessionManager() {
    }

    public static BitwardenSessionManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Secret getSessionToken() throws IOException, InterruptedException {
        if (this.isSessionValid()) {
            LOGGER.fine("Cached Bitwarden session token is valid. Returning cached token.");
            return this.sessionToken;
        }
        LOGGER.fine("Token invalid or missing. Attempting to acquire lock to refresh token.");
        Object object = this.lock;
        synchronized (object) {
            if (this.isSessionValid()) {
                LOGGER.fine("Another thread refreshed the token while waiting for lock. Returning refreshed token.");
                return this.sessionToken;
            }
            BitwardenConfig config = BitwardenConfig.getInstance();
            StandardUsernamePasswordCredentials apiKey = Jenkins.get().getExtensionList(CredentialsProvider.class).stream().filter(p -> !(p instanceof BitwardenCredentialsProvider)).flatMap(p -> p.getCredentialsInItemGroup(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.get(), ACL.SYSTEM2, Collections.emptyList()).stream()).filter(c -> c.getId().equals(config.getApiCredentialId())).findFirst().orElse(null);
            StringCredentials masterPassword = Jenkins.get().getExtensionList(CredentialsProvider.class).stream().filter(p -> !(p instanceof BitwardenCredentialsProvider)).flatMap(p -> p.getCredentialsInItemGroup(StringCredentials.class, (ItemGroup)Jenkins.get(), ACL.SYSTEM2, Collections.emptyList()).stream()).filter(c -> c.getId().equals(config.getMasterPasswordCredentialId())).findFirst().orElse(null);
            if (apiKey == null || masterPassword == null) {
                throw new IOException("Could not find API Key or Master Password credentials. Cannot refresh Bitwarden session token.");
            }
            LOGGER.info("Found Bitwarden API key and Master Password. Fetching new Bitwarden session token.");
            this.sessionToken = this.getNewSessionToken(apiKey, masterPassword, config.getServerUrl());
            return this.sessionToken;
        }
    }

    public boolean isSessionValid() {
        if (this.sessionToken == null) {
            LOGGER.fine("Session token is null \u2014 not valid.");
            return false;
        }
        try {
            BitwardenStatus response = BitwardenCLI.status(this.sessionToken);
            return response.getStatus().equals("unlocked");
        }
        catch (Exception e) {
            LOGGER.warning("Failed to check Bitwarden session token status: " + e.getMessage());
            return false;
        }
    }

    private Secret getNewSessionToken(StandardUsernamePasswordCredentials apiKey, StringCredentials masterPassword, String serverUrl) throws IOException, InterruptedException {
        BitwardenCLI.logout();
        if (serverUrl == null || serverUrl.isEmpty()) {
            LOGGER.fine("Server URL not set. Using default.");
            serverUrl = "https://vault.bitwarden.com";
        }
        BitwardenCLI.configServer(serverUrl);
        BitwardenCLI.login(apiKey);
        return BitwardenCLI.unlock(masterPassword);
    }

    public void invalidateSessionToken() {
        this.sessionToken = null;
        LOGGER.info("Session token has been invalidated.");
    }
}

