/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucket.webhook.moveworkforward.v1;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticatedClient;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketWebHook;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookManager;
import com.damnhandy.uri.template.UriTemplate;
import com.google.common.base.Objects;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import io.jenkins.plugins.bitbucket.webhook.JsonParser;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor.PostWebhooksEventType;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.v1.PostWebhookPayload;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.v1.PostWebhooksConfiguration;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.v1.trait.PostWebhooksConfigurationTrait;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import jenkins.scm.api.trait.SCMSourceTrait;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

@Extension
public class PostWebhooksManager
implements BitbucketWebhookManager {
    private static final String WEBHOOK_API = "/rest/webhook/1.0/projects/{owner}/repos/{repo}/configurations{/id}";
    private static final Logger logger = Logger.getLogger(PostWebhooksManager.class.getName());
    private static final List<PostWebhooksEventType> PLUGIN_SERVER_EVENTS = List.of(PostWebhooksEventType.ABSTRACT_REPOSITORY_REFS_CHANGED, PostWebhooksEventType.BRANCH_CREATED, PostWebhooksEventType.BRANCH_DELETED, PostWebhooksEventType.PULL_REQUEST_DECLINED, PostWebhooksEventType.PULL_REQUEST_DELETED, PostWebhooksEventType.PULL_REQUEST_MERGED, PostWebhooksEventType.PULL_REQUEST_OPENED, PostWebhooksEventType.PULL_REQUEST_REOPENED, PostWebhooksEventType.PULL_REQUEST_UPDATED, PostWebhooksEventType.REPOSITORY_MIRROR_SYNCHRONIZED, PostWebhooksEventType.TAG_CREATED);
    private PostWebhooksConfiguration configuration;
    private String callbackURL;
    private String committersToIgnore;
    private String branchesToIgnore;
    private boolean skipCI;

    public Collection<Class<? extends SCMSourceTrait>> supportedTraits() {
        return List.of(PostWebhooksConfigurationTrait.class);
    }

    public void apply(SCMSourceTrait trait) {
        if (trait instanceof PostWebhooksConfigurationTrait) {
            PostWebhooksConfigurationTrait cfgTrait = (PostWebhooksConfigurationTrait)trait;
            this.committersToIgnore = Util.fixEmptyAndTrim((String)cfgTrait.getCommittersToIgnore());
            this.branchesToIgnore = Util.fixEmptyAndTrim((String)cfgTrait.getBranchesToIgnore());
            this.skipCI = cfgTrait.isSkipCI();
        }
    }

    public void apply(BitbucketWebhookConfiguration configuration) {
        this.configuration = (PostWebhooksConfiguration)configuration;
    }

    public void setCallbackURL(@NonNull String callbackURL, @NonNull BitbucketEndpoint endpoint) {
        this.callbackURL = UriTemplate.buildFromTemplate((String)callbackURL).query(new String[]{"server_url"}).build().set("server_url", (Object)endpoint.getServerURL()).expand();
    }

    @NonNull
    public Collection<BitbucketWebHook> read(@NonNull BitbucketAuthenticatedClient client) throws IOException {
        String endpointJenkinsRootURL = (String)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{() -> this.configuration.getEndpointJenkinsRootURL(), () -> BitbucketWebhookConfiguration.getDefaultJenkinsRootURL()});
        String url = UriTemplate.fromTemplate((String)WEBHOOK_API).set("owner", (Object)client.getRepositoryOwner()).set("repo", (Object)client.getRepositoryName()).expand();
        PostWebhookPayload[] hooks = JsonParser.toJava(client.get(url), PostWebhookPayload[].class);
        return Stream.of(hooks).map(BitbucketWebHook.class::cast).filter(hook -> hook.getUrl().startsWith(endpointJenkinsRootURL)).toList();
    }

    @NonNull
    private PostWebhookPayload buildPayload() {
        PostWebhookPayload hook = new PostWebhookPayload();
        hook.setActive(true);
        hook.setDescription("Jenkins hook");
        hook.setUrl(this.callbackURL);
        hook.setEventTypes(PLUGIN_SERVER_EVENTS);
        hook.setCommittersToIgnore(this.committersToIgnore);
        hook.setBranchesToIgnore(this.branchesToIgnore);
        hook.setSkipCI(this.skipCI);
        return hook;
    }

    private void register(@NonNull PostWebhookPayload payload, @NonNull BitbucketAuthenticatedClient client) throws IOException {
        String url = UriTemplate.fromTemplate((String)WEBHOOK_API).set("owner", (Object)client.getRepositoryOwner()).set("repo", (Object)client.getRepositoryName()).expand();
        client.post(url, (Object)payload);
    }

    private boolean shouldUpdate(@NonNull PostWebhookPayload current, @NonNull PostWebhookPayload expected) {
        List<PostWebhooksEventType> expectedEvents;
        List<PostWebhooksEventType> events;
        boolean update = false;
        if (!Objects.equal((Object)Util.fixEmptyAndTrim((String)current.getCommittersToIgnore()), (Object)expected.getCommittersToIgnore())) {
            logger.info(() -> "Update committersToIgnore to " + expected.getBranchesToIgnore());
            current.setCommittersToIgnore(expected.getCommittersToIgnore());
            update = true;
        }
        if (!Objects.equal((Object)Util.fixEmptyAndTrim((String)current.getBranchesToIgnore()), (Object)expected.getBranchesToIgnore())) {
            logger.info(() -> "Update branchesToIgnore to " + expected.getBranchesToIgnore());
            current.setBranchesToIgnore(expected.getBranchesToIgnore());
            update = true;
        }
        if (current.isSkipCI() != expected.isSkipCI()) {
            logger.info(() -> "Update skipCI to " + expected.isSkipCI());
            current.setSkipCI(expected.isSkipCI());
            update = true;
        }
        if (!current.isActive()) {
            current.setActive(true);
            logger.info(() -> "Re-activate webhook " + current.getUuid());
            update = true;
        }
        if (!Objects.equal((Object)current.getUrl(), (Object)expected.getUrl())) {
            current.setUrl(expected.getUrl());
            logger.info(() -> "Update webhook " + current.getUuid() + " callback URL");
            update = true;
        }
        if (!(events = current.getEventTypes()).containsAll(expectedEvents = expected.getEventTypes())) {
            TreeSet<PostWebhooksEventType> newEvents = new TreeSet<PostWebhooksEventType>(events);
            newEvents.addAll(expectedEvents);
            current.setEventTypes(new ArrayList<PostWebhooksEventType>(newEvents));
            logger.info(() -> "Update webhook " + current.getUuid() + " events because was missing: " + CollectionUtils.subtract((Collection)expectedEvents, (Collection)events));
            update = true;
        }
        return update;
    }

    private void update(@NonNull PostWebhookPayload payload, @NonNull BitbucketAuthenticatedClient client) throws IOException {
        String url = UriTemplate.fromTemplate((String)WEBHOOK_API).set("owner", (Object)client.getRepositoryOwner()).set("repo", (Object)client.getRepositoryName()).set("id", (Object)payload.getUuid()).expand();
        client.put(url, (Object)payload);
    }

    public void remove(@NonNull String webhookId, @NonNull BitbucketAuthenticatedClient client) throws IOException {
        String url = UriTemplate.fromTemplate((String)WEBHOOK_API).set("owner", (Object)client.getRepositoryOwner()).set("repo", (Object)client.getRepositoryName()).set("id", (Object)webhookId).expand();
        client.delete(url);
    }

    public void register(@NonNull BitbucketAuthenticatedClient client) throws IOException {
        PostWebhookPayload existingHook = this.read(client).stream().findFirst().orElse(null);
        if (existingHook == null) {
            logger.log(Level.INFO, "Registering cloud hook for {0}/{1}", new Object[]{client.getRepositoryOwner(), client.getRepositoryName()});
            this.register(this.buildPayload(), client);
        } else if (this.shouldUpdate(existingHook, this.buildPayload())) {
            logger.log(Level.INFO, "Updating cloud hook for {0}/{1}", new Object[]{client.getRepositoryOwner(), client.getRepositoryName()});
            this.update(existingHook, client);
        }
    }
}

