/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequestEvent;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor.AbstractPostWebhookProcessor;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor.PostWebhooksEventType;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor.PostWebhooksPREvent;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor.WebhookPayload;
import java.util.List;
import java.util.Map;
import jenkins.scm.api.SCMEvent;

@Extension
public class PostWebhooksPullRequestProcessor
extends AbstractPostWebhookProcessor {
    @Override
    protected List<PostWebhooksEventType> getSupportedEvents() {
        return List.of(PostWebhooksEventType.PULL_REQUEST_OPENED, PostWebhooksEventType.PULL_REQUEST_REOPENED, PostWebhooksEventType.PULL_REQUEST_RESCOPED, PostWebhooksEventType.PULL_REQUEST_MERGED, PostWebhooksEventType.PULL_REQUEST_DECLINED, PostWebhooksEventType.PULL_REQUEST_UPDATED);
    }

    public void process(@NonNull String hookEventType, @NonNull String payload, @NonNull Map<String, Object> context, @NonNull BitbucketEndpoint endpoint) {
        PostWebhooksEventType hookEvent = PostWebhooksEventType.fromHeader(hookEventType);
        BitbucketPullRequestEvent pull = WebhookPayload.pullRequestEventFromPayload(payload);
        if (pull != null && hookEvent != null) {
            this.notifyEvent(new PostWebhooksPREvent(switch (hookEvent) {
                case PostWebhooksEventType.PULL_REQUEST_OPENED, PostWebhooksEventType.PULL_REQUEST_REOPENED -> SCMEvent.Type.CREATED;
                case PostWebhooksEventType.PULL_REQUEST_DECLINED, PostWebhooksEventType.PULL_REQUEST_MERGED -> SCMEvent.Type.REMOVED;
                default -> SCMEvent.Type.UPDATED;
            }, pull, this.getOrigin(context), hookEvent), BitbucketSCMSource.getEventDelaySeconds());
        }
    }
}

