/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.observer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.scribejava.core.model.Verb;
import hudson.model.Job;
import io.jenkins.plugins.bitbucketpushandpullrequest.client.BitBucketPPRClientFactory;
import io.jenkins.plugins.bitbucketpushandpullrequest.client.BitBucketPPRClientType;
import io.jenkins.plugins.bitbucketpushandpullrequest.config.BitBucketPPRPluginConfig;
import io.jenkins.plugins.bitbucketpushandpullrequest.event.BitBucketPPREventContext;
import io.jenkins.plugins.bitbucketpushandpullrequest.event.BitBucketPPREventType;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public abstract class BitBucketPPRHandlerTemplate {
    static final Logger logger = Logger.getLogger(BitBucketPPRHandlerTemplate.class.getName());
    protected BitBucketPPREventContext context;
    protected BitBucketPPRClientType clientType;

    public void run(BitBucketPPREventType eventType) throws Exception {
        BitBucketPPRPluginConfig config = this.getGlobalConfig();
        switch (eventType) {
            case BUILD_STARTED: {
                if (!config.getNotifyBitBucket()) break;
                this.setBuildStatusInProgress();
                break;
            }
            case BUILD_FINISHED: {
                if (!config.getNotifyBitBucket()) break;
                this.setBuildStatusOnFinished();
                this.setApprovedOrDeclined();
                break;
            }
            default: {
                throw new Exception();
            }
        }
    }

    public void setApprovedOrDeclined() throws MalformedURLException {
    }

    public abstract void setBuildStatusOnFinished() throws MalformedURLException;

    public abstract void setBuildStatusInProgress() throws MalformedURLException;

    protected BitBucketPPRPluginConfig getGlobalConfig() {
        return BitBucketPPRPluginConfig.getInstance();
    }

    protected String computeBitBucketBuildKey(BitBucketPPREventContext context) {
        if (this.getGlobalConfig().getUseJobNameAsBuildKey()) {
            Job job = context.getRun().getParent();
            return job.getDisplayName();
        }
        int buildNumber = context.getBuildNumber();
        return Integer.toString(buildNumber);
    }

    protected void callClient(@Nonnull String url, @Nonnull Map<String, String> payload) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String jsonPayload = objectMapper.writeValueAsString(payload);
            BitBucketPPRClientFactory.createClient(this.clientType, this.context).send(url, jsonPayload);
        }
        catch (JsonProcessingException e) {
            logger.log(Level.WARNING, "Cannot create payload: {0}", e.getMessage());
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
        }
    }

    protected void callClient(@Nonnull Verb verb, @Nonnull String url, @Nonnull Map<String, String> payload) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String jsonPayload = payload.isEmpty() ? "" : objectMapper.writeValueAsString(payload);
            BitBucketPPRClientFactory.createClient(this.clientType, this.context).send(verb, url, jsonPayload);
        }
        catch (JsonProcessingException e) {
            logger.log(Level.WARNING, "Cannot create payload: {0}", e.getMessage());
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
        }
    }
}

