/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.filter.repository;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.cause.BitBucketPPRTriggerCause;
import io.jenkins.plugins.bitbucketpushandpullrequest.cause.repository.BitBucketPPRRepositoryCause;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.repository.BitBucketPPRRepositoryActionDescriptor;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.repository.BitBucketPPRRepositoryActionFilter;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRHookEvent;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class BitBucketPPRRepositoryPushActionFilter
extends BitBucketPPRRepositoryActionFilter {
    private static final Logger logger = Logger.getLogger(BitBucketPPRRepositoryPushActionFilter.class.getName());
    public boolean triggerAlsoIfTagPush;
    public boolean triggerAlsoIfNothingChanged;
    public boolean triggerOnlyIfTagPush;
    public String allowedBranches;
    public boolean isToApprove;

    @DataBoundConstructor
    public BitBucketPPRRepositoryPushActionFilter(boolean triggerAlsoIfTagPush, boolean triggerAlsoIfNothingChanged, String allowedBranches) {
        this.triggerAlsoIfTagPush = triggerAlsoIfTagPush;
        this.triggerAlsoIfNothingChanged = triggerAlsoIfNothingChanged;
        this.allowedBranches = allowedBranches;
    }

    @DataBoundSetter
    public void setTriggerOnlyIfTagPush(boolean triggerOnlyIfTagPush) {
        this.triggerOnlyIfTagPush = triggerOnlyIfTagPush;
    }

    @DataBoundSetter
    public void setIsToApprove(boolean isToApprove) {
        this.isToApprove = isToApprove;
    }

    @Override
    public boolean shouldTriggerBuild(BitBucketPPRAction bitbucketAction) {
        logger.info(() -> "Should trigger build for the bitbucket action: " + bitbucketAction.toString() + "?");
        if (Objects.isNull(bitbucketAction) || Objects.isNull(bitbucketAction.getType())) {
            logger.info("The bitbucketAction or the bitbucketAction type are not set.");
            return false;
        }
        if (!(bitbucketAction.getType().equalsIgnoreCase("BRANCH") || bitbucketAction.getType().equalsIgnoreCase("named_branch") || bitbucketAction.getType().equalsIgnoreCase("UPDATE") || bitbucketAction.getType().equalsIgnoreCase("TAG") || this.triggerAlsoIfTagPush)) {
            logger.info("Neither bitbucketAction type is BRANCH, nor UPDATE, nor trigger on tag push is set: " + bitbucketAction.getType());
            return false;
        }
        if (this.triggerOnlyIfTagPush && !bitbucketAction.getType().equalsIgnoreCase("TAG")) {
            return false;
        }
        return this.matches(this.allowedBranches, bitbucketAction.getTargetBranch(), null);
    }

    @Override
    public BitBucketPPRTriggerCause getCause(File pollingLog, BitBucketPPRAction bitbucketAction, BitBucketPPRHookEvent bitBucketEvent) throws IOException {
        return new BitBucketPPRRepositoryCause(pollingLog, bitbucketAction, bitBucketEvent);
    }

    public String getAllowedBranches() {
        return this.allowedBranches;
    }

    public void setAllowedBranches(String allowedBranches) {
        this.allowedBranches = allowedBranches;
    }

    @Override
    public boolean shouldTriggerAlsoIfNothingChanged() {
        return this.triggerAlsoIfNothingChanged;
    }

    @Override
    public boolean shouldSendApprove() {
        return this.isToApprove;
    }

    @Extension
    public static class ActionFilterDescriptorImpl
    extends BitBucketPPRRepositoryActionDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Bitbucket Cloud Push";
        }
    }
}

