/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.filter.pullrequest.server;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.cause.BitBucketPPRTriggerCause;
import io.jenkins.plugins.bitbucketpushandpullrequest.cause.pullrequest.server.BitBucketPPRPullRequestServerCommentCreatedCause;
import io.jenkins.plugins.bitbucketpushandpullrequest.common.BitBucketPPRUtils;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.pullrequest.server.BitBucketPPRPullRequestServerActionDescriptor;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.pullrequest.server.BitBucketPPRPullRequestServerActionFilter;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRHookEvent;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class BitBucketPPRPullRequestServerCommentCreatedActionFilter
extends BitBucketPPRPullRequestServerActionFilter {
    public String allowedBranches;
    public String commentFilter;

    @DataBoundConstructor
    public BitBucketPPRPullRequestServerCommentCreatedActionFilter() {
    }

    @DataBoundSetter
    public void setAllowedBranches(String allowedBranches) {
        this.allowedBranches = Objects.requireNonNullElse(allowedBranches, "");
    }

    @DataBoundSetter
    public void setCommentFilter(String commentFilter) {
        this.commentFilter = Objects.requireNonNullElse(commentFilter, "");
    }

    @Override
    public boolean shouldTriggerBuild(BitBucketPPRAction bitbucketAction) {
        return (this.matches(this.allowedBranches, bitbucketAction.getTargetBranch(), null) || this.matches(this.allowedBranches, bitbucketAction.getTargetBranchRefId(), null)) && this.hasInComment(bitbucketAction.getServerComment(), null);
    }

    @Override
    public BitBucketPPRTriggerCause getCause(File pollingLog, BitBucketPPRAction pullRequestAction, BitBucketPPRHookEvent bitBucketEvent) throws IOException {
        return new BitBucketPPRPullRequestServerCommentCreatedCause(pollingLog, pullRequestAction, bitBucketEvent);
    }

    @Override
    public boolean shouldSendApprove() {
        return false;
    }

    @Override
    public boolean shouldSendDecline() {
        return false;
    }

    public boolean hasInComment(String comment, EnvVars vars) {
        return BitBucketPPRUtils.matchWithRegex(comment, this.commentFilter, vars);
    }

    public String toString() {
        return "BitBucketPPRPullRequestServerCommentCreatedActionFilter [getDescriptor()=" + String.valueOf(this.getDescriptor()) + ", getClass()=" + String.valueOf(((Object)((Object)this)).getClass()) + ", hashCode()=" + ((Object)((Object)this)).hashCode() + ", toString()=" + super.toString() + "]";
    }

    @Symbol(value={"bitbucketServerPullRequestCommentCreated"})
    @Extension
    public static class ActionFilterDescriptorImpl
    extends BitBucketPPRPullRequestServerActionDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Comment Created";
        }
    }
}

