/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.filter.pullrequest.cloud;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.cause.BitBucketPPRTriggerCause;
import io.jenkins.plugins.bitbucketpushandpullrequest.cause.pullrequest.cloud.BitBucketPPRPullRequestUpdatedCause;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.pullrequest.cloud.BitBucketPPRPullRequestActionDescriptor;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.pullrequest.cloud.BitBucketPPRPullRequestActionFilter;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRHookEvent;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class BitBucketPPRPullRequestUpdatedActionFilter
extends BitBucketPPRPullRequestActionFilter {
    public String allowedBranches;
    public boolean isToApprove;
    public boolean isToDecline;

    @DataBoundConstructor
    public BitBucketPPRPullRequestUpdatedActionFilter() {
    }

    @DataBoundSetter
    public void setAllowedBranches(String allowedBranches) {
        this.allowedBranches = Objects.requireNonNullElse(allowedBranches, "");
    }

    @DataBoundSetter
    public void setIsToApprove(boolean isToApprove) {
        this.isToApprove = isToApprove;
    }

    @DataBoundSetter
    public void setIsToDecline(boolean isToDecline) {
        this.isToDecline = isToDecline;
    }

    @Override
    public boolean shouldSendApprove() {
        return this.isToApprove;
    }

    @Override
    public boolean shouldSendDecline() {
        return this.isToDecline;
    }

    @Override
    public boolean shouldTriggerBuild(BitBucketPPRAction bitbucketAction) {
        return this.matches(this.allowedBranches, bitbucketAction.getTargetBranch(), null);
    }

    @Override
    public BitBucketPPRTriggerCause getCause(File pollingLog, BitBucketPPRAction pullRequestAction, BitBucketPPRHookEvent bitBucketEvent) throws IOException {
        return new BitBucketPPRPullRequestUpdatedCause(pollingLog, pullRequestAction, bitBucketEvent);
    }

    public String toString() {
        return "BitBucketPPRPullRequestUpdatedActionFilter [getDescriptor()=" + String.valueOf(this.getDescriptor()) + ", getClass()=" + String.valueOf(((Object)((Object)this)).getClass()) + ", hashCode()=" + ((Object)((Object)this)).hashCode() + ", toString()=" + super.toString() + "]";
    }

    @Symbol(value={"bitbucketCloudPullRequestUpdated"})
    @Extension
    public static class ActionFilterDescriptorImpl
    extends BitBucketPPRPullRequestActionDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Updated";
        }
    }
}

