/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.event;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.scm.SCM;
import io.jenkins.plugins.bitbucketpushandpullrequest.BitBucketPPRTrigger;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.config.BitBucketPPRPluginConfig;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.BitBucketPPRTriggerFilter;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class BitBucketPPREventContext {
    private SCM scmTrigger;
    private Run<?, ?> run;
    private BitBucketPPRAction action;
    private BitBucketPPRTriggerFilter filter;
    private UserRemoteConfig userRemoteConfig;
    private String url;
    private BitBucketPPRTrigger trigger;

    public BitBucketPPREventContext(BitBucketPPRTrigger trigger, BitBucketPPRAction action, SCM scmTrigger, Run<?, ?> run, BitBucketPPRTriggerFilter filter) {
        this.action = action;
        this.scmTrigger = scmTrigger;
        this.run = run;
        this.filter = filter;
        this.userRemoteConfig = this.getUserRemoteConfigs(scmTrigger);
        this.trigger = trigger;
        this.url = this.userRemoteConfig.getUrl();
    }

    public StringCredentials getSecretTextCredentials() throws Exception {
        StringCredentials credentials = (StringCredentials)CredentialsProvider.findCredentialById((String)this.getCredentialsId(), StringCredentials.class, this.run, (List)URIRequirementBuilder.fromUri((String)this.url).build());
        if (credentials != null) {
            return credentials;
        }
        throw new Exception("No Credentials found for run: " + this.run.getNumber() + " - url: " + this.url + " - credentialsId: " + this.getCredentialsId() + " - absolute url : " + this.run.getAbsoluteUrl());
    }

    public StandardCredentials getStandardCredentials() throws Exception {
        StandardCredentials credentials = (StandardCredentials)CredentialsProvider.findCredentialById((String)this.getCredentialsId(), StandardCredentials.class, this.run, (List)URIRequirementBuilder.fromUri((String)this.url).build());
        if (credentials != null) {
            return credentials;
        }
        throw new Exception("No Credentials found for run: " + this.run.getNumber() + " - url: " + this.url + " - credentialsId: " + this.getCredentialsId() + " - absolute url : " + this.run.getAbsoluteUrl());
    }

    protected BitBucketPPRPluginConfig getGlobalConfig() {
        return BitBucketPPRPluginConfig.getInstance();
    }

    public String getUrl() {
        return this.url;
    }

    public String getCredentialsId() {
        if (StringUtils.isNotBlank((CharSequence)this.trigger.credentialsId)) {
            return this.trigger.credentialsId;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getGlobalConfig().credentialsId)) {
            return this.getGlobalConfig().credentialsId;
        }
        if (StringUtils.isNotBlank((CharSequence)this.userRemoteConfig.getCredentialsId())) {
            return this.userRemoteConfig.getCredentialsId();
        }
        return "";
    }

    public UserRemoteConfig getUserRemoteConfig() {
        return this.userRemoteConfig;
    }

    public SCM getScmTrigger() {
        return this.scmTrigger;
    }

    public BitBucketPPRAction getAction() {
        return this.action;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public String getAbsoluteUrl() {
        return this.run.getAbsoluteUrl();
    }

    public int getBuildNumber() {
        return this.run.getNumber();
    }

    public BitBucketPPRTriggerFilter getFilter() {
        return this.filter;
    }

    public UserRemoteConfig getUserRemoteConfigs(SCM scm) {
        GitSCM gitSCM = (GitSCM)scm;
        UserRemoteConfig config = (UserRemoteConfig)gitSCM.getUserRemoteConfigs().get(0);
        return config;
    }

    public String toString() {
        return "BitBucketPPREventContext [scmTrigger=" + String.valueOf(this.scmTrigger) + ", run=" + String.valueOf(this.run) + ", action=" + String.valueOf(this.action) + ", filter=" + String.valueOf((Object)this.filter) + ", userRemoteConfig=" + String.valueOf(this.userRemoteConfig) + ", url=" + this.url + ", trigger=" + String.valueOf((Object)this.trigger) + "]";
    }
}

