/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.config;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class BitBucketPPRPluginConfig
extends GlobalConfiguration {
    private static final Logger logger = Logger.getLogger(BitBucketPPRPluginConfig.class.getName());
    public static final String BITBUCKET_PPR_PLUGIN_CONFIGURATION_ID = "bitbucket-ppr-plugin-configuration";
    public String hookUrl;
    public boolean notifyBitBucket;
    public boolean useJobNameAsBuildKey;
    public String credentialsId;
    public String singleJob;
    public String propagationUrl;

    public BitBucketPPRPluginConfig() {
        logger.fine("Read bitbucket push and pull request plugin global configuration.");
        this.notifyBitBucket = true;
        this.load();
    }

    public static BitBucketPPRPluginConfig getInstance() {
        return (BitBucketPPRPluginConfig)((Object)ExtensionList.lookupSingleton(BitBucketPPRPluginConfig.class));
    }

    @DataBoundSetter
    public void setHookUrl(String hookUrl) {
        this.hookUrl = hookUrl == null || StringUtils.isEmpty((CharSequence)hookUrl) ? "" : hookUrl;
        this.save();
    }

    @DataBoundSetter
    public void setPropagationUrl(String propagationUrl) {
        this.propagationUrl = propagationUrl;
        this.save();
    }

    public FormValidation doCheckPropagationUrl(@QueryParameter String value) {
        if (value == null || value.isEmpty()) {
            return FormValidation.ok();
        }
        try {
            new URL(value);
            return FormValidation.ok();
        }
        catch (MalformedURLException e) {
            return FormValidation.error((String)"This is not a valid URL. Please enter a correct URL.");
        }
    }

    public boolean isHookUrlSet() {
        return !StringUtils.isEmpty((CharSequence)this.hookUrl);
    }

    public String getHookUrl() {
        return this.hookUrl;
    }

    public boolean getNotifyBitBucket() {
        return this.notifyBitBucket;
    }

    public String getPropagationUrl() {
        return this.propagationUrl;
    }

    public boolean isPropagationUrlSet() {
        return !StringUtils.isEmpty((CharSequence)this.propagationUrl);
    }

    @DataBoundSetter
    public void setNotifyBitBucket(boolean notifyBitBucket) {
        this.notifyBitBucket = notifyBitBucket;
    }

    public boolean getUseJobNameAsBuildKey() {
        return this.useJobNameAsBuildKey;
    }

    @DataBoundSetter
    public void setUseJobNameAsBuildKey(boolean useJobNameAsBuildKey) {
        this.useJobNameAsBuildKey = useJobNameAsBuildKey;
        this.save();
    }

    @DataBoundSetter
    public void setCredentialsId(@CheckForNull String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setSingleJob(String singleJob) {
        this.singleJob = StringUtils.isEmpty((CharSequence)singleJob) ? "" : singleJob.trim();
        this.save();
    }

    public boolean isSingleJobSet() {
        return !StringUtils.isEmpty((CharSequence)this.singleJob);
    }

    public String getSingleJob() {
        return this.singleJob;
    }

    @NonNull
    public String getDisplayName() {
        return "Bitbucket Push and Pull Request";
    }

    public boolean configure(StaplerRequest req, JSONObject formData) {
        req.bindJSON((Object)this, formData);
        this.save();
        return true;
    }

    public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String remote, @QueryParameter String credentialsId) {
        if (context == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
            return new StandardListBoxModel().includeCurrentValue(credentialsId);
        }
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, (ItemGroup)Jenkins.get(), StandardCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(credentialsId);
    }
}

