/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.client;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.github.scribejava.core.model.Verb;
import io.jenkins.plugins.bitbucketpushandpullrequest.client.BitBucketPPRClientVisitor;
import io.jenkins.plugins.bitbucketpushandpullrequest.client.api.BitBucketPPRBasicAuthApiConsumer;
import io.jenkins.plugins.bitbucketpushandpullrequest.client.api.BitBucketPPRBearerAuthorizationApiConsumer;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.NotImplementedException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class BitBucketPPRClientServerVisitor
implements BitBucketPPRClientVisitor {
    private static final Logger logger = Logger.getLogger(BitBucketPPRClientServerVisitor.class.getName());

    @Override
    public void send(StandardCredentials credentials, String url, String payload) throws NoSuchMethodException {
        this.send(credentials, Verb.POST, url, payload);
    }

    @Override
    public void send(StandardCredentials credentials, Verb verb, String url, String payload) throws NoSuchMethodException {
        if (credentials instanceof StandardUsernamePasswordCredentials) {
            StandardUsernamePasswordCredentials usernamePasswordCredentials = (StandardUsernamePasswordCredentials)credentials;
            try {
                HttpResponse response = this.send(usernamePasswordCredentials, verb, url, payload);
                HttpEntity responseEntity = response.getEntity();
                String responseBody = responseEntity == null ? "empty" : EntityUtils.toString((HttpEntity)responseEntity);
                logger.log(Level.FINEST, "Result of the status notification is: {0}, with status code: {1}", new Object[]{responseBody, response.getStatusLine().getStatusCode()});
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error during state notification: {0} ", e.getMessage());
            }
        } else if (credentials instanceof StringCredentials) {
            StringCredentials stringCredentials = (StringCredentials)credentials;
            try {
                HttpResponse response = this.send(stringCredentials, verb, url, payload);
                logger.log(Level.FINEST, "Result of the state notification is: {0}, with status code: {1}", new Object[]{response.getEntity().getContent(), response.getStatusLine().getStatusCode()});
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                logger.log(Level.WARNING, "Error during state notification: {0} ", e.getMessage());
            }
        } else {
            throw new NotImplementedException("Credentials provider for state notification not found");
        }
    }

    private HttpResponse send(StandardUsernamePasswordCredentials credentials, Verb verb, String url, String payload) throws IOException, NoSuchMethodException {
        BitBucketPPRBasicAuthApiConsumer api = new BitBucketPPRBasicAuthApiConsumer();
        return api.send(credentials, verb, url, payload);
    }

    private HttpResponse send(StringCredentials credentials, Verb verb, String url, String payload) throws IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, NoSuchMethodException {
        logger.finest("Set BB StringCredentials for BB Server state notification");
        BitBucketPPRBearerAuthorizationApiConsumer api = new BitBucketPPRBearerAuthorizationApiConsumer();
        return api.send(credentials, verb, url, payload);
    }
}

