/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.action;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRActionAbstract;
import io.jenkins.plugins.bitbucketpushandpullrequest.config.BitBucketPPRPluginConfig;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRPayload;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.server.BitBucketPPRServerChange;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.server.BitBucketPPRServerClone;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;

public class BitBucketPPRServerRepositoryAction
extends BitBucketPPRActionAbstract
implements BitBucketPPRAction {
    private static final Logger logger = Logger.getLogger(BitBucketPPRAction.class.getName());
    private static final BitBucketPPRPluginConfig globalConfig = BitBucketPPRPluginConfig.getInstance();
    @Nonnull
    private final BitBucketPPRPayload payload;
    private URL baseUrl;
    private List<String> scmUrls = new ArrayList<String>(2);
    private String targetBranchName = null;
    private String targetBranchRefId = null;
    private String type;

    public BitBucketPPRServerRepositoryAction(@NonNull BitBucketPPRPayload payload) {
        this.payload = payload;
        List<BitBucketPPRServerClone> clones = payload.getServerRepository().getLinks().getCloneProperty();
        for (BitBucketPPRServerClone clone : clones) {
            if (clone.getName().equalsIgnoreCase("http") || clone.getName().equalsIgnoreCase("https")) {
                try {
                    this.baseUrl = new URL(clone.getHref());
                    this.scmUrls.add(clone.getHref());
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!clone.getName().equalsIgnoreCase("ssh")) continue;
            this.scmUrls.add(clone.getHref());
        }
        for (BitBucketPPRServerChange change : payload.getServerChanges()) {
            if (change.getRefId() == null) continue;
            this.targetBranchName = change.getRef().getDisplayId();
            this.targetBranchRefId = change.getRefId();
            this.type = change.getRef().getType();
            break;
        }
        logger.log(Level.INFO, () -> "Received commit hook notification from server for destination branch: " + this.targetBranchName);
        logger.log(Level.INFO, () -> "Received commit hook type from server: " + this.type);
    }

    @Override
    public String getTargetBranch() {
        return this.targetBranchName;
    }

    @Override
    public String getTargetBranchRefId() {
        return this.targetBranchRefId;
    }

    @Override
    @NonNull
    public BitBucketPPRPayload getPayload() {
        return this.payload;
    }

    @Override
    public String getScm() {
        return this.payload.getServerRepository().getScmId();
    }

    @Override
    public String getUser() {
        return this.payload.getServerActor().getName();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getRepositoryName() {
        return this.payload.getServerRepository().getName();
    }

    @Override
    public List<String> getScmUrls() {
        return this.scmUrls;
    }

    @Override
    public String getPullRequestId() {
        return null;
    }

    @Override
    public String getRepositoryId() {
        return this.payload.getServerRepository().getId();
    }

    @Override
    public String getRepositoryUrl() {
        return this.payload.getServerRepository().getLinks().getSelfProperty().get(0).getHref();
    }

    @Override
    public String getProjectUrl() {
        return this.payload.getServerRepository().getProject().getLinks().getSelfProperty().get(0).getHref();
    }

    public String toString() {
        return "BitBucketPPRServerRepositoryAction";
    }

    @Override
    public String getLatestCommit() {
        for (BitBucketPPRServerChange change : this.payload.getServerChanges()) {
            if (change.getRefId() == null) continue;
            return change.getToHash();
        }
        return null;
    }

    @Override
    public List<String> getCommitLinks() throws MalformedURLException {
        URL baseCommitLink = ObjectUtils.isEmpty((Object)this.getPropagationUrl()) ? this.baseUrl : new URL(this.getPropagationUrl());
        List<BitBucketPPRServerChange> changes = this.payload.getServerChanges();
        ArrayList<String> links = new ArrayList<String>();
        for (BitBucketPPRServerChange change : changes) {
            links.add(String.valueOf(baseCommitLink) + "/rest/build-status/1.0/commits/" + change.getToHash());
        }
        return links;
    }

    private String getBaseUrl() {
        return this.baseUrl.getProtocol() + "://" + this.baseUrl.getHost() + ":" + this.baseUrl.getPort();
    }

    @Override
    public String getLatestFromCommit() {
        for (BitBucketPPRServerChange change : this.payload.getServerChanges()) {
            if (change.getRefId() == null) continue;
            return change.getFromHash();
        }
        return null;
    }

    @Override
    public String getPayloadChangeType() {
        for (BitBucketPPRServerChange change : this.payload.getServerChanges()) {
            if (change.getRefId() == null) continue;
            return change.getType();
        }
        return null;
    }

    @Override
    public String getOPT1CloneUrl() {
        return this.payload.getServerRepository().getLinks().getCloneProperty().get(0).getHref();
    }

    @Override
    public String getOPT2CloneUrl() {
        return this.payload.getServerRepository().getLinks().getCloneProperty().get(1).getHref();
    }
}

