/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.action;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRActionAbstract;
import io.jenkins.plugins.bitbucketpushandpullrequest.common.BitBucketPPRUtils;
import io.jenkins.plugins.bitbucketpushandpullrequest.exception.BitBucketPPRRepositoryNotParsedException;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRHookEvent;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRPayload;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;

public class BitBucketPPRPullRequestAction
extends BitBucketPPRActionAbstract
implements BitBucketPPRAction {
    private static final Logger logger = Logger.getLogger(BitBucketPPRPullRequestAction.class.getName());
    public static final String APPROVE = "/approve";
    public static final String DECLINE = "/decline";
    public static final String STATUSES = "/statuses";
    public static final String COMMIT = "commit";
    public static final String BITBUCKET_API_BASE_URL = "https://api.bitbucket.org/2.0";
    public static final String BITBUCKET_HTTP_BASE_URL = "https://bitbucket.org";
    private static final String PULL_REQUEST_API = "pullrequests";
    private static final String PULL_REQUEST_HTTP = "pull-requests";
    private static final String BITBUCKET_REPOSITORIES = "repositories";
    @Nonnull
    private final BitBucketPPRPayload payload;
    @Nonnull
    private final String workspace;
    @Nonnull
    private final String repoSlug;
    @Nonnull
    private final String pullRequestId;
    @Nonnull
    private final BitBucketPPRHookEvent bitbucketEvent;

    public BitBucketPPRPullRequestAction(@Nonnull BitBucketPPRPayload payload, @Nonnull BitBucketPPRHookEvent event) {
        Map<String, String> workspaceRepo;
        this.payload = payload;
        this.pullRequestId = payload.getPullRequest().getId();
        this.bitbucketEvent = event;
        try {
            workspaceRepo = BitBucketPPRUtils.extractRepositoryNameFromHTTPSUrl(payload.getRepository().getLinks().getHtml().getHref());
        }
        catch (BitBucketPPRRepositoryNotParsedException e) {
            throw new RuntimeException(e);
        }
        this.repoSlug = workspaceRepo.get("repository");
        this.workspace = workspaceRepo.get("workspace");
    }

    @Override
    public String getSourceBranch() {
        return this.payload.getPullRequest().getSource().getBranch().getName();
    }

    @Override
    public String getTargetBranch() {
        return this.payload.getPullRequest().getDestination().getBranch().getName();
    }

    @Override
    public String getLatestCommitFromRef() {
        return this.payload.getPullRequest().getSource().getCommit().getHash();
    }

    @Override
    public String getLatestCommitToRef() {
        return this.payload.getPullRequest().getDestination().getCommit().getHash();
    }

    @Override
    public String getPullRequestApiUrl() {
        return String.join((CharSequence)"/", BITBUCKET_API_BASE_URL, BITBUCKET_REPOSITORIES, this.workspace, this.repoSlug, PULL_REQUEST_API, this.pullRequestId);
    }

    @Override
    public String getPullRequestUrl() {
        return String.join((CharSequence)"/", BITBUCKET_HTTP_BASE_URL, this.workspace, this.repoSlug, PULL_REQUEST_HTTP, this.pullRequestId);
    }

    @Override
    public String getTitle() {
        return this.payload.getPullRequest().getTitle();
    }

    @Override
    public String getDescription() {
        return this.payload.getPullRequest().getDescription();
    }

    @Override
    @NonNull
    public BitBucketPPRPayload getPayload() {
        return this.payload;
    }

    @Override
    public String getScm() {
        String scm;
        String string = scm = Objects.nonNull(this.payload.getRepository().getScm()) ? this.payload.getRepository().getScm() : "git";
        if (!scm.equalsIgnoreCase("git")) {
            logger.log(Level.WARNING, "Payload received from SCM other than git.");
        }
        return this.payload.getRepository().getScm();
    }

    @Override
    public String getUser() {
        return this.payload.getActor().getNickname();
    }

    @Override
    public String getRepositoryName() {
        return this.payload.getRepository().getName();
    }

    @Override
    public List<String> getScmUrls() {
        ArrayList<String> res = new ArrayList<String>();
        res.add(this.payload.getRepository().getLinks().getHtml().getHref());
        return res;
    }

    @Override
    public String getPullRequestId() {
        return this.payload.getPullRequest().getId();
    }

    @Override
    public String getComment() {
        if (this.payload.getComment() == null || this.payload.getComment().getContent() == null || this.payload.getComment().getContent().getRaw() == null) {
            return "";
        }
        return this.payload.getComment().getContent().getRaw();
    }

    @Override
    public String getLinkHtml() {
        return this.payload.getPullRequest().getLinks().getHtml().getHref();
    }

    @Override
    public String getLinkSelf() {
        return this.payload.getPullRequest().getLinks().getSelf().getHref();
    }

    @Override
    public String getLinkApprove() {
        return String.join((CharSequence)"/", BITBUCKET_API_BASE_URL, BITBUCKET_REPOSITORIES, this.workspace, this.repoSlug, PULL_REQUEST_API, this.pullRequestId) + APPROVE;
    }

    @Override
    public String getLinkDecline() {
        return String.join((CharSequence)"/", BITBUCKET_API_BASE_URL, BITBUCKET_REPOSITORIES, this.workspace, this.repoSlug, PULL_REQUEST_API, this.pullRequestId) + DECLINE;
    }

    @Override
    public String getLinkStatuses() {
        return String.join((CharSequence)"/", BITBUCKET_API_BASE_URL, BITBUCKET_REPOSITORIES, this.workspace, this.repoSlug, PULL_REQUEST_API, this.pullRequestId) + STATUSES;
    }

    @Override
    public String getLatestCommit() {
        if ("fulfilled".equalsIgnoreCase(this.bitbucketEvent.getAction())) {
            return this.payload.getPullRequest().getMergeCommit().getHash();
        }
        return this.payload.getPullRequest().getSource().getCommit().getHash();
    }

    @Override
    public String getCommitLink() {
        String baseCommitLink = ObjectUtils.isEmpty((Object)this.getPropagationUrl()) ? BITBUCKET_API_BASE_URL : this.getPropagationUrl();
        return String.join((CharSequence)"/", baseCommitLink, BITBUCKET_REPOSITORIES, this.workspace, this.repoSlug, COMMIT) + "/" + this.getLatestCommit();
    }

    public String toString() {
        return "BitBucketPPRPullRequestAction";
    }
}

