/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest;

import hudson.Util;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.scm.PollingResult;
import hudson.util.StreamTaskListener;
import io.jenkins.plugins.bitbucketpushandpullrequest.BitBucketPPRPollResultListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.triggers.SCMTriggerItem;

public class BitBucketPPRPollingRunnable
implements Runnable {
    private static final Logger logger = Logger.getLogger(BitBucketPPRPollingRunnable.class.getName());
    private Job<?, ?> job;
    private File logFile;
    private BitBucketPPRPollResultListener bitbucketPollResultListener;

    public BitBucketPPRPollingRunnable(@Nonnull Job<?, ?> job, @Nonnull File logFile, @Nonnull BitBucketPPRPollResultListener bitbucketPollResultListener) {
        this.job = job;
        this.bitbucketPollResultListener = bitbucketPollResultListener;
        this.logFile = logFile;
    }

    @Override
    public void run() {
        logger.log(Level.FINE, "Run method called.");
        try (StreamTaskListener streamListener = new StreamTaskListener(this.logFile, Charset.defaultCharset());){
            PrintStream streamListenerLogger = streamListener.getLogger();
            long start = System.currentTimeMillis();
            streamListenerLogger.println("Started on " + DateFormat.getDateTimeInstance().format(new Date()));
            SCMTriggerItem triggerItem = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(this.job);
            if (triggerItem == null) {
                logger.log(Level.FINE, "SCMTriggerItem for job is null");
                return;
            }
            PollingResult pollingResult = triggerItem.poll((TaskListener)streamListener);
            streamListenerLogger.println("Done. Took " + Util.getTimeSpanString((long)(System.currentTimeMillis() - start)));
            this.bitbucketPollResultListener.onPollSuccess(pollingResult);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed {0}", e.getMessage());
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "RuntimeException: Failed to record SCM polling {0}", e.getMessage());
            this.bitbucketPollResultListener.onPollError(e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed ", e);
        }
    }
}

