/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.processor;

import io.jenkins.plugins.bitbucketpushandpullrequest.BitBucketPPRJobProbe;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRHookEvent;
import io.jenkins.plugins.bitbucketpushandpullrequest.processor.BitBucketPPRPayloadProcessor;
import io.jenkins.plugins.bitbucketpushandpullrequest.processor.BitBucketPPRPullRequestCloudPayloadProcessor;
import io.jenkins.plugins.bitbucketpushandpullrequest.processor.BitBucketPPRPullRequestServerPayloadProcessor;
import io.jenkins.plugins.bitbucketpushandpullrequest.processor.BitBucketPPRRepositoryCloudPayloadProcessor;
import io.jenkins.plugins.bitbucketpushandpullrequest.processor.BitBucketPPRRepositoryServerPayloadProcessor;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.naming.OperationNotSupportedException;

public final class BitBucketPPRPayloadProcessorFactory {
    static final Logger logger = Logger.getLogger(BitBucketPPRPayloadProcessorFactory.class.getName());

    private BitBucketPPRPayloadProcessorFactory() {
        throw new AssertionError();
    }

    public static BitBucketPPRPayloadProcessor createProcessor(@Nonnull BitBucketPPRHookEvent bitbucketEvent) throws OperationNotSupportedException {
        return BitBucketPPRPayloadProcessorFactory.createProcessor(new BitBucketPPRJobProbe(), bitbucketEvent);
    }

    public static BitBucketPPRPayloadProcessor createProcessor(@Nonnull BitBucketPPRJobProbe probe, @Nonnull BitBucketPPRHookEvent bitbucketEvent) throws OperationNotSupportedException {
        if ("repo".equalsIgnoreCase(bitbucketEvent.getEvent()) && "push".equalsIgnoreCase(bitbucketEvent.getAction())) {
            logger.info("Create BitBucketPPRRepositoryCloudPayloadProcessor");
            return new BitBucketPPRRepositoryCloudPayloadProcessor(probe, bitbucketEvent);
        }
        if ("repo".equalsIgnoreCase(bitbucketEvent.getEvent()) && "refs_changed".equalsIgnoreCase(bitbucketEvent.getAction())) {
            logger.info("Create BitBucketPPRRepositoryServerPayloadProcessor");
            return new BitBucketPPRRepositoryServerPayloadProcessor(probe, bitbucketEvent);
        }
        if ("repo".equalsIgnoreCase(bitbucketEvent.getEvent()) && "post".equalsIgnoreCase(bitbucketEvent.getAction())) {
            logger.warning("Got unexpected old post action, ignored!");
        }
        if ("pullrequest".equals(bitbucketEvent.getEvent())) {
            logger.info("Create BitBucketPPRPullRequestCloudPayloadProcessor");
            return new BitBucketPPRPullRequestCloudPayloadProcessor(probe, bitbucketEvent);
        }
        if ("pr".equals(bitbucketEvent.getEvent())) {
            logger.info("Create BitBucketPPRPullRequestServerPayloadProcessor");
            return new BitBucketPPRPullRequestServerPayloadProcessor(probe, bitbucketEvent);
        }
        throw new OperationNotSupportedException("No processor found for bitbucket event " + bitbucketEvent.getEvent());
    }
}

