/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.observer;

import com.github.scribejava.core.model.Verb;
import hudson.model.Result;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.client.BitBucketPPRClientType;
import io.jenkins.plugins.bitbucketpushandpullrequest.event.BitBucketPPREvent;
import io.jenkins.plugins.bitbucketpushandpullrequest.observer.BitBucketPPRHandlerTemplate;
import io.jenkins.plugins.bitbucketpushandpullrequest.observer.BitBucketPPRObserver;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.logging.Logger;

public class BitBucketPPRPullRequestServerObserver
extends BitBucketPPRHandlerTemplate
implements BitBucketPPRObserver {
    static final Logger logger = Logger.getLogger(BitBucketPPRPullRequestServerObserver.class.getName());

    public BitBucketPPRPullRequestServerObserver() {
        this.clientType = BitBucketPPRClientType.SERVER;
    }

    @Override
    public void getNotification(BitBucketPPREvent event) {
        this.context = event.getContext();
        event.setEventHandler(this);
        event.runHandler();
    }

    @Override
    public void setApprovedOrDeclined() throws MalformedURLException {
        if (!this.context.getFilter().shouldSendApprove() && !this.context.getFilter().shouldSendDecline()) {
            return;
        }
        Result result = this.context.getRun().getResult();
        BitBucketPPRAction bitbucketAction = this.context.getAction();
        HashMap<String, String> map = new HashMap<String, String>();
        String url = null;
        if (this.context.getFilter().shouldSendApprove()) {
            url = bitbucketAction.getLinkApprove();
            Verb verb = Verb.POST;
            if (result == Result.FAILURE) {
                verb = Verb.DELETE;
            }
            this.callClient(verb, url, map);
        }
        if (result == Result.FAILURE && this.context.getFilter().shouldSendDecline()) {
            url = bitbucketAction.getLinkDecline();
            this.callClient(Verb.POST, url, map);
        }
    }

    @Override
    public void setBuildStatusOnFinished() throws MalformedURLException {
        BitBucketPPRAction bitbucketAction = this.context.getAction();
        String url = bitbucketAction.getCommitLink();
        Result result = this.context.getRun().getResult();
        String state = result == Result.SUCCESS ? "SUCCESSFUL" : "FAILED";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", this.computeBitBucketBuildKey(this.context));
        map.put("url", this.context.getAbsoluteUrl());
        map.put("state", state);
        this.callClient(url, map);
    }

    @Override
    public void setBuildStatusInProgress() throws MalformedURLException {
        BitBucketPPRAction bitbucketAction = this.context.getAction();
        String url = bitbucketAction.getCommitLink();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", this.computeBitBucketBuildKey(this.context));
        map.put("url", this.context.getAbsoluteUrl());
        map.put("state", "INPROGRESS");
        this.callClient(url, map);
    }
}

