/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.environment;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.EnvironmentContributor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRPullRequestAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRPullRequestServerAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRRepositoryAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRServerRepositoryAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.cause.pullrequest.cloud.BitBucketPPRPullRequestCause;
import io.jenkins.plugins.bitbucketpushandpullrequest.cause.pullrequest.server.BitBucketPPRPullRequestServerCause;
import io.jenkins.plugins.bitbucketpushandpullrequest.cause.repository.BitBucketPPRRepositoryCause;
import io.jenkins.plugins.bitbucketpushandpullrequest.cause.repository.BitBucketPPRServerRepositoryCause;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

@Extension
public class BitBucketPPREnvironmentContributor
extends EnvironmentContributor {
    static final String BITBUCKET_PULL_REQUEST_ID = "BITBUCKET_PULL_REQUEST_ID";
    static final String BITBUCKET_PULL_REQUEST_LINK = "BITBUCKET_PULL_REQUEST_LINK";
    static final String BITBUCKET_TARGET_BRANCH = "BITBUCKET_TARGET_BRANCH";
    static final String BITBUCKET_REPOSITORY_UUID = "BITBUCKET_REPOSITORY_UUID";
    static final String BITBUCKET_REPOSITORY_ID = "BITBUCKET_REPOSITORY_ID";
    static final String BITBUCKET_REPOSITORY_URL = "BITBUCKET_REPOSITORY_URL";
    static final String BITBUCKET_SOURCE_BRANCH = "BITBUCKET_SOURCE_BRANCH";
    static final String BITBUCKET_PULL_REQUEST_COMMENT_TEXT = "BITBUCKET_PULL_REQUEST_COMMENT_TEXT";
    static final String REPOSITORY_LINK = "REPOSITORY_LINK";
    static final String REPOSITORY_NAME = "REPOSITORY_NAME";
    static final String BITBUCKET_ACTOR = "BITBUCKET_ACTOR";
    static final String BITBUCKET_PULL_REQUEST_TITLE = "BITBUCKET_PULL_REQUEST_TITLE";
    static final String BITBUCKET_PULL_REQUEST_DESCRIPTION = "BITBUCKET_PULL_REQUEST_DESCRIPTION";
    static final String BITBUCKET_PAYLOAD = "BITBUCKET_PAYLOAD";
    static final String BITBUCKET_X_EVENT = "BITBUCKET_X_EVENT";
    static final String BITBUCKET_PULL_REQUEST_LATEST_COMMIT_FROM_SOURCE_BRANCH = "BITBUCKET_PULL_REQUEST_LATEST_COMMIT_FROM_SOURCE_BRANCH";
    static final String BITBUCKET_PULL_REQUEST_LATEST_COMMIT_FROM_TARGET_BRANCH = "BITBUCKET_PULL_REQUEST_LATEST_COMMIT_FROM_TARGET_BRANCH";
    static final String BITBUCKET_PULL_REQUEST_IS_DRAFT = "BITBUCKET_PULL_REQUEST_IS_DRAFT";
    static final Logger logger = Logger.getLogger(BitBucketPPREnvironmentContributor.class.getName());

    public void buildEnvironmentFor(@NonNull Job job, @NonNull EnvVars envVars, @NonNull TaskListener taskListener) {
    }

    public void buildEnvironmentFor(@Nonnull Run run, @NonNull EnvVars envVars, @NonNull TaskListener taskListener) {
        List causes = null;
        if (run instanceof MatrixRun) {
            MatrixRun matrixRun = (MatrixRun)run;
            MatrixBuild parent = matrixRun.getParentBuild();
            if (parent != null) {
                causes = parent.getCauses();
            }
        } else {
            causes = run.getCauses();
        }
        if (causes == null) {
            return;
        }
        causes.forEach(cause -> {
            try {
                if (cause instanceof BitBucketPPRPullRequestCause) {
                    BitBucketPPRPullRequestCause castedCause = (BitBucketPPRPullRequestCause)((Object)cause);
                    BitBucketPPREnvironmentContributor.setEnvVarsForCloudPullRequest(envVars, castedCause.getPullRequestPayLoad(), castedCause.getHookEvent());
                } else if (cause instanceof BitBucketPPRPullRequestServerCause) {
                    BitBucketPPRPullRequestServerCause castedCause = (BitBucketPPRPullRequestServerCause)((Object)cause);
                    BitBucketPPREnvironmentContributor.setEnvVarsForServerPullRequest(envVars, castedCause.getPullRequestPayLoad(), castedCause.getHookEvent());
                } else if (cause instanceof BitBucketPPRRepositoryCause) {
                    BitBucketPPRRepositoryCause castedCause = (BitBucketPPRRepositoryCause)((Object)cause);
                    BitBucketPPREnvironmentContributor.setEnvVarsForCloudRepository(envVars, castedCause.getRepositoryPayLoad(), castedCause.getHookEvent());
                } else if (cause instanceof BitBucketPPRServerRepositoryCause) {
                    BitBucketPPRServerRepositoryCause castedCause = (BitBucketPPRServerRepositoryCause)((Object)cause);
                    BitBucketPPREnvironmentContributor.setEnvVarsForServerRepository(envVars, castedCause.getServerRepositoryPayLoad(), castedCause.getHookEvent());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.warning(String.format("Cannot build environment variables for cause %s %s.", cause.getShortDescription(), e));
            }
        });
    }

    private static void setEnvVarsForServerRepository(EnvVars envVars, BitBucketPPRServerRepositoryAction action, String hookEvent) {
        String targetBranch = action.getTargetBranch();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_TARGET_BRANCH, targetBranch);
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_SOURCE_BRANCH, targetBranch);
        String repoName = action.getRepositoryName();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, REPOSITORY_NAME, repoName);
        String actor = action.getUser();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_ACTOR, actor);
        String repositoryId = action.getRepositoryId();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_REPOSITORY_ID, repositoryId);
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_X_EVENT, hookEvent);
        String payload = action.getPayload().toString();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_PAYLOAD, payload);
    }

    private static void setEnvVarsForCloudRepository(EnvVars envVars, BitBucketPPRRepositoryAction action, String hookEvent) {
        String urlBranchDeprecated = action.getRepositoryUrl();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, REPOSITORY_LINK, urlBranchDeprecated);
        String targetBranch = action.getTargetBranch();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_TARGET_BRANCH, targetBranch);
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_SOURCE_BRANCH, targetBranch);
        String urlBranch = action.getRepositoryUrl();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_REPOSITORY_URL, urlBranch);
        String repositoryUuid = action.getRepositoryId();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_REPOSITORY_UUID, repositoryUuid);
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_REPOSITORY_ID, repositoryUuid);
        String actor = action.getUser();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_ACTOR, actor);
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_X_EVENT, hookEvent);
        String payload = action.getPayload().toString();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_PAYLOAD, payload);
    }

    private static void setEnvVarsForCloudPullRequest(EnvVars envVars, BitBucketPPRPullRequestAction action, String hookEvent) {
        String pullRequestGetLatestCommitFromSourceBranch = action.getLatestCommitFromRef();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_PULL_REQUEST_LATEST_COMMIT_FROM_SOURCE_BRANCH, pullRequestGetLatestCommitFromSourceBranch);
        String pullRequestGetLatestCommitFromTargetBranch = action.getLatestCommitToRef();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_PULL_REQUEST_LATEST_COMMIT_FROM_TARGET_BRANCH, pullRequestGetLatestCommitFromTargetBranch);
        String pullRequestSourceBranch = action.getSourceBranch();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_SOURCE_BRANCH, pullRequestSourceBranch);
        String pullRequestTargetBranch = action.getTargetBranch();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_TARGET_BRANCH, pullRequestTargetBranch);
        String pullRequestUrlBranch = action.getPullRequestUrl();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_PULL_REQUEST_LINK, pullRequestUrlBranch);
        String pullRequestId = action.getPullRequestId();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_PULL_REQUEST_ID, pullRequestId);
        Boolean isPullRequestDraft = action.getPayload().getPullRequest().getDraft();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_PULL_REQUEST_IS_DRAFT, isPullRequestDraft != false ? "true" : "false");
        String actor = action.getUser();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_ACTOR, actor);
        String title = action.getTitle();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_PULL_REQUEST_TITLE, title);
        String description = action.getDescription();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_PULL_REQUEST_DESCRIPTION, description);
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_X_EVENT, hookEvent);
        String payload = action.getPayload().toString();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_PAYLOAD, payload);
    }

    private static void setEnvVarsForServerPullRequest(EnvVars envVars, BitBucketPPRPullRequestServerAction action, String hookEvent) {
        String pullRequestGetLatestCommitFromSourceBranch = action.getLatestCommitFromRef();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_PULL_REQUEST_LATEST_COMMIT_FROM_SOURCE_BRANCH, pullRequestGetLatestCommitFromSourceBranch);
        String pullRequestGetLatestCommitFromTargetBranch = action.getLatestCommitToRef();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_PULL_REQUEST_LATEST_COMMIT_FROM_TARGET_BRANCH, pullRequestGetLatestCommitFromTargetBranch);
        String pullRequestSourceBranch = action.getSourceBranch();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_SOURCE_BRANCH, pullRequestSourceBranch);
        String pullRequestTargetBranch = action.getTargetBranch();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_TARGET_BRANCH, pullRequestTargetBranch);
        String pullRequestUrlBranch = action.getPullRequestUrl();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_PULL_REQUEST_LINK, pullRequestUrlBranch);
        String pullRequestId = action.getPullRequestId();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_PULL_REQUEST_ID, pullRequestId);
        String actor = action.getUser();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_ACTOR, actor);
        String title = action.getTitle();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_PULL_REQUEST_TITLE, title);
        String description = action.getDescription();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_PULL_REQUEST_DESCRIPTION, description);
        String payload = action.getPayload().toString();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_PAYLOAD, payload);
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_X_EVENT, hookEvent);
        String pullRequestCommentText = action.getServerComment();
        BitBucketPPREnvironmentContributor.putEnvVar(envVars, BITBUCKET_PULL_REQUEST_COMMENT_TEXT, pullRequestCommentText);
    }

    private static void putEnvVar(EnvVars envs, String name, String value) {
        envs.put(name, value == null ? "" : value);
    }
}

