/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.client.api;

import com.github.scribejava.core.model.Verb;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class BitBucketPPRBearerAuthorizationApiConsumer {
    private static final Logger logger = Logger.getLogger(BitBucketPPRBearerAuthorizationApiConsumer.class.getName());

    public HttpResponse send(StringCredentials credentials, Verb verb, String url, String payload) throws IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, NoSuchMethodException {
        logger.finest("Use BB Bearer Authorization for state notification");
        TrustStrategy acceptingTrustStrategy = (cert, authType) -> true;
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
        BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        String authHeader = "Bearer ".concat(credentials.getSecret().getPlainText());
        if (verb == Verb.POST) {
            HttpPost request = new HttpPost(url);
            request.setHeader("Authorization", authHeader);
            request.setHeader("X-Atlassian-Token", "nocheck");
            if (StringUtils.isNotBlank((CharSequence)payload)) {
                request.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
            }
            request.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
            return httpClient.execute((HttpUriRequest)request);
        }
        if (verb == Verb.DELETE) {
            HttpDelete request = new HttpDelete(url);
            request.setHeader("Authorization", authHeader);
            request.setHeader("X-Atlassian-Token", "nocheck");
            return httpClient.execute((HttpUriRequest)request);
        }
        throw new NoSuchMethodException();
    }
}

