/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.action;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRActionAbstract;
import io.jenkins.plugins.bitbucketpushandpullrequest.common.BitBucketPPRUtils;
import io.jenkins.plugins.bitbucketpushandpullrequest.exception.BitBucketPPRRepositoryNotParsedException;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRPayload;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.cloud.BitBucketPPRChange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;

public class BitBucketPPRRepositoryAction
extends BitBucketPPRActionAbstract
implements BitBucketPPRAction {
    private static final Logger logger = Logger.getLogger(BitBucketPPRAction.class.getName());
    public static final String COMMIT = "commit";
    private static final String BITBUCKET_API_BASE_URL = "https://api.bitbucket.org/2.0";
    private static final String BITBUCKET_REPOSITORIES = "repositories";
    @Nonnull
    private final BitBucketPPRPayload payload;
    private final String repoSlug;
    private final String workspace;
    private String targetBranchName;
    private String type;
    private String repositoryUuid;

    public BitBucketPPRRepositoryAction(@Nonnull BitBucketPPRPayload payload) {
        Map<String, String> workspaceRepo;
        this.payload = payload;
        for (BitBucketPPRChange change : payload.getPush().getChanges()) {
            if (change.getNewChange() == null) continue;
            this.targetBranchName = change.getNewChange().getName();
            this.type = change.getNewChange().getType();
            this.repositoryUuid = payload.getRepository().getUuid();
            break;
        }
        try {
            workspaceRepo = BitBucketPPRUtils.extractRepositoryNameFromHTTPSUrl(payload.getRepository().getLinks().getHtml().getHref());
        }
        catch (BitBucketPPRRepositoryNotParsedException e) {
            throw new RuntimeException(e);
        }
        this.repoSlug = workspaceRepo.get("repository");
        this.workspace = workspaceRepo.get("workspace");
        logger.log(Level.INFO, () -> "Received commit hook notification for branch: " + this.targetBranchName);
        logger.log(Level.INFO, () -> "Received commit hook type: " + this.type);
    }

    @Override
    public String getTargetBranch() {
        return this.targetBranchName;
    }

    @Override
    public String getRepositoryUrl() {
        return this.payload.getRepository().getLinks().getHtml().getHref();
    }

    @Override
    @NonNull
    public BitBucketPPRPayload getPayload() {
        return this.payload;
    }

    @Override
    public String getScm() {
        return this.payload.getRepository().getScm() != null ? this.payload.getRepository().getScm() : "git";
    }

    @Override
    public String getUser() {
        return this.payload.getActor().getNickname();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getRepositoryName() {
        return this.payload.getRepository().getName();
    }

    @Override
    public List<String> getScmUrls() {
        ArrayList<String> res = new ArrayList<String>();
        res.add(this.payload.getRepository().getLinks().getHtml().getHref());
        return res;
    }

    @Override
    public String getRepositoryId() {
        return this.repositoryUuid;
    }

    @Override
    public String getLatestCommit() {
        for (BitBucketPPRChange change : this.payload.getPush().getChanges()) {
            if (change.getNewChange() == null) continue;
            return change.getNewChange().getTarget().getHash();
        }
        return null;
    }

    @Override
    public List<String> getCommitLinks() {
        String baseCommitLink = ObjectUtils.isEmpty((Object)this.getPropagationUrl()) ? BITBUCKET_API_BASE_URL : this.getPropagationUrl();
        return this.payload.getPush().getChanges().stream().map(c -> String.join((CharSequence)"/", baseCommitLink, BITBUCKET_REPOSITORIES, this.workspace, this.repoSlug, COMMIT, c.getNewChange().getTarget().getHash())).collect(Collectors.toList());
    }

    public String toString() {
        return "BitBucketPPRRepositoryAction";
    }
}

