/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.action;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRActionAbstract;
import io.jenkins.plugins.bitbucketpushandpullrequest.config.BitBucketPPRPluginConfig;
import io.jenkins.plugins.bitbucketpushandpullrequest.exception.BitBucketPPRPayloadPropertyNotFoundException;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRHookEvent;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRPayload;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.server.BitBucketPPRServerClone;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;

public class BitBucketPPRPullRequestServerAction
extends BitBucketPPRActionAbstract
implements BitBucketPPRAction {
    private static final Logger logger = Logger.getLogger(BitBucketPPRPullRequestServerAction.class.getName());
    @Nonnull
    private final BitBucketPPRPayload payload;
    private URL baseUrl;
    private List<String> scmUrls = new ArrayList<String>(2);
    private String repositoryUuid;
    private static final BitBucketPPRPluginConfig globalConfig = BitBucketPPRPluginConfig.getInstance();
    private final BitBucketPPRHookEvent bitbucketEvent;

    public BitBucketPPRPullRequestServerAction(@Nonnull BitBucketPPRPayload payload, BitBucketPPRHookEvent bitbucketEvent) throws BitBucketPPRPayloadPropertyNotFoundException {
        this.payload = payload;
        this.bitbucketEvent = bitbucketEvent;
        if (Objects.isNull(payload.getServerPullRequest().getToRef()) || Objects.isNull(payload.getServerPullRequest().getToRef().getRepository()) || Objects.isNull(payload.getServerPullRequest().getToRef().getRepository().getLinks()) || Objects.isNull(payload.getServerPullRequest().getToRef().getRepository().getLinks().getCloneProperty())) {
            throw new BitBucketPPRPayloadPropertyNotFoundException("A property (toRef -> repository -> links -> clone ) was not found in the JSON payload.");
        }
        List<BitBucketPPRServerClone> clones = payload.getServerPullRequest().getToRef().getRepository().getLinks().getCloneProperty();
        if (clones.isEmpty()) {
            throw new BitBucketPPRPayloadPropertyNotFoundException("Number of clone urls in JSON payload is zero.");
        }
        for (BitBucketPPRServerClone clone : clones) {
            if (clone.getName().equalsIgnoreCase("http") || clone.getName().equalsIgnoreCase("https")) {
                try {
                    this.baseUrl = new URL(clone.getHref());
                    this.scmUrls.add(clone.getHref());
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!clone.getName().equalsIgnoreCase("ssh")) continue;
            this.scmUrls.add(clone.getHref());
        }
        if (globalConfig.isPropagationUrlSet()) {
            try {
                this.baseUrl = new URL(globalConfig.getPropagationUrl());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        logger.fine("BitBucketPPRPullRequestServerAction was called.");
    }

    @Override
    public String getSourceBranch() {
        return this.payload.getServerPullRequest().getFromRef().getDisplayId();
    }

    @Override
    public String getLatestCommitFromRef() {
        return this.payload.getServerPullRequest().getFromRef().getLatestCommit();
    }

    @Override
    public String getLatestCommitToRef() {
        return this.payload.getServerPullRequest().getToRef().getLatestCommit();
    }

    @Override
    public String getTargetBranch() {
        return this.payload.getServerPullRequest().getToRef().getDisplayId();
    }

    @Override
    public String getTargetBranchRefId() {
        return this.payload.getServerPullRequest().getToRef().getId();
    }

    @Override
    public String getPullRequestApiUrl() {
        return this.baseUrl.toString();
    }

    @Override
    public String getScm() {
        return this.payload.getServerPullRequest().getFromRef().getRepository().getScmId();
    }

    @Override
    public String getUser() {
        return this.payload.getServerActor().getName();
    }

    @Override
    public String getTitle() {
        return this.payload.getServerPullRequest().getTitle();
    }

    @Override
    @NonNull
    public BitBucketPPRPayload getPayload() {
        return this.payload;
    }

    @Override
    public String getRepositoryName() {
        return this.payload.getServerRepository().getName();
    }

    @Override
    public String getServerComment() {
        if (this.payload.getServerComment() == null) {
            return "";
        }
        return this.payload.getServerComment().getText();
    }

    @Override
    public List<String> getScmUrls() {
        return this.scmUrls;
    }

    @Override
    public String getPullRequestId() {
        return Long.toString(this.payload.getServerPullRequest().getId());
    }

    @Override
    public String getRepositoryId() {
        return this.repositoryUuid;
    }

    @Override
    public String getLinkApprove() throws MalformedURLException {
        String projectKey = this.payload.getServerPullRequest().getFromRef().getRepository().getProject().getKey();
        String repoSlug = this.payload.getServerPullRequest().getFromRef().getRepository().getSlug();
        Long pullrequestId = this.payload.getServerPullRequest().getId();
        return this.getBaseUrl() + "/rest/api/1.0/projects/" + projectKey.trim() + "/repos/" + repoSlug.trim() + "/pull-requests/" + Long.toString(pullrequestId).trim() + "/approve";
    }

    @Override
    public String getLinkDecline() throws MalformedURLException {
        String projectKey = this.payload.getServerPullRequest().getFromRef().getRepository().getProject().getKey();
        String repoSlug = this.payload.getServerPullRequest().getFromRef().getRepository().getSlug();
        Long pullrequestId = this.payload.getServerPullRequest().getId();
        return this.getBaseUrl() + "/rest/api/1.0/projects/" + projectKey.trim() + "/repos/" + repoSlug.trim() + "/pull-requests/" + Long.toString(pullrequestId).trim() + "/decline";
    }

    @Override
    public String getLatestCommit() {
        if ("merged".equalsIgnoreCase(this.bitbucketEvent.getAction())) {
            return this.payload.getServerPullRequest().getProperties().getMergeCommit().getId();
        }
        return this.payload.getServerPullRequest().getFromRef().getLatestCommit();
    }

    @Override
    public String getCommitLink() throws MalformedURLException {
        String commitId = this.getLatestCommit();
        return this.getBaseUrl() + "/rest/build-status/1.0/commits/" + commitId;
    }

    private String getBaseUrl() throws MalformedURLException {
        URL baseCommitLink = ObjectUtils.isEmpty((Object)this.getPropagationUrl()) ? this.baseUrl : new URL(this.getPropagationUrl());
        return baseCommitLink.getProtocol() + "://" + baseCommitLink.getHost() + ":" + baseCommitLink.getPort();
    }

    public String toString() {
        return "BitBucketPPRPullRequestServerAction";
    }

    public String setBaseUrl(String url) {
        try {
            this.baseUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return url;
    }
}

