/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest;

import hudson.model.Job;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitStatus;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.ACLContext;
import io.jenkins.plugins.bitbucketpushandpullrequest.BitBucketPPRTrigger;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.config.BitBucketPPRPluginConfig;
import io.jenkins.plugins.bitbucketpushandpullrequest.exception.TriggerNotSetException;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRHookEvent;
import io.jenkins.plugins.bitbucketpushandpullrequest.observer.BitBucketPPRObservable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.branch.MultiBranchProject;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.triggers.SCMTriggerItem;
import org.eclipse.jgit.transport.URIish;
import org.springframework.security.core.Authentication;

public class BitBucketPPRJobProbe {
    private static final Logger logger = Logger.getLogger(BitBucketPPRJobProbe.class.getName());
    private static final BitBucketPPRPluginConfig globalConfig = BitBucketPPRPluginConfig.getInstance();
    private final List<SCM> scmTriggered = new ArrayList<SCM>();

    public void triggerMatchingJobs(BitBucketPPRHookEvent bitbucketEvent, BitBucketPPRAction bitbucketAction, BitBucketPPRObservable observable) {
        block13: {
            if (!"git".equals(bitbucketAction.getScm()) && !"hg".equals(bitbucketAction.getScm())) {
                throw new UnsupportedOperationException(String.format("Unsupported SCM type %s", bitbucketAction.getScm()));
            }
            Function<String, URIish> makeUrl = a -> {
                try {
                    return new URIish(a);
                }
                catch (URISyntaxException e) {
                    logger.warning(String.format("Invalid URI %s.", e.getMessage()));
                    return null;
                }
            };
            List<URIish> remoteScmUrls = bitbucketAction.getScmUrls().stream().map(makeUrl).filter(Objects::nonNull).collect(Collectors.toList());
            try (ACLContext ctx = ACL.as2((Authentication)ACL.SYSTEM2);){
                if (globalConfig.isSingleJobSet()) {
                    Job job2;
                    block12: {
                        job2 = (Job)Jenkins.get().getItemByFullName(globalConfig.getSingleJob());
                        if (job2 != null) break block12;
                        logger.log(Level.WARNING, "Job could not be found!");
                        return;
                    }
                    try {
                        this.triggerScmForSingleJob(job2, remoteScmUrls, bitbucketEvent, bitbucketAction, observable);
                    }
                    catch (TriggerNotSetException e) {
                        logger.log(Level.FINE, "Trigger not set");
                    }
                    break block13;
                }
                Jenkins.get().getAllItems(Job.class).forEach(job -> {
                    try {
                        this.triggerScm((Job<?, ?>)job, remoteScmUrls, bitbucketEvent, bitbucketAction, observable);
                    }
                    catch (TriggerNotSetException e) {
                        logger.log(Level.FINE, "Trigger not set");
                    }
                });
            }
        }
    }

    private void triggerScmForSingleJob(@Nonnull Job<?, ?> job, List<URIish> remotes, BitBucketPPRHookEvent bitbucketEvent, BitBucketPPRAction bitbucketAction, BitBucketPPRObservable observable) throws TriggerNotSetException {
        Trigger jobTrigger = new Trigger(this.getBitBucketTrigger(job).orElseThrow(() -> new TriggerNotSetException(job.getFullDisplayName())), Optional.ofNullable(SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(job)));
        jobTrigger.scmTriggerItem.ifPresent(it -> it.getSCMs().forEach(scm -> {
            if (!this.scmTriggered.contains(scm)) {
                this.scmTriggered.add((SCM)scm);
                try {
                    jobTrigger.bitbucketTrigger.onPost(bitbucketEvent, bitbucketAction, (SCM)scm, observable);
                    return;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Error: {0}", e.getMessage());
                }
            }
            logger.log(Level.FINE, "{0} SCM doesn't match remote repo {1} or it was already triggered.", new Object[]{job.getName(), remotes});
        }));
    }

    private void triggerScm(@Nonnull Job<?, ?> job, List<URIish> remotes, BitBucketPPRHookEvent bitbucketEvent, BitBucketPPRAction bitbucketAction, BitBucketPPRObservable observable) throws TriggerNotSetException {
        Trigger jobTrigger = new Trigger(this.getBitBucketTrigger(job).orElseThrow(() -> new TriggerNotSetException(job.getFullDisplayName())), Optional.ofNullable(SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(job)));
        jobTrigger.scmTriggerItem.ifPresent(it -> it.getSCMs().forEach(scm -> {
            if (job.getParent() instanceof MultiBranchProject && this.mPJobShouldNotBeTriggered(job, bitbucketEvent, bitbucketAction)) {
                logger.log(Level.FINEST, "Skipping job {0}.", job.getDisplayName());
                return;
            }
            Predicate<URIish> checkSCM = url -> scm instanceof GitSCM && this.matchGitScm((SCM)scm, (URIish)url);
            if (remotes.stream().anyMatch(checkSCM) && !this.scmTriggered.contains(scm)) {
                this.scmTriggered.add((SCM)scm);
                try {
                    jobTrigger.bitbucketTrigger.onPost(bitbucketEvent, bitbucketAction, (SCM)scm, observable);
                    return;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Error: {0}", e.getMessage());
                }
            }
            logger.log(Level.FINE, "{0} SCM doesn't match remote repo {1} or it was already triggered.", new Object[]{job.getName(), remotes.stream().map(URIish::toString).collect(Collectors.joining(", "))});
        }));
    }

    private boolean mPJobShouldNotBeTriggered(Job<?, ?> job, BitBucketPPRHookEvent bitbucketEvent, BitBucketPPRAction bitbucketAction) {
        if (job.getDisplayName() != null) {
            String displayName = job.getDisplayName();
            String sourceBranchName = bitbucketAction.getSourceBranch();
            String targetBranchName = bitbucketAction.getTargetBranch();
            logger.log(Level.FINEST, "Bitbucket event is : {0}, Job Name : {1}, sourceBranchName: {2}, targetBranchName: {3}", new String[]{bitbucketEvent.getAction(), displayName, sourceBranchName, targetBranchName});
            if ("fulfilled".equalsIgnoreCase(bitbucketEvent.getAction())) {
                return !displayName.equalsIgnoreCase(targetBranchName);
            }
            if ("merged".equalsIgnoreCase(bitbucketEvent.getAction())) {
                return !displayName.equalsIgnoreCase(targetBranchName);
            }
            if (sourceBranchName != null) {
                return !displayName.equalsIgnoreCase(sourceBranchName);
            }
            if ("push".equalsIgnoreCase(bitbucketEvent.getAction()) && targetBranchName != null) {
                return !displayName.equals(targetBranchName);
            }
            if ("refs_changed".equalsIgnoreCase(bitbucketEvent.getAction()) && targetBranchName != null) {
                return !displayName.equals(targetBranchName);
            }
        }
        return true;
    }

    private Optional<BitBucketPPRTrigger> getBitBucketTrigger(Job<?, ?> job) {
        if (job instanceof ParameterizedJobMixIn.ParameterizedJob) {
            ParameterizedJobMixIn.ParameterizedJob pJob = (ParameterizedJobMixIn.ParameterizedJob)job;
            return pJob.getTriggers().values().stream().filter(BitBucketPPRTrigger.class::isInstance).findFirst().map(BitBucketPPRTrigger.class::cast);
        }
        return Optional.empty();
    }

    private boolean matchGitScm(SCM scm, URIish remote) {
        return ((GitSCM)scm).getRepositories().stream().anyMatch(repo -> repo.getURIs().stream().anyMatch(repoUrl -> GitStatus.looselyMatches((URIish)repoUrl, (URIish)remote)));
    }

    private static class Trigger {
        public final BitBucketPPRTrigger bitbucketTrigger;
        final Optional<SCMTriggerItem> scmTriggerItem;

        public Trigger(BitBucketPPRTrigger bitbucketTrigger, Optional<SCMTriggerItem> item) {
            this.bitbucketTrigger = bitbucketTrigger;
            this.scmTriggerItem = item;
        }
    }
}

