/*
 * The MIT License
 *
 * Copyright (c) 2025, Badge Plugin Authors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

Behaviour.specify('[id^="icon-only-badge"]', "CopyToClipboard", 0, (element) => {
    element.onclick = () => copy(element);
});

Behaviour.specify('[id^="text-only-badge"]', "CopyToClipboard", 0, (element) => {
    element.onclick = () => copy(element);
});

/**
 * Copy the text to the clipboard
 * @param element The element to get the text from and display the notification in
 */
function copy(element) {
    let text = element.dataset.text;

    if (text == null || text === "") {
        return;
    }

    navigator.clipboard
        .writeText(text)
        .then(() => {
            hoverNotification(
                "Copied to clipboard",
                element
            );
        })
        .catch((error) => {
            console.warn(error);
            hoverNotification(
                "Could not get permission to copy to clipboard",
                element
            );
        });
}
