/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.sftp.SftpClientTask;
import com.sshtools.client.tasks.AbstractFileTask;
import com.sshtools.client.tasks.FileTransferProgress;
import com.sshtools.common.util.Utils;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;

public class DownloadFileTask
extends AbstractFileTask {
    final Path remote;
    final Optional<Path> local;

    private DownloadFileTask(DownloadFileTaskBuilder builder) {
        super(builder);
        this.remote = builder.remote.orElseThrow(() -> new IllegalStateException("Remote path must be supplied."));
        this.local = builder.local;
    }

    public void doTask() {
        this.doTaskUntilDone(new SftpClientTask(this.con, self -> self.get(Utils.translatePathString((Path)this.remote), this.local.orElse(Path.of(self.lpwd(), new String[0])).toAbsolutePath().toString(), (FileTransferProgress)this.progress.orElse(null))));
    }

    public File getDownloadedFile() {
        return this.local.orElseThrow().toFile();
    }

    public static final class DownloadFileTaskBuilder
    extends AbstractFileTask.AbstractFileTaskBuilder<DownloadFileTaskBuilder, DownloadFileTask> {
        private Optional<Path> remote = Optional.empty();
        private Optional<Path> local = Optional.empty();

        private DownloadFileTaskBuilder() {
        }

        public static DownloadFileTaskBuilder create() {
            return new DownloadFileTaskBuilder();
        }

        public DownloadFileTaskBuilder withLocalFile(Optional<File> file) {
            return this.withLocal(file.map(File::toPath));
        }

        public DownloadFileTaskBuilder withLocal(Optional<Path> file) {
            this.local = file;
            return this;
        }

        public DownloadFileTaskBuilder withLocalFile(File file) {
            return this.withLocal(file.toPath());
        }

        public DownloadFileTaskBuilder withLocal(Path file) {
            return this.withLocal(Optional.of(file));
        }

        public DownloadFileTaskBuilder withRemotePath(Optional<String> remote) {
            return this.withRemote((Path)remote.map(x$0 -> Path.of(x$0, new String[0])).orElse(null));
        }

        public DownloadFileTaskBuilder withRemote(Path remote) {
            return this.withRemote(Optional.of(remote));
        }

        public DownloadFileTaskBuilder withRemote(Optional<Path> remote) {
            this.remote = remote;
            return this;
        }

        public DownloadFileTaskBuilder withRemotePath(String remote) {
            return this.withRemotePath(Optional.of(remote));
        }

        @Override
        public DownloadFileTask build() {
            return new DownloadFileTask(this);
        }
    }
}

