/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.ClientAuthenticator;
import com.sshtools.client.ClientStateListener;
import com.sshtools.client.ConnectionProtocolClient;
import com.sshtools.client.KeyPairAuthenticator;
import com.sshtools.client.PassphrasePrompt;
import com.sshtools.client.PasswordAuthenticator;
import com.sshtools.client.PrivateKeyFileAuthenticator;
import com.sshtools.client.SessionChannelNG;
import com.sshtools.client.SshClientContext;
import com.sshtools.client.tasks.CommandTask;
import com.sshtools.client.tasks.DownloadFileTask;
import com.sshtools.client.tasks.Task;
import com.sshtools.client.tasks.UploadFileTask;
import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventListener;
import com.sshtools.common.forwarding.ForwardingPolicy;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.UnauthorizedException;
import com.sshtools.common.ssh.Channel;
import com.sshtools.common.ssh.ChannelEventListener;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.synergy.nio.ConnectRequestFuture;
import com.sshtools.synergy.nio.ProtocolContext;
import com.sshtools.synergy.ssh.Connection;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.UnresolvedAddressException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SshClient
implements Closeable {
    public static final String GUEST_USERNAME = System.getProperty("maverick.guestUsername", "guest");
    public static final long DEFAULT_CONNECT_TIMEOUT = Long.parseLong(System.getProperty("maverick.defaultConnectTimeout", "30000"));
    private final SshClientContext sshContext;
    private final String hostname;
    private final int port;
    private final boolean closeConnection;
    private final Optional<OnConfiguration> onConfigure;
    private final String[] remotePublicKeys;
    private final Connection<SshClientContext> con;

    private SshClient(SshClientBuilder builder) throws IOException, SshException {
        this.sshContext = builder.sshContext.isPresent() ? builder.sshContext.get() : new SshClientContext();
        this.hostname = builder.hostname.orElse("localhost");
        this.port = builder.port.orElse(22);
        this.closeConnection = true;
        this.onConfigure = builder.onConfigure;
        this.sshContext.setUsername(builder.username.orElseGet(() -> GUEST_USERNAME));
        if (builder.stateListener.isPresent()) {
            this.sshContext.addStateListener(builder.stateListener.get());
        }
        if (builder.eventListener.isPresent()) {
            this.sshContext.setEventListener(builder.eventListener.get());
        }
        ArrayList<String> keys = new ArrayList<String>();
        this.con = this.doConnect(this.hostname, this.port, this.sshContext, builder.connectTimeout.map(Duration::toMillis).orElse(DEFAULT_CONNECT_TIMEOUT), keys);
        this.remotePublicKeys = keys.toArray(new String[0]);
        if (!builder.authenticators.isEmpty() || !builder.identities.isEmpty()) {
            ArrayList<ClientAuthenticator> auths = new ArrayList<ClientAuthenticator>(builder.authenticators);
            if (!builder.identities.isEmpty()) {
                auths.add(0, new KeyPairAuthenticator(builder.identities.toArray(new SshKeyPair[0])));
            }
            while (!this.isAuthenticated() && !auths.isEmpty()) {
                this.authenticate(auths.remove(0), builder.connectTimeout.map(Duration::toMillis).orElse(DEFAULT_CONNECT_TIMEOUT));
            }
            if (!this.isAuthenticated()) {
                this.close();
                throw new IOException("Authentication failed");
            }
        }
    }

    private SshClient(SshConnection con, boolean closeConnection) {
        this.con = (Connection)con;
        this.closeConnection = closeConnection;
        this.onConfigure = Optional.empty();
        this.sshContext = (SshClientContext)con.getContext();
        this.hostname = con.getRemoteIPAddress();
        this.port = con.getRemotePort();
        this.remotePublicKeys = con.getRemotePublicKeys();
    }

    protected final Connection<SshClientContext> doConnect(String hostname, int port, SshClientContext sshContext, long connectTimeout, final List<String> keys) throws SshException, IOException {
        if (this.onConfigure.isPresent()) {
            this.onConfigure.get().accept(sshContext);
        }
        try {
            ConnectRequestFuture future = sshContext.getEngine().connect(hostname, port, (ProtocolContext)sshContext, connectTimeout);
            future.waitFor(connectTimeout);
            if (!future.isSuccess()) {
                Throwable lastErr = future.getLastError();
                if (lastErr != null) {
                    if (lastErr instanceof IOException) {
                        throw (IOException)lastErr;
                    }
                    if (lastErr instanceof SshException) {
                        throw (SshException)lastErr;
                    }
                }
                throw new IOException(String.format("Failed to connect to %s:%d", hostname, port));
            }
            Connection con = future.getConnection();
            con.addEventListener(new EventListener(){

                public void processEvent(Event evt) {
                    switch (evt.getId()) {
                        case -16777211: {
                            keys.addAll(Arrays.asList(((String)evt.getAttribute("REMOTE_PUBLICKEYS")).split(",")));
                            break;
                        }
                        case -16776961: {
                            SshClient.this.disconnect();
                            break;
                        }
                    }
                }
            });
            if (!sshContext.getAuthenticators().isEmpty()) {
                con.getAuthenticatedFuture().waitForever();
                if (!con.getAuthenticatedFuture().isSuccess()) {
                    this.close();
                    throw new IOException(String.format("Failed to authenticate user %s at %s:%d", sshContext.getUsername(), hostname, port));
                }
            }
            return con;
        }
        catch (UnresolvedAddressException uae) {
            UnknownHostException uhe = new UnknownHostException(hostname);
            uhe.initCause(uae);
            throw uhe;
        }
    }

    public synchronized Task addTask(Task task) throws IOException {
        if (this.con == null) {
            throw new IOException("Client is no longer connected!");
        }
        this.con.addTask((ConnectionAwareTask)task);
        return task;
    }

    @Override
    public void close() throws IOException {
        if (this.closeConnection) {
            this.con.disconnect();
        }
    }

    public SshClientContext getContext() {
        return (SshClientContext)this.con.getContext();
    }

    public Connection<SshClientContext> getConnection() {
        return this.con;
    }

    public ForwardingPolicy getForwardingPolicy() {
        return ((SshClientContext)this.con.getContext()).getForwardingPolicy();
    }

    public int startLocalForwarding(String addressToBind, String destinationHost) throws UnauthorizedException, SshException {
        return this.startLocalForwarding(addressToBind, 0, destinationHost, 0);
    }

    public int startLocalForwarding(String addressToBind, int portToBind, String destinationHost, int destinationPort) throws UnauthorizedException, SshException {
        ConnectionProtocolClient client = (ConnectionProtocolClient)this.con.getConnectionProtocol();
        return client.startLocalForwarding(addressToBind, portToBind, destinationHost, destinationPort);
    }

    public void stopLocalForwarding(String addressToBind, int portToBind) {
        ConnectionProtocolClient client = (ConnectionProtocolClient)this.con.getConnectionProtocol();
        client.stopLocalForwarding(addressToBind, portToBind);
    }

    public void stopLocalForwarding() {
        ConnectionProtocolClient client = (ConnectionProtocolClient)this.con.getConnectionProtocol();
        client.stopLocalForwarding();
    }

    public int startRemoteForwarding(String addressToBind, int portToBind, String destinationHost, int destinationPort) throws SshException {
        ConnectionProtocolClient client = (ConnectionProtocolClient)this.con.getConnectionProtocol();
        return client.startRemoteForwarding(addressToBind, portToBind, destinationHost, destinationPort);
    }

    public int startRemoteForwarding(String addressToBind, String destinationHost) throws SshException {
        return this.startRemoteForwarding(addressToBind, 0, destinationHost, 0);
    }

    public void stopRemoteForwarding(String addressToBind, int portToBind) throws SshException {
        ConnectionProtocolClient client = (ConnectionProtocolClient)this.con.getConnectionProtocol();
        client.stopRemoteForwarding(addressToBind, portToBind);
    }

    public void stopRemoteForwarding() throws SshException {
        ConnectionProtocolClient client = (ConnectionProtocolClient)this.con.getConnectionProtocol();
        client.stopRemoteForwarding();
    }

    public boolean isConnected() {
        return !this.con.isDisconnected();
    }

    public void disconnect() {
        if (this.isConnected() && this.closeConnection) {
            this.con.disconnect();
        }
    }

    protected <T extends Task> T doTask(T task, long timeout) throws IOException {
        this.addTask(task);
        if (timeout > 0L) {
            task.waitFor(timeout);
        } else {
            task.waitForever();
        }
        if (!task.isDone()) {
            throw new IOException("Task did not complete before the specified timeout");
        }
        if (!task.isSuccess()) {
            if (!Objects.isNull(task.getLastError())) {
                if (task.getLastError() instanceof IOException) {
                    throw (IOException)task.getLastError();
                }
                throw new IOException(task.getLastError().getMessage(), task.getLastError());
            }
            throw new IOException("Task did not succeed but did not report an error");
        }
        return task;
    }

    public File getFile(String path) throws IOException {
        return this.getFile(path, 0L);
    }

    public File getFile(String path, long timeout) throws IOException {
        return this.doTask(((DownloadFileTask.DownloadFileTaskBuilder)DownloadFileTask.DownloadFileTaskBuilder.create().withConnection((SshConnection)this.getConnection())).withRemotePath(path).build(), timeout).getDownloadedFile();
    }

    public void getFile(String path, File destination) throws IOException {
        this.getFile(path, destination, 0L);
    }

    public void getFile(String path, File destination, long timeout) throws IOException {
        this.doTask(((DownloadFileTask.DownloadFileTaskBuilder)DownloadFileTask.DownloadFileTaskBuilder.create().withConnection((SshConnection)this.getConnection())).withRemotePath(path).withLocalFile(destination).build(), timeout);
    }

    public void putFile(File file) throws IOException {
        this.putFile(file, file.getName(), 0L);
    }

    public void putFile(File file, String path) throws IOException {
        this.putFile(file, path, 0L);
    }

    public void putFile(File file, String path, long timeout) throws IOException {
        this.doTask(((UploadFileTask.UploadFileTaskBuilder)UploadFileTask.UploadFileTaskBuilder.create().withConnection((SshConnection)this.getConnection())).withLocalFile(file).withRemotePath(path).build(), timeout);
    }

    public String executeCommand(String cmd) throws IOException {
        return this.executeCommand(cmd, 0L, "UTF-8");
    }

    public String executeCommand(String cmd, long timeout) throws IOException {
        return this.executeCommand(cmd, timeout, "UTF-8");
    }

    public String executeCommand(String cmd, String charset) throws IOException {
        return this.executeCommand(cmd, 0L, charset);
    }

    public String executeCommand(String cmd, long timeout, String charset) throws IOException {
        StringBuffer buffer = new StringBuffer();
        this.executeCommandWithResult(cmd, buffer, timeout, charset);
        return buffer.toString();
    }

    public int executeCommandWithResult(String cmd, StringBuffer buffer) throws IOException {
        return this.executeCommandWithResult(cmd, buffer, 0L);
    }

    public int executeCommandWithResult(String cmd) throws IOException {
        return this.executeCommandWithResult(cmd, new StringBuffer(), 0L);
    }

    public int executeCommandWithResult(String cmd, StringBuffer buffer, long timeout) throws IOException {
        return this.executeCommandWithResult(cmd, buffer, timeout, "UTF-8");
    }

    public int executeCommandWithResult(String cmd, StringBuffer buffer, String charset) throws IOException {
        return this.executeCommandWithResult(cmd, buffer, 0L, charset);
    }

    public int executeCommandWithResult(String cmd, StringBuffer buffer, long timeout, String charset) throws IOException {
        InteractiveOutputListener listener = new InteractiveOutputListener(buffer);
        CommandTask task = ((CommandTask.CommandTaskBuilder)CommandTask.CommandTaskBuilder.create().withCommand(cmd).withClient(this)).withEncoding(charset).onBeforeExecute((t, session) -> session.addEventListener(listener)).onTask((t, session) -> {
            try {
                while (session.getInputStream().read() > -1) {
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }).build();
        this.doTask(task, timeout);
        return task.getExitCode();
    }

    public Set<String> getAuthenticationMethods() {
        return this.sshContext.getAuthenticationClient().getSupportedAuthentications();
    }

    public boolean authenticate(ClientAuthenticator authenticator, long timeout) throws IOException, SshException {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Authenticating with {}", (Object[])new Object[]{authenticator.getName()});
        }
        this.sshContext.getAuthenticationClient().addAuthentication(authenticator);
        authenticator.waitFor(timeout);
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Authentication {}", (Object[])new Object[]{authenticator.isCancelled() ? "was cancelled" : (authenticator.isSuccess() ? "succeeded" : "failed")});
        }
        if (authenticator.isCancelled()) {
            throw new SshException("Authentication cancelled.", 8);
        }
        return authenticator.isDone() && authenticator.isSuccess();
    }

    public boolean isAuthenticated() {
        return this.con.getAuthenticatedFuture().isDone() && this.con.getAuthenticatedFuture().isSuccess();
    }

    public <T extends Task> void runTask(T task, long timeout) throws IOException {
        this.doTask(task, timeout);
    }

    public <T extends Task> void runTask(T task) throws IOException {
        this.doTask(task, 0L);
    }

    public String[] getRemotePublicKeys() {
        return this.remotePublicKeys;
    }

    public String getRemoteIdentification() {
        return this.con.getRemoteIdentification();
    }

    public String getLocalIdentification() {
        return this.con.getLocalIdentification();
    }

    public String getHost() {
        return this.hostname;
    }

    public SshPublicKey getHostKey() {
        return this.con.getHostKey();
    }

    public SessionChannelNG openSessionChannel() throws SshException {
        return this.openSessionChannel(60000L, false);
    }

    public SessionChannelNG openSessionChannel(long timeout) throws SshException {
        return this.openSessionChannel(timeout, false);
    }

    public SessionChannelNG openSessionChannel(boolean autoConsume) throws SshException {
        return this.openSessionChannel(60000L, autoConsume);
    }

    public SessionChannelNG openSessionChannel(long timeout, boolean autoConsume) throws SshException {
        SessionChannelNG session = new SessionChannelNG((SshConnection)this.con, autoConsume);
        this.con.openChannel((Channel)session);
        session.getOpenFuture().waitFor(timeout);
        if (session.getOpenFuture().isSuccess()) {
            return session;
        }
        throw new SshException(String.format("Session was not opened after %d ms timeout threshold", timeout), 19);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SshClient openRemoteClient(String hostname, int port, String username) throws SshException, IOException, UnauthorizedException {
        int localPort = this.startLocalForwarding("127.0.0.1", 0, hostname, port);
        try {
            SshClient sshClient = SshClientBuilder.create().withHostname("127.0.0.1").withPort(localPort).withUsername(username).build();
            return sshClient;
        }
        finally {
            this.stopLocalForwarding("127.0.0.1", localPort);
        }
    }

    public int getPort() {
        return this.port;
    }

    public static void main(String[] args) throws IOException, SshException {
        Log.enableConsole((Log.Level)Log.Level.DEBUG);
        SshClientContext ctx = new SshClientContext();
        ctx.supportedPublicKeys().removeAllBut("rsa-sha2-256-cert-v01@openssh.com");
        SshClientBuilder.create().withSshContext(ctx).withHostname("10.0.200.14").withUsername("root").build();
    }

    public static final class SshClientBuilder {
        private Optional<SshClientContext> sshContext = Optional.empty();
        private Optional<String> hostname = Optional.empty();
        private Optional<Integer> port = Optional.empty();
        private Optional<String> username = Optional.empty();
        private Optional<Duration> connectTimeout = Optional.empty();
        private Set<ClientAuthenticator> authenticators = new LinkedHashSet<ClientAuthenticator>();
        private Set<SshKeyPair> identities = new LinkedHashSet<SshKeyPair>();
        private Optional<OnConfiguration> onConfigure = Optional.empty();
        private Optional<ClientStateListener> stateListener = Optional.empty();
        private Optional<EventListener> eventListener = Optional.empty();

        public SshClientBuilder onConfigure(OnConfiguration onConfigure) {
            this.onConfigure = Optional.of(onConfigure);
            return this;
        }

        public SshClientBuilder withPrivateKeyFile(Path file) {
            try {
                return this.addAuthenticators(new PrivateKeyFileAuthenticator(file));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public SshClientBuilder withPrivateKeyPaths(Collection<Path> paths) {
            for (Path path : paths) {
                this.withPrivateKeyFile(path);
            }
            return this;
        }

        public SshClientBuilder withPrivateKeyPaths(Collection<Path> paths, PassphrasePrompt prompt) {
            for (Path path : paths) {
                this.withPrivateKeyFile(path, prompt);
            }
            return this;
        }

        public SshClientBuilder withPrivateKeyFile(File file) {
            try {
                return this.addAuthenticators(new PrivateKeyFileAuthenticator(file));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public SshClientBuilder withPrivateKeyFile(File file, PassphrasePrompt prompt) {
            try {
                return this.addAuthenticators(new PrivateKeyFileAuthenticator(file, prompt));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public SshClientBuilder withPrivateKeyFile(Path path, PassphrasePrompt prompt) {
            try {
                return this.addAuthenticators(new PrivateKeyFileAuthenticator(path, prompt));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public SshClientBuilder withPrivateKeyFiles(Collection<File> files) {
            for (File file : files) {
                this.withPrivateKeyFile(file);
            }
            return this;
        }

        public SshClientBuilder withPrivateKeyFiles(Collection<File> files, PassphrasePrompt prompt) {
            for (File file : files) {
                this.withPrivateKeyFile(file, prompt);
            }
            return this;
        }

        public SshClientBuilder withPassword(char[] password) {
            return this.withPassword(password == null ? null : new String(password));
        }

        public SshClientBuilder withPassword(String password) {
            return this.withPassword(Optional.ofNullable(password));
        }

        public SshClientBuilder withPassword(Optional<String> password) {
            return this.withPasswordPrompt(() -> password.orElse(null));
        }

        public SshClientBuilder withPasswordPrompt(PasswordAuthenticator.PasswordPrompt prompt) {
            return this.addAuthenticators(PasswordAuthenticator.of(prompt));
        }

        public SshClientBuilder addIdentities(SshKeyPair ... identities) {
            return this.addIdentities(Arrays.asList(identities));
        }

        public SshClientBuilder addIdentities(Collection<SshKeyPair> identities) {
            this.identities.addAll(identities);
            return this;
        }

        public SshClientBuilder withIdentities(SshKeyPair ... identities) {
            this.identities.clear();
            return this.addIdentities(identities);
        }

        public SshClientBuilder withIdentities(Collection<SshKeyPair> identities) {
            this.identities.clear();
            return this.addIdentities(identities);
        }

        public SshClientBuilder addAuthenticators(ClientAuthenticator ... authenticators) {
            return this.addAuthenticators(Arrays.asList(authenticators));
        }

        public SshClientBuilder addAuthenticators(Collection<ClientAuthenticator> authenticators) {
            this.authenticators.addAll(authenticators);
            return this;
        }

        public SshClientBuilder withAuthenticators(ClientAuthenticator ... authenticators) {
            return this.withAuthenticators(Arrays.asList(authenticators));
        }

        public SshClientBuilder withAuthenticators(Collection<ClientAuthenticator> authenticators) {
            this.authenticators.clear();
            return this.addAuthenticators(authenticators);
        }

        public SshClientBuilder withListener(ClientStateListener listener) {
            this.stateListener = Optional.of(listener);
            return this;
        }

        public SshClientBuilder withConnectTimeout(long connectTimeout) {
            return this.withConnectTimeout(Duration.ofMillis(connectTimeout));
        }

        public SshClientBuilder withConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = Optional.of(connectTimeout);
            return this;
        }

        public SshClientBuilder withUsername(String username) {
            return this.withUsername("".equals(username) ? Optional.empty() : Optional.ofNullable(username));
        }

        public SshClientBuilder withCurrentUsername(String username) {
            return this.withUsername(System.getProperty("user.name"));
        }

        public SshClientBuilder withUsername(Optional<String> username) {
            this.username = username;
            return this;
        }

        public SshClientBuilder withPort(int port) {
            return this.withPort(Optional.of(port));
        }

        public SshClientBuilder withPort(Optional<Integer> port) {
            this.port = port;
            return this;
        }

        public SshClientBuilder withHost(InetAddress address) {
            return this.withHostname(address.getHostName());
        }

        public SshClientBuilder withHostname(String hostname) {
            this.hostname = Optional.of(hostname);
            return this;
        }

        public SshClientBuilder withTarget(InetSocketAddress address) {
            return this.withHostname(address.getHostName()).withPort(address.getPort());
        }

        public SshClientBuilder withTarget(String hostname, int port) {
            return this.withHostname(hostname).withPort(port);
        }

        public SshClientBuilder withSshContext(SshClientContext context) {
            this.sshContext = Optional.of(context);
            return this;
        }

        public static SshClientBuilder create() {
            return new SshClientBuilder();
        }

        public static PreConnectedSshClientBuilder create(SshConnection connection) {
            return new PreConnectedSshClientBuilder(connection);
        }

        private SshClientBuilder() {
        }

        public SshClient build() throws IOException, SshException {
            return new SshClient(this);
        }

        public SshClientBuilder withEventListener(EventListener eventListener) {
            this.eventListener = Optional.of(eventListener);
            return this;
        }
    }

    @FunctionalInterface
    public static interface OnConfiguration {
        public void accept(SshClientContext var1) throws IOException, SshException;
    }

    class InteractiveOutputListener
    implements ChannelEventListener {
        StringBuffer output;

        InteractiveOutputListener(StringBuffer output) {
            this.output = output;
        }

        public void onChannelDataIn(Channel channel, ByteBuffer buffer) {
            this.recordOutput(buffer);
        }

        public void onChannelExtendedData(Channel channel, ByteBuffer buffer, int type) {
            this.recordOutput(buffer);
        }

        private synchronized void recordOutput(ByteBuffer buffer) {
            byte[] tmp = new byte[buffer.remaining()];
            buffer.get(tmp);
            try {
                this.output.append(new String(tmp, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    public static final class PreConnectedSshClientBuilder {
        private final SshConnection con;
        private boolean closeOnDisconnect = true;

        private PreConnectedSshClientBuilder(SshConnection con) {
            this.con = con;
        }

        public PreConnectedSshClientBuilder withoutCloseOnDisconnect() {
            this.closeOnDisconnect = false;
            return this;
        }

        public SshClient build() {
            return new SshClient(this.con, this.closeOnDisconnect);
        }
    }
}

