/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.AbstractSessionChannel;
import com.sshtools.common.logger.Log;
import com.sshtools.common.shell.ShellPolicy;
import com.sshtools.common.ssh.ChannelRequestFuture;
import com.sshtools.common.ssh.SessionChannel;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.synergy.ssh.CachingDataWindow;
import com.sshtools.synergy.ssh.ChannelNG;
import java.io.EOFException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;

public class SessionChannelNG
extends AbstractSessionChannel
implements SessionChannel {
    CachingDataWindow extendedData;
    ChannelNG.ChannelInputStream stderrInputStream;

    public SessionChannelNG(SshConnection con) {
        this(con, false);
    }

    public SessionChannelNG(SshConnection con, boolean autoConsume) {
        this("session", ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMaxPacketSize(), ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMaxWindowSize(), ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMaxWindowSize(), ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMinWindowSize(), null, autoConsume);
    }

    public SessionChannelNG(SshConnection con, String channelName, boolean autoConsume) {
        this("session", ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMaxPacketSize(), ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMaxWindowSize(), ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMaxWindowSize(), ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMinWindowSize(), null, autoConsume);
    }

    public SessionChannelNG(String channelName, SshConnection con, boolean autoConsume) {
        this(channelName, ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMaxPacketSize(), ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMaxWindowSize(), ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMaxWindowSize(), ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMinWindowSize(), null, autoConsume);
    }

    public SessionChannelNG(String channelName, int maximumPacketSize, UnsignedInteger32 initialWindowSize, UnsignedInteger32 maximumWindowSpace, UnsignedInteger32 minimumWindowSpace, ChannelRequestFuture closeFuture, boolean autoConsume) {
        super(channelName, maximumPacketSize, initialWindowSize, maximumWindowSpace, minimumWindowSpace, closeFuture, autoConsume);
        this.extendedData = new CachingDataWindow(maximumWindowSpace.intValue(), true);
        this.stderrInputStream = new ChannelNG.ChannelInputStream((ChannelNG)this, this.extendedData);
    }

    public SessionChannelNG(int maximumPacketSize, UnsignedInteger32 initialWindowSize, UnsignedInteger32 maximumWindowSpace, UnsignedInteger32 minimumWindowSpace, ChannelRequestFuture closeFuture, boolean autoConsume) {
        this("session", maximumPacketSize, initialWindowSize, maximumWindowSpace, minimumWindowSpace, closeFuture, autoConsume);
    }

    public SessionChannelNG(int maximumPacketSize, UnsignedInteger32 initialWindowSize, UnsignedInteger32 maximumWindowSpace, UnsignedInteger32 minimumWindowSpace, boolean autoConsume) {
        this("session", maximumPacketSize, initialWindowSize, maximumWindowSpace, minimumWindowSpace, null, autoConsume);
    }

    public SessionChannelNG(int maximumPacketSize, UnsignedInteger32 initialWindowSize, UnsignedInteger32 maximumWindowSpace, UnsignedInteger32 minimumWindowSpace) {
        this("session", maximumPacketSize, initialWindowSize, maximumWindowSpace, minimumWindowSpace, null, false);
    }

    protected void onExtendedData(ByteBuffer data, int type) {
        super.onExtendedData(data, type);
        if (type == 1) {
            try {
                this.extendedData.put(data);
            }
            catch (EOFException e) {
                Log.error((String)"Attempt to write extended data to channel cache failed because the cache is closed", (Object[])new Object[0]);
                this.close();
            }
        }
    }

    public InputStream getStderrStream() {
        return this.stderrInputStream;
    }

    protected boolean checkWindowSpace() {
        if (Log.isTraceEnabled()) {
            Log.trace((String)("Checking window space on channel=" + this.getLocalId() + " window=" + this.localWindow.getWindowSpace() + (String)(Objects.nonNull(this.cache) ? " cached=" + this.cache.remaining() : "") + (String)(Objects.nonNull(this.extendedData) ? " extended=" + this.extendedData.remaining() : "")), (Object[])new Object[0]);
        }
        return this.localWindow.getWindowSpace().longValue() + (long)(Objects.nonNull(this.cache) ? this.cache.remaining() : 0) + (long)(Objects.nonNull(this.extendedData) ? this.extendedData.remaining() : 0) <= this.localWindow.getMinimumWindowSpace().longValue();
    }

    public UnsignedInteger32 getMaximumWindowSpace() {
        return this.localWindow.getMaximumWindowSpace();
    }

    public UnsignedInteger32 getMinimumWindowSpace() {
        return this.localWindow.getMinimumWindowSpace();
    }

    public void onSessionOpen() {
    }
}

