/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.AuthenticationMessage;
import com.sshtools.client.ClientAuthenticator;
import com.sshtools.client.NotifiedPrompt;
import com.sshtools.client.SimpleClientAuthenticator;
import com.sshtools.client.TransportProtocolClient;
import com.sshtools.common.ssh.SshException;
import com.sshtools.synergy.util.EncodingUtils;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Supplier;

public class PasswordAuthenticator
extends SimpleClientAuthenticator {
    private final PasswordPrompt password;
    private String lastPassword;

    public static PasswordAuthenticator of(PasswordPrompt password) {
        return new PasswordAuthenticator(password);
    }

    public static PasswordAuthenticator forPassword(String password) {
        return new PasswordAuthenticator(() -> password);
    }

    public static PasswordAuthenticator forPassword(char[] password) {
        return new PasswordAuthenticator(() -> new String(password));
    }

    PasswordAuthenticator(PasswordPrompt password) {
        this.password = password;
    }

    @Deprecated(forRemoval=true, since="3.1.3")
    public PasswordAuthenticator(String password) {
        this.password = () -> password;
    }

    @Deprecated(forRemoval=true, since="3.1.3")
    public PasswordAuthenticator(char[] password) {
        this.password = () -> new String(password);
    }

    public String getPassword() {
        return (String)this.password.get();
    }

    public synchronized void done(boolean success) {
        try {
            super.done(success);
        }
        finally {
            this.password.completed(success, this.lastPassword, this);
        }
    }

    @Override
    public void authenticate(TransportProtocolClient transport, String username) throws SshException {
        this.lastPassword = this.getPassword();
        final byte[] tmp = EncodingUtils.getUTF8Bytes((String)this.lastPassword);
        if (Objects.isNull(tmp)) {
            this.cancel();
            return;
        }
        transport.postMessage(new AuthenticationMessage(username, "ssh-connection", "password"){

            @Override
            public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                super.writeMessageIntoBuffer(buf);
                buf.put((byte)0);
                buf.putInt(tmp.length);
                buf.put(tmp);
                return true;
            }
        });
    }

    @Override
    public String getName() {
        return "password";
    }

    @FunctionalInterface
    public static interface PasswordPrompt
    extends Supplier<String>,
    NotifiedPrompt {
        @Override
        default public void completed(boolean success, String value, ClientAuthenticator authenticator) {
        }
    }
}

