/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.SshClientContext;
import com.sshtools.common.nio.WriteOperationRequest;
import com.sshtools.common.ssh.ChannelOpenException;
import com.sshtools.common.ssh.ChannelRequestFuture;
import com.sshtools.common.ssh.RequestFuture;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.synergy.ssh.ChannelNG;
import com.sshtools.synergy.ssh.TerminalModes;
import java.io.IOException;

public abstract class AbstractSessionChannel
extends ChannelNG<SshClientContext> {
    public static final int EXITCODE_NOT_RECEIVED = Integer.MIN_VALUE;
    public static final int SSH_EXTENDED_DATA_STDERR = 1;
    private int exitcode = Integer.MIN_VALUE;
    private String exitsignalinfo;
    private boolean flowControlEnabled;
    private boolean singleSession = false;

    public AbstractSessionChannel(int maximumPacketSize, UnsignedInteger32 initialWindowSize, UnsignedInteger32 maximumWindowSpace, UnsignedInteger32 minimumWindowSpace, boolean autoConsume) {
        this("session", maximumPacketSize, initialWindowSize, maximumWindowSpace, minimumWindowSpace, new ChannelRequestFuture(), autoConsume);
    }

    public AbstractSessionChannel(int maximumPacketSize, UnsignedInteger32 initialWindowSize, UnsignedInteger32 maximumWindowSpace, UnsignedInteger32 minimumWindowSpace, ChannelRequestFuture closeFuture, boolean autoConsume) {
        this("session", maximumPacketSize, initialWindowSize, maximumWindowSpace, minimumWindowSpace, closeFuture, autoConsume);
    }

    public AbstractSessionChannel(String channelName, int maximumPacketSize, UnsignedInteger32 initialWindowSize, UnsignedInteger32 maximumWindowSpace, UnsignedInteger32 minimumWindowSpace, ChannelRequestFuture closeFuture, boolean autoConsume) {
        super(channelName, maximumPacketSize, initialWindowSize, maximumWindowSpace, minimumWindowSpace, closeFuture, autoConsume);
    }

    public boolean isSingleSession() {
        return this.singleSession;
    }

    public void setSingleSession(boolean singleSession) {
        this.singleSession = singleSession;
    }

    protected void onChannelFree() {
    }

    protected byte[] createChannel() throws IOException {
        return null;
    }

    protected byte[] openChannel(byte[] requestdata) throws WriteOperationRequest, ChannelOpenException {
        return null;
    }

    protected void onChannelOpenConfirmation() {
    }

    protected void onChannelError(Throwable e) {
    }

    protected void onChannelClosed() {
        if (this.singleSession) {
            this.con.disconnect();
        }
    }

    protected void onChannelOpen() {
    }

    public RequestFuture allocatePseudoTerminal(String type) {
        return this.allocatePseudoTerminal(type, 80, 25);
    }

    public RequestFuture allocatePseudoTerminal(String type, int cols, int rows) {
        return this.allocatePseudoTerminal(type, cols, rows, 0, 0, null);
    }

    public RequestFuture allocatePseudoTerminal(String type, int cols, int rows, TerminalModes modes) {
        return this.allocatePseudoTerminal(type, cols, rows, 0, 0, modes);
    }

    public void changeTerminalDimensions(int cols, int rows, int width, int height) {
        ByteArrayWriter request = new ByteArrayWriter();
        try {
            request.writeInt(cols);
            request.writeInt(rows);
            request.writeInt(width);
            request.writeInt(height);
            this.sendChannelRequest("window-change", false, request.toByteArray());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
        finally {
            try {
                request.close();
            }
            catch (IOException iOException) {}
        }
    }

    public RequestFuture signal(String signal) {
        ChannelRequestFuture channelRequestFuture;
        ByteArrayWriter request = new ByteArrayWriter();
        try {
            request.writeString(signal);
            ChannelRequestFuture future = new ChannelRequestFuture();
            this.sendChannelRequest("signal", true, request.toByteArray(), future);
            channelRequestFuture = future;
        }
        catch (Throwable throwable) {
            try {
                try {
                    request.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
        request.close();
        return channelRequestFuture;
    }

    public RequestFuture allocatePseudoTerminal(String type, int cols, int rows, int width, int height, TerminalModes modes) {
        ByteArrayWriter request = new ByteArrayWriter();
        try {
            request.writeString(type);
            request.writeInt(cols);
            request.writeInt(rows);
            request.writeInt(width);
            request.writeInt(height);
            if (modes == null) {
                request.writeInt(0);
            } else {
                request.writeBinaryString(modes.toByteArray());
            }
            ChannelRequestFuture future = new ChannelRequestFuture();
            this.sendChannelRequest("pty-req", true, request.toByteArray(), future);
            ChannelRequestFuture channelRequestFuture = future;
            return channelRequestFuture;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
        finally {
            try {
                request.close();
            }
            catch (IOException iOException) {}
        }
    }

    public RequestFuture setEnvironmentVariable(String key, String val) {
        ByteArrayWriter request = new ByteArrayWriter();
        try {
            request.writeString(key);
            request.writeString(val);
            ChannelRequestFuture future = new ChannelRequestFuture();
            this.sendChannelRequest("env", true, request.toByteArray(), future);
            ChannelRequestFuture channelRequestFuture = future;
            return channelRequestFuture;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
        finally {
            try {
                request.close();
            }
            catch (IOException iOException) {}
        }
    }

    public RequestFuture startShell() {
        ChannelRequestFuture future = new ChannelRequestFuture();
        this.sendChannelRequest("shell", true, null, future);
        return future;
    }

    public RequestFuture executeCommand(String cmd) {
        ByteArrayWriter request = new ByteArrayWriter();
        try {
            request.writeString(cmd);
            ChannelRequestFuture future = new ChannelRequestFuture();
            this.sendChannelRequest("exec", true, request.toByteArray(), future);
            ChannelRequestFuture channelRequestFuture = future;
            return channelRequestFuture;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
        finally {
            try {
                request.close();
            }
            catch (IOException iOException) {}
        }
    }

    public RequestFuture executeCommand(String cmd, String charset) {
        ByteArrayWriter request = new ByteArrayWriter();
        try {
            request.writeString(cmd, charset);
            ChannelRequestFuture future = new ChannelRequestFuture();
            this.sendChannelRequest("exec", true, request.toByteArray(), future);
            ChannelRequestFuture channelRequestFuture = future;
            return channelRequestFuture;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
        finally {
            try {
                request.close();
            }
            catch (IOException iOException) {}
        }
    }

    public RequestFuture startSubsystem(String subsystem) {
        ByteArrayWriter request = new ByteArrayWriter();
        try {
            request.writeString(subsystem, "UTF-8");
            ChannelRequestFuture future = new ChannelRequestFuture();
            this.sendChannelRequest("subsystem", true, request.toByteArray(), future);
            ChannelRequestFuture channelRequestFuture = future;
            return channelRequestFuture;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
        finally {
            try {
                request.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void onChannelClosing() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChannelRequest(String requesttype, boolean wantreply, byte[] requestdata) {
        try {
            if (requesttype.equals("exit-status") && requestdata != null) {
                this.exitcode = (int)ByteArrayReader.readInt((byte[])requestdata, (int)0);
            }
            if (requesttype.equals("exit-signal") && requestdata != null) {
                try (ByteArrayReader bar = new ByteArrayReader(requestdata, 0, requestdata.length);){
                    this.exitsignalinfo = "Signal=" + bar.readString() + " CoreDump=" + String.valueOf(bar.read() != 0) + " Message=" + bar.readString();
                }
            }
            if (requesttype.equals("xon-xoff")) {
                this.flowControlEnabled = requestdata != null && requestdata[0] != 0;
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unexpected I/O error reading channel request", ex);
        }
    }

    public int getExitCode() {
        return this.exitcode;
    }

    public boolean isFlowControlEnabled() {
        return this.flowControlEnabled;
    }

    public String getExitSignalInfo() {
        return this.exitsignalinfo;
    }

    protected void onRemoteEOF() {
    }

    protected void onLocalEOF() {
    }

    public int getMaximumRemotePacketLength() {
        return this.getRemotePacket();
    }

    public int getMaximumLocalPacketLength() {
        return this.getLocalPacket();
    }
}

