/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.direct;

import com.sshtools.common.events.Event;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.direct.NioFile;
import com.sshtools.common.permissions.PermissionDeniedException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public final class NioFileFactory
implements AbstractFileFactory<NioFile> {
    private final Path home;
    private final boolean sandbox;
    private final String username;
    private final String group;

    private NioFileFactory(NioFileFactoryBuilder nioFileFactoryBuilder) {
        this.username = null;
        this.group = null;
        this.home = nioFileFactoryBuilder.home.orElseGet(() -> Paths.get(System.getProperty("user.home"), new String[0]));
        this.sandbox = nioFileFactoryBuilder.sandbox;
    }

    @Override
    public NioFile getFile(String path) throws PermissionDeniedException, IOException {
        return new NioFile(path, this, this.home, this.sandbox);
    }

    @Override
    public Event populateEvent(Event evt) {
        return evt;
    }

    @Override
    public NioFile getDefaultPath() throws PermissionDeniedException, IOException {
        return this.getFile("");
    }

    Path home() {
        return this.home;
    }

    boolean isSandboxed() {
        return this.sandbox;
    }

    public static final class NioFileFactoryBuilder {
        private Optional<Path> home = Optional.empty();
        private boolean sandbox = true;
        public boolean mapOwnership;

        public static NioFileFactoryBuilder create() {
            return new NioFileFactoryBuilder();
        }

        private NioFileFactoryBuilder() {
        }

        public NioFileFactoryBuilder withSandbox(boolean sandbox) {
            this.sandbox = sandbox;
            return this;
        }

        public NioFileFactoryBuilder withMapOwnership() {
            this.mapOwnership = true;
            return this;
        }

        public NioFileFactoryBuilder withoutSandbox() {
            return this.withSandbox(false);
        }

        public NioFileFactoryBuilder withHome(Path home) {
            this.home = Optional.of(home);
            return this;
        }

        public NioFileFactoryBuilder withHome(File home) {
            return this.withHome(home.toPath());
        }

        public NioFileFactoryBuilder withCurrentDirectoryAsHome() {
            return this.withHome(Paths.get(System.getProperty("user.dir"), new String[0]));
        }

        public NioFileFactory build() {
            return new NioFileFactory(this);
        }
    }
}

