/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.util;

import com.microsoft.azure.vmagent.AzureVMAgent;
import com.microsoft.azure.vmagent.AzureVMAgentTemplate;
import com.microsoft.azure.vmagent.AzureVMComputer;
import com.microsoft.azure.vmagent.util.TemplateUtil;
import hudson.model.Computer;
import hudson.model.Label;
import hudson.model.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public final class DynamicBufferCalculator {
    private static final Logger LOGGER = Logger.getLogger(DynamicBufferCalculator.class.getName());

    private DynamicBufferCalculator() {
    }

    public static int countQueuedItemsForTemplate(AzureVMAgentTemplate template) {
        int queueCount = 0;
        Queue queue = Jenkins.get().getQueue();
        Queue.Item[] items = queue.getItems();
        String templateLabels = template.getLabels();
        boolean templateHasLabels = templateLabels != null && !templateLabels.trim().isEmpty();
        for (Queue.Item item : items) {
            boolean matches;
            if (!(item instanceof Queue.BuildableItem)) continue;
            Label itemLabel = item.getAssignedLabel();
            boolean bl = matches = itemLabel == null || !templateHasLabels;
            if (!matches && itemLabel != null) {
                String itemLabelName = itemLabel.getName();
                matches = templateLabels.contains(itemLabelName);
            }
            if (!matches) continue;
            ++queueCount;
        }
        LOGGER.log(Level.FINE, "Template {0} has {1} queued items", new Object[]{template.getTemplateName(), queueCount});
        return queueCount;
    }

    public static int calculateMachinesToProvision(AzureVMAgentTemplate template, int effectivePoolSize, int currentTotalMachines) {
        int deficit = effectivePoolSize - currentTotalMachines;
        int toProvision = Math.max(0, deficit);
        String templateName = template != null ? template.getTemplateName() : "unknown";
        LOGGER.log(Level.FINE, "Template {0}: effectivePoolSize={1}, currentTotal={2}, toProvision={3}", new Object[]{templateName, effectivePoolSize, currentTotalMachines, toProvision});
        return toProvision;
    }

    public static BufferMetrics calculateBufferMetrics(AzureVMAgentTemplate template) {
        int busy = 0;
        int idle = 0;
        int total = 0;
        for (Computer computer : Jenkins.get().getComputers()) {
            AzureVMComputer azureComputer;
            AzureVMAgent agent;
            if (!(computer instanceof AzureVMComputer) || (agent = (AzureVMAgent)(azureComputer = (AzureVMComputer)computer).getNode()) == null || !TemplateUtil.checkSame(agent.getTemplate(), template)) continue;
            ++total;
            if (computer.isIdle() && computer.isOnline()) {
                ++idle;
                continue;
            }
            if (computer.isIdle()) continue;
            ++busy;
        }
        int queued = DynamicBufferCalculator.countQueuedItemsForTemplate(template);
        LOGGER.log(Level.FINE, "Template {0}: busy={1}, idle={2}, total={3}, queued={4}", new Object[]{template.getTemplateName(), busy, idle, total, queued});
        return new BufferMetrics(busy, idle, total, queued);
    }

    public record BufferMetrics(int busyMachines, int idleMachines, int totalMachines, int queuedItems) {
    }
}

