/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.builders;

import com.microsoft.azure.vmagent.AzureTagPair;
import com.microsoft.azure.vmagent.AzureVMCloudBaseRetentionStrategy;
import com.microsoft.azure.vmagent.AzureVMCloudPoolRetentionStrategy;
import com.microsoft.azure.vmagent.AzureVMCloudRetensionStrategy;
import com.microsoft.azure.vmagent.builders.AdvancedImage;
import com.microsoft.azure.vmagent.builders.AdvancedImageBuilder;
import com.microsoft.azure.vmagent.builders.AdvancedImageFluent;
import com.microsoft.azure.vmagent.builders.BuiltInImage;
import com.microsoft.azure.vmagent.builders.BuiltInImageBuilder;
import com.microsoft.azure.vmagent.builders.BuiltInImageFluent;
import hudson.model.Node;
import java.util.ArrayList;
import java.util.List;

public class AzureVMTemplateFluent<T extends AzureVMTemplateFluent<T>> {
    private String name;
    private String description;
    private String workspace;
    private String labels;
    private String location = "Japan West";
    private String virtualMachineSize = "Standard_A0";
    private String storageAccountType = "Standard_LRS";
    private String storageAccountNameReferenceType = "new";
    private String diskType = "managed";
    private boolean ephemeralOSDisk;
    private boolean encryptionAtHost;
    private boolean disableWindowsUpdates;
    private int osDiskSize = 0;
    private String newStorageAccountName;
    private String existingStorageAccountName;
    private AzureVMCloudBaseRetentionStrategy retentionStrategy = new AzureVMCloudRetensionStrategy(60);
    private boolean shutdownOnIdle = false;
    private Node.Mode usageMode = Node.Mode.NORMAL;
    private String imageTopLevelType = "basic";
    private BuiltInImage builtInImage = new BuiltInImageBuilder().build();
    private AdvancedImage advancedImage = new AdvancedImageBuilder().build();
    private String credentialsId;
    private List<AzureTagPair> cloudTags = new ArrayList<AzureTagPair>();

    public T withName(String name) {
        this.name = name;
        return (T)this;
    }

    public T withTags(List<AzureTagPair> tags) {
        this.cloudTags = new ArrayList<AzureTagPair>(tags);
        return (T)this;
    }

    public T withDescription(String description) {
        this.description = description;
        return (T)this;
    }

    public T withWorkspace(String workspace) {
        this.workspace = workspace;
        return (T)this;
    }

    public T withLabels(String labels) {
        this.labels = labels;
        return (T)this;
    }

    public T withLocation(String location) {
        this.location = location;
        return (T)this;
    }

    public T withVirtualMachineSize(String virtualMachineSize) {
        this.virtualMachineSize = virtualMachineSize;
        return (T)this;
    }

    public T withStorageAccountType(String storageAccountType) {
        this.storageAccountType = storageAccountType;
        return (T)this;
    }

    public T withNewStorageAccount(String storageAccountName) {
        this.storageAccountNameReferenceType = "new";
        this.newStorageAccountName = storageAccountName;
        return (T)this;
    }

    public T withExistingStorageAccount(String storageAccountName) {
        this.storageAccountNameReferenceType = "existing";
        this.existingStorageAccountName = storageAccountName;
        return (T)this;
    }

    public T withDiskType(String diskType) {
        this.diskType = diskType;
        return (T)this;
    }

    public T withEphemeralOSDisk(boolean isEphemeral) {
        this.ephemeralOSDisk = isEphemeral;
        return (T)this;
    }

    public T withEncryptionAtHost(boolean isEncryptionAtHost) {
        this.encryptionAtHost = isEncryptionAtHost;
        return (T)this;
    }

    public T withDisableWindowsUpdates(boolean isDisableWindowsUpdates) {
        this.disableWindowsUpdates = isDisableWindowsUpdates;
        return (T)this;
    }

    public T withOsDiskSize(int osDiskSize) {
        this.osDiskSize = osDiskSize;
        return (T)this;
    }

    public T withRetentionStrategy(AzureVMCloudBaseRetentionStrategy retentionStrategy) {
        this.retentionStrategy = retentionStrategy;
        return (T)this;
    }

    public T addNewIdleRetentionStrategy(String retentionTime) {
        this.retentionStrategy = new AzureVMCloudRetensionStrategy(Integer.parseInt(retentionTime));
        return (T)this;
    }

    public T addNewPoolRetentionStrategy(String retentionTime, String poolSize, boolean singleUseAgents) {
        AzureVMCloudPoolRetentionStrategy retentionStrategy1 = new AzureVMCloudPoolRetentionStrategy(Integer.parseInt(retentionTime), Integer.parseInt(poolSize));
        retentionStrategy1.setSingleUseAgents(singleUseAgents);
        this.retentionStrategy = retentionStrategy1;
        return (T)this;
    }

    public T withShutdownOnIdle(boolean isShutdown) {
        this.shutdownOnIdle = isShutdown;
        return (T)this;
    }

    public T withUsageMode(Node.Mode usageMode) {
        this.usageMode = usageMode;
        return (T)this;
    }

    public T withBuiltInImage(BuiltInImage builtInImage) {
        this.imageTopLevelType = "basic";
        this.builtInImage = builtInImage;
        return (T)this;
    }

    public BuiltInImageNested addNewBuiltInImage() {
        return new BuiltInImageNested();
    }

    public BuiltInImageNested addNewBuiltInImageLike(BuiltInImage image) {
        return new BuiltInImageNested(image);
    }

    public T withAdvancedImage(AdvancedImage advancedImage) {
        this.imageTopLevelType = "advanced";
        this.advancedImage = advancedImage;
        return (T)this;
    }

    public AdvancedImageNested addNewAdvancedImage() {
        return new AdvancedImageNested();
    }

    public AdvancedImageNested addNewAdvancedImageLike(AdvancedImage image) {
        return new AdvancedImageNested(image);
    }

    public T withAdminCredential(String credentialsId) {
        this.credentialsId = credentialsId;
        return (T)this;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String getLabels() {
        return this.labels;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVirtualMachineSize() {
        return this.virtualMachineSize;
    }

    public String getStorageAccountType() {
        return this.storageAccountType;
    }

    public String getStorageAccountNameReferenceType() {
        return this.storageAccountNameReferenceType;
    }

    public String getDiskType() {
        return this.diskType;
    }

    public boolean isEphemeralOSDisk() {
        return this.ephemeralOSDisk;
    }

    public boolean isEncryptionAtHost() {
        return this.encryptionAtHost;
    }

    public boolean isDisableWindowsUpdates() {
        return this.disableWindowsUpdates;
    }

    public int getOsDiskSize() {
        return this.osDiskSize;
    }

    public String getNewStorageAccountName() {
        return this.newStorageAccountName;
    }

    public String getExistingStorageAccountName() {
        return this.existingStorageAccountName;
    }

    public AzureVMCloudBaseRetentionStrategy getRetentionStrategy() {
        return this.retentionStrategy;
    }

    public boolean isShutdownOnIdle() {
        return this.shutdownOnIdle;
    }

    public Node.Mode getUsageMode() {
        return this.usageMode;
    }

    public String getImageTopLevelType() {
        return this.imageTopLevelType;
    }

    public BuiltInImage getBuiltInImage() {
        return this.builtInImage;
    }

    public AdvancedImage getAdvancedImage() {
        return this.advancedImage;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    List<AzureTagPair> getCloudTags() {
        return new ArrayList<AzureTagPair>(this.cloudTags);
    }

    public class BuiltInImageNested
    extends BuiltInImageFluent<BuiltInImageNested> {
        private final BuiltInImageBuilder builder;

        BuiltInImageNested() {
            this.builder = new BuiltInImageBuilder(this);
        }

        BuiltInImageNested(BuiltInImage image) {
            this.builder = new BuiltInImageBuilder(this, image);
        }

        public T endBuiltInImage() {
            return AzureVMTemplateFluent.this.withBuiltInImage(this.builder.build());
        }
    }

    public class AdvancedImageNested
    extends AdvancedImageFluent<AdvancedImageNested> {
        private final AdvancedImageBuilder builder;

        AdvancedImageNested() {
            this.builder = new AdvancedImageBuilder(this);
        }

        AdvancedImageNested(AdvancedImage image) {
            this.builder = new AdvancedImageBuilder(this, image);
        }

        public T endAdvancedImage() {
            return AzureVMTemplateFluent.this.withAdvancedImage(this.builder.build());
        }
    }
}

