/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.microsoft.azure.vmagent.AzureVMAgentTemplate;
import com.microsoft.azure.vmagent.AzureVMCloud;
import com.microsoft.azure.vmagent.AzureVMCloudPoolRetentionStrategy;
import com.microsoft.azure.vmagent.AzureVMCloudVerificationTask;
import com.microsoft.azure.vmagent.util.DynamicBufferCalculator;
import com.microsoft.azure.vmagent.util.PoolLock;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class AzureVMMaintainPoolTask
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(AzureVMMaintainPoolTask.class.getName());
    private static final int RECURRENCE_PERIOD_IN_MILLIS = 300000;

    public AzureVMMaintainPoolTask() {
        super("Azure VM Maintainer Pool Size");
    }

    public void maintain(AzureVMCloud cloud, AzureVMAgentTemplate template) {
        LOGGER.log(this.getNormalLoggingLevel(), "Starting to maintain template: {0}", template.getTemplateName());
        if (PoolLock.checkProvisionLock(template)) {
            LOGGER.log(this.getNormalLoggingLevel(), "Agents of template {0} is creating, check later", template);
            return;
        }
        AzureVMCloudPoolRetentionStrategy retentionStrategy = (AzureVMCloudPoolRetentionStrategy)template.getRetentionStrategy();
        DynamicBufferCalculator.BufferMetrics metrics = DynamicBufferCalculator.calculateBufferMetrics(template);
        int effectivePoolSize = retentionStrategy.calculateEffectivePoolSize(metrics.busyMachines(), metrics.queuedItems());
        LOGGER.log(this.getNormalLoggingLevel(), "Template {0}: busy={1}, idle={2}, total={3}, queued={4}, effectivePoolSize={5}", new Object[]{template.getTemplateName(), metrics.busyMachines(), metrics.idleMachines(), metrics.totalMachines(), metrics.queuedItems(), effectivePoolSize});
        int currentSize = metrics.totalMachines();
        if (currentSize < effectivePoolSize) {
            int deploymentSize = effectivePoolSize - currentSize;
            if (template.getMaximumDeploymentSize() > 0 && deploymentSize > template.getMaximumDeploymentSize()) {
                deploymentSize = template.getMaximumDeploymentSize();
            }
            LOGGER.log(this.getNormalLoggingLevel(), "Prepare for provisioning {0} agents for template {1}", new Object[]{deploymentSize, template.getTemplateName()});
            this.provisionNodes(cloud, template, deploymentSize);
        }
    }

    public void provisionNodes(AzureVMCloud cloud, AzureVMAgentTemplate template, int newAgents) {
        if (!template.retrieveTemplateProvisionStrategy().isVerifiedPass()) {
            AzureVMCloudVerificationTask.verify(cloud.getCloudName(), template.getTemplateName());
        }
        if (template.retrieveTemplateProvisionStrategy().isVerifiedPass()) {
            cloud.doProvision(newAgents, new ArrayList<NodeProvisioner.PlannedNode>(), template, true);
        } else {
            LOGGER.log(Level.WARNING, "Template {0} failed to verify, cannot be provisioned", template.getTemplateName());
        }
    }

    public void execute(TaskListener arg0) {
        for (Cloud cloud : Jenkins.get().clouds) {
            if (!(cloud instanceof AzureVMCloud)) continue;
            AzureVMCloud azureVMCloud = (AzureVMCloud)cloud;
            for (AzureVMAgentTemplate template : azureVMCloud.getVmTemplates()) {
                if (!(template.getRetentionStrategy() instanceof AzureVMCloudPoolRetentionStrategy)) continue;
                this.maintain(azureVMCloud, template);
            }
        }
    }

    public long getRecurrencePeriod() {
        return 300000L;
    }

    protected Level getNormalLoggingLevel() {
        return Level.FINE;
    }
}

