/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

import com.sshtools.common.logger.Log;
import com.sshtools.common.nio.WriteOperationRequest;
import com.sshtools.common.ssh.ChannelOpenException;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.synergy.nio.ClientConnector;
import com.sshtools.synergy.nio.ProtocolEngine;
import com.sshtools.synergy.nio.SshEngine;
import com.sshtools.synergy.ssh.RemoteForward;
import com.sshtools.synergy.ssh.SocketForwardingChannel;
import com.sshtools.synergy.ssh.SshContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;

public class RemoteForwardingChannel<T extends SshContext>
extends SocketForwardingChannel<T>
implements ClientConnector {
    protected boolean hasConnected = false;

    public RemoteForwardingChannel(SshConnection con, String addressToBind, int portToBind, SocketChannel socketChannel) {
        super("forwarded-tcpip", con);
        this.socketChannel = socketChannel;
        this.hostToConnect = addressToBind;
        this.portToConnect = portToBind;
    }

    protected RemoteForwardingChannel(SshConnection con) {
        super("forwarded-tcpip", con);
    }

    public RemoteForwardingChannel(String name, SshConnection con, String addressToBind, int portToBind, SocketChannel socketChannel, T context) {
        super(name, con);
        this.socketChannel = socketChannel;
        this.hostToConnect = addressToBind;
        this.portToConnect = portToBind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] createChannel() throws IOException {
        boolean success = true;
        if (!this.getContext().getForwardingPolicy().checkHostPermitted(this.getConnectionProtocol().getTransport().getConnection(), this.hostToConnect, this.portToConnect)) {
            success = false;
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Forwarding policy has " + (success ? "authorized" : "denied") + " " + this.connection.getUsername() + (success ? " to open" : " from opening") + " a local forwarding channel to " + this.hostToConnect + ":" + this.portToConnect), (Object[])new Object[0]);
            }
        }
        if (!success) {
            block9: {
                try {
                    this.socketChannel.close();
                }
                catch (Throwable t) {
                    if (!Log.isTraceEnabled()) break block9;
                    Log.trace((String)"Failed to close socket channel", (Throwable)t, (Object[])new Object[0]);
                }
            }
            throw new IOException("Cannot create channel because access has been denied by forwarding policy");
        }
        try (ByteArrayWriter baw = new ByteArrayWriter();){
            if (!this.getChannelType().equals("x11")) {
                baw.writeString(this.hostToConnect);
                baw.writeInt(this.portToConnect);
            }
            this.originatingHost = ((InetSocketAddress)this.socketChannel.socket().getRemoteSocketAddress()).getAddress().getHostAddress();
            baw.writeString(this.originatingHost);
            this.originatingPort = ((InetSocketAddress)this.socketChannel.socket().getRemoteSocketAddress()).getPort();
            baw.writeInt(this.originatingPort);
            byte[] byArray = baw.toByteArray();
            return byArray;
        }
    }

    @Override
    protected void onRegistrationComplete() {
        if (Log.isTraceEnabled()) {
            Log.trace((String)"Registration Complete channel={}", (Object[])new Object[]{this.getLocalId()});
        }
    }

    @Override
    protected void onChannelOpenConfirmation() {
        block2: {
            try {
                this.getContext().getEngine().registerHandler(this, this.socketChannel);
            }
            catch (IOException ex) {
                if (!Log.isTraceEnabled()) break block2;
                Log.trace((String)"Failed to register channel with a selector", (Throwable)ex, (Object[])new Object[0]);
            }
        }
    }

    @Override
    protected byte[] openChannel(byte[] requestdata) throws WriteOperationRequest, ChannelOpenException {
        try (ByteArrayReader bar = new ByteArrayReader(requestdata);){
            String addressToBind = bar.readString();
            int portToBind = (int)bar.readInt();
            this.originatingHost = bar.readString();
            this.originatingPort = (int)bar.readInt();
            Map remoteForwards = (Map)this.getConnectionProtocol().getConnection().getProperty("remoteForwards");
            RemoteForward remoteForward = (RemoteForward)remoteForwards.get(addressToBind + ":" + portToBind);
            if (remoteForward == null) {
                throw new ChannelOpenException("Remote forwarding not available", 1);
            }
            this.hostToConnect = remoteForward.getHostToConnect();
            this.portToConnect = remoteForward.getPortToConnect();
            boolean success = this.getContext().getForwardingPolicy().checkHostPermitted(this.getConnectionProtocol().getTransport().getConnection(), this.hostToConnect, this.portToConnect);
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Forwarding policy has " + (success ? "authorized" : "denied") + " " + this.connection.getUsername() + (success ? " to open" : " from opening") + " a " + this.getChannelType() + " forwarding channel to " + this.hostToConnect + ":" + this.portToConnect), (Object[])new Object[0]);
            }
            if (!success) {
                throw new ChannelOpenException("User does not have permission", 1);
            }
            this.createSocketChannel();
            if (this.socketChannel.connect(this.createSocketAddress())) {
                if (Log.isInfoEnabled() && Log.isInfoEnabled()) {
                    Log.info((String)"Remote forwarding socket to {}:{} has connected [synchronously] channel={} remote={}", (Object[])new Object[]{this.hostToConnect, this.portToConnect, this.getLocalId(), this.getRemoteId()});
                }
                this.hasConnected = true;
                byte[] byArray = null;
                return byArray;
            }
            this.connection.getContext().getEngine().registerConnector(this, this.socketChannel);
        }
        throw new WriteOperationRequest();
    }

    protected SocketAddress createSocketAddress() {
        return new InetSocketAddress(this.hostToConnect, this.portToConnect);
    }

    protected void createSocketChannel() throws IOException {
        this.socketChannel = SocketChannel.open();
        this.socketChannel.configureBlocking(false);
        this.socketChannel.socket().setTcpNoDelay(true);
    }

    @Override
    public synchronized boolean finishConnect(SelectionKey key) {
        if (this.socketChannel == null) {
            return true;
        }
        if (this.hasConnected) {
            if (Log.isWarnEnabled()) {
                Log.warn((String)"Duplicate finishConnect call to {}:{} channel={}", (Object[])new Object[]{this.hostToConnect, this.portToConnect, this.getLocalId()});
            }
            return true;
        }
        this.hasConnected = true;
        try {
            while (!this.socketChannel.finishConnect()) {
            }
            if (Log.isInfoEnabled() && Log.isInfoEnabled()) {
                Log.info((String)"Remote forwarding socket to {}:{} has connected [asynchronously] channel={} remote={}", (Object[])new Object[]{this.hostToConnect, this.portToConnect, this.getLocalId(), this.getRemoteId()});
            }
            this.connection.sendChannelOpenConfirmation(this, null);
        }
        catch (IOException ex) {
            if (Log.isInfoEnabled()) {
                Log.info((String)"Remote forwarding socket to {}:{} has failed \"{}\" channel={} remote={}", (Object[])new Object[]{this.hostToConnect, this.portToConnect, ex.getMessage(), this.getLocalId(), this.getRemoteId()});
            }
            this.connection.sendChannelOpenFailure(this, 2, "Connection failed.");
        }
        return true;
    }

    @Override
    protected void onChannelOpenFailure() {
        try {
            this.socketChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void initialize(ProtocolEngine engine, SshEngine daemon, SelectableChannel channel) {
    }
}

