/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.auth;

import com.sshtools.common.auth.AbstractPublicKeyAuthenticationProvider;
import com.sshtools.common.auth.KeysIterator;
import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.policy.FileSystemPolicy;
import com.sshtools.common.publickey.SshPublicKeyFile;
import com.sshtools.common.publickey.authorized.AuthorizedKeyFile;
import com.sshtools.common.publickey.authorized.PublicKeyEntry;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPublicKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class AuthorizedKeysPublicKeyAuthenticationProvider
extends AbstractPublicKeyAuthenticationProvider {
    protected String authorizedKeysFile = ".ssh/authorized_keys";

    public AuthorizedKeysPublicKeyAuthenticationProvider() {
    }

    public AuthorizedKeysPublicKeyAuthenticationProvider(String authorizedKeysFile) {
        this.authorizedKeysFile = authorizedKeysFile;
    }

    @Override
    public boolean isAuthorizedKey(SshPublicKey key, SshConnection con) {
        boolean bl;
        block8: {
            InputStream in = this.getAuthorizedKeysInputStream(con);
            try {
                AuthorizedKeyFile file = new AuthorizedKeyFile();
                file.load(in);
                bl = file.isAuthorizedKey(key);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PermissionDeniedException | IOException e) {
                    return false;
                }
            }
            in.close();
        }
        return bl;
    }

    protected InputStream getAuthorizedKeysInputStream(SshConnection con) throws PermissionDeniedException, IOException {
        AbstractFile file = this.getFile(con);
        return file.getInputStream();
    }

    protected OutputStream getAuthorizedKeysOutputStream(SshConnection con) throws PermissionDeniedException, IOException {
        AbstractFile file = this.getFile(con);
        return file.getOutputStream();
    }

    @Override
    public void add(SshPublicKey key, String comment, SshConnection con) throws IOException, PermissionDeniedException, SshException {
        block12: {
            try (InputStream in = this.getAuthorizedKeysInputStream(con);){
                AuthorizedKeyFile file = new AuthorizedKeyFile();
                file.load(in);
                if (file.isAuthorizedKey(key)) break block12;
                file.addKey(key, comment);
                try (OutputStream out = this.getAuthorizedKeysOutputStream(con);){
                    file.save(out);
                }
            }
        }
    }

    @Override
    public void remove(SshPublicKey key, SshConnection con) throws IOException, PermissionDeniedException, SshException {
        block12: {
            try (InputStream in = this.getAuthorizedKeysInputStream(con);){
                AuthorizedKeyFile file = new AuthorizedKeyFile();
                file.load(in);
                if (!file.isAuthorizedKey(key)) break block12;
                file.removeKeys(key);
                try (OutputStream out = this.getAuthorizedKeysOutputStream(con);){
                    file.save(out);
                }
            }
        }
    }

    @Override
    public Iterator<SshPublicKeyFile> getKeys(SshConnection con) throws PermissionDeniedException, IOException {
        try (InputStream in = this.getAuthorizedKeysInputStream(con);){
            AuthorizedKeyFile file = new AuthorizedKeyFile();
            file.load(in);
            KeysIterator keysIterator = new KeysIterator(new ArrayList<PublicKeyEntry>(file.getKeys()));
            return keysIterator;
        }
    }

    protected AbstractFile getFile(SshConnection con) throws PermissionDeniedException, IOException {
        AbstractFileFactory<?> s = con.getContext().getPolicy(FileSystemPolicy.class).getFileFactory().getFileFactory(con);
        Object file = this.authorizedKeysFile.startsWith("/") ? s.getFile(this.authorizedKeysFile) : s.getDefaultPath().resolveFile(this.authorizedKeysFile);
        return file;
    }

    @Override
    public boolean checkKey(SshPublicKey key, SshConnection con) throws IOException {
        return this.isAuthorizedKey(key, con);
    }
}

