/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

import com.sshtools.common.logger.Log;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.common.util.Utils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class TerminalModes {
    private final Map<Mode, Integer> modes;

    private TerminalModes(TerminalModesBuilder builder) {
        this.modes = Collections.unmodifiableMap(new LinkedHashMap<Mode, Integer>(builder.codes));
    }

    public Map<Mode, Integer> modes() {
        return this.modes;
    }

    public byte[] toByteArray() {
        ByteArrayWriter baw = new ByteArrayWriter();
        this.write(baw);
        return baw.toByteArray();
    }

    public int get(Mode mode) {
        return this.get(mode, 0);
    }

    public int get(Mode mode, int defaultValue) {
        return this.modes.getOrDefault((Object)mode, defaultValue);
    }

    public boolean is(Mode mode) {
        return this.is(mode, false);
    }

    public boolean is(Mode mode, boolean defaultValue) {
        Integer m = this.modes.get((Object)mode);
        return m == null ? defaultValue : m > 0;
    }

    public boolean present(Mode mode) {
        return this.modes.containsKey((Object)mode);
    }

    public void write(ByteArrayWriter writer) {
        this.modes.forEach((k, v) -> {
            writer.write(k.toMode());
            try {
                writer.writeInt(v.intValue());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public static final class TerminalModesBuilder {
        private final Map<Mode, Integer> codes = new LinkedHashMap<Mode, Integer>();

        public TerminalModesBuilder reset() {
            this.codes.clear();
            return this;
        }

        public TerminalModesBuilder withModes(Mode ... modes) {
            Arrays.asList(modes).forEach(m -> this.withMode((Mode)((Object)m), true));
            return this;
        }

        public TerminalModesBuilder withoutModes(Mode ... modes) {
            Arrays.asList(modes).forEach(m -> this.withMode((Mode)((Object)m), false));
            return this;
        }

        public TerminalModesBuilder withMode(int mode, boolean value) {
            return this.withMode(Mode.fromMode(mode), value);
        }

        public TerminalModesBuilder withMode(Mode mode, boolean value) {
            return this.withMode(mode, value ? 1 : 0);
        }

        public TerminalModesBuilder withMode(int mode, int value) {
            return this.withMode(Mode.fromMode(mode), value);
        }

        public TerminalModesBuilder withMode(Mode mode, int value) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)String.format("%s: 0x%s", Utils.rightPad((String)mode.name(), (int)13), Integer.toHexString(value)), (Object[])new Object[0]);
            }
            this.codes.put(mode, value);
            return this;
        }

        public TerminalModesBuilder withMode(int mode) {
            return this.withMode(mode, true);
        }

        public TerminalModesBuilder withoutMode(int mode) {
            return this.withMode(mode, false);
        }

        public static TerminalModesBuilder create() {
            return new TerminalModesBuilder();
        }

        public TerminalModes build() {
            return new TerminalModes(this);
        }

        public TerminalModesBuilder fromBytes(byte[] modes) {
            return this.read(new ByteArrayReader(modes));
        }

        public TerminalModesBuilder read(ByteArrayReader reader) {
            try {
                int mode;
                while ((mode = reader.read()) >= 1) {
                    this.withMode(Mode.fromMode(mode), (int)reader.readInt());
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return this;
        }
    }

    public static enum Mode {
        VINTR,
        VQUIT,
        VERASE,
        VKILL,
        VEOF,
        VEOL,
        VEOL2,
        VSTART,
        VSTOP,
        VSUSP,
        VDSUSP,
        VREPRINT,
        VWERASE,
        VLNEXT,
        VFLUSH,
        VSWITCH,
        VSTATUS,
        VDISCARD,
        IGNPAR,
        PARMRK,
        INPCK,
        ISTRIP,
        INLCR,
        IGNCR,
        ICRNL,
        IUCLC,
        IXON,
        IXANY,
        IXOFF,
        IMAXBEL,
        IUTF8,
        ISIG,
        ICANON,
        XCASE,
        ECHO,
        ECHOE,
        ECHOK,
        ECHONL,
        NOFLSH,
        TOSTOP,
        IEXTEN,
        ECHOCTL,
        ECHOKE,
        PENDIN,
        OPOST,
        OLCUC,
        ONLCR,
        OCRNL,
        ONOCR,
        ONLRET,
        CS7,
        CS8,
        PARENB,
        PARODD,
        TTY_OP_ISPEED,
        TTY_OP_OSPEED;


        public int toMode() {
            switch (this) {
                case VINTR: {
                    return 1;
                }
                case VQUIT: {
                    return 2;
                }
                case VERASE: {
                    return 3;
                }
                case VKILL: {
                    return 4;
                }
                case VEOF: {
                    return 5;
                }
                case VEOL: {
                    return 6;
                }
                case VEOL2: {
                    return 7;
                }
                case VSTART: {
                    return 8;
                }
                case VSTOP: {
                    return 9;
                }
                case VSUSP: {
                    return 10;
                }
                case VDSUSP: {
                    return 11;
                }
                case VREPRINT: {
                    return 12;
                }
                case VWERASE: {
                    return 13;
                }
                case VLNEXT: {
                    return 14;
                }
                case VFLUSH: {
                    return 15;
                }
                case VSWITCH: {
                    return 16;
                }
                case VSTATUS: {
                    return 17;
                }
                case VDISCARD: {
                    return 18;
                }
                case IGNPAR: {
                    return 30;
                }
                case PARMRK: {
                    return 31;
                }
                case INPCK: {
                    return 32;
                }
                case ISTRIP: {
                    return 33;
                }
                case INLCR: {
                    return 34;
                }
                case IGNCR: {
                    return 35;
                }
                case ICRNL: {
                    return 36;
                }
                case IUCLC: {
                    return 37;
                }
                case IXON: {
                    return 38;
                }
                case IXANY: {
                    return 39;
                }
                case IXOFF: {
                    return 40;
                }
                case IMAXBEL: {
                    return 41;
                }
                case IUTF8: {
                    return 42;
                }
                case ISIG: {
                    return 50;
                }
                case ICANON: {
                    return 51;
                }
                case XCASE: {
                    return 52;
                }
                case ECHO: {
                    return 53;
                }
                case ECHOE: {
                    return 54;
                }
                case ECHOK: {
                    return 55;
                }
                case ECHONL: {
                    return 56;
                }
                case NOFLSH: {
                    return 57;
                }
                case TOSTOP: {
                    return 58;
                }
                case IEXTEN: {
                    return 59;
                }
                case ECHOCTL: {
                    return 60;
                }
                case ECHOKE: {
                    return 61;
                }
                case PENDIN: {
                    return 62;
                }
                case OPOST: {
                    return 70;
                }
                case OLCUC: {
                    return 71;
                }
                case ONLCR: {
                    return 72;
                }
                case OCRNL: {
                    return 73;
                }
                case ONOCR: {
                    return 74;
                }
                case ONLRET: {
                    return 75;
                }
                case CS7: {
                    return 90;
                }
                case CS8: {
                    return 91;
                }
                case PARENB: {
                    return 92;
                }
                case PARODD: {
                    return 93;
                }
                case TTY_OP_ISPEED: {
                    return 128;
                }
                case TTY_OP_OSPEED: {
                    return 129;
                }
            }
            throw new IllegalStateException();
        }

        public static Mode fromMode(int mode) {
            switch (mode) {
                case 1: {
                    return VINTR;
                }
                case 2: {
                    return VQUIT;
                }
                case 3: {
                    return VERASE;
                }
                case 4: {
                    return VKILL;
                }
                case 5: {
                    return VEOF;
                }
                case 6: {
                    return VEOL;
                }
                case 7: {
                    return VEOL2;
                }
                case 8: {
                    return VSTART;
                }
                case 9: {
                    return VSTOP;
                }
                case 10: {
                    return VSUSP;
                }
                case 11: {
                    return VDSUSP;
                }
                case 12: {
                    return VREPRINT;
                }
                case 13: {
                    return VWERASE;
                }
                case 14: {
                    return VLNEXT;
                }
                case 15: {
                    return VFLUSH;
                }
                case 16: {
                    return VSWITCH;
                }
                case 17: {
                    return VSTATUS;
                }
                case 18: {
                    return VDISCARD;
                }
                case 30: {
                    return IGNPAR;
                }
                case 31: {
                    return PARMRK;
                }
                case 32: {
                    return INPCK;
                }
                case 33: {
                    return ISTRIP;
                }
                case 34: {
                    return INLCR;
                }
                case 35: {
                    return INLCR;
                }
                case 36: {
                    return ICRNL;
                }
                case 37: {
                    return IUCLC;
                }
                case 38: {
                    return IXON;
                }
                case 39: {
                    return IXANY;
                }
                case 40: {
                    return IXOFF;
                }
                case 41: {
                    return IMAXBEL;
                }
                case 42: {
                    return IUTF8;
                }
                case 50: {
                    return ISIG;
                }
                case 51: {
                    return ICANON;
                }
                case 52: {
                    return XCASE;
                }
                case 53: {
                    return ECHO;
                }
                case 54: {
                    return ECHOE;
                }
                case 55: {
                    return ECHOK;
                }
                case 56: {
                    return ECHONL;
                }
                case 57: {
                    return NOFLSH;
                }
                case 58: {
                    return TOSTOP;
                }
                case 59: {
                    return IEXTEN;
                }
                case 60: {
                    return ECHOCTL;
                }
                case 61: {
                    return ECHOKE;
                }
                case 62: {
                    return PENDIN;
                }
                case 70: {
                    return OPOST;
                }
                case 71: {
                    return OLCUC;
                }
                case 72: {
                    return ONLCR;
                }
                case 73: {
                    return OCRNL;
                }
                case 74: {
                    return ONOCR;
                }
                case 75: {
                    return ONLRET;
                }
                case 90: {
                    return CS7;
                }
                case 91: {
                    return CS8;
                }
                case 92: {
                    return PARENB;
                }
                case 93: {
                    return PARODD;
                }
                case 128: {
                    return TTY_OP_ISPEED;
                }
                case 129: {
                    return TTY_OP_OSPEED;
                }
            }
            throw new IllegalStateException("" + mode);
        }
    }
}

