/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.retry;

import com.microsoft.azure.vmagent.exceptions.AzureCloudException;
import com.microsoft.azure.vmagent.retry.RetryStrategy;

public class NoRetryStrategy
implements RetryStrategy {
    private static final int DEFAULT_TIMEOUT_IN_SECONDS = 240;
    private int defaultTimeoutInSeconds = 240;

    public NoRetryStrategy() {
    }

    public NoRetryStrategy(int defaultTimeoutInSeconds) {
        this.defaultTimeoutInSeconds = defaultTimeoutInSeconds;
    }

    @Override
    public boolean canRetry(int currentRetryCount, Exception e) throws AzureCloudException {
        return false;
    }

    @Override
    public int getWaitPeriodInSeconds(int currentRetryCount, Exception e) {
        return 0;
    }

    @Override
    public void handleRetry(Exception e) throws AzureCloudException {
        throw AzureCloudException.create(e.getMessage(), e);
    }

    @Override
    public int getMaxTimeoutInSeconds() {
        return this.defaultTimeoutInSeconds;
    }

    @Override
    public void reset() {
        this.defaultTimeoutInSeconds = 240;
    }
}

