/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.builders;

import com.microsoft.azure.vmagent.AzureVMAgentTemplate;
import com.microsoft.azure.vmagent.AzureVMCloudBaseRetentionStrategy;
import com.microsoft.azure.vmagent.builders.AzureVMTemplateFluent;
import com.microsoft.azure.vmagent.launcher.AzureComputerLauncher;
import com.microsoft.azure.vmagent.launcher.AzureInboundLauncher;
import com.microsoft.azure.vmagent.launcher.AzureSSHLauncher;

public class AzureVMTemplateBuilder
extends AzureVMTemplateFluent<AzureVMTemplateBuilder> {
    private AzureVMTemplateFluent<?> fluent;

    public AzureVMTemplateBuilder() {
        this.fluent = this;
    }

    public AzureVMTemplateBuilder(AzureVMAgentTemplate template) {
        this.fluent = this;
        this.fluent.withName(template.getTemplateName());
        this.fluent.withDescription(template.getTemplateDesc());
        this.fluent.withLabels(template.getLabels());
        this.fluent.withLocation(template.getLocation());
        this.fluent.withVirtualMachineSize(template.getVirtualMachineSize());
        if (template.getStorageAccountNameReferenceType().equalsIgnoreCase("new")) {
            this.fluent.withNewStorageAccount(template.getNewStorageAccountName());
        } else {
            this.fluent.withExistingStorageAccount(template.getExistingStorageAccountName());
        }
        this.fluent.withStorageAccountType(template.getStorageAccountType());
        this.fluent.withDiskType(template.getDiskType());
        this.fluent.withEphemeralOSDisk(template.isEphemeralOSDisk());
        this.fluent.withOsDiskSize(template.getOsDiskSize());
        this.fluent.withRetentionStrategy((AzureVMCloudBaseRetentionStrategy)template.getRetentionStrategy());
        this.fluent.withUsageMode(template.getUsageMode());
        this.fluent.withAdminCredential(template.getCredentialsId());
        this.fluent.withWorkspace(template.getAgentWorkspace());
        this.fluent.withShutdownOnIdle(template.isShutdownOnIdle());
        if (template.getImageTopLevelType().equalsIgnoreCase("basic")) {
            this.fluent.withBuiltInImage(template.getBuiltInImageInside());
        } else {
            this.fluent.withAdvancedImage(template.getAdvancedImageInside());
        }
        this.fluent.withTags(template.getTags());
    }

    public AzureVMTemplateBuilder(AzureVMTemplateFluent<?> fluent) {
        this.fluent = fluent;
    }

    public AzureVMTemplateBuilder(AzureVMTemplateFluent<?> fluent, AzureVMAgentTemplate template) {
        this.fluent = fluent;
        fluent.withName(template.getTemplateName());
        fluent.withDescription(template.getTemplateDesc());
        fluent.withLabels(template.getLabels());
        fluent.withLocation(template.getLocation());
        fluent.withVirtualMachineSize(template.getVirtualMachineSize());
        if (template.getStorageAccountNameReferenceType().equalsIgnoreCase("new")) {
            fluent.withNewStorageAccount(template.getNewStorageAccountName());
        } else {
            fluent.withExistingStorageAccount(template.getExistingStorageAccountName());
        }
        fluent.withStorageAccountType(template.getStorageAccountType());
        fluent.withDiskType(template.getDiskType());
        fluent.withOsDiskSize(template.getOsDiskSize());
        fluent.withRetentionStrategy((AzureVMCloudBaseRetentionStrategy)template.getRetentionStrategy());
        fluent.withUsageMode(template.getUsageMode());
        fluent.withAdminCredential(template.getCredentialsId());
        fluent.withWorkspace(template.getAgentWorkspace());
        fluent.withShutdownOnIdle(template.isShutdownOnIdle());
        if (template.getImageTopLevelType().equalsIgnoreCase("basic")) {
            fluent.withBuiltInImage(template.getBuiltInImageInside());
        } else {
            fluent.withAdvancedImage(template.getAdvancedImageInside());
        }
        fluent.withTags(template.getTags());
    }

    public AzureVMAgentTemplate build() {
        AzureComputerLauncher launcher;
        String agentLaunchMethod = this.fluent.getAdvancedImage().getAgentLaunchMethod();
        if (agentLaunchMethod.equals("JNLP")) {
            launcher = new AzureInboundLauncher();
        } else {
            AzureSSHLauncher azureSSHLauncher = new AzureSSHLauncher();
            azureSSHLauncher.setSshConfig(this.fluent.getAdvancedImage().getSshConfig());
            azureSSHLauncher.setPreInstallSsh(this.fluent.getAdvancedImage().isPreInstallSsh());
            launcher = azureSSHLauncher;
        }
        AzureVMAgentTemplate azureVMAgentTemplate = new AzureVMAgentTemplate(this.fluent.getName(), this.fluent.getDescription(), this.fluent.getLabels(), this.fluent.getLocation(), null, this.fluent.getVirtualMachineSize(), this.fluent.getStorageAccountNameReferenceType(), this.fluent.getStorageAccountType(), this.fluent.getNewStorageAccountName(), this.fluent.getExistingStorageAccountName(), this.fluent.getDiskType(), this.fluent.getAdvancedImage().getNoOfParallelJobs(), this.fluent.getUsageMode(), this.fluent.getAdvancedImage().getOsType(), this.fluent.getImageTopLevelType(), new AzureVMAgentTemplate.ImageReferenceTypeClass(this.fluent.getAdvancedImage().getImage(), this.fluent.getAdvancedImage().getImageId(), this.fluent.getAdvancedImage().getImagePublisher(), this.fluent.getAdvancedImage().getImageOffer(), this.fluent.getAdvancedImage().getImageSku(), this.fluent.getAdvancedImage().getImageVersion(), this.fluent.getAdvancedImage().getGalleryName(), this.fluent.getAdvancedImage().getGalleryImageDefinition(), this.fluent.getAdvancedImage().getGalleryImageVersion(), this.fluent.getAdvancedImage().getGallerySubscriptionId(), this.fluent.getAdvancedImage().getGalleryResourceGroup()), launcher, this.fluent.getAdvancedImage().getInitScript(), this.fluent.getAdvancedImage().getTerminateScript(), this.fluent.getCredentialsId(), this.fluent.getAdvancedImage().getVirtualNetworkName(), this.fluent.getAdvancedImage().getVirtualNetworkResourceGroupName(), this.fluent.getAdvancedImage().getSubnetName(), this.fluent.getAdvancedImage().getNsgName(), this.fluent.getWorkspace(), this.fluent.getAdvancedImage().getJvmOptions(), this.fluent.getRetentionStrategy(), this.fluent.getAdvancedImage().isExecuteInitScriptAsRoot(), this.fluent.getAdvancedImage().isDoNotUseMachineIfInitFails());
        azureVMAgentTemplate.setShutdownOnIdle(this.fluent.isShutdownOnIdle());
        azureVMAgentTemplate.setEphemeralOSDisk(this.fluent.isEphemeralOSDisk());
        azureVMAgentTemplate.setOsDiskSize(this.fluent.getOsDiskSize());
        azureVMAgentTemplate.setTemplateDisabled(this.fluent.getAdvancedImage().isTemplateDisabled());
        azureVMAgentTemplate.setBuiltInImage(this.fluent.getBuiltInImage().getBuiltInImage());
        azureVMAgentTemplate.setInstallGit(this.fluent.getBuiltInImage().isInstallGit());
        azureVMAgentTemplate.setInstallMaven(this.fluent.getBuiltInImage().isInstallMaven());
        azureVMAgentTemplate.setInstallDocker(this.fluent.getBuiltInImage().isInstallDocker());
        azureVMAgentTemplate.setInstallQemu(this.fluent.getBuiltInImage().isInstallQemu());
        azureVMAgentTemplate.setUsePrivateIP(this.fluent.getAdvancedImage().isUsePrivateIP());
        azureVMAgentTemplate.setEnableMSI(this.fluent.getAdvancedImage().isEnableMSI());
        azureVMAgentTemplate.setEnableUAMI(this.fluent.getAdvancedImage().isEnableUAMI());
        azureVMAgentTemplate.setUamiID(this.fluent.getAdvancedImage().getUamiID());
        azureVMAgentTemplate.setTags(this.fluent.getCloudTags());
        azureVMAgentTemplate.getImageReference().setGalleryImageSpecialized(this.fluent.getAdvancedImage().getGalleryImageSpecialized());
        return azureVMAgentTemplate;
    }
}

