/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.availability;

import com.azure.core.management.Region;
import com.azure.core.util.ExpandableStringEnum;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.compute.models.ComputeResourceType;
import com.microsoft.azure.vmagent.AzureVMCloud;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.availability.AzureAvailabilityType;
import com.microsoft.jenkins.credentials.AzureResourceManagerCache;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.Descriptor;
import hudson.slaves.Cloud;
import hudson.util.ListBoxModel;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class AvailabilityZone
extends AzureAvailabilityType {
    private static final Logger LOGGER = Logger.getLogger(AvailabilityZone.class.getName());
    public static final String AZURE_SELECTED = "AZURE_SELECTED";
    private final String zone;

    @DataBoundConstructor
    public AvailabilityZone(String zone) {
        this.zone = zone;
    }

    public String getZone() {
        return this.zone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailabilityZone that = (AvailabilityZone)o;
        return Objects.equals(this.zone, that.zone);
    }

    public int hashCode() {
        return Objects.hashCode(this.zone);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AzureAvailabilityType> {
        @NonNull
        public String getDisplayName() {
            return Messages.availabilityZone();
        }

        @POST
        public ListBoxModel doFillZoneItems(@RelativePath(value="..") @QueryParameter(value="cloudName") String cloudName, @RelativePath(value="..") @QueryParameter String location, @RelativePath(value="..") @QueryParameter String virtualMachineSize) {
            Jenkins.get().checkPermission(Jenkins.SYSTEM_READ);
            ListBoxModel model = new ListBoxModel();
            AzureVMCloud cloud = this.getAzureCloud(cloudName);
            if (cloud == null) {
                return model;
            }
            String azureCredentialsId = cloud.getAzureCredentialsId();
            if (StringUtils.isBlank((CharSequence)azureCredentialsId)) {
                return model;
            }
            try {
                AzureResourceManager azureClient = AzureResourceManagerCache.get((String)azureCredentialsId);
                if (azureClient == null) {
                    return model;
                }
                Region region = Region.fromName((String)location);
                Set<String> zones = DescriptorImpl.getZonesBy(virtualMachineSize, region, azureClient);
                List<ListBoxModel.Option> options = zones.stream().map(zone -> new ListBoxModel.Option(zone, zone)).toList();
                return new ListBoxModel(options);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Cannot list availability set: ", e);
                return model;
            }
        }

        private static Set<String> getZonesBy(String virtualMachineSize, Region region, AzureResourceManager azureClient) {
            return azureClient.computeSkus().listByRegionAndResourceType(region, ComputeResourceType.VIRTUALMACHINES).stream().filter(sku -> sku.name().toString().equalsIgnoreCase(virtualMachineSize)).map(sku -> (Set)sku.zones().get(region)).filter(Objects::nonNull).flatMap(Collection::stream).map(ExpandableStringEnum::toString).collect(Collectors.toSet());
        }

        private AzureVMCloud getAzureCloud(String cloudName) {
            Cloud cloud = Jenkins.get().getCloud(cloudName);
            if (cloud instanceof AzureVMCloud) {
                AzureVMCloud azureCloud = (AzureVMCloud)cloud;
                return azureCloud;
            }
            return null;
        }
    }
}

