/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.microsoft.azure.vmagent.AzureVMCloud;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Label;
import hudson.model.LoadStatistics;
import hudson.model.Queue;
import hudson.model.queue.QueueListener;
import hudson.slaves.Cloud;
import hudson.slaves.CloudProvisioningListener;
import hudson.slaves.NodeProvisioner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import jenkins.util.Timer;

@Extension(ordinal=101.0)
public class AzureVMNoDelayProvisionerStrategy
extends NodeProvisioner.Strategy {
    private static final Logger LOGGER = Logger.getLogger(AzureVMNoDelayProvisionerStrategy.class.getName());
    private static final boolean DISABLE_NO_DELAY_PROVISIONING = SystemProperties.getBoolean((String)(AzureVMNoDelayProvisionerStrategy.class.getName() + ".disableNoDelayProvisioning"));
    private static final boolean DISABLE_CLOUD_SHUFFLE = SystemProperties.getBoolean((String)(AzureVMNoDelayProvisionerStrategy.class.getName() + ".disableCloudShuffle"));
    public static final int ORDER = 101;

    @NonNull
    public NodeProvisioner.StrategyDecision apply(@NonNull NodeProvisioner.StrategyState strategyState) {
        int availableCapacity;
        if (DISABLE_NO_DELAY_PROVISIONING) {
            LOGGER.log(Level.FINE, "Provisioning not complete, NoDelayProvisionerStrategy is disabled");
            return NodeProvisioner.StrategyDecision.CONSULT_REMAINING_STRATEGIES;
        }
        if (Jenkins.get().isQuietingDown()) {
            LOGGER.log(Level.FINE, "Skipping provision as Jenkins is quieting down");
            return NodeProvisioner.StrategyDecision.CONSULT_REMAINING_STRATEGIES;
        }
        Label label = strategyState.getLabel();
        LoadStatistics.LoadStatisticsSnapshot snapshot = strategyState.getSnapshot();
        int previousCapacity = availableCapacity = snapshot.getAvailableExecutors() + snapshot.getConnectingExecutors() + strategyState.getPlannedCapacitySnapshot() + strategyState.getAdditionalPlannedCapacity();
        int currentDemand = snapshot.getQueueLength();
        LOGGER.log(Level.FINE, "Available capacity={0}, currentDemand={1}", new Object[]{availableCapacity, currentDemand});
        if (availableCapacity < currentDemand) {
            ArrayList jenkinsClouds = new ArrayList(Jenkins.get().clouds);
            if (!DISABLE_CLOUD_SHUFFLE) {
                Collections.shuffle(jenkinsClouds);
            }
            Cloud.CloudState cloudState = new Cloud.CloudState(label, strategyState.getAdditionalPlannedCapacity());
            block0: for (Cloud cloud : jenkinsClouds) {
                int workloadToProvision = currentDemand - availableCapacity;
                if (!(cloud instanceof AzureVMCloud) || !cloud.canProvision(cloudState)) continue;
                for (CloudProvisioningListener cl : CloudProvisioningListener.all()) {
                    if (cl.canProvision(cloud, cloudState, workloadToProvision) == null) continue;
                    continue block0;
                }
                Collection plannedNodes = cloud.provision(cloudState, workloadToProvision);
                LOGGER.log(Level.FINE, "Planned {0} new nodes", plannedNodes.size());
                AzureVMNoDelayProvisionerStrategy.fireOnStarted(cloud, strategyState.getLabel(), plannedNodes);
                strategyState.recordPendingLaunches(plannedNodes);
                LOGGER.log(Level.FINE, "After provisioning, available capacity={0}, currentDemand={1}", new Object[]{availableCapacity += plannedNodes.size(), currentDemand});
                break;
            }
        }
        if (availableCapacity > previousCapacity && label != null) {
            LOGGER.log(Level.FINE, "Suggesting NodeProvisioner review");
            Timer.get().schedule(() -> ((NodeProvisioner)label.nodeProvisioner).suggestReviewNow(), 1L, TimeUnit.SECONDS);
        }
        if (availableCapacity >= currentDemand) {
            LOGGER.log(Level.FINE, "Provisioning completed");
            return NodeProvisioner.StrategyDecision.PROVISIONING_COMPLETED;
        }
        LOGGER.log(Level.FINE, "Provisioning not complete, consulting remaining strategies");
        return NodeProvisioner.StrategyDecision.CONSULT_REMAINING_STRATEGIES;
    }

    private static void fireOnStarted(Cloud cloud, Label label, Collection<NodeProvisioner.PlannedNode> plannedNodes) {
        for (CloudProvisioningListener cl : CloudProvisioningListener.all()) {
            try {
                cl.onStarted(cloud, label, plannedNodes);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Unexpected uncaught exception encountered while processing onStarted() listener call in " + String.valueOf(cl) + " for label " + label.toString(), e);
            }
        }
    }

    @Extension
    public static class AzureVMFastProvisioning
    extends QueueListener {
        public void onEnterBuildable(Queue.BuildableItem item) {
            if (DISABLE_NO_DELAY_PROVISIONING) {
                return;
            }
            Jenkins jenkins = Jenkins.get();
            Label label = item.getAssignedLabel();
            for (Cloud cloud : jenkins.clouds) {
                if (!(cloud instanceof AzureVMCloud) || !cloud.canProvision(new Cloud.CloudState(label, 0))) continue;
                NodeProvisioner provisioner = label == null ? jenkins.unlabeledNodeProvisioner : label.nodeProvisioner;
                provisioner.suggestReviewNow();
            }
        }
    }
}

