/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.sftp.SftpClientTask;
import com.sshtools.client.tasks.AbstractFileTask;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.util.Utils;
import java.nio.file.Path;
import java.util.Optional;

public class StatTask
extends AbstractFileTask {
    private final Path remote;
    private SftpFileAttributes attrs = null;

    private StatTask(StatTaskBuilder builder) {
        super(builder);
        this.remote = builder.remote.orElseThrow(() -> new IllegalStateException("Remote path must be supplied."));
    }

    public void doTask() {
        this.doTaskUntilDone(new SftpClientTask(this.con, self -> {
            this.attrs = self.stat(Utils.translatePathString((Path)this.remote));
        }));
    }

    public SftpFileAttributes getAttributes() {
        return this.attrs;
    }

    public static final class StatTaskBuilder
    extends AbstractFileTask.AbstractFileTaskBuilder<StatTaskBuilder, StatTask> {
        private Optional<Path> remote = Optional.empty();

        private StatTaskBuilder() {
        }

        public static StatTaskBuilder create() {
            return new StatTaskBuilder();
        }

        public StatTaskBuilder withRemotePath(Optional<String> remote) {
            return this.withRemote((Path)remote.map(x$0 -> Path.of(x$0, new String[0])).orElse(null));
        }

        public StatTaskBuilder withRemote(Path remote) {
            return this.withRemote(Optional.of(remote));
        }

        public StatTaskBuilder withRemote(Optional<Path> remote) {
            this.remote = remote;
            return this;
        }

        public StatTaskBuilder withRemotePath(String remote) {
            return this.withRemotePath(Optional.of(remote));
        }

        @Override
        public StatTask build() {
            return new StatTask(this);
        }
    }
}

