/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.shell;

import com.sshtools.client.shell.ExpectShell;
import com.sshtools.client.shell.ShellInputStream;
import com.sshtools.common.ssh.SshIOException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ShellProcess {
    private final ExpectShell shell;
    private final ShellInputStream in;
    private final BufferedInputStream bin;
    private final OutputStream out;

    ShellProcess(ExpectShell shell, ShellInputStream in, OutputStream out) {
        this.shell = shell;
        this.in = in;
        this.bin = new BufferedInputStream(in);
        this.out = out;
    }

    public void mark(int readlimit) {
        this.bin.mark(readlimit);
    }

    public void reset() throws IOException {
        this.bin.reset();
    }

    public InputStream getInputStream() {
        return this.bin;
    }

    public OutputStream getOutputStream() throws SshIOException {
        return this.out;
    }

    public int getExitCode() {
        return this.in.getExitCode();
    }

    public boolean hasSucceeded() {
        return this.in.hasSucceeded();
    }

    public boolean isActive() {
        return this.in.isActive();
    }

    public void clearOutput() {
        this.in.clearOutput();
    }

    public String getCommandOutput() {
        return this.in.getCommandOutput();
    }

    public ExpectShell getShell() {
        return this.shell;
    }

    public ShellProcess waitFor() throws IOException {
        while (this.in.isActive() && this.bin.read() > -1 && !this.shell.isClosed()) {
        }
        return this;
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public ShellProcess drain() throws IOException {
        while (this.in.isActive() && this.bin.read() > -1 && !this.shell.isClosed()) {
        }
        return this;
    }
}

