/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.shell;

import com.sshtools.client.SessionChannelNG;
import com.sshtools.client.shell.ShellController;
import com.sshtools.client.shell.ShellDefaultMatcher;
import com.sshtools.client.shell.ShellInputStream;
import com.sshtools.client.shell.ShellMatcher;
import com.sshtools.client.shell.ShellProcess;
import com.sshtools.client.shell.ShellProcessController;
import com.sshtools.client.shell.ShellReader;
import com.sshtools.client.shell.ShellStartupTrigger;
import com.sshtools.client.shell.ShellTimeoutException;
import com.sshtools.client.tasks.AbstractSessionTask;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshIOException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ExpectShell {
    private static final String PASSWORD_ERROR_TEXT = "Sorry, try again.";
    private static final String DEFAULT_PASSWORD_PROMPT = "Password:";
    @Deprecated(forRemoval=true, since="3.1.3")
    public static final int OS_WINDOWS = 1;
    @Deprecated(forRemoval=true, since="3.1.3")
    public static final int OS_LINUX = 2;
    @Deprecated(forRemoval=true, since="3.1.3")
    public static final int OS_SOLARIS = 3;
    @Deprecated(forRemoval=true, since="3.1.3")
    public static final int OS_AIX = 4;
    @Deprecated(forRemoval=true, since="3.1.3")
    public static final int OS_DARWIN = 5;
    @Deprecated(forRemoval=true, since="3.1.3")
    public static final int OS_FREEBSD = 6;
    @Deprecated(forRemoval=true, since="3.1.3")
    public static final int OS_OPENBSD = 7;
    @Deprecated(forRemoval=true, since="3.1.3")
    public static final int OS_NETBSD = 8;
    @Deprecated(forRemoval=true, since="3.1.3")
    public static final int OS_HPUX = 9;
    @Deprecated(forRemoval=true, since="3.1.3")
    public static final int OS_UNIX = 20;
    @Deprecated(forRemoval=true, since="3.1.3")
    public static final int OS_OPENVMS = 21;
    @Deprecated(forRemoval=true, since="3.1.3")
    public static final int OS_POWERSHELL = 22;
    @Deprecated(forRemoval=true, since="3.1.3")
    public static final int OS_UNKNOWN = 99;
    private final OS osType;
    static final String BEGIN_COMMAND_MARKER = "---BEGIN---";
    static final String END_COMMAND_MARKER = "---END---";
    static final String PROCESS_MARKER = "PROCESS=";
    static final String EXIT_CODE_MARKER = "EXITCODE=";
    static final int WAITING_FOR_COMMAND = 1;
    static final int PROCESSING_COMMAND = 2;
    static final int CLOSED = 3;
    int state = 1;
    @Deprecated
    private static int SHELL_INIT_PERIOD = 2000;
    List<Runnable> closeHooks = new ArrayList<Runnable>();
    Optional<String> sudoPassword = Optional.empty();
    int numCommandsExecuted = 0;
    private static final boolean verboseDebug = Boolean.getBoolean("maverick.shell.verbose");
    private final StartupInputStream startupIn;
    private final boolean childShell;
    public static final int EXIT_CODE_PROCESS_ACTIVE = Integer.MIN_VALUE;
    public static final int EXIT_CODE_UNKNOWN = -2147483647;
    private final Duration startupTimeout;
    private String passwordErrorText;
    private String passwordPrompt;
    private Charset characterEncoding;

    @Deprecated(since="3.2.0", forRemoval=true)
    public ExpectShell(AbstractSessionTask<SessionChannelNG> session) throws SshException, IOException, ShellTimeoutException {
        this(session, null, 30000L);
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    public ExpectShell(AbstractSessionTask<SessionChannelNG> session, int osType) throws SshException, IOException, ShellTimeoutException {
        this(session, OS.code(osType));
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    private ExpectShell(AbstractSessionTask<SessionChannelNG> session, OS osType) throws SshException, IOException, ShellTimeoutException {
        this(session, null, 30000L, osType);
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    public ExpectShell(AbstractSessionTask<SessionChannelNG> session, ShellStartupTrigger trigger) throws SshException, IOException, ShellTimeoutException {
        this(session, trigger, 30000L);
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    public ExpectShell(AbstractSessionTask<SessionChannelNG> session, ShellStartupTrigger trigger, long startupTimeout) throws SshException, IOException, ShellTimeoutException {
        this(session, trigger, startupTimeout, OS.UNKNOWN);
    }

    @Deprecated(forRemoval=true)
    public ExpectShell(AbstractSessionTask<SessionChannelNG> session, ShellStartupTrigger trigger, long startupTimeout, int osType) throws SshException, IOException, ShellTimeoutException {
        this(session, trigger, startupTimeout, OS.code(osType));
    }

    @Deprecated(forRemoval=true)
    private ExpectShell(AbstractSessionTask<SessionChannelNG> session, ShellStartupTrigger trigger, long startupTimeout, OS osType) throws SshException, IOException, ShellTimeoutException {
        this(session.getSession(), trigger, startupTimeout, osType);
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    public ExpectShell(SessionChannelNG session, int osType) throws SshException, IOException, ShellTimeoutException {
        this(session, OS.code(osType));
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    private ExpectShell(SessionChannelNG session, OS osType) throws SshException, IOException, ShellTimeoutException {
        this(session, null, 30000L, osType);
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    public ExpectShell(SessionChannelNG session, ShellStartupTrigger trigger, long startupTimeout, OS osType) throws SshException, IOException, ShellTimeoutException {
        this.startupTimeout = Duration.ofMillis(startupTimeout);
        this.childShell = false;
        this.characterEncoding = ExpectShell.defaultEncoding();
        this.passwordPrompt = DEFAULT_PASSWORD_PROMPT;
        this.passwordErrorText = PASSWORD_ERROR_TEXT;
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Creating session for interactive shell", (Object[])new Object[0]);
        }
        this.closeHooks.add(() -> session.close());
        if (SHELL_INIT_PERIOD > 0) {
            try {
                Thread.sleep(SHELL_INIT_PERIOD);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (osType == OS.UNKNOWN) {
            osType = this.determineServerType(session.getConnection().getRemoteIdentification());
        }
        this.startupIn = new StartupInputStream(osType, BEGIN_COMMAND_MARKER, osType != OS.OPENVMS, trigger, this, session.getInputStream(), session.getOutputStream());
        this.osType = this.startupIn.osType;
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    ExpectShell(InputStream in, OutputStream out, OS osType, ExpectShell parentShell) throws SshIOException, SshException, IOException, ShellTimeoutException {
        this.characterEncoding = parentShell.characterEncoding;
        this.childShell = true;
        this.passwordPrompt = parentShell.passwordPrompt;
        this.passwordErrorText = parentShell.passwordErrorText;
        this.startupTimeout = parentShell.startupTimeout;
        this.startupIn = new StartupInputStream(osType, BEGIN_COMMAND_MARKER, true, null, this, in, out);
        this.osType = this.startupIn.osType;
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    public ExpectShell(InputStream in, OutputStream out, ExpectShell parentShell) throws SshIOException, SshException, IOException, ShellTimeoutException {
        this(in, out, parentShell, parentShell.osType);
    }

    @Deprecated(since="3.2.0")
    public ExpectShell(InputStream in, OutputStream out, ExpectShell parentShell, OS osType) throws SshIOException, SshException, IOException, ShellTimeoutException {
        this.childShell = true;
        this.characterEncoding = parentShell.characterEncoding;
        this.startupTimeout = parentShell.startupTimeout;
        this.passwordPrompt = parentShell.passwordPrompt;
        this.passwordErrorText = parentShell.passwordErrorText;
        this.startupIn = new StartupInputStream(osType, BEGIN_COMMAND_MARKER, false, null, this, in, out);
        this.osType = this.startupIn.osType;
    }

    private ExpectShell(ExpectShellBuilder bldr) throws SshException, IOException, ShellTimeoutException {
        this.childShell = false;
        this.startupTimeout = bldr.startupTimeout;
        this.characterEncoding = bldr.encoding.orElseGet(() -> ExpectShell.defaultEncoding());
        this.passwordPrompt = bldr.passwordPrompt.orElse(DEFAULT_PASSWORD_PROMPT);
        this.passwordErrorText = bldr.passwordErrorText.orElse(PASSWORD_ERROR_TEXT);
        this.startupIn = new StartupInputStream(bldr.os.orElseGet(() -> bldr.remoteIdentification.or(() -> bldr.session.map(sesh -> sesh.getConnection().getRemoteIdentification())).map(this::determineServerType).orElse(OS.UNKNOWN)), BEGIN_COMMAND_MARKER, bldr.detectSettings, bldr.trigger.orElse(null), this, bldr.input.or(() -> bldr.session.map(sesh -> sesh.getInputStream())).orElseThrow(() -> new IllegalStateException("InputStream could not be determined.")), bldr.output.or(() -> bldr.session.map(sesh -> sesh.getOutputStream())).orElseThrow(() -> new IllegalStateException("OutputStream could not be determined.")));
        this.osType = this.startupIn.osType;
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    public String getCharacterEncoding() {
        return this.characterEncoding.name();
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = Charset.forName(characterEncoding);
    }

    @Deprecated(forRemoval=true, since="3.1.3")
    public static void setShellInitTimeout(int timeout) {
        SHELL_INIT_PERIOD = timeout;
    }

    public InputStream getStartupInputStream() {
        return this.startupIn;
    }

    OS determineServerType(String remoteID) {
        if (remoteID.indexOf("OpenVMS") > 0) {
            return OS.OPENVMS;
        }
        if (remoteID.indexOf("Windows") > 0) {
            return OS.WINDOWS;
        }
        return OS.UNKNOWN;
    }

    public boolean inStartup() {
        return this.startupIn.inStartup;
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    public void setPasswordErrorText(String passwordErrorText) {
        this.passwordErrorText = passwordErrorText;
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    public void setPasswordPrompt(String passwordPrompt) {
        this.passwordPrompt = passwordPrompt;
    }

    public ShellReader getStartupReader() {
        return this.startupIn.startupController;
    }

    public ExpectShell su(String cmd, String password) throws SshIOException, SshException, IOException, ShellTimeoutException {
        return this.su(cmd, password, this.passwordPrompt, new ShellDefaultMatcher());
    }

    public ExpectShell su(String cmd, String password, String passwordPrompt) throws SshException, SshIOException, IOException, ShellTimeoutException {
        return this.su(cmd, password, passwordPrompt, new ShellDefaultMatcher());
    }

    public ExpectShell su(String cmd) throws SshException, SshIOException, IOException, ShellTimeoutException {
        ShellProcess process = this.executeCommand(cmd, false, false);
        return new ExpectShell(process.getInputStream(), process.getOutputStream(), this.osType, this);
    }

    public ExpectShell su(String cmd, String password, String passwordPrompt, ShellMatcher matcher) throws SshException, SshIOException, IOException, ShellTimeoutException {
        ShellProcess process = this.executeCommand(cmd, false, false);
        ShellProcessController contr = new ShellProcessController(process, matcher);
        process.mark(1024);
        if (contr.expectNextLine(passwordPrompt)) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"su password expression matched", (Object[])new Object[0]);
            }
            contr.typeAndReturn(password);
            contr.readLine();
            process.mark(1024);
            if (contr.expectNextLine(this.passwordErrorText)) {
                throw new IOException("Incorrect password!");
            }
            process.reset();
        } else {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"su password expression not matched", (Object[])new Object[0]);
            }
            process.reset();
        }
        if (process.isActive()) {
            return new ExpectShell(process.getInputStream(), process.getOutputStream(), this.osType, this);
        }
        throw new SshException("The command failed: " + cmd, 15);
    }

    public ShellProcess sudo(String cmd, String password) throws SshException, ShellTimeoutException, IOException {
        return this.sudo(cmd, password, this.passwordPrompt, new ShellDefaultMatcher());
    }

    public ShellProcess sudo(String cmd) throws SshException, ShellTimeoutException, IOException {
        return this.sudo(cmd, this.sudoPassword.orElseThrow(), this.passwordPrompt, new ShellDefaultMatcher());
    }

    public ShellProcess sudo(String cmd, String password, String promptExpression) throws SshException, ShellTimeoutException, IOException {
        return this.sudo(cmd, password, promptExpression, new ShellDefaultMatcher());
    }

    public ShellProcess sudo(String cmd, String password, String promptExpression, ShellMatcher matcher) throws SshException, ShellTimeoutException, IOException {
        boolean found;
        ShellProcess process = this.executeCommand(cmd, false, false);
        ShellProcessController contr = new ShellProcessController(process, matcher);
        process.mark(4096);
        int lines = 0;
        while (!(found = contr.expectNextLine(promptExpression)) && ++lines < 10 && !contr.isEOF()) {
        }
        if (found) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"sudo password expression matched", (Object[])new Object[0]);
            }
            contr.typeAndReturn(password);
            if (contr.expectNextLine(this.passwordErrorText)) {
                throw new IOException("Incorrect password!");
            }
            process.clearOutput();
        } else {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"sudo password expression not matched", (Object[])new Object[0]);
            }
            process.reset();
        }
        return process;
    }

    public boolean isClosed() {
        return this.state == 3;
    }

    public void exit() throws IOException, SshException {
        this.startupIn.sessionOut.write(("exit" + this.osType.eol()).getBytes());
        if (this.childShell) {
            while (this.startupIn.sessionIn.read() > -1) {
            }
        }
        this.close();
    }

    public void close() throws IOException, SshException {
        this.internalClose();
    }

    public String getNewline() {
        return this.osType.eol();
    }

    public synchronized String executeWithOutput(String cmd) throws SshException {
        return this.executeCommand(cmd, true).getCommandOutput();
    }

    public synchronized int executeWithExitCode(String cmd) throws SshException {
        return this.executeCommand(cmd, true).getExitCode();
    }

    public synchronized void execute(String cmd) throws SshException {
        this.executeCommand(cmd, true);
    }

    public synchronized ShellProcess executeCommand(String origCmd) throws SshException {
        return this.executeCommand(origCmd, false, false, null);
    }

    public synchronized ShellProcess executeCommand(String origCmd, boolean consume) throws SshException {
        return this.executeCommand(origCmd, false, consume, null);
    }

    public synchronized ShellProcess executeCommand(String origCmd, String charset) throws SshException {
        return this.executeCommand(origCmd, false, false, charset);
    }

    public synchronized ShellProcess executeCommand(String origCmd, boolean consume, String charset) throws SshException {
        return this.executeCommand(origCmd, false, consume, charset);
    }

    public synchronized ShellProcess executeCommand(String origCmd, boolean matchPromptMarker, boolean consume) throws SshException {
        return this.executeCommand(origCmd, matchPromptMarker, consume, null);
    }

    public synchronized ShellProcess executeCommand(String origCmd, boolean matchPromptMarker, boolean consume, String charsetName) throws SshException {
        try {
            Charset charset = charsetName == null ? this.characterEncoding : Charset.forName(charsetName);
            String cmd = origCmd;
            if (this.state == 2) {
                throw new SshException("Command still active", 4);
            }
            if (this.state == 3) {
                throw new SshException("Shell is closed!", 4);
            }
            this.checkStartupFinished();
            this.state = 2;
            StringBuffer prompt = new StringBuffer();
            if (matchPromptMarker |= (origCmd.startsWith(".") || origCmd.startsWith("source")) && this.osType == OS.HPUX) {
                int ch;
                this.startupIn.sessionOut.write(this.osType.eol().getBytes());
                this.startupIn.sessionOut.write(this.osType.eol().getBytes());
                while ((ch = this.startupIn.sessionIn.read()) > -1 && ch != 10) {
                }
                while ((ch = this.startupIn.sessionIn.read()) > -1 && ch != 10) {
                    prompt.append((char)ch);
                }
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Prompt is " + prompt.toString().trim()), (Object[])new Object[0]);
                }
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Executing command: " + cmd), (Object[])new Object[0]);
            }
            String endCommand = this.nextEndMarker();
            String echoCmd = this.osType == OS.WINDOWS ? this.osType.echoCommand() + " ---BEGIN--- && " + cmd + " && " + this.osType.echoCommand() + " " + endCommand + "0 || " + this.osType.echoCommand() + " " + endCommand + "1" + this.osType.eol() : (this.osType == OS.OPENVMS ? this.osType.pipeCommand() + this.osType.echoCommand() + " \"---BEGIN---\" && " + cmd + " && " + this.osType.echoCommand() + " \"" + endCommand + "0\" || " + this.osType.echoCommand() + "\"" + endCommand + "1\"" + this.osType.eol() : (this.osType == OS.POWERSHELL ? "echo \"---BEGIN---\"; " + cmd + "; echo \"" + endCommand + this.osType.exitCodeVariable() + "\"" + this.osType.eol() : "echo \"---BEGIN---\"; " + cmd + "; echo \"" + endCommand + this.osType.exitCodeVariable() + "\"" + this.osType.eol()));
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Executing raw command: {}", (Object[])new Object[]{echoCmd});
            }
            this.startupIn.sessionOut.write(echoCmd.getBytes(charset));
            ++this.numCommandsExecuted;
            ShellInputStream in = new ShellInputStream(this.startupIn.sessionIn, this, BEGIN_COMMAND_MARKER, endCommand, origCmd, matchPromptMarker, prompt.toString().trim());
            ShellProcess process = new ShellProcess(this, in, this.startupIn.sessionOut);
            if (consume) {
                process.waitFor();
            }
            return process;
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException("Failed to execute command: " + ex.getMessage(), 6);
        }
    }

    public int getNumCommandsExecuted() {
        return this.numCommandsExecuted;
    }

    private void checkStartupFinished() throws IOException {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Checking state of startup controller", (Object[])new Object[0]);
        }
        if (!this.startupIn.isClosed()) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Shell still in startup mode, draining startup output", (Object[])new Object[0]);
            }
            while (this.startupIn.read() > -1) {
            }
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Shell is ready for command", (Object[])new Object[0]);
        }
    }

    private synchronized String nextEndMarker() {
        return "---END---;PROCESS=" + System.currentTimeMillis() + ";EXITCODE=";
    }

    public int getOsType() {
        return this.osType.code();
    }

    public String getOsDescription() {
        return this.osType.description();
    }

    void type(String string) throws IOException {
        this.write(string.getBytes(this.characterEncoding));
    }

    void write(byte[] bytes) throws IOException {
        this.startupIn.sessionOut.write(bytes);
    }

    void type(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    void carriageReturn() throws IOException {
        this.write(this.osType.eol().getBytes(this.characterEncoding));
    }

    void typeAndReturn(String string) throws IOException {
        this.write((string + this.osType.eol()).getBytes(this.characterEncoding));
    }

    void internalClose() {
        this.state = 3;
        for (Runnable r : this.closeHooks) {
            try {
                r.run();
            }
            catch (Throwable throwable) {}
        }
    }

    private static Charset defaultEncoding() {
        return Charset.forName("UTF-8");
    }

    public void setSudoPassword(Optional<String> sudoPassword) {
        this.sudoPassword = sudoPassword;
    }

    public static enum OS {
        WINDOWS,
        LINUX,
        SOLARIS,
        AIX,
        DARWIN,
        FREEBSD,
        OPENBSD,
        NETBSD,
        HPUX,
        UNIX,
        OPENVMS,
        POWERSHELL,
        UNKNOWN;


        @Deprecated(forRemoval=true, since="3.1.3")
        public int code() {
            switch (this) {
                case WINDOWS: {
                    return 1;
                }
                case LINUX: {
                    return 2;
                }
                case SOLARIS: {
                    return 3;
                }
                case AIX: {
                    return 4;
                }
                case DARWIN: {
                    return 5;
                }
                case FREEBSD: {
                    return 6;
                }
                case OPENBSD: {
                    return 7;
                }
                case NETBSD: {
                    return 8;
                }
                case HPUX: {
                    return 9;
                }
                case UNIX: {
                    return 20;
                }
                case OPENVMS: {
                    return 21;
                }
                case POWERSHELL: {
                    return 22;
                }
            }
            return 99;
        }

        @Deprecated(forRemoval=true, since="3.1.3")
        public static OS code(int code) {
            switch (code) {
                case 1: {
                    return WINDOWS;
                }
                case 2: {
                    return LINUX;
                }
                case 3: {
                    return SOLARIS;
                }
                case 4: {
                    return AIX;
                }
                case 5: {
                    return DARWIN;
                }
                case 6: {
                    return FREEBSD;
                }
                case 7: {
                    return OPENBSD;
                }
                case 8: {
                    return NETBSD;
                }
                case 9: {
                    return HPUX;
                }
                case 20: {
                    return UNIX;
                }
                case 21: {
                    return OPENVMS;
                }
                case 22: {
                    return POWERSHELL;
                }
            }
            return UNKNOWN;
        }

        public String description() {
            switch (this) {
                case WINDOWS: {
                    return "Windows";
                }
                case LINUX: {
                    return "Linux";
                }
                case SOLARIS: {
                    return "Solaris";
                }
                case AIX: {
                    return "AIX";
                }
                case DARWIN: {
                    return "Darwin";
                }
                case FREEBSD: {
                    return "FreeBSD";
                }
                case OPENBSD: {
                    return "OpenBSD";
                }
                case NETBSD: {
                    return "NetBSD";
                }
                case HPUX: {
                    return "HP-UX";
                }
                case UNIX: {
                    return "UNIX";
                }
                case OPENVMS: {
                    return "OpenVMS";
                }
                case POWERSHELL: {
                    return "Windows PowerShell";
                }
            }
            return "Unknown";
        }

        public String exitCodeVariable() {
            switch (this) {
                case WINDOWS: {
                    return "%errorlevel%";
                }
                case OPENVMS: {
                    return "$SEVERITY";
                }
            }
            return "$?";
        }

        public String echoCommand() {
            switch (this) {
                case WINDOWS: {
                    return "\r\n";
                }
                case OPENVMS: {
                    return "WRITE SYS$OUTPUT";
                }
            }
            return "echo";
        }

        public String pipeCommand() {
            switch (this) {
                case OPENVMS: {
                    return "PIPE";
                }
            }
            return "";
        }

        public String eol() {
            switch (this) {
                case WINDOWS: {
                    return "\r\n";
                }
            }
            return "\r";
        }
    }

    static class StartupInputStream
    extends InputStream {
        final char[] marker1;
        int markerPos;
        final StringBuilder currentLine = new StringBuilder();
        final boolean detectSettings;
        final ShellController startupController;
        final BufferedInputStream sessionIn;
        final OutputStream sessionOut;
        final ExpectShell shell;
        final Instant startupStarted = Instant.now();
        OS osType;
        boolean inStartup;

        StartupInputStream(OS osType, String marker1str, boolean detectSettings, ShellStartupTrigger trigger, ExpectShell shell, InputStream in, OutputStream out) throws SshException, IOException, ShellTimeoutException {
            this.osType = osType;
            this.shell = shell;
            this.sessionIn = new BufferedInputStream(in);
            this.sessionOut = out;
            this.detectSettings = detectSettings;
            this.marker1 = marker1str.toCharArray();
            this.startupController = new ShellController(shell, new ShellDefaultMatcher(), this);
            if (trigger != null) {
                StringBuffer line = new StringBuffer();
                do {
                    int ch;
                    if ((ch = this.internalRead(this.sessionIn)) != 10 && ch != 13 && ch != -1) {
                        line.append((char)ch);
                    }
                    if (ch == 10) {
                        line.setLength(0);
                    }
                    if (ch != -1) continue;
                    throw new SshException("Shell output ended before trigger could start shell", 20);
                } while (!trigger.canStartShell(line.toString(), this.startupController));
            }
            if (detectSettings) {
                String cmd = osType == OS.WINDOWS ? osType.echoCommand() + " ---BEGIN---&& " + osType.echoCommand() + " " + osType.exitCodeVariable() + osType.eol() : (osType == OS.OPENVMS ? osType.pipeCommand() + osType.echoCommand() + " \"---BEGIN---\" && " + osType.echoCommand() + " $?" + osType.eol() : (osType == OS.POWERSHELL ? "echo \"---BEGIN---\"; ; echo \"" + osType.exitCodeVariable() + "\"" + osType.eol() : "echo \"---BEGIN---\"; echo \"$?\"" + osType.eol()));
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Performing marker test: " + cmd), (Object[])new Object[0]);
                }
                this.sessionOut.write(cmd.getBytes());
            }
            this.inStartup = detectSettings;
        }

        boolean isClosed() {
            return !this.inStartup;
        }

        int internalRead(InputStream in) throws IOException {
            while (true) {
                try {
                    return in.read();
                }
                catch (SshIOException e) {
                    if (e.getRealException().getReason() == 21) {
                        if (System.currentTimeMillis() - this.startupStarted.toEpochMilli() <= this.shell.startupTimeout.toMillis()) continue;
                        throw new SshIOException(new SshException("", 20));
                    }
                    throw e;
                }
                break;
            }
        }

        String internalReadLine(InputStream in) throws IOException {
            int ch;
            StringBuffer tmp = new StringBuffer();
            do {
                if ((ch = this.internalRead(in)) <= -1) continue;
                tmp.append((char)ch);
            } while (ch != -1 && ch != 10);
            return tmp.toString().trim();
        }

        @Override
        public int read() throws IOException {
            if (this.inStartup) {
                int ch;
                this.sessionIn.mark(this.marker1.length + 1);
                StringBuffer tmp = new StringBuffer();
                while (true) {
                    try {
                        do {
                            ch = this.internalRead(this.sessionIn);
                            tmp.append((char)ch);
                        } while (this.markerPos < this.marker1.length - 1 && this.marker1[this.markerPos++] == ch);
                    }
                    catch (SshIOException e) {
                        if (e.getRealException().getReason() == 21) {
                            if (System.currentTimeMillis() - this.startupStarted.toEpochMilli() <= this.shell.startupTimeout.toMillis()) continue;
                            throw new SshIOException(new SshException("", 20));
                        }
                        throw e;
                    }
                    break;
                }
                if (this.markerPos == this.marker1.length - 1) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("Potentially found test marker [" + this.currentLine.toString() + tmp.toString() + "]"), (Object[])new Object[0]);
                    }
                    if ((ch = this.internalRead(this.sessionIn)) == 13) {
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Looking good, found CR", (Object[])new Object[0]);
                        }
                        ch = this.internalRead(this.sessionIn);
                    }
                    if (ch == 10) {
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Found test marker", (Object[])new Object[0]);
                        }
                        try {
                            this.detect();
                        }
                        catch (SshException e) {
                            throw new SshIOException(e);
                        }
                        return -1;
                    }
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("Detected echo of test marker command since we did not find LF at end of marker ch=" + Integer.valueOf(ch) + " currentLine=" + this.currentLine.toString() + tmp.toString()), (Object[])new Object[0]);
                    }
                }
                this.sessionIn.reset();
                ch = this.internalRead(this.sessionIn);
                this.markerPos = 0;
                this.currentLine.append((char)ch);
                if (ch == 10) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("Shell startup (read): " + this.currentLine.toString()), (Object[])new Object[0]);
                    }
                    this.currentLine.setLength(0);
                }
                if (verboseDebug && Log.isDebugEnabled()) {
                    Log.debug((String)("Shell startup (read): " + this.currentLine.toString()), (Object[])new Object[0]);
                }
                this.sessionIn.mark(-1);
                return ch;
            }
            return -1;
        }

        void detect() throws IOException, SshException {
            this.inStartup = false;
            if (!this.detectSettings) {
                return;
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Detecting shell settings", (Object[])new Object[0]);
            }
            Object line = this.internalReadLine(this.sessionIn);
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Shell startup (detect): " + (String)line), (Object[])new Object[0]);
            }
            if (((String)line).equals("0") && this.osType == OS.UNKNOWN) {
                String tmp;
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"This looks like a *nix type machine, setting EOL to CR only and exit code variable to $?", (Object[])new Object[0]);
                }
                ShellProcess proc = this.shell.executeCommand("uname");
                BufferedReader r2 = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                line = "";
                while ((tmp = r2.readLine()) != null) {
                    line = (String)line + tmp;
                }
                switch (proc.getExitCode()) {
                    case 0: {
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)("Remote side reported it is " + ((String)line).trim()), (Object[])new Object[0]);
                        }
                        if (((String)(line = ((String)line).toLowerCase())).startsWith("Sun")) {
                            this.osType = OS.SOLARIS;
                            break;
                        }
                        if (((String)line).startsWith("aix")) {
                            this.osType = OS.AIX;
                            break;
                        }
                        if (((String)line).startsWith("darwin")) {
                            this.osType = OS.DARWIN;
                            break;
                        }
                        if (((String)line).startsWith("freebsd")) {
                            this.osType = OS.FREEBSD;
                            break;
                        }
                        if (((String)line).startsWith("openbsd")) {
                            this.osType = OS.OPENBSD;
                            break;
                        }
                        if (((String)line).startsWith("netbsd")) {
                            this.osType = OS.NETBSD;
                            break;
                        }
                        if (((String)line).startsWith("linux")) {
                            this.osType = OS.LINUX;
                            break;
                        }
                        if (((String)line).startsWith("hp-ux")) {
                            this.osType = OS.HPUX;
                            break;
                        }
                        this.osType = OS.UNKNOWN;
                        break;
                    }
                    case 127: {
                        Log.debug((String)"Remote side does not support uname", (Object[])new Object[0]);
                        break;
                    }
                    default: {
                        Log.debug((String)("uname returned error code " + proc.getExitCode()), (Object[])new Object[0]);
                        break;
                    }
                }
            } else if (this.osType == OS.UNKNOWN) {
                String cmd = "echo ---BEGIN--- && echo %errorlevel%\r\n";
                this.sessionOut.write(cmd.getBytes());
                while ((line = this.internalReadLine(this.sessionIn)) != null && !((String)line).endsWith(ExpectShell.BEGIN_COMMAND_MARKER)) {
                    if (((String)line).trim().equals("") || !Log.isDebugEnabled()) continue;
                    Log.debug((String)("Shell startup: " + (String)line), (Object[])new Object[0]);
                }
                line = this.internalReadLine(this.sessionIn);
                if (((String)line).equals("0")) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"This looks like a Windows machine, setting EOL to CRLF and exit code variable to %errorlevel%", (Object[])new Object[0]);
                    }
                    this.osType = OS.WINDOWS;
                }
            }
            switch (this.osType) {
                case WINDOWS: 
                case OPENVMS: 
                case POWERSHELL: {
                    break;
                }
                default: {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Setting default sudo prompt", (Object[])new Object[0]);
                    }
                    this.shell.executeCommand("export SUDO_PROMPT=Password:", true);
                }
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Shell initialized", (Object[])new Object[0]);
            }
        }
    }

    public static final class ExpectShellBuilder {
        private Optional<OS> os = Optional.empty();
        private Duration startupTimeout = Duration.ofSeconds(30L);
        private Optional<InputStream> input = Optional.empty();
        private Optional<OutputStream> output = Optional.empty();
        private Optional<SessionChannelNG> session = Optional.empty();
        private Optional<String> remoteIdentification = Optional.empty();
        private Optional<Charset> encoding = Optional.empty();
        private Optional<String> passwordPrompt = Optional.empty();
        private Optional<String> passwordErrorText = Optional.empty();
        private Optional<ShellStartupTrigger> trigger = Optional.empty();
        private boolean detectSettings = true;

        public static ExpectShellBuilder create() {
            return new ExpectShellBuilder();
        }

        public ExpectShellBuilder withoutDetectSettings() {
            return this.withDetectSettings(false);
        }

        public ExpectShellBuilder withDetectSettings(boolean detectSettings) {
            this.detectSettings = detectSettings;
            return this;
        }

        public ExpectShellBuilder withTrigger(ShellStartupTrigger trigger) {
            this.trigger = Optional.of(trigger);
            return this;
        }

        public ExpectShellBuilder withPasswordErrorText(String passwordErrorText) {
            this.passwordErrorText = Optional.of(passwordErrorText);
            return this;
        }

        public ExpectShellBuilder withPasswordPrompt(String passwordPrompt) {
            this.passwordPrompt = Optional.of(passwordPrompt);
            return this;
        }

        public ExpectShellBuilder withEncoding(String encoding) {
            if (encoding == null) {
                this.encoding = Optional.empty();
                return this;
            }
            return this.withEncoding(Charset.forName(encoding));
        }

        public ExpectShellBuilder withEncoding(Charset encoding) {
            this.encoding = Optional.of(encoding);
            return this;
        }

        public ExpectShellBuilder withInput(InputStream input) {
            this.input = Optional.of(input);
            return this;
        }

        public ExpectShellBuilder withOutput(OutputStream output) {
            this.output = Optional.of(output);
            return this;
        }

        public ExpectShellBuilder withSession(SessionChannelNG session) {
            this.session = Optional.of(session);
            return this;
        }

        public ExpectShellBuilder withTask(AbstractSessionTask<SessionChannelNG> task) {
            return this.withSession(task.getSession());
        }

        public ExpectShellBuilder withSession(AbstractSessionTask<SessionChannelNG> session) {
            return this.withSession(session.getSession());
        }

        public ExpectShellBuilder withOS(OS os) {
            this.os = Optional.of(os);
            return this;
        }

        @Deprecated(forRemoval=true, since="3.1.3")
        public ExpectShellBuilder withOS(int os) {
            return this.withOS(OS.code(os));
        }

        public ExpectShellBuilder withStartupTimeout(Duration startupTimeout) {
            this.startupTimeout = startupTimeout;
            return this;
        }

        public ExpectShellBuilder withStartupTimeoutSec(int startupTimeout) {
            return this.withStartupTimeout(Duration.ofSeconds(startupTimeout));
        }

        public ExpectShell build() throws SshException, IOException, ShellTimeoutException {
            return new ExpectShell(this);
        }
    }
}

