/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.AuthenticationProtocolClient;
import com.sshtools.client.BannerDisplay;
import com.sshtools.client.ClientAuthenticator;
import com.sshtools.client.ClientStateListener;
import com.sshtools.client.DefaultClientChannelFactory;
import com.sshtools.client.DefaultRemoteForwardRequestHandler;
import com.sshtools.client.LocalForwardingChannelFactoryImpl;
import com.sshtools.client.SshKeyExchangeClient;
import com.sshtools.client.SshKeyExchangeClientFactory;
import com.sshtools.client.TransportProtocolClient;
import com.sshtools.common.knownhosts.HostKeyVerification;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.ComponentFactory;
import com.sshtools.common.ssh.components.ComponentInstanceFactory;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.synergy.nio.ConnectRequestFuture;
import com.sshtools.synergy.nio.DefaultSocketConnectionFactory;
import com.sshtools.synergy.nio.ProtocolEngine;
import com.sshtools.synergy.nio.SocketConnectionFactory;
import com.sshtools.synergy.nio.SshEngine;
import com.sshtools.synergy.nio.SshEngineContext;
import com.sshtools.synergy.ssh.ChannelFactory;
import com.sshtools.synergy.ssh.ConnectionManager;
import com.sshtools.synergy.ssh.ForwardingManager;
import com.sshtools.synergy.ssh.GlobalRequestHandler;
import com.sshtools.synergy.ssh.RemoteForwardRequestHandler;
import com.sshtools.synergy.ssh.SshContext;
import com.sshtools.synergy.ssh.components.SshKeyExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;

public class SshClientContext
extends SshContext {
    List<ClientAuthenticator> authenticators = new ArrayList<ClientAuthenticator>();
    BannerDisplay bannerDisplay;
    String username;
    protected TransportProtocolClient transport;
    Collection<ClientStateListener> stateListeners = new ArrayList<ClientStateListener>();
    int subsystemCacheSize = 655350;
    ChannelFactory<SshClientContext> channelFactory = new DefaultClientChannelFactory();
    Map<String, GlobalRequestHandler<SshClientContext>> globalRequestHandlers = Collections.synchronizedMap(new HashMap());
    SocketConnectionFactory socketConnectionFactory = new DefaultSocketConnectionFactory();
    AuthenticationProtocolClient authenticationClient;
    private HostKeyVerification hkv = null;
    ForwardingManager<SshClientContext> forwardingManager;
    ConnectionManager<SshClientContext> connectionManager;
    static ForwardingManager<SshClientContext> defaultForwardingManager = new ForwardingManager();
    static ConnectionManager<SshClientContext> defaultConnectionManager = new ConnectionManager("client");
    private boolean preferKeyboardInteractiveOverPassword = true;
    private static ComponentFactory<SshKeyExchange<SshClientContext>> verifiedKeyExchanges;

    public SshClientContext() throws IOException, SshException {
        this(SecurityLevel.WEAK);
    }

    public SshClientContext(SshEngine daemon, ComponentManager componentManager, SecurityLevel securityLevel) throws IOException, SshException {
        super(componentManager, securityLevel);
        this.daemon = daemon;
    }

    public SshClientContext(SshEngine daemon) throws IOException, SshException {
        this(daemon, ComponentManager.getDefaultInstance(), SecurityLevel.WEAK);
    }

    public SshClientContext(SshEngine daemon, SecurityLevel securityLevel) throws IOException, SshException {
        this(daemon, ComponentManager.getDefaultInstance(), securityLevel);
    }

    public SshClientContext(SecurityLevel securityLevel) throws IOException, SshException {
        this(SshEngine.getDefaultInstance(), securityLevel);
    }

    public ProtocolEngine createEngine(ConnectRequestFuture connectFuture) throws IOException {
        this.transport = new TransportProtocolClient(this, connectFuture);
        return this.transport;
    }

    public final SshEngine getEngine() {
        return this.daemon;
    }

    public SshClientContext setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public SshClientContext addStateListener(ClientStateListener stateListener) {
        this.stateListeners.add(stateListener);
        return this;
    }

    public Collection<ClientStateListener> getStateListeners() {
        return this.stateListeners;
    }

    public ForwardingManager<SshClientContext> getForwardingManager() {
        return this.forwardingManager == null ? defaultForwardingManager : this.forwardingManager;
    }

    public SshClientContext setForwardingManager(ForwardingManager<SshClientContext> forwardingManager) {
        this.forwardingManager = forwardingManager;
        return this;
    }

    public void keysExchanged(boolean first) {
        if (first) {
            this.authenticationClient = new AuthenticationProtocolClient(this.transport, this, this.username);
            this.transport.startService(this.authenticationClient);
        }
    }

    public AuthenticationProtocolClient getAuthenticationClient() {
        return this.authenticationClient;
    }

    protected synchronized void configureKeyExchanges() {
        if (Objects.nonNull(verifiedKeyExchanges)) {
            this.keyExchanges = (ComponentFactory)verifiedKeyExchanges.clone();
            return;
        }
        if (Log.isInfoEnabled()) {
            Log.info((String)"Initializing client key exchanges", (Object[])new Object[0]);
        }
        verifiedKeyExchanges = new ComponentFactory(this.componentManager);
        for (SshKeyExchangeClientFactory kex : ServiceLoader.load(SshKeyExchangeClientFactory.class, JCEComponentManager.getDefaultInstance().getClassLoader())) {
            if (!this.testClientKeyExchangeAlgorithm(kex)) continue;
            verifiedKeyExchanges.add((ComponentInstanceFactory)kex);
        }
        this.keyExchanges = (ComponentFactory)verifiedKeyExchanges.clone();
    }

    public boolean testClientKeyExchangeAlgorithm(SshKeyExchangeClientFactory<? extends SshKeyExchangeClient> cls) {
        String name = cls.getKeys()[0];
        SshKeyExchange c = null;
        try {
            c = (SshKeyExchange)cls.create();
            if (!JCEComponentManager.getDefaultInstance().supportedDigests().contains(c.getHashAlgorithm())) {
                throw new Exception("Hash algorithm " + c.getHashAlgorithm() + " is not supported");
            }
            c.test();
        }
        catch (Exception e) {
            if (Log.isInfoEnabled()) {
                Log.info((String)("   " + name + " (client) will not be supported: " + e.getMessage()), (Object[])new Object[0]);
            }
            return false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Log.isInfoEnabled()) {
            Log.info((String)("   " + name + " (client) will be supported using JCE Provider " + c.getProvider()), (Object[])new Object[0]);
        }
        return true;
    }

    public String getSupportedPublicKeys() {
        return this.listPublicKeys(this.supportedPublicKeys().toArray());
    }

    public ComponentFactory<SshKeyExchange<?>> supportedKeyExchanges() {
        return this.keyExchanges;
    }

    public String getPreferredPublicKey() {
        return this.prefPublicKey;
    }

    public void setPreferredPublicKey(String prefPublicKey) {
        this.prefPublicKey = prefPublicKey;
    }

    public ConnectionManager<SshClientContext> getConnectionManager() {
        return this.connectionManager == null ? defaultConnectionManager : this.connectionManager;
    }

    public SshClientContext setConnectionManager(ConnectionManager<SshClientContext> connectionManager) {
        this.connectionManager = connectionManager;
        return this;
    }

    public SshClientContext addAuthenticator(ClientAuthenticator auth) {
        this.authenticators.add(auth);
        return this;
    }

    public List<ClientAuthenticator> getAuthenticators() {
        return this.authenticators;
    }

    public BannerDisplay getBannerDisplay() {
        return this.bannerDisplay;
    }

    public SshClientContext setBannerDisplay(BannerDisplay bannerDisplay) {
        this.bannerDisplay = bannerDisplay;
        return this;
    }

    public int getSubsystemCacheSize() {
        return this.subsystemCacheSize;
    }

    public SshClientContext setSubsystemCacheSize(int subsystemCacheSize) {
        this.subsystemCacheSize = subsystemCacheSize;
        return this;
    }

    public ChannelFactory<SshClientContext> getChannelFactory() {
        return this.channelFactory;
    }

    public void setChannelFactory(ChannelFactory<SshClientContext> channelFactory) {
        this.channelFactory = channelFactory;
    }

    public SshEngineContext getDaemonContext() {
        return this.daemon.getContext();
    }

    public SshClientContext addGlobalRequestHandler(GlobalRequestHandler<SshClientContext> handler) {
        for (int i = 0; i < handler.supportedRequests().length; ++i) {
            this.globalRequestHandlers.put(handler.supportedRequests()[i], handler);
        }
        return this;
    }

    public GlobalRequestHandler<SshClientContext> getGlobalRequestHandler(String name) {
        return this.globalRequestHandlers.get(name);
    }

    public SocketConnectionFactory getSocketConnectionFactory() {
        return this.socketConnectionFactory;
    }

    public HostKeyVerification getHostKeyVerification() {
        return this.hkv;
    }

    public SshClientContext setHostKeyVerification(HostKeyVerification hkv) {
        this.hkv = hkv;
        return this;
    }

    public boolean getPreferKeyboardInteractiveOverPassword() {
        return this.preferKeyboardInteractiveOverPassword;
    }

    public void setPreferKeyboardInteractiveOverPassword(boolean preferKeyboardInteractiveOverPassword) {
        this.preferKeyboardInteractiveOverPassword = preferKeyboardInteractiveOverPassword;
    }

    static {
        defaultForwardingManager.setForwardingFactory((h, p) -> new LocalForwardingChannelFactoryImpl(h, p));
        defaultForwardingManager.addRemoteForwardRequestHandler((RemoteForwardRequestHandler)new DefaultRemoteForwardRequestHandler());
    }
}

