/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.remote;

import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.OpenSSHConfig;
import com.jcraft.jsch.Session;
import com.microsoft.azure.vmagent.AzureVMAgent;
import com.microsoft.azure.vmagent.AzureVMAgentTemplate;
import com.microsoft.azure.vmagent.AzureVMCloud;
import com.microsoft.azure.vmagent.AzureVMComputer;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.util.AzureUtil;
import com.microsoft.azure.vmagent.util.CleanUpAction;
import com.microsoft.azure.vmagent.util.FailureStage;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jvnet.localizer.Localizable;

public class AzureVMAgentSSHLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(AzureVMAgentSSHLauncher.class.getName());
    private static final String REMOTE_INIT_FILE_NAME = "init.sh";
    private static final String REMOTE_INIT_FILE_NAME_WINDOWS = "/init.ps1";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(SlaveComputer agentComputer, TaskListener listener) {
        SlaveComputer slaveComputer;
        Session session;
        boolean successful;
        PrintStream logger;
        boolean isUnix;
        AzureVMAgent agent;
        AzureVMComputer computer;
        block33: {
            if (!(agentComputer instanceof AzureVMComputer)) {
                LOGGER.log(Level.INFO, "AgentComputer is invalid {0}", agentComputer);
                return;
            }
            computer = (AzureVMComputer)agentComputer;
            agent = (AzureVMAgent)computer.getNode();
            if (agent == null) {
                LOGGER.log(Level.INFO, "Agent node is null");
                return;
            }
            LOGGER.log(Level.FINE, "launching agent {0}", computer.getName());
            isUnix = agent.getOsType().equals((Object)OperatingSystemTypes.LINUX);
            try {
                if (!agent.isVMAliveOrHealthy()) {
                    LOGGER.log(Level.INFO, "Agent {0} is shut down, deleted, etc. Not attempting to connect", computer.getName());
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            agent.blockCleanUpAction();
            logger = listener.getLogger();
            successful = false;
            session = null;
            slaveComputer = agent.getComputer();
            if (slaveComputer == null) {
                LOGGER.log(Level.SEVERE, "Got null computer.");
                this.handleLaunchFailure(agent, "Post Provisioning Failure: 'Computer' was null");
                return;
            }
            try {
                session = this.connectToSsh(agent);
            }
            catch (UnknownHostException e) {
                LOGGER.log(Level.SEVERE, "Got unknown host exception. Virtual machine might have been deleted already", e);
            }
            catch (ConnectException e) {
                LOGGER.log(Level.SEVERE, "Got connect exception while launching " + agent.getNodeName() + ". Might be due to firewall rules", e);
                this.handleLaunchFailure(agent, "Post Provisioning Failure: Not able to connect to agent machine. Ensure that ssh server is configured properly");
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().equalsIgnoreCase("Auth fail")) {
                    LOGGER.log(Level.SEVERE, "Authentication failure launching " + agent.getNodeName() + ". Image may not be supporting password authentication", e);
                    this.handleLaunchFailure(agent, "Post Provisioning Failure: Not able to authenticate via username and  Image may not be supporting password authentication , marking template has disabled");
                }
                LOGGER.log(Level.SEVERE, "Exception launching" + agent.getNodeName(), e);
                this.handleLaunchFailure(agent, "Post Provisioning Failure: Not able to connect to agent machine. Ensure that ssh server is configured properly" + e.getMessage());
            }
            finally {
                if (session != null) break block33;
                slaveComputer.setAcceptingTasks(false);
                agent.setCleanUpAction(CleanUpAction.DELETE, Messages._Agent_Failed_To_Connect());
                return;
            }
        }
        Localizable cleanUpReason = null;
        try {
            final Session cleanupSession = session;
            String initScript = agent.getInitScript();
            String command = isUnix ? "test -e ~/.azure-agent-init" : "dir C:\\.azure-agent-init";
            if (StringUtils.isNotBlank((CharSequence)initScript) && this.executeRemoteCommand(session, command, logger, isUnix) != 0) {
                LOGGER.fine("Init script is not null, preparing to execute script remotely on " + agent.getNodeName());
                if (isUnix) {
                    this.copyFileToRemote(session, (InputStream)new ByteArrayInputStream(initScript.getBytes(StandardCharsets.UTF_8)), REMOTE_INIT_FILE_NAME);
                } else {
                    this.copyFileToRemote(session, (InputStream)new ByteArrayInputStream(initScript.getBytes(StandardCharsets.UTF_8)), REMOTE_INIT_FILE_NAME_WINDOWS);
                }
                command = isUnix ? "sh init.sh" : "powershell /init.ps1";
                int exitStatus = this.executeRemoteCommand(session, command, logger, isUnix, agent.getExecuteInitScriptAsRoot());
                if (exitStatus != 0) {
                    if (agent.getDoNotUseMachineIfInitFails()) {
                        LOGGER.log(Level.SEVERE, "Init script failed on " + agent.getNodeName() + ": exit code={0} (marking agent for deletion)", exitStatus);
                        cleanUpReason = Messages._Agent_Failed_Init_Script();
                        return;
                    }
                    LOGGER.log(Level.INFO, "Init script failed on " + agent.getNodeName() + ": exit code={0} (ignoring)", exitStatus);
                } else {
                    LOGGER.fine("Init script on " + agent.getNodeName() + " got executed successfully");
                }
                if (!isUnix) {
                    this.executeRemoteCommand(session, "powershell -ExecutionPolicy Bypass Restart-Service sshd", logger, isUnix);
                }
                session.disconnect();
                session = this.connectToSsh(agent);
                command = isUnix ? "touch ~/.azure-agent-init" : "copy NUL C:\\.azure-agent-init";
                this.executeRemoteCommand(session, command, logger, isUnix);
            }
            LOGGER.fine("Checking for java runtime on " + agent.getNodeName());
            if (this.executeRemoteCommand(session, agent.getJavaPath() + " -fullversion", logger, isUnix) != 0) {
                LOGGER.info("Java not found on " + agent.getNodeName() + ". At a minimum init script should ensure that java runtime is installed");
                this.handleLaunchFailure(agent, "Post Provisioning Failure: Java runtime not found. At a minimum init script  should ensure that java runtime is installed");
                return;
            }
            LOGGER.fine("Java runtime present on " + agent.getNodeName() + ", copying remoting.jar to remote");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Jenkins.get().getJnlpJars("remoting.jar").readFully());
            this.copyFileToRemote(session, (InputStream)inputStream, "remoting.jar");
            String remotingWorkingDirectory = this.getRemotingWorkingDirectory(isUnix);
            String remotingDefaultOptions = "-workDir " + remotingWorkingDirectory;
            Object remotingOptions = Util.fixEmpty((String)agent.getRemotingOptions()) != null ? agent.getRemotingOptions() : remotingDefaultOptions;
            String jvmopts = agent.getJvmOptions();
            String execCommand = agent.getJavaPath() + " " + (StringUtils.isNotBlank((CharSequence)jvmopts) ? jvmopts : "") + " -jar remoting.jar " + (String)remotingOptions;
            LOGGER.log(Level.INFO, "Launching agent " + agent.getNodeName() + ": {0}", execCommand);
            final ChannelExec jschChannel = (ChannelExec)session.openChannel("exec");
            jschChannel.setCommand(execCommand);
            jschChannel.connect();
            LOGGER.info("Connected " + agent.getNodeName() + " successfully");
            computer.setChannel(jschChannel.getInputStream(), jschChannel.getOutputStream(), logger, new Channel.Listener(){

                public void onClosed(Channel channel, IOException cause) {
                    jschChannel.disconnect();
                    cleanupSession.disconnect();
                }
            });
            LOGGER.info("Launched agent " + agent.getNodeName() + " successfully");
            agent.clearCleanUpAction();
            successful = true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Got exception on agent " + agent.getNodeName(), e);
        }
        finally {
            if (!successful) {
                session.disconnect();
                if (cleanUpReason == null) {
                    cleanUpReason = Messages._Agent_Failed_To_Connect();
                }
                slaveComputer.setAcceptingTasks(false);
                agent.setCleanUpAction(CleanUpAction.DELETE, cleanUpReason);
            }
        }
    }

    private String getRemotingWorkingDirectory(boolean isUnix) {
        if (isUnix) {
            return "~/remoting";
        }
        return "C:\\remoting";
    }

    private Session getRemoteSession(String userName, String passwordOrKey, String passphrase, String dnsName, int sshPort, String sshConfig, boolean passwordAuth) throws JSchException {
        LOGGER.log(Level.INFO, "Getting remote session for user {0} to host {1}:{2}", new Object[]{userName, dnsName, sshPort});
        JSch remoteClient = new JSch();
        if (StringUtils.isNotBlank((CharSequence)sshConfig)) {
            try {
                OpenSSHConfig configRepository = OpenSSHConfig.parse((String)sshConfig);
                remoteClient.setConfigRepository((ConfigRepository)configRepository);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "AzureVMAgentSSHLauncher: getRemoteSession: Got exception while using custom openssh config: {0} {1}", new Object[]{sshConfig, e.getMessage()});
                throw new JSchException("Unable to parse openssh config", (Throwable)e);
            }
        }
        Session session = remoteClient.getSession(userName, dnsName, sshPort);
        session.setConfig("StrictHostKeyChecking", "no");
        if (passwordAuth) {
            session.setPassword(passwordOrKey);
        } else {
            remoteClient.addIdentity("key", passwordOrKey.getBytes(StandardCharsets.UTF_8), null, passphrase != null ? passphrase.getBytes(StandardCharsets.UTF_8) : null);
        }
        int serverAliveIntervalInMillis = 60000;
        session.setServerAliveInterval(60000);
        session.connect();
        LOGGER.log(Level.INFO, "Got remote session for user {0} to host {1}:{2}", new Object[]{userName, dnsName, sshPort});
        return session;
    }

    public void copyFileToRemote(AzureVMAgent agent, InputStream stream, String remotePath) throws Exception {
        this.copyFileToRemote(this.connectToSsh(agent), stream, remotePath);
    }

    private void copyFileToRemote(Session jschSession, InputStream stream, String remotePath) throws Exception {
        LOGGER.log(Level.FINE, "Initiating file transfer to {0}", remotePath);
        ChannelSftp sftpChannel = null;
        try {
            sftpChannel = (ChannelSftp)jschSession.openChannel("sftp");
            sftpChannel.connect();
            sftpChannel.put(stream, remotePath);
            if (!sftpChannel.isClosed()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            LOGGER.log(Level.FINE, "Copied file Successfully to {0}", remotePath);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error occurred while copying file to remote host", e);
            throw e;
        }
        finally {
            try {
                if (sftpChannel != null) {
                    sftpChannel.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }

    public int executeRemoteCommand(AzureVMAgent agent, String command, PrintStream logger, boolean isUnix) throws Exception {
        return this.executeRemoteCommand(this.connectToSsh(agent), command, logger, isUnix, false);
    }

    public int executeRemoteCommand(AzureVMAgent agent, String command, PrintStream logger, boolean isUnix, boolean executeAsRoot) throws Exception {
        return this.executeRemoteCommand(this.connectToSsh(agent), command, logger, isUnix, executeAsRoot);
    }

    private int executeRemoteCommand(Session jschSession, String command, PrintStream logger, boolean isUnix) {
        return this.executeRemoteCommand(jschSession, command, logger, isUnix, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeRemoteCommand(Session jschSession, String command, PrintStream logger, boolean isUnix, boolean executeAsRoot) {
        ChannelExec channel = null;
        try {
            Object finalCommand = isUnix && executeAsRoot ? "sudo -S -p '' " + command : command;
            LOGGER.log(Level.INFO, "Starting {0}", command);
            channel = (ChannelExec)jschSession.openChannel("exec");
            channel.setCommand((String)finalCommand);
            channel.setInputStream(null);
            channel.setErrStream((OutputStream)System.err);
            InputStream inputStream = channel.getInputStream();
            InputStream errorStream = channel.getErrStream();
            int connectTimeoutInMillis = 60000;
            channel.connect(60000);
            try {
                IOUtils.copy((InputStream)inputStream, (OutputStream)logger);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            try {
                IOUtils.copy((InputStream)errorStream, (OutputStream)logger);
            }
            finally {
                IOUtils.closeQuietly((InputStream)errorStream);
            }
            if (!channel.isClosed()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            LOGGER.fine("Executed command successfully");
            int n = channel.getExitStatus();
            return n;
        }
        catch (JSchException jse) {
            LOGGER.log(Level.SEVERE, "Exception while executing remote command" + command, jse);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "IO failure running {0}", command);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, String.format("Unexpected exception running %s", command), e);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        return -1;
    }

    private Session connectToSsh(AzureVMAgent agent) throws Exception {
        Session session;
        LOGGER.fine("Start connecting to SSH");
        int maxRetryCount = 36;
        int currRetryCount = 0;
        while (true) {
            ++currRetryCount;
            try {
                String passwordOrKey;
                StandardUsernameCredentials creds = AzureUtil.getCredentials(agent.getVMCredentialsId());
                String passphrase = null;
                boolean passwordAuth = false;
                if (creds instanceof StandardUsernamePasswordCredentials) {
                    passwordOrKey = ((StandardUsernamePasswordCredentials)creds).getPassword().getPlainText();
                    passwordAuth = true;
                } else {
                    SSHUserPrivateKey sshCreds = (SSHUserPrivateKey)creds;
                    passwordOrKey = (String)sshCreds.getPrivateKeys().get(0);
                    Secret secretPassphrase = sshCreds.getPassphrase();
                    passphrase = secretPassphrase != null ? secretPassphrase.getPlainText() : null;
                }
                session = this.getRemoteSession(creds.getUsername(), passwordOrKey, passphrase, agent.getPublicDNSName(), agent.getSshPort(), agent.getSshConfig(), passwordAuth);
                LOGGER.fine("Got remote connection");
            }
            catch (Exception e) {
                if (currRetryCount >= 36) {
                    throw e;
                }
                int backoffTime = 10;
                LOGGER.log(Level.INFO, String.format("Failed connecting to host %s:%s. Will be trying again after %s seconds, error was: %s ", agent.getPublicDNSName(), agent.getSshPort(), backoffTime, e.getMessage()));
                LOGGER.log(Level.FINE, String.format("Failed connecting to host %s:%s.", agent.getPublicDNSName(), agent.getSshPort()), e);
                long sleepInMills = TimeUnit.SECONDS.toMillis(backoffTime);
                Thread.sleep(sleepInMills);
                continue;
            }
            break;
        }
        return session;
    }

    private void handleLaunchFailure(AzureVMAgent agent, String message) {
        AzureVMAgentTemplate agentTemplate;
        AzureVMCloud azureCloud = agent.getCloud();
        if (azureCloud != null && (agentTemplate = azureCloud.getAzureAgentTemplate(agent.getTemplateName())) != null) {
            agentTemplate.handleTemplateProvisioningFailure(message, FailureStage.POSTPROVISIONING);
        }
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }
}

