/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.BinaryData;
import com.azure.core.util.ExpandableStringEnum;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.compute.models.GalleryImageVersion;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.PowerState;
import com.azure.resourcemanager.compute.models.PurchasePlan;
import com.azure.resourcemanager.compute.models.VirtualMachine;
import com.azure.resourcemanager.compute.models.VirtualMachineCustomImage;
import com.azure.resourcemanager.compute.models.VirtualMachineImage;
import com.azure.resourcemanager.compute.models.VirtualMachineOffer;
import com.azure.resourcemanager.compute.models.VirtualMachinePublisher;
import com.azure.resourcemanager.compute.models.VirtualMachineSize;
import com.azure.resourcemanager.compute.models.VirtualMachineSku;
import com.azure.resourcemanager.msi.models.Identity;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.NetworkInterface;
import com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.models.Deployment;
import com.azure.resourcemanager.resources.models.DeploymentMode;
import com.azure.resourcemanager.resources.models.GenericResource;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import com.azure.resourcemanager.storage.models.CheckNameAvailabilityResult;
import com.azure.resourcemanager.storage.models.Reason;
import com.azure.resourcemanager.storage.models.SkuName;
import com.azure.resourcemanager.storage.models.StorageAccount;
import com.azure.resourcemanager.storage.models.StorageAccountKey;
import com.azure.resourcemanager.storage.models.StorageAccountSkuType;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.jcraft.jsch.OpenSSHConfig;
import com.microsoft.azure.vmagent.AzureTagPair;
import com.microsoft.azure.vmagent.AzureVMAgent;
import com.microsoft.azure.vmagent.AzureVMAgentCleanUpTask;
import com.microsoft.azure.vmagent.AzureVMAgentTemplate;
import com.microsoft.azure.vmagent.AzureVMCloud;
import com.microsoft.azure.vmagent.AzureVMCloudBaseRetentionStrategy;
import com.microsoft.azure.vmagent.AzureVMComputer;
import com.microsoft.azure.vmagent.AzureVMDeploymentInfo;
import com.microsoft.azure.vmagent.ImageReferenceType;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.availability.AvailabilitySet;
import com.microsoft.azure.vmagent.availability.AvailabilityZone;
import com.microsoft.azure.vmagent.availability.AzureAvailabilityType;
import com.microsoft.azure.vmagent.availability.VirtualMachineScaleSet;
import com.microsoft.azure.vmagent.exceptions.AzureCloudException;
import com.microsoft.azure.vmagent.launcher.AzureComputerLauncher;
import com.microsoft.azure.vmagent.launcher.AzureSSHLauncher;
import com.microsoft.azure.vmagent.util.AzureUtil;
import com.microsoft.azure.vmagent.util.CleanUpAction;
import com.microsoft.azure.vmagent.util.Constants;
import com.microsoft.azure.vmagent.util.KeyDecoder;
import com.microsoft.azure.vmagent.util.LocationCache;
import com.microsoft.jenkins.credentials.AzureResourceManagerCache;
import com.microsoft.jenkins.credentials.BlobServiceClientCache;
import com.sshtools.common.publickey.InvalidPassphraseException;
import com.sshtools.common.ssh.SshException;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.slaves.RetentionStrategy;
import hudson.util.Secret;
import io.jenkins.plugins.azuresdk.HttpClientRetriever;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.model.Jenkins;
import jenkins.slaves.JnlpAgentReceiver;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public final class AzureVMManagementServiceDelegate {
    private static final Logger LOGGER = Logger.getLogger(AzureVMManagementServiceDelegate.class.getName());
    private static final String EMBEDDED_TEMPLATE_FILENAME = "/referenceImageTemplate.json";
    private static final String EMBEDDED_TEMPLATE_WITH_SCRIPT_FILENAME = "/referenceImageTemplateWithScript.json";
    private static final String EMBEDDED_TEMPLATE_IMAGE_FILENAME = "/customImageTemplate.json";
    private static final String EMBEDDED_TEMPLATE_IMAGE_WITH_SCRIPT_FILENAME = "/customImageTemplateWithScript.json";
    private static final String EMBEDDED_TEMPLATE_WITH_MANAGED_FILENAME = "/referenceImageTemplateWithManagedDisk.json";
    private static final String EMBEDDED_TEMPLATE_WITH_SCRIPT_MANAGED_FILENAME = "/referenceImageTemplateWithScriptAndManagedDisk.json";
    private static final String EMBEDDED_TEMPLATE_IMAGE_WITH_MANAGED_FILENAME = "/customImageTemplateWithManagedDisk.json";
    private static final String EMBEDDED_TEMPLATE_IMAGE_WITH_SCRIPT_MANAGED_FILENAME = "/customImageTemplateWithScriptAndManagedDisk.json";
    private static final String EMBEDDED_TEMPLATE_IMAGE_ID_WITH_MANAGED_FILENAME = "/referenceImageIDTemplateWithManagedDisk.json";
    private static final String EMBEDDED_TEMPLATE_IMAGE_ID_WITH_SCRIPT_MANAGED_FILENAME = "/referenceImageIDTemplateWithScriptAndManagedDisk.json";
    private static final String VIRTUAL_NETWORK_TEMPLATE_FRAGMENT_FILENAME = "/virtualNetworkFragment.json";
    private static final String PUBLIC_IP_FRAGMENT_FILENAME = "/publicIPFragment.json";
    private static final Map<String, List<String>> AVAILABLE_ROLE_SIZES = AzureVMManagementServiceDelegate.getAvailableRoleSizes();
    private static final Set<String> AVAILABLE_LOCATIONS_STD = AzureVMManagementServiceDelegate.getAvailableLocationsStandard();
    private static final Set<String> AVAILABLE_LOCATIONS_CHINA = AzureVMManagementServiceDelegate.getAvailableLocationsChina();
    private static final List<String> DEFAULT_VM_SIZES = Arrays.asList("Standard_A0", "Standard_A1", "Standard_A2", "Standard_A3", "Standard_A4", "Standard_A5", "Standard_A6", "Standard_A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_DS1_v2", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_DS11_v2", "Standard_DS12_v2", "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS15_v2", "Standard_DS1", "Standard_DS2", "Standard_DS3", "Standard_DS4", "Standard_DS11", "Standard_DS12", "Standard_DS13", "Standard_DS14", "Standard_F1s", "Standard_F2s", "Standard_F4s", "Standard_F8s", "Standard_F16s", "Standard_D1", "Standard_D2", "Standard_D3", "Standard_D4", "Standard_D11", "Standard_D12", "Standard_D13", "Standard_D14", "Standard_A1_v2", "Standard_A2m_v2", "Standard_A2_v2", "Standard_A4m_v2", "Standard_A4_v2", "Standard_A8m_v2", "Standard_A8_v2", "Standard_D1_v2", "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2", "Standard_D11_v2", "Standard_D12_v2", "Standard_D13_v2", "Standard_D14_v2", "Standard_D15_v2", "Standard_F1", "Standard_F2", "Standard_F4", "Standard_F8", "Standard_F16");
    public static final Map<String, Map<String, String>> DEFAULT_IMAGE_PROPERTIES = AzureVMManagementServiceDelegate.getDefaultImageProperties();
    public static final Map<String, Map<String, String>> PRE_INSTALLED_TOOLS_SCRIPT = AzureVMManagementServiceDelegate.getPreInstalledToolsScript();
    private static final String INSTALL_JNLP_WINDOWS_FILENAME = "windowsInstallJnlpScript.ps1";
    private static final String INSTALL_GIT_WINDOWS_FILENAME = "windowsInstallGitScript.ps1";
    private static final String INSTALL_JAVA_WINDOWS_FILENAME = "windowsInstallJavaScript.ps1";
    private static final String INSTALL_MAVEN_WINDOWS_FILENAME = "windowsInstallMavenScript.ps1";
    private static final String INSTALL_QEMU_WINDOWS_FILENAME = "windowsInstallQemuScript.ps1";
    private static final String INSTALL_GIT_UBUNTU_FILENAME = "ubuntuInstallGitScript.sh";
    private static final String INSTALL_JAVA_UBUNTU_FILENAME = "ubuntuInstallJavaScript.sh";
    private static final String INSTALL_MAVEN_UBUNTU_FILENAME = "ubuntuInstallMavenScript.sh";
    private static final String INSTALL_DOCKER_UBUNTU_FILENAME = "ubuntuInstallDockerScript.sh";
    private static final String INSTALL_QEMU_UBUNTU_FILENAME = "ubuntuInstallQemuScript.sh";
    private static final String PRE_INSTALL_SSH_FILENAME = "sshInit.ps1";
    private final AzureResourceManager azureClient;
    private final String azureCredentialsId;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Cache<String, Set<String>> vmSizesByLocation = Caffeine.newBuilder().expireAfterAccess(24L, TimeUnit.HOURS).build();

    public static AzureVMManagementServiceDelegate getInstance(AzureVMCloud cloud) {
        return cloud.getServiceDelegate();
    }

    public static AzureVMManagementServiceDelegate getInstance(AzureResourceManager azureClient, String azureCredentialsId) {
        if (azureClient == null) {
            throw new NullPointerException("the azure client is null!");
        }
        return new AzureVMManagementServiceDelegate(azureClient, azureCredentialsId);
    }

    public AzureVMDeploymentInfo createDeployment(AzureVMAgentTemplate template, int numberOfAgents) throws AzureCloudException, IOException {
        return this.createDeployment(template, numberOfAgents, AzureVMAgentCleanUpTask.DeploymentRegistrar.getInstance());
    }

    public AzureVMDeploymentInfo createDeployment(AzureVMAgentTemplate template, int numberOfAgents, AzureVMAgentCleanUpTask.DeploymentRegistrar deploymentRegistrar) throws AzureCloudException, IOException {
        String scriptUri = null;
        try (InputStream embeddedTemplate = null;){
            ArrayNode resources;
            String templateLocation;
            String msg;
            boolean useCustomImage;
            boolean useCustomScriptExtension;
            LOGGER.log(Level.INFO, "Initializing deployment for {0} agentTemplate(s) {1}", new Object[]{numberOfAgents, template.getTemplateName()});
            Map<String, Object> properties = AzureVMAgentTemplate.getTemplateProperties(template);
            Date timestamp = new Date(System.currentTimeMillis());
            String deploymentName = AzureUtil.getDeploymentName(template.getTemplateName(), timestamp);
            String vmBaseName = AzureUtil.getVMBaseName(template.getTemplateName(), deploymentName, (String)properties.get("osType"), numberOfAgents);
            String locationName = AzureUtil.getLocationNameByLabel(template.getLocation());
            String storageAccountName = template.getStorageAccountName();
            String storageAccountType = template.getStorageAccountType();
            String diskType = template.getDiskType();
            boolean ephemeralOSDisk = template.isEphemeralOSDisk();
            boolean encryptionAtHost = template.isEncryptionAtHost();
            int osDiskSize = template.getOsDiskSize();
            if ("new".equals(template.getResourceGroupReferenceType()) && !template.getResourceGroupName().matches("^[a-zA-Z0-9][a-zA-Z\\-\\._0-9]{0,62}[a-zA-Z0-9]$")) {
                LOGGER.log(Level.SEVERE, "ResourceGroup Name {0} is invalid. It should be 1-64 alphanumeric characters", new Object[]{template.getResourceGroupName()});
                throw new RuntimeException("ResourceGroup Name is invalid");
            }
            LOGGER.log(Level.INFO, "Creating a new deployment {0} with VM base name {1} for {2} VM(s)", new Object[]{deploymentName, vmBaseName, numberOfAgents});
            String resourceGroupName = template.getResourceGroupName();
            String resourceGroupReferenceType = template.getResourceGroupReferenceType();
            String cloudName = template.retrieveAzureCloudReference().getCloudName();
            if ("new".equals(resourceGroupReferenceType)) {
                this.createAzureResourceGroup(this.azureClient, locationName, resourceGroupName, cloudName);
            }
            List<AzureTagPair> cloudTags = template.retrieveAzureCloudReference().getCloudTags();
            List<AzureTagPair> templateTags = template.getTags();
            List<AzureTagPair> tags = AzureVMManagementServiceDelegate.concat(cloudTags, templateTags);
            this.createStorageAccount(this.azureClient, storageAccountType, storageAccountName, locationName, resourceGroupName, template.getTemplateName(), tags);
            StorageAccount storageAccount = this.getStorageAccount(this.azureClient, storageAccountName, resourceGroupName);
            String blobEndpointSuffix = AzureVMManagementServiceDelegate.getBlobEndpointSuffixForTemplate(storageAccount);
            boolean isBasic = template.isTopLevelType("basic");
            ImageReferenceType referenceType = template.getImageReference().getType();
            boolean preInstallSSH = template.getLauncher() instanceof AzureSSHLauncher && ((AzureSSHLauncher)template.getLauncher()).isPreInstallSsh();
            boolean preInstallSshInWindows = properties.get("osType").equals("Windows") && properties.get("agentLaunchMethod").equals("SSH") && (isBasic || referenceType == ImageReferenceType.REFERENCE || preInstallSSH);
            boolean windows = properties.get("osType").equals("Windows");
            boolean inboundAgent = properties.get("agentLaunchMethod").equals("JNLP");
            boolean bl = useCustomScriptExtension = preInstallSshInWindows || windows && StringUtils.isNotBlank((CharSequence)((String)properties.get("initScript"))) && inboundAgent;
            if (!useCustomScriptExtension && !windows && inboundAgent) {
                useCustomScriptExtension = true;
            }
            boolean useManagedDisk = diskType.equals("managed");
            boolean bl2 = useCustomImage = !isBasic && referenceType == ImageReferenceType.CUSTOM;
            if (useCustomScriptExtension) {
                if (useManagedDisk) {
                    msg = "Use embedded deployment template (with script and managed) {0}";
                    templateLocation = useCustomImage ? EMBEDDED_TEMPLATE_IMAGE_WITH_SCRIPT_MANAGED_FILENAME : (referenceType == ImageReferenceType.CUSTOM_IMAGE || referenceType == ImageReferenceType.GALLERY ? EMBEDDED_TEMPLATE_IMAGE_ID_WITH_SCRIPT_MANAGED_FILENAME : EMBEDDED_TEMPLATE_WITH_SCRIPT_MANAGED_FILENAME);
                } else {
                    msg = "Use embedded deployment template (with script) {0}";
                    templateLocation = useCustomImage ? EMBEDDED_TEMPLATE_IMAGE_WITH_SCRIPT_FILENAME : EMBEDDED_TEMPLATE_WITH_SCRIPT_FILENAME;
                }
            } else if (useManagedDisk) {
                msg = "Use embedded deployment template (with managed) {0}";
                templateLocation = useCustomImage ? EMBEDDED_TEMPLATE_IMAGE_WITH_MANAGED_FILENAME : (referenceType == ImageReferenceType.CUSTOM_IMAGE || referenceType == ImageReferenceType.GALLERY ? EMBEDDED_TEMPLATE_IMAGE_ID_WITH_MANAGED_FILENAME : EMBEDDED_TEMPLATE_WITH_MANAGED_FILENAME);
            } else {
                msg = "Use embedded deployment template {0}";
                templateLocation = useCustomImage ? EMBEDDED_TEMPLATE_IMAGE_FILENAME : EMBEDDED_TEMPLATE_FILENAME;
            }
            LOGGER.log(Level.INFO, msg, templateLocation);
            embeddedTemplate = AzureVMManagementServiceDelegate.class.getResourceAsStream(templateLocation);
            JsonNode tmp = MAPPER.readTree(embeddedTemplate);
            if (useCustomScriptExtension) {
                ArrayNode resources2 = (ArrayNode)tmp.get("resources");
                for (JsonNode resource : resources2) {
                    String type = resource.get("type").asText();
                    if (!type.contains("virtualMachine")) continue;
                    ArrayNode vmResources = (ArrayNode)resource.get("resources");
                    vmResources.remove(windows ? 1 : 0);
                }
            }
            ObjectNode count = MAPPER.createObjectNode();
            count.put("type", "int");
            count.put("defaultValue", numberOfAgents);
            ((ObjectNode)tmp.get("parameters")).replace("count", (JsonNode)count);
            AzureVMManagementServiceDelegate.putVariable(tmp, "vmName", vmBaseName);
            AzureVMManagementServiceDelegate.putVariable(tmp, "location", locationName);
            AzureVMManagementServiceDelegate.putVariable(tmp, "jenkinsTag", "ManagedByAzureVMAgents");
            AzureVMManagementServiceDelegate.putVariable(tmp, "resourceTag", deploymentRegistrar.getDeploymentTag().get());
            AzureVMManagementServiceDelegate.putVariable(tmp, "cloudTag", cloudName);
            AzureVMManagementServiceDelegate.putVariable(tmp, "templateTag", template.getTemplateName());
            AzureVMManagementServiceDelegate.putVariable(tmp, "osDiskStorageAccountType", template.getOsDiskStorageAccountType());
            if (!isBasic) {
                if (referenceType == ImageReferenceType.REFERENCE) {
                    boolean isImageParameterValid = this.checkImageParameter(template);
                    if (isImageParameterValid) {
                        String imageVersion = StringUtils.isNotEmpty((CharSequence)template.getImageReference().getVersion()) ? template.getImageReference().getVersion() : "latest";
                        VirtualMachineImage image = this.azureClient.virtualMachineImages().getImage(locationName, template.getImageReference().getPublisher(), template.getImageReference().getOffer(), template.getImageReference().getSku(), imageVersion);
                        if (image != null) {
                            PurchasePlan plan = image.plan();
                            if (plan != null) {
                                ArrayNode resources3 = (ArrayNode)tmp.get("resources");
                                for (JsonNode resource : resources3) {
                                    String type = resource.get("type").asText();
                                    if (!type.contains("virtualMachine")) continue;
                                    ObjectNode planNode = MAPPER.createObjectNode();
                                    planNode.put("name", plan.name());
                                    planNode.put("publisher", plan.publisher());
                                    planNode.put("product", plan.product());
                                    ((ObjectNode)resource).replace("plan", (JsonNode)planNode);
                                }
                            }
                        } else {
                            LOGGER.log(Level.SEVERE, "Failed to find the image with publisher:{0} offer:{1} sku:{2} version:{3} when trying to add purchase plan to ARM template", new Object[]{template.getImageReference().getPublisher(), template.getImageReference().getOffer(), template.getImageReference().getSku(), imageVersion});
                        }
                    }
                } else if (referenceType == ImageReferenceType.CUSTOM_IMAGE) {
                    Map imageTags;
                    String id = template.getId();
                    VirtualMachineCustomImage customImage = (VirtualMachineCustomImage)this.azureClient.virtualMachineCustomImages().getById(id);
                    if (customImage != null && (imageTags = customImage.tags()) != null) {
                        String planInfo = (String)imageTags.get("PlanInfo");
                        String planProduct = (String)imageTags.get("PlanProduct");
                        String planPublisher = (String)imageTags.get("PlanPublisher");
                        if (StringUtils.isNotBlank((CharSequence)planInfo) && StringUtils.isNotBlank((CharSequence)planProduct) && StringUtils.isNotBlank((CharSequence)planPublisher)) {
                            ArrayNode resources4 = (ArrayNode)tmp.get("resources");
                            for (JsonNode resource : resources4) {
                                String type = resource.get("type").asText();
                                if (!type.contains("virtualMachine")) continue;
                                ObjectNode planNode = MAPPER.createObjectNode();
                                planNode.put("name", planInfo);
                                planNode.put("publisher", planPublisher);
                                planNode.put("product", planProduct);
                                ((ObjectNode)resource).replace("plan", (JsonNode)planNode);
                            }
                        }
                    }
                }
            }
            boolean msiEnabled = template.isEnableMSI();
            boolean uamiEnabled = template.isEnableUAMI();
            boolean osDiskSizeChanged = osDiskSize > 0;
            AzureAvailabilityType availabilityType = template.getAvailabilityType();
            String availabilitySet = availabilityType instanceof AvailabilitySet ? ((AvailabilitySet)availabilityType).getName() : null;
            String vmssName = availabilityType instanceof VirtualMachineScaleSet ? ((VirtualMachineScaleSet)availabilityType).getName() : null;
            boolean availabilitySetEnabled = availabilitySet != null;
            boolean availabilityZoneEnabled = availabilityType instanceof AvailabilityZone;
            boolean vmssEnabled = vmssName != null;
            boolean isSpecializedImage = false;
            if (template.getImageReference() != null) {
                isSpecializedImage = template.getImageReference().getGalleryImageSpecialized();
            }
            if (msiEnabled || uamiEnabled || osDiskSizeChanged || availabilitySetEnabled || isSpecializedImage || vmssEnabled || availabilityZoneEnabled) {
                resources = (ArrayNode)tmp.get("resources");
                for (JsonNode resource : resources) {
                    String zone;
                    JsonNode propertiesNode;
                    String type = resource.get("type").asText();
                    if (!type.contains("virtualMachine")) continue;
                    if (msiEnabled && uamiEnabled) {
                        uamiID = template.getUamiID();
                        identityNode = MAPPER.createObjectNode();
                        identityNode.put("type", "SystemAssigned, UserAssigned");
                        resourceId = MAPPER.createObjectNode();
                        resourceId.replace(uamiID, (JsonNode)MAPPER.createObjectNode());
                        identityNode.replace("userAssignedIdentities", (JsonNode)resourceId);
                        ((ObjectNode)resource).replace("identity", (JsonNode)identityNode);
                    } else if (msiEnabled) {
                        ObjectNode identityNode = MAPPER.createObjectNode();
                        identityNode.put("type", "systemAssigned");
                        ((ObjectNode)resource).replace("identity", (JsonNode)identityNode);
                    } else if (uamiEnabled) {
                        uamiID = template.getUamiID();
                        identityNode = MAPPER.createObjectNode();
                        identityNode.put("type", "UserAssigned");
                        resourceId = MAPPER.createObjectNode();
                        resourceId.replace(uamiID, (JsonNode)MAPPER.createObjectNode());
                        identityNode.replace("userAssignedIdentities", (JsonNode)resourceId);
                        ((ObjectNode)resource).replace("identity", (JsonNode)identityNode);
                    }
                    if (osDiskSizeChanged) {
                        JsonNode jsonNode = resource.get("properties").get("storageProfile").get("osDisk");
                        ((ObjectNode)jsonNode).replace("diskSizeGB", (JsonNode)new IntNode(osDiskSize));
                    }
                    if (availabilitySetEnabled) {
                        ObjectNode availabilitySetNode = MAPPER.createObjectNode();
                        availabilitySetNode.put("id", String.format("[resourceId('Microsoft.Compute/availabilitySets', '%s')]", availabilitySet));
                        propertiesNode = resource.get("properties");
                        ((ObjectNode)propertiesNode).replace("availabilitySet", (JsonNode)availabilitySetNode);
                    }
                    if (vmssEnabled) {
                        ObjectNode vmssNode = MAPPER.createObjectNode();
                        vmssNode.put("id", String.format("[resourceId('Microsoft.Compute/virtualMachineScaleSets', '%s')]", vmssName));
                        propertiesNode = resource.get("properties");
                        ((ObjectNode)propertiesNode).replace("virtualMachineScaleSet", (JsonNode)vmssNode);
                    }
                    if (availabilityZoneEnabled && StringUtils.isNotBlank((CharSequence)(zone = ((AvailabilityZone)availabilityType).getZone()))) {
                        if (zone.equals("AZURE_SELECTED")) {
                            ObjectNode placementNode = MAPPER.createObjectNode();
                            placementNode.put("zonePlacementPolicy", "Any");
                            ((ObjectNode)resource).replace("placement", (JsonNode)placementNode);
                        } else {
                            ArrayNode zonesNode = MAPPER.createArrayNode();
                            zonesNode.add(zone);
                            ((ObjectNode)resource).replace("zones", (JsonNode)zonesNode);
                        }
                    }
                    if (!isSpecializedImage) continue;
                    JsonNode propertiesNode2 = resource.get("properties");
                    ((ObjectNode)propertiesNode2).remove("osProfile");
                }
            }
            resources = (ArrayNode)tmp.get("resources");
            for (JsonNode resource : resources) {
                this.injectCustomTag(resource, tags);
            }
            AzureVMManagementServiceDelegate.copyVariableIfNotBlank(tmp, properties, "imageId");
            AzureVMManagementServiceDelegate.copyVariableIfNotBlank(tmp, properties, "imagePublisher");
            AzureVMManagementServiceDelegate.copyVariableIfNotBlank(tmp, properties, "imageOffer");
            AzureVMManagementServiceDelegate.copyVariableIfNotBlank(tmp, properties, "imageSku");
            AzureVMManagementServiceDelegate.copyVariableIfNotBlank(tmp, properties, "imageVersion");
            AzureVMManagementServiceDelegate.copyVariableIfNotBlank(tmp, properties, "osType");
            AzureVMManagementServiceDelegate.putVariable(tmp, "ephemeralOSDisk", Boolean.toString(ephemeralOSDisk));
            AzureVMManagementServiceDelegate.putVariable(tmp, "encryptionAtHost", Boolean.toString(encryptionAtHost));
            AzureVMManagementServiceDelegate.putVariableIfNotBlank(tmp, "image", template.getImageReference().getUri());
            String imageId = this.getImageId(properties);
            if (!isBasic && referenceType == ImageReferenceType.GALLERY) {
                String galleryImageVersionStr = template.getImageReference().getGalleryImageVersion();
                String galleryImageDefinition = template.getImageReference().getGalleryImageDefinition();
                String gallerySubscriptionId = template.getImageReference().getGallerySubscriptionId();
                String galleryResourceGroup = template.getImageReference().getGalleryResourceGroup();
                String galleryName = template.getImageReference().getGalleryName();
                if (StringUtils.isBlank((CharSequence)galleryImageVersionStr) || StringUtils.isBlank((CharSequence)galleryImageDefinition) || StringUtils.isBlank((CharSequence)galleryResourceGroup) || StringUtils.isBlank((CharSequence)galleryName)) {
                    throw AzureCloudException.create("One of gallery name, gallery image version, image definition and image resource group is blank.");
                }
                AzureResourceManager client = AzureResourceManagerCache.get((String)this.azureCredentialsId, (String)gallerySubscriptionId);
                if (client == null) {
                    AzureVMDeploymentInfo azureVMDeploymentInfo = null;
                    return azureVMDeploymentInfo;
                }
                GalleryImageVersion galleryImageVersion = "latest".equals(galleryImageVersionStr) ? this.getGalleryImageLatestVersion(galleryResourceGroup, galleryName, galleryImageDefinition, client) : client.galleryImageVersions().getByGalleryImage(galleryResourceGroup, galleryName, galleryImageDefinition, galleryImageVersionStr);
                if (galleryImageVersion == null) {
                    throw AzureCloudException.create("Can not find the right version for the gallery image.");
                }
                imageId = galleryImageVersion.id();
                LOGGER.log(Level.INFO, "Create VM with gallery image id {0}", new Object[]{imageId});
                AzureVMManagementServiceDelegate.putVariableIfNotBlank(tmp, "imageId", imageId);
                Map imageTags = galleryImageVersion.tags();
                if (imageTags != null) {
                    String planInfo = (String)imageTags.get("PlanInfo");
                    String planProduct = (String)imageTags.get("PlanProduct");
                    String planPublisher = (String)imageTags.get("PlanPublisher");
                    if (StringUtils.isNotBlank((CharSequence)planInfo) && StringUtils.isNotBlank((CharSequence)planProduct) && StringUtils.isNotBlank((CharSequence)planPublisher)) {
                        for (JsonNode resource : resources) {
                            String type = resource.get("type").asText();
                            if (!type.contains("virtualMachine")) continue;
                            ObjectNode planNode = MAPPER.createObjectNode();
                            planNode.put("name", planInfo);
                            planNode.put("publisher", planPublisher);
                            planNode.put("product", planProduct);
                            ((ObjectNode)resource).replace("plan", (JsonNode)planNode);
                        }
                    }
                }
            }
            if (imageId != null) {
                this.addTagToVm(tmp, "JenkinsImageId", imageId);
            }
            if (useCustomScriptExtension) {
                String rootUrl = Util.fixEmpty((String)Jenkins.get().getRootUrl());
                if (rootUrl == null) {
                    throw AzureCloudException.create("Jenkins URL must be set");
                }
                AzureVMManagementServiceDelegate.putVariable(tmp, "jenkinsServerURL", rootUrl);
                ArrayNode clientSecretsNode = ((ObjectNode)tmp.get("variables")).putArray("clientSecrets");
                for (int i = 0; i < numberOfAgents; ++i) {
                    clientSecretsNode.add(JnlpAgentReceiver.SLAVE_SECRET.mac(String.format("%s%d", vmBaseName, i)));
                }
                String scriptName = String.format("%s%s", deploymentName, "init.ps1");
                String initScript = preInstallSshInWindows ? AzureVMManagementServiceDelegate.loadScript(PRE_INSTALL_SSH_FILENAME) : (String)properties.get("initScript");
                scriptUri = this.uploadCustomScript(template, scriptName, initScript);
                AzureVMManagementServiceDelegate.putVariable(tmp, "startupScriptURI", scriptUri);
                AzureVMManagementServiceDelegate.putVariable(tmp, "startupScriptName", scriptName);
                if (template.isUseEntraIdForStorageAccount()) {
                    String uamiClientId = ((Identity)this.azureClient.identities().getById(template.getUamiID())).clientId();
                    for (JsonNode resource : resources) {
                        String type = resource.get("type").asText();
                        if (!type.contains("virtualMachine")) continue;
                        ArrayNode vmResources = (ArrayNode)resource.get("resources");
                        JsonNode scriptExtension = vmResources.get(0);
                        ObjectNode scriptExtensionProperties = (ObjectNode)scriptExtension.get("properties");
                        ObjectNode protectedSettings = (ObjectNode)scriptExtensionProperties.get("protectedSettings");
                        protectedSettings.remove("storageAccountName");
                        protectedSettings.remove("storageAccountKey");
                        ObjectNode clientId = MAPPER.createObjectNode();
                        clientId.put("clientId", uamiClientId);
                        protectedSettings.replace("managedIdentity", (JsonNode)clientId);
                    }
                    ObjectNode parameters = (ObjectNode)tmp.get("parameters");
                    parameters.remove("storageAccountKey");
                } else {
                    List storageKeys = ((StorageAccount)this.azureClient.storageAccounts().getByResourceGroup(template.getResourceGroupName(), storageAccountName)).getKeys();
                    if (storageKeys.isEmpty()) {
                        throw AzureCloudException.create("Exception occurred while fetching the storage account key");
                    }
                    String storageAccountKey = ((StorageAccountKey)storageKeys.get(0)).value();
                    ObjectNode storageAccountKeyNode = MAPPER.createObjectNode();
                    storageAccountKeyNode.put("type", "secureString");
                    storageAccountKeyNode.put("defaultValue", storageAccountKey);
                    ((ObjectNode)tmp.get("parameters")).replace("storageAccountKey", (JsonNode)storageAccountKeyNode);
                }
            }
            AzureVMManagementServiceDelegate.putVariable(tmp, "vmSize", template.getVirtualMachineSize());
            StandardUsernameCredentials creds = template.getVMCredentials();
            AzureVMManagementServiceDelegate.putVariableIfNotBlank(tmp, "storageAccountName", storageAccountName);
            AzureVMManagementServiceDelegate.putVariableIfNotBlank(tmp, "storageAccountType", storageAccountType);
            AzureVMManagementServiceDelegate.putVariableIfNotBlank(tmp, "blobEndpointSuffix", blobEndpointSuffix);
            if (StringUtils.isNotBlank((CharSequence)((String)properties.get("virtualNetworkName")))) {
                AzureVMManagementServiceDelegate.copyVariableIfNotBlank(tmp, properties, "virtualNetworkName");
                AzureVMManagementServiceDelegate.copyVariable(tmp, properties, "subnetName");
                if (StringUtils.isNotBlank((CharSequence)((String)properties.get("virtualNetworkResourceGroupName")))) {
                    AzureVMManagementServiceDelegate.copyVariable(tmp, properties, "virtualNetworkResourceGroupName");
                } else {
                    AzureVMManagementServiceDelegate.putVariable(tmp, "virtualNetworkResourceGroupName", resourceGroupName);
                }
            } else {
                this.addDefaultVNetResourceNode(tmp, resourceGroupName, tags);
            }
            if (template.isSpotInstance()) {
                this.addSpotInstance(tmp);
            }
            if (template.isTrustedLaunch()) {
                this.addTrustedLaunch(tmp);
            }
            if (!((Boolean)properties.get("usePrivateIP")).booleanValue()) {
                List<String> availabilityZones = new ArrayList<String>();
                if (availabilityType instanceof VirtualMachineScaleSet) {
                    String name = ((VirtualMachineScaleSet)availabilityType).getName();
                    availabilityZones = ((com.azure.resourcemanager.compute.models.VirtualMachineScaleSet)this.azureClient.virtualMachineScaleSets().getByResourceGroup(resourceGroupName, name)).availabilityZones().stream().map(ExpandableStringEnum::toString).collect(Collectors.toList());
                }
                this.addPublicIPResourceNode(tmp, tags, availabilityZones);
            }
            if (template.isAcceleratedNetworking()) {
                this.addAcceleratedNetworking(tmp);
            }
            if (StringUtils.isNotBlank((CharSequence)((String)properties.get("nsgName")))) {
                AzureVMManagementServiceDelegate.addNSGNode(tmp, (String)properties.get("nsgName"));
            }
            ObjectNode parameters = MAPPER.createObjectNode();
            AzureVMManagementServiceDelegate.defineParameter(tmp, "adminUsername", "string");
            AzureVMManagementServiceDelegate.putParameter(parameters, "adminUsername", creds.getUsername());
            AzureVMManagementServiceDelegate.defineParameter(tmp, "authenticationType", "string");
            AzureVMManagementServiceDelegate.defineParameter(tmp, "adminPasswordOrKey", "secureString");
            if (creds instanceof StandardUsernamePasswordCredentials) {
                StandardUsernamePasswordCredentials passwordCredentials = (StandardUsernamePasswordCredentials)creds;
                AzureVMManagementServiceDelegate.putParameter(parameters, "adminPasswordOrKey", passwordCredentials.getPassword().getPlainText());
                AzureVMManagementServiceDelegate.putParameter(parameters, "authenticationType", "password");
            } else {
                SSHUserPrivateKey sshCredentials = (SSHUserPrivateKey)creds;
                String privateKey = (String)sshCredentials.getPrivateKeys().get(0);
                String rsaPublicKey = KeyDecoder.getPublicKey(privateKey, Secret.toString((Secret)sshCredentials.getPassphrase()));
                AzureVMManagementServiceDelegate.putParameter(parameters, "adminPasswordOrKey", rsaPublicKey);
                AzureVMManagementServiceDelegate.putParameter(parameters, "authenticationType", "key");
            }
            if (template.getLicenseType() != null && !Constants.NO_LICENSE_TYPE.contains(template.getLicenseType())) {
                this.addLicenseType(tmp, template.getLicenseType());
            }
            deploymentRegistrar.registerDeployment(cloudName, template.getResourceGroupName(), deploymentName, scriptUri, template.isUseEntraIdForStorageAccount());
            String templateJson = tmp.toString();
            LOGGER.log(Level.FINE, templateJson);
            ((Deployment.DefinitionStages.WithTemplate)((Deployment.DefinitionStages.Blank)this.azureClient.deployments().define(deploymentName)).withExistingResourceGroup(template.getResourceGroupName())).withTemplate(templateJson).withParameters(parameters.toString()).withMode(DeploymentMode.INCREMENTAL).beginCreate();
            AzureVMDeploymentInfo azureVMDeploymentInfo = new AzureVMDeploymentInfo(deploymentName, vmBaseName, numberOfAgents);
            return azureVMDeploymentInfo;
        }
    }

    private String getImageId(Map<String, Object> properties) {
        Object imageId = properties.get("imageId");
        Object imagePublisherObj = properties.get("imagePublisher");
        if (imageId == null && imagePublisherObj == null) {
            return null;
        }
        if (imagePublisherObj != null) {
            Object imageOfferObj = properties.get("imageOffer");
            Object imageSkuObj = properties.get("imageSku");
            Object imageVersionObj = properties.get("imageVersion");
            imageId = String.valueOf(imagePublisherObj) + "::" + String.valueOf(imageOfferObj) + "::" + String.valueOf(imageSkuObj) + "::" + String.valueOf(imageVersionObj);
        }
        return (String)imageId;
    }

    private void addTagToVm(JsonNode template, String key, String value) {
        ArrayNode resources = (ArrayNode)template.get("resources");
        for (JsonNode resource : resources) {
            String type = resource.get("type").asText();
            if (!type.contains("virtualMachine")) continue;
            ObjectNode tags = (ObjectNode)resource.get("tags");
            tags.put(key, StringUtils.left((String)value, (int)255));
            return;
        }
    }

    private void addSpotInstance(JsonNode template) {
        ArrayNode resources = (ArrayNode)template.get("resources");
        for (JsonNode resource : resources) {
            String type = resource.get("type").asText();
            if (!type.contains("virtualMachine")) continue;
            ObjectNode properties = (ObjectNode)resource.get("properties");
            properties.put("priority", "Spot");
            properties.put("evictionPolicy", "Delete");
        }
    }

    private void addTrustedLaunch(JsonNode template) {
        ObjectNode parameterNode = (ObjectNode)template.get("parameters");
        ObjectNode securityTypeNode = MAPPER.createObjectNode();
        securityTypeNode.put("type", "string");
        securityTypeNode.put("defaultValue", "TrustedLaunch");
        ArrayNode allowedValuesNode = MAPPER.createArrayNode();
        allowedValuesNode.add("Standard");
        allowedValuesNode.add("TrustedLaunch");
        securityTypeNode.set("allowedValues", (JsonNode)allowedValuesNode);
        ObjectNode metaDataNode = MAPPER.createObjectNode();
        metaDataNode.put("description", "Security Type of the Virtual Machine.");
        securityTypeNode.set("metadata", (JsonNode)metaDataNode);
        parameterNode.set("securityType", (JsonNode)securityTypeNode);
        ObjectNode variableNode = (ObjectNode)template.get("variables");
        ObjectNode profileNode = MAPPER.createObjectNode();
        ObjectNode settingsNode = MAPPER.createObjectNode();
        settingsNode.put("secureBootEnabled", true);
        settingsNode.put("vTpmEnabled", true);
        profileNode.set("uefiSettings", (JsonNode)settingsNode);
        profileNode.put("securityType", "[parameters('securityType')]");
        variableNode.set("securityProfileJson", (JsonNode)profileNode);
        ArrayNode resources = (ArrayNode)template.get("resources");
        for (JsonNode resource : resources) {
            String type = resource.get("type").asText();
            if (!type.contains("virtualMachine")) continue;
            ObjectNode properties = (ObjectNode)resource.get("properties");
            properties.put("securityProfile", "[if(equals(parameters('securityType'), 'TrustedLaunch'), variables('securityProfileJson'), null())]");
        }
    }

    private void addAcceleratedNetworking(JsonNode template) {
        ArrayNode resources = (ArrayNode)template.get("resources");
        for (JsonNode resource : resources) {
            String type = resource.get("type").asText();
            if (!type.contains("networkInterfaces")) continue;
            ObjectNode properties = (ObjectNode)resource.get("properties");
            properties.put("enableAcceleratedNetworking", "true");
        }
    }

    private void addLicenseType(JsonNode template, String licenseType) {
        ArrayNode resources = (ArrayNode)template.get("resources");
        for (JsonNode resource : resources) {
            String type = resource.get("type").asText();
            if (!type.contains("virtualMachine")) continue;
            ObjectNode properties = (ObjectNode)resource.get("properties");
            properties.put("licenseType", licenseType);
            return;
        }
    }

    private void injectCustomTag(JsonNode resource, List<AzureTagPair> tags) {
        ObjectNode tagsNode = (ObjectNode)resource.get("tags");
        if (tags != null) {
            for (AzureTagPair tag : tags) {
                tagsNode.put(tag.getName(), tag.getValue());
            }
        }
    }

    private boolean checkImageParameter(AzureVMAgentTemplate template) {
        if (StringUtils.isBlank((CharSequence)template.getImageReference().getPublisher()) || StringUtils.isBlank((CharSequence)template.getImageReference().getOffer()) || StringUtils.isBlank((CharSequence)template.getImageReference().getSku())) {
            LOGGER.log(Level.SEVERE, "Missing Image Reference information when trying to add purchase plan to ARM template");
            return false;
        }
        return true;
    }

    private GalleryImageVersion getGalleryImageLatestVersion(String galleryResourceGroup, String galleryName, String galleryImageDefinition, AzureResourceManager client) throws AzureCloudException {
        PagedIterable galleryImageVersions = client.galleryImageVersions().listByGalleryImage(galleryResourceGroup, galleryName, galleryImageDefinition);
        GalleryImageVersion latestVersion = null;
        for (GalleryImageVersion galleryImageVersion : galleryImageVersions) {
            if (latestVersion == null) {
                latestVersion = galleryImageVersion;
                continue;
            }
            OffsetDateTime currentPublishedDate = latestVersion.publishingProfile().publishedDate();
            if (galleryImageVersion.publishingProfile().publishedDate().compareTo(currentPublishedDate) <= 0) continue;
            latestVersion = galleryImageVersion;
        }
        return latestVersion;
    }

    private static void putVariable(JsonNode template, String name, String value) {
        ((ObjectNode)template.get("variables")).put(name, value);
    }

    private static void putParameter(ObjectNode template, String name, String value) {
        ObjectNode objectNode = MAPPER.createObjectNode();
        objectNode.put("value", value);
        template.set(name, (JsonNode)objectNode);
    }

    private static void defineParameter(JsonNode template, String name, String value) {
        ObjectNode objectNode = MAPPER.createObjectNode();
        objectNode.put("type", value);
        ((ObjectNode)template.get("parameters")).set(name, (JsonNode)objectNode);
    }

    private static void putVariableIfNotBlank(JsonNode template, String name, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            AzureVMManagementServiceDelegate.putVariable(template, name, value);
        }
    }

    private static void copyVariable(JsonNode template, Map<String, Object> properties, String name) {
        AzureVMManagementServiceDelegate.putVariable(template, name, (String)properties.get(name));
    }

    private static void copyVariableIfNotBlank(JsonNode template, Map<String, Object> properties, String name) {
        AzureVMManagementServiceDelegate.putVariableIfNotBlank(template, name, (String)properties.get(name));
    }

    private void addPublicIPResourceNode(JsonNode template, List<AzureTagPair> tags, List<String> availabilityZones) throws IOException {
        block10: {
            String ipName = "variables('vmName'), copyIndex(), 'IPName'";
            try (InputStream fragmentStream = AzureVMManagementServiceDelegate.class.getResourceAsStream(PUBLIC_IP_FRAGMENT_FILENAME);){
                ObjectNode publicIPFragment = (ObjectNode)MAPPER.readTree(fragmentStream);
                if (!availabilityZones.isEmpty()) {
                    ArrayNode zones = MAPPER.createArrayNode();
                    for (String zone : availabilityZones) {
                        zones.add(zone);
                    }
                    publicIPFragment.set("zones", (JsonNode)zones);
                }
                this.injectCustomTag((JsonNode)publicIPFragment, tags);
                ((ArrayNode)template.get("resources")).add((JsonNode)publicIPFragment);
                ArrayNode resourcesNodes = (ArrayNode)template.get("resources");
                Iterator resourcesNodesIter = resourcesNodes.elements();
                while (resourcesNodesIter.hasNext()) {
                    JsonNode resourcesNode = (JsonNode)resourcesNodesIter.next();
                    JsonNode typeNode = resourcesNode.get("type");
                    if (typeNode == null || !typeNode.asText().equals("Microsoft.Network/networkInterfaces")) continue;
                    ArrayNode dependsOnNode = (ArrayNode)resourcesNode.get("dependsOn");
                    dependsOnNode.add("[concat('Microsoft.Network/publicIPAddresses/',variables('vmName'), copyIndex(), 'IPName')]");
                    ArrayNode ipConfigurationsNode = (ArrayNode)resourcesNode.get("properties").get("ipConfigurations");
                    Iterator ipConfigNodeIter = ipConfigurationsNode.elements();
                    while (ipConfigNodeIter.hasNext()) {
                        JsonNode ipConfigNode = (JsonNode)ipConfigNodeIter.next();
                        JsonNode nameNode = ipConfigNode.get("name");
                        if (nameNode == null || !nameNode.asText().equals("ipconfig1")) continue;
                        ObjectNode propertiesNode = (ObjectNode)ipConfigNode.get("properties");
                        ObjectNode publicIPIdNode = MAPPER.createObjectNode();
                        publicIPIdNode.put("id", "[resourceId('Microsoft.Network/publicIPAddresses', concat(variables('vmName'), copyIndex(), 'IPName'))]");
                        ObjectNode ipAddressPropertiesNode = MAPPER.createObjectNode();
                        ipAddressPropertiesNode.put("deleteOption", "Delete");
                        publicIPIdNode.set("properties", (JsonNode)ipAddressPropertiesNode);
                        propertiesNode.set("publicIPAddress", (JsonNode)publicIPIdNode);
                        break block10;
                    }
                    break;
                }
            }
        }
    }

    private static void addNSGNode(JsonNode template, String nsgName) {
        ((ObjectNode)template.get("variables")).put("nsgName", nsgName);
        ArrayNode resourcesNodes = (ArrayNode)template.get("resources");
        Iterator resourcesNodesIter = resourcesNodes.elements();
        while (resourcesNodesIter.hasNext()) {
            JsonNode resourcesNode = (JsonNode)resourcesNodesIter.next();
            JsonNode typeNode = resourcesNode.get("type");
            if (typeNode == null || !typeNode.asText().equals("Microsoft.Network/networkInterfaces")) continue;
            ObjectNode nsgNode = MAPPER.createObjectNode();
            nsgNode.put("id", "[resourceId('Microsoft.Network/networkSecurityGroups', variables('nsgName'))]");
            ObjectNode propertiesNode = (ObjectNode)resourcesNode.get("properties");
            propertiesNode.set("networkSecurityGroup", (JsonNode)nsgNode);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDefaultVNetResourceNode(JsonNode template, String resourceGroupName, List<AzureTagPair> tags) throws IOException {
        try (InputStream fragmentStream = null;){
            String virtualNetworkName = "jenkinsarm-vnet";
            String subnetName = "jenkinsarm-snet";
            ((ObjectNode)template.get("variables")).put("virtualNetworkName", "jenkinsarm-vnet");
            ((ObjectNode)template.get("variables")).put("virtualNetworkResourceGroupName", resourceGroupName);
            ((ObjectNode)template.get("variables")).put("subnetName", "jenkinsarm-snet");
            fragmentStream = AzureVMManagementServiceDelegate.class.getResourceAsStream(VIRTUAL_NETWORK_TEMPLATE_FRAGMENT_FILENAME);
            JsonNode virtualNetworkFragment = MAPPER.readTree(fragmentStream);
            this.injectCustomTag(virtualNetworkFragment, tags);
            ((ArrayNode)template.get("resources")).add(virtualNetworkFragment);
            ArrayNode resourcesNodes = (ArrayNode)template.get("resources");
            Iterator resourcesNodesIter = resourcesNodes.elements();
            while (resourcesNodesIter.hasNext()) {
                JsonNode resourcesNode = (JsonNode)resourcesNodesIter.next();
                JsonNode typeNode = resourcesNode.get("type");
                if (typeNode == null || !typeNode.asText().equals("Microsoft.Network/networkInterfaces")) continue;
                ArrayNode dependsOnNode = (ArrayNode)resourcesNode.get("dependsOn");
                dependsOnNode.add("[concat('Microsoft.Network/virtualNetworks/', variables('virtualNetworkName'))]");
                break;
            }
        }
    }

    public String uploadCustomScript(AzureVMAgentTemplate template, String targetScriptName, String initScript) throws AzureCloudException {
        String localInitScript = initScript != null ? initScript : "";
        String targetStorageAccount = template.getStorageAccountName();
        String targetStorageAccountType = template.getStorageAccountType();
        String resourceGroupName = template.getResourceGroupName();
        String resourceGroupReferenceType = template.getResourceGroupReferenceType();
        String location = template.getLocation();
        List<AzureTagPair> tags = AzureVMManagementServiceDelegate.concat(template.retrieveAzureCloudReference().getCloudTags(), template.getTags());
        try {
            if ("new".equals(resourceGroupReferenceType)) {
                AzureVMCloud azureVMCloud = template.retrieveAzureCloudReference();
                this.createAzureResourceGroup(this.azureClient, location, resourceGroupName, azureVMCloud.getCloudName());
            }
            this.createStorageAccount(this.azureClient, targetStorageAccountType, targetStorageAccount, location, resourceGroupName, template.getTemplateName(), tags);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Got exception when checking the storage account for custom scripts", e);
        }
        int scriptLength = 0;
        try {
            BlobContainerClient container = this.getCloudBlobContainer(this.azureClient, resourceGroupName, targetStorageAccount, "jenkinsconfig", template.retrieveAzureCloudReference().getAzureCredentialsId(), template.isUseEntraIdForStorageAccount());
            BlobClient blob = container.getBlobClient(targetScriptName);
            scriptLength = localInitScript.getBytes(StandardCharsets.UTF_8).length;
            blob.upload(BinaryData.fromString((String)localInitScript).toStream(), (long)scriptLength, true);
            return blob.getBlobUrl();
        }
        catch (Exception e) {
            throw AzureCloudException.create(String.format("Failed to create Page Blob with script's length: %d", scriptLength), e);
        }
    }

    public String uploadCustomScript(AzureVMAgentTemplate template, String targetScriptName) throws AzureCloudException {
        return this.uploadCustomScript(template, targetScriptName, template.getInitScript());
    }

    public void setVirtualMachineDetails(AzureVMAgent azureAgent, AzureVMAgentTemplate template) throws AzureCloudException {
        String fqdn;
        VirtualMachine vm = (VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(template.getResourceGroupName(), azureAgent.getNodeName());
        PublicIpAddress publicIP = vm.getPrimaryPublicIPAddress();
        String publicIPStr = "";
        String privateIP = vm.getPrimaryNetworkInterface().primaryPrivateIP();
        if (publicIP == null || template.getUsePrivateIP()) {
            fqdn = privateIP;
            LOGGER.log(Level.INFO, "The Azure agent doesn't have a public IP or usePrivateIP is set. Will use the private IP");
        } else {
            fqdn = publicIP.fqdn();
            publicIPStr = publicIP.ipAddress();
        }
        azureAgent.setPublicDNSName(fqdn);
        azureAgent.setSshPort(22);
        azureAgent.setPublicIP(publicIPStr);
        azureAgent.setPrivateIP(privateIP);
        LOGGER.log(Level.FINE, "Azure agent details:\nnodeName={0}\nadminUserName={1}\nshutdownOnIdle={2}\nretentionTimeInMin={3}\nlabels={4}", new Object[]{azureAgent.getNodeName(), azureAgent.getVMCredentialsId(), azureAgent.isShutdownOnIdle(), azureAgent.getRetentionTimeInMin(), azureAgent.getLabelString()});
    }

    public void attachPublicIP(AzureVMAgent azureAgent, AzureVMAgentTemplate template) throws AzureCloudException {
        VirtualMachine vm;
        try {
            vm = (VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(template.getResourceGroupName(), azureAgent.getNodeName());
        }
        catch (Exception e) {
            throw AzureCloudException.create(e);
        }
        LOGGER.log(Level.INFO, "Trying to attach a public IP to the agent {0}", azureAgent.getNodeName());
        if (vm != null) {
            if (vm.getPrimaryPublicIPAddress() == null) {
                try {
                    ((NetworkInterface.Update)vm.getPrimaryNetworkInterface().update()).withNewPrimaryPublicIPAddress((Creatable)((PublicIpAddress.DefinitionStages.WithCreate)((PublicIpAddress.DefinitionStages.WithGroup)((PublicIpAddress.DefinitionStages.Blank)this.azureClient.publicIpAddresses().define(azureAgent.getNodeName() + "IPName")).withRegion(template.getLocation())).withExistingResourceGroup(template.getResourceGroupName())).withLeafDomainLabel(azureAgent.getNodeName())).apply();
                }
                catch (Exception e) {
                    throw AzureCloudException.create(e);
                }
                this.setVirtualMachineDetails(azureAgent, template);
            } else {
                LOGGER.log(Level.INFO, "Agent {0} already has a public IP", azureAgent.getNodeName());
            }
        } else {
            LOGGER.log(Level.WARNING, "Could not find agent {0} in Azure", azureAgent.getNodeName());
        }
    }

    private boolean virtualMachineExists(String vmName, String resourceGroupName) throws AzureCloudException {
        LOGGER.log(Level.INFO, "Checking VM exists for {0}", vmName);
        try {
            this.azureClient.virtualMachines().getByResourceGroup(resourceGroupName, vmName);
        }
        catch (ManagementException e) {
            if (e.getResponse().getStatusCode() == 404) {
                LOGGER.log(Level.INFO, "{0} doesn't exist", vmName);
                return false;
            }
            throw e;
        }
        catch (Exception e) {
            throw AzureCloudException.create(e);
        }
        LOGGER.log(Level.FINE, "{0} exists", vmName);
        return true;
    }

    public static boolean virtualMachineExists(AzureVMAgent agent) {
        try {
            AzureVMManagementServiceDelegate delegate = agent.getServiceDelegate();
            if (delegate != null) {
                return delegate.virtualMachineExists(agent.getNodeName(), agent.getResourceGroupName());
            }
            return false;
        }
        catch (AzureCloudException e) {
            LOGGER.log(Level.WARNING, "Error while determining whether vm exists", e);
            return false;
        }
    }

    public AzureVMAgent parseResponse(ProvisioningActivity.Id id, String vmname, String deploymentName, AzureVMAgentTemplate template, OperatingSystemTypes osType) throws AzureCloudException {
        try {
            LOGGER.log(Level.INFO, "Deployment response: \n\tfound agent {0}\n\tOS type {1}\n\tnumber of executors {2}", new Object[]{vmname, osType, template.getNoOfParallelJobs()});
            AzureVMCloud azureCloud = template.retrieveAzureCloudReference();
            Map<String, Object> properties = AzureVMAgentTemplate.getTemplateProperties(template);
            VirtualMachine vm = (VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(template.getResourceGroupName(), vmname);
            PublicIpAddress publicIP = vm.getPrimaryPublicIPAddress();
            String privateIP = vm.getPrimaryNetworkInterface().primaryPrivateIP();
            String fqdn = publicIP == null ? privateIP : publicIP.fqdn();
            return new AzureVMAgent(id, vmname, template.getTemplateName(), template.getTemplateDesc(), osType, Util.fixNull((String)template.getAgentWorkspace()), (Integer)properties.get("noOfParallelJobs"), template.getUsageMode(), template.getLabels(), template.retrieveAzureCloudReference().getDisplayName(), template.getCredentialsId(), null, null, template.getAdvancedImageInside().getSshConfig(), (String)properties.get("jvmOptions"), template.isShutdownOnIdle(), false, deploymentName, (RetentionStrategy<AzureVMComputer>)template.getRetentionStrategy(), (String)properties.get("initScript"), (String)properties.get("terminateScript"), azureCloud.getAzureCredentialsId(), (String)properties.get("agentLaunchMethod"), CleanUpAction.DEFAULT, null, template.getResourceGroupName(), (Boolean)properties.get("executeInitScriptAsRoot"), (Boolean)properties.get("doNotUseMachineIfInitFails"), (Boolean)properties.get("enableMSI"), (Boolean)properties.get("enableUAMI"), (Boolean)properties.get("ephemeralOSDisk"), (Boolean)properties.get("encryptionAtHost"), (String)properties.get("uamiID"), template, fqdn, template.getJavaPath(), template.getRemotingOptions());
        }
        catch (Descriptor.FormException | IOException e) {
            throw AzureCloudException.create("Exception occurred while creating agent object", (Exception)e);
        }
    }

    private static Set<String> getAvailableLocationsStandard() {
        HashSet<String> locations = new HashSet<String>();
        locations.add("UK South");
        locations.add("UK West");
        locations.add("East US");
        locations.add("West US");
        locations.add("South Central US");
        locations.add("Central US");
        locations.add("North Central US");
        locations.add("North Europe");
        locations.add("West Europe");
        locations.add("Southeast Asia");
        locations.add("East Asia");
        locations.add("Japan West");
        locations.add("Japan East");
        locations.add("Brazil South");
        locations.add("Australia Southeast");
        locations.add("Australia East");
        locations.add("Central India");
        locations.add("South India");
        locations.add("West India");
        return locations;
    }

    private static Set<String> getAvailableLocationsChina() {
        HashSet<String> locations = new HashSet<String>();
        locations.add("China North");
        locations.add("China East");
        return locations;
    }

    private static Map<String, List<String>> getAvailableRoleSizes() {
        HashMap<String, List<String>> sizes = new HashMap<String, List<String>>();
        sizes.put("East US", Arrays.asList("A10", "A11", "A5", "A6", "A7", "A8", "A9", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("West US", Arrays.asList("A10", "A11", "A5", "A6", "A7", "A8", "A9", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s", "Standard_G1", "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3", "Standard_GS4", "Standard_GS5"));
        sizes.put("South Central US", Arrays.asList("A10", "A11", "A5", "A6", "A7", "A8", "A9", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("Central US", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("North Central US", Arrays.asList("A10", "A11", "A5", "A6", "A7", "A8", "A9", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1_v2", "Standard_DS11_v2", "Standard_DS12_v2", "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("East US 2", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s", "Standard_G1", "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3", "Standard_GS4", "Standard_GS5"));
        sizes.put("North Europe", Arrays.asList("A10", "A11", "A5", "A6", "A7", "A8", "A9", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("West Europe", Arrays.asList("A10", "A11", "A5", "A6", "A7", "A8", "A9", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s", "Standard_G1", "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3", "Standard_GS4", "Standard_GS5"));
        sizes.put("Southeast Asia", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s", "Standard_G1", "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3", "Standard_GS4", "Standard_GS5"));
        sizes.put("East Asia", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS11", "Standard_DS12", "Standard_DS13", "Standard_DS14", "Standard_DS2", "Standard_DS3", "Standard_DS4", "Standard_F1", "Standard_F16", "Standard_F2", "Standard_F4", "Standard_F8"));
        sizes.put("Japan West", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("Japan East", Arrays.asList("A10", "A11", "A5", "A6", "A7", "A8", "A9", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("Brazil South", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1_v2", "Standard_DS11_v2", "Standard_DS12_v2", "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("Australia Southeast", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("Australia East", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s", "Standard_G1", "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3", "Standard_GS4", "Standard_GS5"));
        sizes.put("Central India", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1_v2", "Standard_D11_v2", "Standard_D12_v2", "Standard_D13_v2", "Standard_D14_v2", "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1_v2", "Standard_DS11_v2", "Standard_DS12_v2", "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("South India", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1_v2", "Standard_D11_v2", "Standard_D12_v2", "Standard_D13_v2", "Standard_D14_v2", "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1_v2", "Standard_DS11_v2", "Standard_DS12_v2", "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s"));
        sizes.put("West India", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1_v2", "Standard_D11_v2", "Standard_D12_v2", "Standard_D13_v2", "Standard_D14_v2", "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2", "Standard_F1", "Standard_F16", "Standard_F2", "Standard_F4", "Standard_F8"));
        sizes.put("China North", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS1_v2", "Standard_DS11", "Standard_DS11_v2", "Standard_DS12", "Standard_DS12_v2", "Standard_DS13", "Standard_DS13_v2", "Standard_DS14", "Standard_DS14_v2", "Standard_DS2", "Standard_DS2_v2", "Standard_DS3", "Standard_DS3_v2", "Standard_DS4", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_F1", "Standard_F16", "Standard_F16s", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F4", "Standard_F4s", "Standard_F8", "Standard_F8s", "Standard_G1", "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3", "Standard_GS4", "Standard_GS5"));
        sizes.put("China East", Arrays.asList("A5", "A6", "A7", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A4", "Standard_A0", "Standard_A3", "Standard_A2", "Standard_A1", "Standard_D1", "Standard_D1_v2", "Standard_D11", "Standard_D11_v2", "Standard_D12", "Standard_D12_v2", "Standard_D13", "Standard_D13_v2", "Standard_D14", "Standard_D14_v2", "Standard_D2", "Standard_D2_v2", "Standard_D3", "Standard_D3_v2", "Standard_D4", "Standard_D4_v2", "Standard_D5_v2", "Standard_DS1", "Standard_DS11", "Standard_DS12", "Standard_DS13", "Standard_DS14", "Standard_DS2", "Standard_DS3", "Standard_DS4", "Standard_F1", "Standard_F16", "Standard_F2", "Standard_F4", "Standard_F8"));
        return sizes;
    }

    private static Map<String, Map<String, String>> getDefaultImageProperties() {
        HashMap<String, Map<String, String>> imageProperties = new HashMap<String, Map<String, String>>();
        imageProperties.put("Windows Server 2016", AzureVMManagementServiceDelegate.imageProperties("MicrosoftWindowsServer", "WindowsServer", "2016-Datacenter", "2016-Datacenter-with-Containers", "Windows"));
        imageProperties.put("Windows Server 2019", AzureVMManagementServiceDelegate.imageProperties("MicrosoftWindowsServer", "WindowsServer", "2019-Datacenter", "2019-Datacenter-with-Containers", "Windows"));
        imageProperties.put("Windows Server 2022", AzureVMManagementServiceDelegate.imageProperties("MicrosoftWindowsServer", "WindowsServer", "2022-datacenter-azure-edition-core", "2022-datacenter-azure-edition-core", "Windows"));
        imageProperties.put("Windows Server 2025", AzureVMManagementServiceDelegate.imageProperties("MicrosoftWindowsServer", "WindowsServer", "2025-datacenter-azure-edition-core", "2025-datacenter-azure-edition-core", "Windows"));
        imageProperties.put("Ubuntu 20.04 LTS", AzureVMManagementServiceDelegate.imageProperties("canonical", "0001-com-ubuntu-server-focal", "20_04-lts-gen2", "20_04-lts-gen2", "Linux"));
        imageProperties.put("Ubuntu 22.04 LTS", AzureVMManagementServiceDelegate.imageProperties("canonical", "0001-com-ubuntu-server-jammy", "22_04-lts-gen2", "22_04-lts-gen2", "Linux"));
        imageProperties.put("Ubuntu 24.04 LTS", AzureVMManagementServiceDelegate.imageProperties("canonical", "ubuntu-24_04-lts", "server", "server", "Linux"));
        return imageProperties;
    }

    private static Map<String, String> imageProperties(String defaultImagePublisher, String offer, String sku, String dockerImageSku, String osType) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("defaultImagePublisher", defaultImagePublisher);
        properties.put("defaultImageOffer", offer);
        properties.put("defaultImageSku", sku);
        properties.put("defaultDockerImageSku", dockerImageSku);
        properties.put("defaultImageVersion", "latest");
        properties.put("defaultOsType", osType);
        properties.put("defaultLaunchMethod", "SSH");
        return properties;
    }

    private static Map<String, Map<String, String>> getPreInstalledToolsScript() {
        HashMap<String, Map<String, String>> tools = new HashMap<String, Map<String, String>>();
        tools.put("Windows Server 2016", new HashMap());
        tools.put("Windows Server 2019", new HashMap());
        tools.put("Windows Server 2022", new HashMap());
        tools.put("Windows Server 2025", new HashMap());
        tools.put("Ubuntu 20.04 LTS", new HashMap());
        tools.put("Ubuntu 22.04 LTS", new HashMap());
        tools.put("Ubuntu 24.04 LTS", new HashMap());
        try {
            AzureVMManagementServiceDelegate.windows("Windows Server 2016", tools);
            AzureVMManagementServiceDelegate.windows("Windows Server 2019", tools);
            AzureVMManagementServiceDelegate.windows("Windows Server 2022", tools);
            AzureVMManagementServiceDelegate.windows("Windows Server 2025", tools);
            AzureVMManagementServiceDelegate.ubuntu("Ubuntu 20.04 LTS", tools);
            AzureVMManagementServiceDelegate.ubuntu("Ubuntu 22.04 LTS", tools);
            AzureVMManagementServiceDelegate.ubuntu("Ubuntu 24.04 LTS", tools);
            return tools;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Get pre-installed tools script {0} failed.", e);
            return tools;
        }
    }

    private static void ubuntu(String imageName, Map<String, Map<String, String>> tools) throws IOException {
        tools.get(imageName).put("Java", AzureVMManagementServiceDelegate.loadScript(INSTALL_JAVA_UBUNTU_FILENAME));
        tools.get(imageName).put("Maven", AzureVMManagementServiceDelegate.loadScript(INSTALL_MAVEN_UBUNTU_FILENAME));
        tools.get(imageName).put("QEMU", AzureVMManagementServiceDelegate.loadScript(INSTALL_QEMU_UBUNTU_FILENAME));
        tools.get(imageName).put("Git", AzureVMManagementServiceDelegate.loadScript(INSTALL_GIT_UBUNTU_FILENAME));
        tools.get(imageName).put("Docker", AzureVMManagementServiceDelegate.loadScript(INSTALL_DOCKER_UBUNTU_FILENAME));
    }

    private static void windows(String imageName, Map<String, Map<String, String>> tools) throws IOException {
        tools.get(imageName).put("Java", AzureVMManagementServiceDelegate.loadScript(INSTALL_JAVA_WINDOWS_FILENAME));
        tools.get(imageName).put("Maven", AzureVMManagementServiceDelegate.loadScript(INSTALL_MAVEN_WINDOWS_FILENAME));
        tools.get(imageName).put("QEMU", AzureVMManagementServiceDelegate.loadScript(INSTALL_QEMU_WINDOWS_FILENAME));
        tools.get(imageName).put("Git", AzureVMManagementServiceDelegate.loadScript(INSTALL_GIT_WINDOWS_FILENAME));
        tools.get(imageName).put("Jnlp", AzureVMManagementServiceDelegate.loadScript(INSTALL_JNLP_WINDOWS_FILENAME));
    }

    public Set<String> getVirtualMachineLocations(String envNameOrUrl) {
        if (envNameOrUrl == null) {
            return null;
        }
        envNameOrUrl = envNameOrUrl.toLowerCase();
        try {
            return LocationCache.getLocation(this.azureClient, envNameOrUrl);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error while fetching the regions {0}. Will return default list ", e);
            if (envNameOrUrl.contains("china")) {
                return AVAILABLE_LOCATIONS_CHINA;
            }
            return AVAILABLE_LOCATIONS_STD;
        }
    }

    public Set<String> getVMSizes(String location) {
        if (location == null || location.isEmpty()) {
            return new TreeSet<String>(DEFAULT_VM_SIZES);
        }
        return (Set)vmSizesByLocation.get((Object)location, location1 -> {
            try {
                TreeSet<String> ret = new TreeSet<String>();
                for (VirtualMachineSize vmSize : this.azureClient.virtualMachines().sizes().listByRegion(location1)) {
                    ret.add(vmSize.name());
                }
                return ret;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error while fetching the VM sizes {0}. Will return default list", e);
                return new TreeSet(AVAILABLE_ROLE_SIZES.get(location1));
            }
        });
    }

    public String verifyConfiguration(String resourceGroupName, boolean existingResourceGroup, String timeOut) {
        try {
            if (!AzureUtil.isValidTimeOut(timeOut)) {
                return "Invalid Timeout, Should be a positive number, minimum value 1200";
            }
            if (!existingResourceGroup && !AzureUtil.isValidResourceGroupName(resourceGroupName)) {
                return "Error: " + Messages.Azure_GC_Template_ResourceGroupName_Err();
            }
            if (!AzureUtil.isValidTimeOut(timeOut)) {
                return Messages.Azure_GC_Template_Val_Profile_Err();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error validating profile", e);
            return Messages.Azure_GC_Template_Val_Profile_Err();
        }
        return "Success";
    }

    private VMStatus getVirtualMachineStatus(String vmName, String resourceGroupName) throws AzureCloudException {
        VirtualMachine vm;
        try {
            vm = (VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(resourceGroupName, vmName);
        }
        catch (Exception e) {
            throw AzureCloudException.create(e);
        }
        String provisioningState = vm.provisioningState();
        if (!provisioningState.equalsIgnoreCase("succeeded")) {
            if (provisioningState.equalsIgnoreCase("updating")) {
                return VMStatus.UPDATING;
            }
            return VMStatus.PROVISIONING_OR_DEPROVISIONING;
        }
        return VMStatus.fromPowerState(vm.powerState());
    }

    public boolean isVMAliveOrHealthy(AzureVMAgent agent) throws AzureCloudException {
        VMStatus status = this.getVirtualMachineStatus(agent.getNodeName(), agent.getResourceGroupName());
        int maxRetryCount = 120;
        for (int currentRetryCount = 0; status.equals((Object)VMStatus.UPDATING) && currentRetryCount < 120; ++currentRetryCount) {
            status = this.getVirtualMachineStatus(agent.getNodeName(), agent.getResourceGroupName());
            LOGGER.log(Level.FINE, "Status is Updating, wait for another 10 seconds");
            int sleepInMills = 10000;
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LOGGER.log(Level.FINE, "Status {0}", status.toString());
        return !VMStatus.PROVISIONING_OR_DEPROVISIONING.equals((Object)status) && !VMStatus.UPDATING.equals((Object)status) && !VMStatus.DEALLOCATING.equals((Object)status) && !VMStatus.STOPPED.equals((Object)status) && !VMStatus.DEALLOCATED.equals((Object)status);
    }

    public int getVirtualMachineCount(String cloudName, String resourceGroupName) {
        Map<String, Integer> countsByTemplate = this.getVirtualMachineCountsByTemplate(cloudName, resourceGroupName);
        int count = 0;
        for (Integer countForTemplate : countsByTemplate.values()) {
            count += countForTemplate.intValue();
        }
        return count;
    }

    @Restricted(value={NoExternalUse.class})
    Map<String, Integer> getVirtualMachineCountsByTemplate(String cloudName, String resourceGroupName) {
        TreeMap<String, Integer> result = new TreeMap<String, Integer>();
        try {
            PagedIterable vms = this.azureClient.virtualMachines().listByResourceGroup(resourceGroupName);
            AzureUtil.DeploymentTag deployTag = new AzureUtil.DeploymentTag();
            for (VirtualMachine vm : vms) {
                Map tags = vm.tags();
                String resourcesTag = tags.getOrDefault("JenkinsResourceTag", null);
                String cloudTag = tags.getOrDefault("JenkinsCloudTag", null);
                String templateTag = tags.getOrDefault("JenkinsTemplateTag", null);
                if (resourcesTag == null || cloudTag == null || !deployTag.isFromSameInstance(new AzureUtil.DeploymentTag(resourcesTag)) || !cloudTag.equals(cloudName)) continue;
                String templateThisVmBelongsTo = templateTag == null ? "" : templateTag;
                Integer existingCountForThisTemplate = (Integer)result.get(templateThisVmBelongsTo);
                Integer newCountForThisTemplate = existingCountForThisTemplate == null ? 1 : existingCountForThisTemplate + 1;
                result.put(templateThisVmBelongsTo, newCountForThisTemplate);
            }
        }
        catch (ManagementException e) {
            if (e.getResponse().getStatusCode() != 404) {
                throw e;
            }
            LOGGER.log(Level.SEVERE, "Failed to retrieve count of virtual machines from cloud '" + cloudName + "' resourceGroup '" + resourceGroupName + "'.", e);
            return Collections.emptyMap();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to retrieve count of virtual machines from cloud '" + cloudName + "' resourceGroup '" + resourceGroupName + "'.", e);
            return Collections.emptyMap();
        }
        return result;
    }

    public void shutdownVirtualMachine(AzureVMAgent agent) {
        LOGGER.log(Level.INFO, "shutdown called for {0}", agent.getNodeName());
        try {
            ((VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(agent.getResourceGroupName(), agent.getNodeName())).deallocate();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not terminate or shutdown " + agent.getNodeName(), e);
        }
    }

    public static void terminateVirtualMachine(AzureVMAgent agent) throws AzureCloudException {
        AzureVMManagementServiceDelegate delegate = agent.getServiceDelegate();
        if (delegate != null) {
            delegate.terminateVirtualMachine(agent.getNodeName(), agent.getResourceGroupName(), agent.getTemplate().isUseEntraIdForStorageAccount());
        }
    }

    public void terminateVirtualMachine(String vmName, String resourceGroupName, boolean isUseEntraIdForStorageAccount) throws AzureCloudException {
        block8: {
            try {
                if (this.virtualMachineExists(vmName, resourceGroupName)) {
                    ArrayList<URI> diskUrisToRemove = new ArrayList<URI>();
                    ArrayList<String> diskIdToRemove = new ArrayList<String>();
                    if (!((VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(resourceGroupName, vmName)).isManagedDiskEnabled()) {
                        diskUrisToRemove.add(new URI(((VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(resourceGroupName, vmName)).osUnmanagedDiskVhdUri()));
                    } else {
                        diskIdToRemove.add(((VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(resourceGroupName, vmName)).osDiskId());
                    }
                    LOGGER.log(Level.INFO, "Removing virtual machine {0}", vmName);
                    this.azureClient.virtualMachines().deleteByResourceGroup(resourceGroupName, vmName);
                    for (URI diskUri : diskUrisToRemove) {
                        this.removeStorageBlob(diskUri, resourceGroupName, this.azureCredentialsId, isUseEntraIdForStorageAccount);
                    }
                    for (String id : diskIdToRemove) {
                        LOGGER.log(Level.INFO, "Removing managed disk with id: {0}", id);
                        this.azureClient.disks().deleteById(id);
                    }
                    if (!diskIdToRemove.isEmpty()) {
                        this.removeImage(this.azureClient, vmName, resourceGroupName);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception while deleting VM", e);
                if ("ResourceNotFound".equalsIgnoreCase(e.getMessage())) break block8;
                throw AzureCloudException.create(e);
            }
        }
    }

    public void removeImage(AzureResourceManager azureClient, String vmName, String resourceGroupName) {
        PagedIterable customImages = azureClient.virtualMachineCustomImages().listByResourceGroup(resourceGroupName);
        for (VirtualMachineCustomImage image : customImages) {
            String prefix = StringUtils.substringBefore((String)image.name(), (String)"Image");
            if (!StringUtils.contains((CharSequence)vmName, (CharSequence)prefix)) continue;
            LOGGER.log(Level.INFO, "Removing image with name: {0}", image.name());
            azureClient.virtualMachineCustomImages().deleteById(image.id());
        }
    }

    public void removeStorageBlob(URI blobURI, String resourceGroupName, String credentialsId, boolean isUseEntraIdForStorageAccount) throws Exception {
        BlobUrlParts blobUrlParts = BlobUrlParts.parse((URL)blobURI.toURL());
        String storageAccountName = blobUrlParts.getAccountName();
        String containerName = blobUrlParts.getBlobContainerName();
        String blobName = blobUrlParts.getBlobName();
        LOGGER.log(Level.INFO, "removeStorageBlob: Removing blob {0}, in container {1} of storage account {2}", new Object[]{blobName, containerName, storageAccountName});
        BlobContainerClient container = this.getCloudBlobContainer(this.azureClient, resourceGroupName, storageAccountName, containerName, credentialsId, isUseEntraIdForStorageAccount);
        container.getBlobClient(blobName).delete();
        if (containerName.startsWith("jnk")) {
            PagedIterable blobs = container.listBlobs();
            if (blobs.iterator().hasNext()) {
                return;
            }
            LOGGER.log(Level.INFO, "removeStorageBlob: Removing empty container ", containerName);
            container.delete();
        }
    }

    public void restartVirtualMachine(AzureVMAgent agent) throws AzureCloudException {
        try {
            ((VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(agent.getResourceGroupName(), agent.getNodeName())).restart();
        }
        catch (Exception e) {
            throw AzureCloudException.create(e);
        }
    }

    public void startVirtualMachine(AzureVMAgent agent) throws AzureCloudException {
        LOGGER.log(Level.INFO, "Starting: {0}", agent.getNodeName());
        int retryCount = 0;
        boolean successful = false;
        while (!successful) {
            try {
                ((VirtualMachine)this.azureClient.virtualMachines().getByResourceGroup(agent.getResourceGroupName(), agent.getNodeName())).start();
                successful = true;
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Got exception while starting VM {0}. Will retry again after 30 seconds. Current retry count {1} / {2}\n", new Object[]{agent.getNodeName(), retryCount, 20});
                if (retryCount > 20) {
                    throw AzureCloudException.create(e);
                }
                ++retryCount;
                int sleepMillis = 30000;
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public Network getVirtualNetwork(String virtualNetworkName, String resourceGroupName) {
        try {
            return (Network)this.azureClient.networks().getByResourceGroup(resourceGroupName, virtualNetworkName);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Got exception while getting virtual network info: ", e);
            return null;
        }
    }

    public List<String> verifyTemplate(String templateName, String labels, String location, String virtualMachineSize, String storageAccountName, String storageAccountType, String noOfParallelJobs, String imageTopLevelType, AzureVMAgentTemplate.ImageReferenceTypeClass imageReferenceType, String builtInImage, String osType, AzureComputerLauncher launcher, String initScript, String credentialsId, String virtualNetworkName, String virtualNetworkResourceGroupName, String subnetName, AzureVMCloudBaseRetentionStrategy retentionStrategy, String jvmOptions, String resourceGroupName, boolean returnOnSingleError, boolean usePrivateIP, String nsgName) {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            String validationResult = this.verifyTemplateName(templateName);
            AzureVMManagementServiceDelegate.addValidationResultIfFailed(validationResult, errors);
            if (returnOnSingleError && !errors.isEmpty()) {
                return errors;
            }
            validationResult = AzureVMManagementServiceDelegate.verifyNoOfExecutors(noOfParallelJobs);
            AzureVMManagementServiceDelegate.addValidationResultIfFailed(validationResult, errors);
            if (returnOnSingleError && !errors.isEmpty()) {
                return errors;
            }
            validationResult = AzureVMManagementServiceDelegate.verifyRetentionTime(retentionStrategy);
            AzureVMManagementServiceDelegate.addValidationResultIfFailed(validationResult, errors);
            if (returnOnSingleError && !errors.isEmpty()) {
                return errors;
            }
            StandardUsernameCredentials creds = AzureUtil.getCredentials(credentialsId);
            if (creds instanceof StandardUsernamePasswordCredentials) {
                String adminPassword = ((StandardUsernamePasswordCredentials)creds).getPassword().getPlainText();
                validationResult = AzureVMManagementServiceDelegate.verifyAdminPassword(adminPassword);
                AzureVMManagementServiceDelegate.addValidationResultIfFailed(validationResult, errors);
                if (returnOnSingleError && !errors.isEmpty()) {
                    return errors;
                }
            } else {
                SSHUserPrivateKey sshCredentials = (SSHUserPrivateKey)creds;
                validationResult = AzureVMManagementServiceDelegate.verifySSHKey(sshCredentials.getPrivateKeys(), sshCredentials.getPassphrase());
                AzureVMManagementServiceDelegate.addValidationResultIfFailed(validationResult, errors);
                if (returnOnSingleError && !errors.isEmpty()) {
                    return errors;
                }
            }
            validationResult = AzureVMManagementServiceDelegate.verifyJvmOptions(jvmOptions);
            AzureVMManagementServiceDelegate.addValidationResultIfFailed(validationResult, errors);
            if (returnOnSingleError && !errors.isEmpty()) {
                return errors;
            }
            if (launcher instanceof AzureSSHLauncher) {
                String sshConfig = ((AzureSSHLauncher)launcher).getSshConfig();
                validationResult = AzureVMManagementServiceDelegate.verifySshConfig(sshConfig);
                AzureVMManagementServiceDelegate.addValidationResultIfFailed(validationResult, errors);
                if (returnOnSingleError && !errors.isEmpty()) {
                    return errors;
                }
            }
            validationResult = AzureVMManagementServiceDelegate.verifyImageParameters(imageTopLevelType, imageReferenceType, builtInImage, osType);
            AzureVMManagementServiceDelegate.addValidationResultIfFailed(validationResult, errors);
            if (returnOnSingleError && !errors.isEmpty()) {
                return errors;
            }
            this.verifyTemplateAsync(location, imageTopLevelType, imageReferenceType, builtInImage, storageAccountName, storageAccountType, virtualNetworkName, virtualNetworkResourceGroupName, subnetName, resourceGroupName, errors, usePrivateIP, nsgName);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error validating template", e);
            errors.add("Error occurred while validating Azure Profile");
        }
        return errors;
    }

    private void verifyTemplateAsync(String location, String imageTopLevelType, AzureVMAgentTemplate.ImageReferenceTypeClass imageReferenceType, String builtInImage, String storageAccountName, String storageAccountType, String virtualNetworkName, String virtualNetworkResourceGroupName, String subnetName, String resourceGroupName, List<String> errors, boolean usePrivateIP, String nsgName) {
        ArrayList<Callable<String>> verificationTaskList = new ArrayList<Callable<String>>();
        Callable<String> callVerifyVirtualNetwork = () -> this.verifyVirtualNetwork(virtualNetworkName, virtualNetworkResourceGroupName, subnetName, usePrivateIP, resourceGroupName);
        verificationTaskList.add(callVerifyVirtualNetwork);
        Callable<String> callVerifyVirtualMachineImage = () -> this.verifyVirtualMachineImage(location, storageAccountName, imageTopLevelType, imageReferenceType, builtInImage);
        verificationTaskList.add(callVerifyVirtualMachineImage);
        Callable<String> callVerifyStorageAccountName = () -> this.verifyStorageAccountName(resourceGroupName, storageAccountName, storageAccountType);
        verificationTaskList.add(callVerifyStorageAccountName);
        Callable<String> callVerifyNSG = () -> this.verifyNSG(resourceGroupName, nsgName);
        verificationTaskList.add(callVerifyNSG);
        try {
            for (Future validationResult : AzureVMCloud.getThreadPool().invokeAll(verificationTaskList)) {
                try {
                    int timeoutInSeconds = 60;
                    String result = (String)validationResult.get(60L, TimeUnit.SECONDS);
                    AzureVMManagementServiceDelegate.addValidationResultIfFailed(result, errors);
                }
                catch (ExecutionException executionException) {
                    errors.add("Exception occurred while validating temaplate " + String.valueOf(executionException));
                }
                catch (TimeoutException timeoutException) {
                    errors.add("Exception occurred while validating template " + String.valueOf(timeoutException));
                }
                catch (Exception others) {
                    errors.add(others.getMessage() + String.valueOf(others));
                }
            }
        }
        catch (InterruptedException interruptedException) {
            errors.add("Exception occurred while validating template " + String.valueOf(interruptedException));
        }
    }

    private static void addValidationResultIfFailed(String validationResult, List<String> errors) {
        if (!validationResult.equalsIgnoreCase("Success")) {
            errors.add(validationResult);
        }
    }

    public String verifyTemplateName(String templateName) {
        if (StringUtils.lowerCase((String)templateName).contains("login") || StringUtils.lowerCase((String)templateName).contains("microsoft") || StringUtils.lowerCase((String)templateName).contains("windows") || StringUtils.lowerCase((String)templateName).contains("xbox")) {
            return Messages.Azure_GC_Template_Name_Reserved();
        }
        return "Success";
    }

    public static String verifyNoOfExecutors(String noOfExecutors) {
        try {
            if (StringUtils.isBlank((CharSequence)noOfExecutors)) {
                return Messages.Azure_GC_Template_Executors_Null_Or_Empty();
            }
            AzureUtil.isPositiveInteger(noOfExecutors);
            return "Success";
        }
        catch (IllegalArgumentException e) {
            return Messages.Azure_GC_Template_Executors_Not_Positive();
        }
    }

    public static String verifyRetentionTime(AzureVMCloudBaseRetentionStrategy retentionStrategy) {
        try {
            if (retentionStrategy == null) {
                return Messages.Azure_GC_Template_RT_Null_Or_Empty();
            }
            return "Success";
        }
        catch (IllegalArgumentException e) {
            return Messages.Azure_GC_Template_RT_Not_Positive();
        }
    }

    public String verifyVirtualNetwork(String virtualNetworkName, String virtualNetworkResourceGroupName, String subnetName, boolean usePrivateIP, String resourceGroupName) {
        if (StringUtils.isNotBlank((CharSequence)virtualNetworkName)) {
            Network virtualNetwork;
            String finalResourceGroupName = resourceGroupName;
            if (StringUtils.isNotBlank((CharSequence)virtualNetworkResourceGroupName)) {
                finalResourceGroupName = virtualNetworkResourceGroupName;
            }
            if ((virtualNetwork = this.getVirtualNetwork(virtualNetworkName, finalResourceGroupName)) == null) {
                return Messages.Azure_GC_Template_VirtualNetwork_NotFound(virtualNetworkName, finalResourceGroupName);
            }
            if (StringUtils.isBlank((CharSequence)subnetName)) {
                return Messages.Azure_GC_Template_subnet_Empty();
            }
            if (virtualNetwork.subnets().get(subnetName) == null) {
                return Messages.Azure_GC_Template_subnet_NotFound(subnetName);
            }
        } else if (StringUtils.isNotBlank((CharSequence)subnetName) || usePrivateIP) {
            return Messages.Azure_GC_Template_VirtualNetwork_Null_Or_Empty();
        }
        return "Success";
    }

    public String verifyVirtualMachineImage(String locationLabel, String storageAccountName, String imageTopLevelType, AzureVMAgentTemplate.ImageReferenceTypeClass imageReference, String builtInImage) {
        if (imageTopLevelType == null || imageTopLevelType.equals("basic")) {
            if (StringUtils.isNotBlank((CharSequence)builtInImage)) {
                return "Success";
            }
            return Messages.Azure_GC_Template_BuiltIn_Not_Valid();
        }
        if (imageReference.getType() == ImageReferenceType.UNKNOWN && StringUtils.isNotBlank((CharSequence)imageReference.getUri()) || imageReference.getType() == ImageReferenceType.CUSTOM) {
            try {
                URI u;
                try {
                    u = URI.create(imageReference.getUri());
                }
                catch (Exception e) {
                    return Messages.Azure_GC_Template_ImageURI_Not_Valid();
                }
                String host = u.getHost();
                int firstDot = host.indexOf(46);
                if (firstDot == -1) {
                    return Messages.Azure_GC_Template_ImageURI_Not_Valid();
                }
                String uriStorageAccount = host.substring(0, firstDot);
                if (!uriStorageAccount.equals(storageAccountName)) {
                    return Messages.Azure_GC_Template_ImageURI_Wrong_Storage_Account();
                }
                return "Success";
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Invalid virtual machine image", e);
                return Messages.Azure_GC_Template_ImageURI_Not_Valid();
            }
        }
        if (imageReference.getType() == ImageReferenceType.CUSTOM_IMAGE) {
            try {
                GenericResource r = this.azureClient.genericResources().getById(imageReference.getId());
                if (r == null) {
                    return Messages.Azure_GC_Template_ImageID_Not_Valid();
                }
                return "Success";
            }
            catch (Exception e) {
                return Messages.Azure_GC_Template_ImageID_Not_Valid();
            }
        }
        if (imageReference.getType() == ImageReferenceType.GALLERY) {
            try {
                GalleryImageVersion galleryImage;
                PagedIterable galleryImageVersions;
                AzureResourceManager client = AzureResourceManagerCache.get((String)this.azureCredentialsId, (String)imageReference.getGallerySubscriptionId());
                if (client == null) {
                    return null;
                }
                if ("latest".equals(imageReference.getGalleryImageVersion()) ? !(galleryImageVersions = client.galleryImageVersions().listByGalleryImage(imageReference.getGalleryResourceGroup(), imageReference.getGalleryName(), imageReference.getGalleryImageDefinition())).iterator().hasNext() : (galleryImage = client.galleryImageVersions().getByGalleryImage(imageReference.getGalleryResourceGroup(), imageReference.getGalleryName(), imageReference.getGalleryImageDefinition(), imageReference.getGalleryImageVersion())) == null) {
                    return Messages.Azure_GC_Template_Gallery_Image_Not_Found();
                }
            }
            catch (RuntimeException ex) {
                return ex.getMessage();
            }
            catch (Exception e) {
                return Messages.Azure_GC_Template_Gallery_Image_Not_Found();
            }
            return "Success";
        }
        try {
            String locationName = AzureUtil.getLocationNameByLabel(locationLabel);
            PagedIterable publishers = this.azureClient.virtualMachineImages().publishers().listByRegion(locationName);
            for (VirtualMachinePublisher publisher : publishers) {
                if (!publisher.name().equalsIgnoreCase(imageReference.getPublisher())) continue;
                for (VirtualMachineOffer offer : publisher.offers().list()) {
                    if (!offer.name().equalsIgnoreCase(imageReference.getOffer())) continue;
                    for (VirtualMachineSku sku : offer.skus().list()) {
                        if (!sku.name().equalsIgnoreCase(imageReference.getSku())) continue;
                        PagedIterable images = sku.images().list();
                        if ((imageReference.getVersion().equalsIgnoreCase("latest") || StringUtils.isEmpty((CharSequence)imageReference.getVersion())) && images.stream().iterator().hasNext()) {
                            return "Success";
                        }
                        for (VirtualMachineImage vmImage : images) {
                            if (!vmImage.version().equalsIgnoreCase(imageReference.getVersion())) continue;
                            return "Success";
                        }
                        return Messages.Azure_GC_Template_ImageReference_Not_Valid("Invalid image version");
                    }
                    return Messages.Azure_GC_Template_ImageReference_Not_Valid("Invalid SKU");
                }
                return Messages.Azure_GC_Template_ImageReference_Not_Valid("Invalid publisher");
            }
            return Messages.Azure_GC_Template_ImageReference_Not_Valid("Invalid region");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Invalid virtual machine image", e);
            return Messages.Azure_GC_Template_ImageReference_Not_Valid(e.getMessage());
        }
    }

    public String verifyStorageAccountName(String resourceGroupName, String storageAccountName, String storageAccountType) {
        try {
            if (StringUtils.isBlank((CharSequence)storageAccountType)) {
                return Messages.Azure_GC_Template_SA_Type_Null_Or_Empty();
            }
            CheckNameAvailabilityResult checkResult = this.azureClient.storageAccounts().checkNameAvailability(storageAccountName);
            boolean isAvailable = checkResult.isAvailable();
            if (!isAvailable && Reason.ACCOUNT_NAME_INVALID.equals((Object)checkResult.reason())) {
                return Messages.Azure_GC_Template_SA_Not_Valid();
            }
            if (!isAvailable) {
                StorageAccount checkAccount = (StorageAccount)this.azureClient.storageAccounts().getByResourceGroup(resourceGroupName, storageAccountName);
                if (null == checkAccount) {
                    return Messages.Azure_GC_Template_SA_Already_Exists();
                }
                if (checkAccount.skuType().name().toString().equalsIgnoreCase(storageAccountType)) {
                    return "Success";
                }
                return Messages.Azure_GC_Template_SA_Type_Not_Match(storageAccountType, checkAccount.skuType().name().toString());
            }
            return "Success";
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Verification failed for storage account name", e);
            return Messages.Azure_GC_Template_SA_Already_Exists();
        }
    }

    private static String verifyAdminPassword(String adminPassword) {
        if (StringUtils.isBlank((CharSequence)adminPassword)) {
            return Messages.Azure_GC_Template_PWD_Null_Or_Empty();
        }
        if (AzureUtil.isValidPassword(adminPassword)) {
            return "Success";
        }
        return Messages.Azure_GC_Template_PWD_Not_Valid();
    }

    private static String verifySSHKey(List<String> sshKeys, Secret passphrase) throws RuntimeException {
        if (sshKeys == null || sshKeys.isEmpty()) {
            return Messages.AzureVMManagementServiceDelegate_SSH_Missing_Key();
        }
        if (sshKeys.size() > 1) {
            return Messages.AzureVMManagementServiceDelegate_SSH_Multiple_Keys_Found();
        }
        String sshKey = sshKeys.get(0);
        try {
            KeyDecoder.getPublicKey(sshKey, Secret.toString((Secret)passphrase));
        }
        catch (InvalidPassphraseException | SshException | IOException e) {
            LOGGER.log(Level.INFO, "Failed to validate SSH key", e);
            return Messages.AzureVMManagementServiceDelegate_SSH_Invalid_Key_Format();
        }
        return "Success";
    }

    private static String verifyJvmOptions(String jvmOptions) {
        if (StringUtils.isBlank((CharSequence)jvmOptions) || AzureUtil.isValidJvmOption(jvmOptions)) {
            return "Success";
        }
        return Messages.Azure_GC_JVM_Option_Err();
    }

    private static String verifySshConfig(String sshConfig) {
        if (StringUtils.isBlank((CharSequence)sshConfig)) {
            return "Success";
        }
        try {
            OpenSSHConfig.parse((String)sshConfig);
        }
        catch (IOException e) {
            return Messages.Ssh_Config_Invalid() + e.getMessage();
        }
        return "Success";
    }

    private static String verifyImageParameters(String imageTopLevelType, AzureVMAgentTemplate.ImageReferenceTypeClass imageReference, String builtInImage, String osType) {
        if (imageTopLevelType == null || imageTopLevelType.equals("basic")) {
            if (StringUtils.isNotBlank((CharSequence)builtInImage)) {
                return "Success";
            }
            return Messages.Azure_GC_Template_BuiltIn_Not_Valid();
        }
        if (imageReference.getType() == ImageReferenceType.UNKNOWN && StringUtils.isNotBlank((CharSequence)imageReference.getUri()) && StringUtils.isNotBlank((CharSequence)osType) || imageReference.getType() == ImageReferenceType.CUSTOM) {
            try {
                URI.create(imageReference.getUri());
            }
            catch (Exception e) {
                return Messages.Azure_GC_Template_ImageURI_Not_Valid();
            }
            return "Success";
        }
        if (imageReference.getType() == ImageReferenceType.CUSTOM_IMAGE && StringUtils.isNotBlank((CharSequence)imageReference.getId())) {
            return "Success";
        }
        if (imageReference.getType() == ImageReferenceType.REFERENCE && StringUtils.isNotBlank((CharSequence)imageReference.getPublisher()) && StringUtils.isNotBlank((CharSequence)imageReference.getOffer()) && StringUtils.isNotBlank((CharSequence)imageReference.getSku()) && StringUtils.isNotBlank((CharSequence)imageReference.getVersion())) {
            return "Success";
        }
        if (imageReference.getType() == ImageReferenceType.GALLERY && StringUtils.isNotBlank((CharSequence)imageReference.getGalleryName()) && StringUtils.isNotBlank((CharSequence)imageReference.getGalleryImageDefinition()) && StringUtils.isNotBlank((CharSequence)imageReference.getGalleryImageVersion()) && StringUtils.isNotBlank((CharSequence)imageReference.getGalleryResourceGroup())) {
            return "Success";
        }
        return Messages.Azure_GC_Template_ImageReference_Not_Valid("Image parameters should not be blank.");
    }

    public String verifyNSG(String resourceGroupName, String nsgName) {
        if (StringUtils.isNotBlank((CharSequence)nsgName)) {
            try {
                NetworkSecurityGroup nsg = (NetworkSecurityGroup)this.azureClient.networkSecurityGroups().getByResourceGroup(resourceGroupName, nsgName);
                if (nsg == null) {
                    return Messages.Azure_GC_Template_NSG_NotFound(nsgName);
                }
            }
            catch (Exception e) {
                return Messages.Azure_GC_Template_NSG_NotFound(nsgName);
            }
        }
        return "Success";
    }

    private void createAzureResourceGroup(AzureResourceManager azureClient, String locationName, String resourceGroupName, String cloudName) throws AzureCloudException {
        try {
            ((ResourceGroup.DefinitionStages.WithCreate)((ResourceGroup.DefinitionStages.WithCreate)((ResourceGroup.DefinitionStages.WithCreate)((ResourceGroup.DefinitionStages.Blank)azureClient.resourceGroups().define(resourceGroupName)).withRegion(locationName)).withTag("JenkinsManagedTag", "ManagedByAzureVMAgents")).withTag("JenkinsCloudTag", cloudName)).create();
        }
        catch (Exception e) {
            throw AzureCloudException.create(String.format("Failed to create resource group with group name %s, location %s", resourceGroupName, locationName), e);
        }
    }

    private void createStorageAccount(AzureResourceManager azureClient, String targetStorageAccountType, String targetStorageAccount, String location, String resourceGroupName, String templateName, List<AzureTagPair> tags) throws AzureCloudException {
        block5: {
            try {
                try {
                    azureClient.storageAccounts().getByResourceGroup(resourceGroupName, targetStorageAccount);
                }
                catch (ManagementException e) {
                    if (e.getResponse().getStatusCode() == 404) {
                        SkuName skuName = SkuName.fromString((String)targetStorageAccountType);
                        ((StorageAccount.DefinitionStages.WithCreate)((StorageAccount.DefinitionStages.WithCreate)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)azureClient.storageAccounts().define(targetStorageAccount)).withRegion(location)).withExistingResourceGroup(resourceGroupName)).withTags(this.getTags(templateName, tags))).withSku(StorageAccountSkuType.fromSkuName((SkuName)skuName)).create();
                        break block5;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                throw AzureCloudException.create(String.format("Failed to create storage account with account name %s, location %s, resourceGroupName %s", targetStorageAccount, location, resourceGroupName), e);
            }
        }
    }

    private Map<String, String> getTags(String templateName, List<AzureTagPair> tags) {
        List<AzureTagPair> tmpTags = tags;
        if (tmpTags == null) {
            tmpTags = new ArrayList<AzureTagPair>();
        }
        Map<String, String> rawTags = tmpTags.stream().collect(Collectors.toMap(AzureTagPair::getName, AzureTagPair::getValue));
        rawTags.put("JenkinsManagedTag", "ManagedByAzureVMAgents");
        rawTags.put("JenkinsTemplateTag", templateName);
        return rawTags;
    }

    private StorageAccount getStorageAccount(AzureResourceManager azureClient, String targetStorageAccount, String resourceGroupName) throws AzureCloudException {
        try {
            return (StorageAccount)azureClient.storageAccounts().getByResourceGroup(resourceGroupName, targetStorageAccount);
        }
        catch (Exception e) {
            throw AzureCloudException.create(e);
        }
    }

    public static String getBlobEndpointSuffixForTemplate(StorageAccount storageAccount) {
        return AzureVMManagementServiceDelegate.getBlobEndPointSuffix(storageAccount, "blob", ".", "/");
    }

    public static String getBlobEndpointSuffixForCloudStorageAccount(StorageAccount storageAccount) {
        return AzureVMManagementServiceDelegate.getBlobEndPointSuffix(storageAccount, "core", "", "");
    }

    private static String getBlobEndPointSuffix(StorageAccount storageAccount, String startKey, String prefix, String suffix) {
        String endpointSuffix = null;
        if (storageAccount != null) {
            String blobUri = storageAccount.endPoints().primary().blob().toLowerCase();
            endpointSuffix = AzureVMManagementServiceDelegate.getSubString(blobUri, startKey, prefix, suffix);
        }
        return endpointSuffix;
    }

    private static String getSubString(String uri, String startKey, String prefix, String suffix) {
        Object subString = null;
        if (StringUtils.isNotBlank((CharSequence)uri)) {
            subString = StringUtils.isNotEmpty((CharSequence)startKey) && uri.contains(startKey) ? uri.substring(uri.indexOf(startKey)) : uri;
            Object object = subString = StringUtils.isNotEmpty((CharSequence)prefix) ? prefix + (String)subString : subString;
            if (StringUtils.isNotEmpty((CharSequence)suffix) && ((String)subString).lastIndexOf(suffix) < ((String)subString).length() - suffix.length()) {
                subString = (String)subString + suffix;
            }
        }
        return subString;
    }

    public static BlobServiceClient getCloudStorageAccount(StorageAccount storageAccount, String credentialsId, boolean isUseEntraIdForStorageAccount) throws AzureCloudException {
        List storageKeys = storageAccount.getKeys();
        if (storageKeys.isEmpty()) {
            throw AzureCloudException.create("Exception occurred while fetching the storage account key");
        }
        String blobSuffix = storageAccount.endPoints().primary().blob().toLowerCase();
        LOGGER.log(Level.FINE, "The suffix for construct CloudStorageCloud is {0}", blobSuffix);
        if (StringUtils.isEmpty((CharSequence)blobSuffix)) {
            throw AzureCloudException.create("Exception occurred while getting blobSuffix, it's empty'");
        }
        try {
            if (isUseEntraIdForStorageAccount) {
                return BlobServiceClientCache.get((String)credentialsId, (String)blobSuffix);
            }
            String storageAccountKey = ((StorageAccountKey)storageKeys.get(0)).value();
            return new BlobServiceClientBuilder().credential(new StorageSharedKeyCredential(storageAccount.name(), storageAccountKey)).endpoint(blobSuffix).httpClient(HttpClientRetriever.get()).buildClient();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, String.format("Unable to get storage account %s and blob Suffix %s", storageAccount.name(), blobSuffix), e);
            throw AzureCloudException.create(e);
        }
    }

    public static BlobContainerClient getCloudBlobContainer(BlobServiceClient account, String containerName) throws AzureCloudException {
        try {
            BlobContainerClient blobContainerClient = account.getBlobContainerClient(containerName);
            if (!blobContainerClient.exists()) {
                blobContainerClient.create();
            }
            return blobContainerClient;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to get container " + containerName, e);
            throw AzureCloudException.create(e);
        }
    }

    public BlobContainerClient getCloudBlobContainer(AzureResourceManager azureClient, String resourceGroupName, String targetStorageAccount, String blobContainerName, String credentialsId, boolean isUseEntraIdForStorageAccount) throws AzureCloudException {
        StorageAccount storageAccount;
        try {
            storageAccount = (StorageAccount)azureClient.storageAccounts().getByResourceGroup(resourceGroupName, targetStorageAccount);
        }
        catch (Exception e) {
            throw AzureCloudException.create(e);
        }
        BlobServiceClient account = AzureVMManagementServiceDelegate.getCloudStorageAccount(storageAccount, credentialsId, isUseEntraIdForStorageAccount);
        return AzureVMManagementServiceDelegate.getCloudBlobContainer(account, blobContainerName);
    }

    private AzureVMManagementServiceDelegate(AzureResourceManager azureClient, String azureCredentialsId) {
        this.azureClient = azureClient;
        this.azureCredentialsId = azureCredentialsId;
    }

    private static List<AzureTagPair> concat(List<AzureTagPair> cloudTags, List<AzureTagPair> templateTags) {
        return Stream.concat(cloudTags.stream(), templateTags.stream()).collect(Collectors.toList());
    }

    private static String loadScript(String scriptName) throws IOException {
        String scriptFolder = System.getProperty("com.microsoft.azure.vmagent.AzureVMManagementServiceDelegate.scriptFolder");
        if (scriptFolder == null) {
            return AzureVMManagementServiceDelegate.loadScriptFromClassPath(scriptName);
        }
        Path script = Paths.get(scriptFolder, scriptName);
        if (Files.exists(script, new LinkOption[0])) {
            return IOUtils.toString((URI)script.toUri(), (Charset)StandardCharsets.UTF_8);
        }
        return AzureVMManagementServiceDelegate.loadScriptFromClassPath(scriptName);
    }

    private static String loadScriptFromClassPath(String scriptName) throws IOException {
        String classPathResource = "/scripts/" + scriptName;
        return IOUtils.toString((InputStream)AzureVMManagementServiceDelegate.class.getResourceAsStream(classPathResource), (Charset)StandardCharsets.UTF_8);
    }

    public static class VMStatus
    extends ExpandableStringEnum<VMStatus> {
        public static final VMStatus PROVISIONING_OR_DEPROVISIONING = VMStatus.fromString("PROVISIONING_OR_DEPROVISIONING");
        public static final VMStatus UPDATING = VMStatus.fromString("UPDATING");
        public static final VMStatus RUNNING = VMStatus.fromString("PowerState/running");
        public static final VMStatus DEALLOCATING = VMStatus.fromString("PowerState/deallocating");
        public static final VMStatus DEALLOCATED = VMStatus.fromString("PowerState/deallocated");
        public static final VMStatus STARTING = VMStatus.fromString("PowerState/starting");
        public static final VMStatus STOPPED = VMStatus.fromString("PowerState/stopped");
        public static final VMStatus STOPPING = VMStatus.fromString("PowerState/stopping");
        public static final VMStatus UNKNOWN = VMStatus.fromString("PowerState/unknown");

        public static VMStatus fromString(String name) {
            return (VMStatus)VMStatus.fromString((String)name, VMStatus.class);
        }

        public static VMStatus fromPowerState(PowerState powerState) {
            return (VMStatus)VMStatus.fromString((String)powerState.toString(), VMStatus.class);
        }
    }
}

