/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.compute.models.DiskSkuTypes;
import com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.azure.resourcemanager.storage.models.SkuName;
import com.azure.resourcemanager.storage.models.StorageAccount;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.jcraft.jsch.OpenSSHConfig;
import com.microsoft.azure.util.AzureBaseCredentials;
import com.microsoft.azure.util.AzureCredentialUtil;
import com.microsoft.azure.vmagent.AzureTagPair;
import com.microsoft.azure.vmagent.AzureVMAgent;
import com.microsoft.azure.vmagent.AzureVMCloud;
import com.microsoft.azure.vmagent.AzureVMCloudBaseRetentionStrategy;
import com.microsoft.azure.vmagent.AzureVMCloudOnceRetentionStrategy;
import com.microsoft.azure.vmagent.AzureVMCloudPoolRetentionStrategy;
import com.microsoft.azure.vmagent.AzureVMCloudRetensionStrategy;
import com.microsoft.azure.vmagent.AzureVMDeploymentInfo;
import com.microsoft.azure.vmagent.AzureVMManagementServiceDelegate;
import com.microsoft.azure.vmagent.ImageReferenceType;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.ProvisionStrategy;
import com.microsoft.azure.vmagent.availability.AzureAvailabilityType;
import com.microsoft.azure.vmagent.availability.NoAvailabilityRequired;
import com.microsoft.azure.vmagent.builders.AdvancedImage;
import com.microsoft.azure.vmagent.builders.AdvancedImageBuilder;
import com.microsoft.azure.vmagent.builders.BuiltInImage;
import com.microsoft.azure.vmagent.builders.BuiltInImageBuilder;
import com.microsoft.azure.vmagent.exceptions.AzureCloudException;
import com.microsoft.azure.vmagent.launcher.AzureComputerLauncher;
import com.microsoft.azure.vmagent.launcher.AzureInboundLauncher;
import com.microsoft.azure.vmagent.launcher.AzureSSHLauncher;
import com.microsoft.azure.vmagent.util.AzureClientHolder;
import com.microsoft.azure.vmagent.util.AzureUtil;
import com.microsoft.azure.vmagent.util.FailureStage;
import com.microsoft.jenkins.credentials.AzureResourceManagerCache;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Functions;
import hudson.RelativePath;
import hudson.Util;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.slaves.RetentionStrategy;
import hudson.util.DescribableList;
import hudson.util.FormApply;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

public class AzureVMAgentTemplate
implements Describable<AzureVMAgentTemplate>,
Serializable {
    private static final long serialVersionUID = 1574325692L;
    private static final Logger LOGGER = Logger.getLogger(AzureVMAgentTemplate.class.getName());
    private static final int GEN_STORAGE_ACCOUNT_UID_LENGTH = 22;
    private static final String VALIDATE_DEPLOYMENT_TEMPLATE_MESSAGE = "Verify configuration:\n\t{0}{1}{2}{3}resourceGroupName: {4};\n\ttemplateName: {5};\n\tlabels: {6};\n\tlocation: {7};\n\tvirtualMachineSize: {8};\n\tstorageAccountName: {9};\n\tnoOfParallelJobs: {10};\n\timageTopLevelType: {11};\n\tbuiltInImage: {12};\n\timage: {13};\n\tosType: {14};\n\tid: {15};\n\tpublisher: {16};\n\toffer: {17};\n\tsku: {18};\n\tversion: {19};\n\tsshConfig: {20};\n\tinitScript: {21};\n\tcredentialsId: {22};\n\tvirtualNetworkName: {23};\n\tvirtualNetworkResourceGroupName: {24};\n\tsubnetName: {25};\n\tprivateIP: {26};\n\tnsgName: {27};\n\tjvmOptions: {28};\n\tgalleryName: {29}\n\tgalleryImageDefinition: {30}\n\tgalleryImageVersion: {31}\n\tgalleryResourceGroup: {32}\n\tgallerySubscriptionId: {33}";
    private final String templateName;
    private final String templateDesc;
    private final String labels;
    private final String location;
    private AzureAvailabilityType availabilityType;
    private final String virtualMachineSize;
    private String storageAccountNameReferenceType;
    private transient String storageAccountName;
    private String diskType;
    private boolean ephemeralOSDisk;
    private boolean encryptionAtHost;
    private int osDiskSize;
    private String newStorageAccountName;
    private String existingStorageAccountName;
    private String storageAccountType;
    private String osDiskStorageAccountType;
    private final int noOfParallelJobs;
    private Node.Mode usageMode;
    private boolean shutdownOnIdle;
    private String imageTopLevelType;
    private ImageReferenceTypeClass imageReference;
    private String builtInImage;
    private boolean installGit;
    private boolean installMaven;
    private boolean installDocker;
    private boolean installQemu;
    private boolean trustedLaunch;
    private final String osType;
    private transient String agentLaunchMethod;
    private AzureComputerLauncher launcher;
    private transient boolean preInstallSsh;
    private transient String sshConfig;
    private final String initScript;
    private final String terminateScript;
    private final String credentialsId;
    private final String agentWorkspace;
    private int retentionTimeInMin;
    private String virtualNetworkName;
    private String virtualNetworkResourceGroupName;
    private String subnetName;
    private boolean usePrivateIP;
    private boolean spotInstance;
    private boolean acceleratedNetworking;
    private final String nsgName;
    private final String jvmOptions;
    private String remotingOptions;
    private boolean templateDisabled;
    private transient String templateStatusDetails;
    private transient AzureVMCloud azureCloud;
    private transient Set<LabelAtom> labelDataSet;
    private boolean templateVerified;
    private transient ProvisionStrategy templateProvisionStrategy;
    private boolean executeInitScriptAsRoot;
    private boolean doNotUseMachineIfInitFails;
    private boolean enableMSI;
    private boolean enableUAMI;
    private boolean useEntraIdForStorageAccount;
    private String uamiID;
    private String javaPath;
    private RetentionStrategy<?> retentionStrategy;
    private int maximumDeploymentSize;
    private List<AzureTagPair> tags;
    private int maxVirtualMachinesLimit;
    private String licenseType;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="They are serializable in practice")
    private DescribableList<NodeProperty<?>, NodePropertyDescriptor> nodeProperties = new DescribableList(Saveable.NOOP);

    @DataBoundConstructor
    public AzureVMAgentTemplate(String templateName, String templateDesc, String labels, String location, AzureAvailabilityType availabilityType, String virtualMachineSize, String storageAccountNameReferenceType, String storageAccountType, String newStorageAccountName, String existingStorageAccountName, String diskType, String noOfParallelJobs, Node.Mode usageMode, String osType, String imageTopLevelType, ImageReferenceTypeClass imageReference, AzureComputerLauncher launcher, String initScript, String terminateScript, String credentialsId, String virtualNetworkName, String virtualNetworkResourceGroupName, String subnetName, String nsgName, String agentWorkspace, String jvmOptions, RetentionStrategy<?> retentionStrategy, boolean executeInitScriptAsRoot, boolean doNotUseMachineIfInitFails) {
        this.templateName = templateName;
        this.templateDesc = templateDesc;
        this.labels = labels;
        this.location = location;
        this.availabilityType = availabilityType;
        if (availabilityType == null) {
            this.availabilityType = new NoAvailabilityRequired();
        }
        this.virtualMachineSize = virtualMachineSize;
        this.storageAccountType = storageAccountType;
        this.storageAccountName = AzureVMAgentTemplate.getStorageAccountName(storageAccountNameReferenceType, newStorageAccountName, existingStorageAccountName);
        this.newStorageAccountName = newStorageAccountName;
        this.existingStorageAccountName = existingStorageAccountName;
        this.storageAccountNameReferenceType = storageAccountNameReferenceType;
        this.diskType = diskType;
        this.noOfParallelJobs = StringUtils.isBlank((CharSequence)noOfParallelJobs) || !noOfParallelJobs.matches("\\d+") || noOfParallelJobs.trim().equals("0") ? 1 : Integer.parseInt(noOfParallelJobs);
        this.setUsageMode(usageMode);
        this.imageTopLevelType = imageTopLevelType;
        this.imageReference = imageReference;
        if (imageReference == null) {
            this.imageReference = new ImageReferenceTypeClass();
        }
        this.osType = osType;
        this.initScript = initScript;
        this.terminateScript = terminateScript;
        this.launcher = launcher;
        this.credentialsId = credentialsId;
        this.virtualNetworkName = virtualNetworkName;
        this.virtualNetworkResourceGroupName = virtualNetworkResourceGroupName;
        this.subnetName = subnetName;
        this.nsgName = nsgName;
        this.agentWorkspace = agentWorkspace;
        this.jvmOptions = jvmOptions;
        this.executeInitScriptAsRoot = executeInitScriptAsRoot;
        this.doNotUseMachineIfInitFails = doNotUseMachineIfInitFails;
        this.templateStatusDetails = "";
        this.templateProvisionStrategy = new ProvisionStrategy();
        this.retentionStrategy = retentionStrategy;
        this.labelDataSet = Label.parse((String)labels);
        this.tags = new ArrayList<AzureTagPair>();
    }

    public DescribableList<NodeProperty<?>, NodePropertyDescriptor> getNodeProperties() {
        return this.nodeProperties;
    }

    @DataBoundSetter
    public void setNodeProperties(List<? extends NodeProperty<?>> nodeProperties) throws IOException {
        if (nodeProperties == null) {
            this.nodeProperties = new DescribableList(Saveable.NOOP);
        }
        this.nodeProperties.replaceBy(nodeProperties);
    }

    @DataBoundSetter
    public void setBuiltInImage(String builtInImage) {
        this.builtInImage = builtInImage;
    }

    @Restricted(value={NoExternalUse.class})
    public String getGallerySubscriptionId() {
        return this.imageReference != null ? this.imageReference.getGallerySubscriptionId() : null;
    }

    @Restricted(value={NoExternalUse.class})
    public String getGalleryResourceGroup() {
        return this.imageReference != null ? this.imageReference.getGalleryResourceGroup() : null;
    }

    @NonNull
    public String getUrl() {
        return "template/" + Util.rawEncode((String)this.templateName) + "/";
    }

    @Restricted(value={NoExternalUse.class})
    public String getGalleryName() {
        return this.imageReference != null ? this.imageReference.getGalleryName() : null;
    }

    @Restricted(value={NoExternalUse.class})
    public String getGalleryImageDefinition() {
        return this.imageReference != null ? this.imageReference.getGalleryImageDefinition() : null;
    }

    @Restricted(value={NoExternalUse.class})
    public String getGalleryImageVersion() {
        return this.imageReference != null ? this.imageReference.getGalleryImageVersion() : null;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean getGalleryImageSpecialized() {
        return this.imageReference != null ? this.imageReference.getGalleryImageSpecialized() : false;
    }

    @Restricted(value={NoExternalUse.class})
    public String getId() {
        return this.imageReference != null ? this.imageReference.getId() : null;
    }

    @Restricted(value={NoExternalUse.class})
    public String getUri() {
        return this.imageReference != null ? this.imageReference.getUri() : null;
    }

    @Restricted(value={NoExternalUse.class})
    public String getPublisher() {
        return this.imageReference != null ? this.imageReference.getPublisher() : null;
    }

    @Restricted(value={NoExternalUse.class})
    public String getOffer() {
        return this.imageReference != null ? this.imageReference.getOffer() : null;
    }

    @Restricted(value={NoExternalUse.class})
    public String getSku() {
        return this.imageReference != null ? this.imageReference.getSku() : null;
    }

    @Restricted(value={NoExternalUse.class})
    public String getVersion() {
        return this.imageReference != null ? this.imageReference.getVersion() : null;
    }

    public int getMaxVirtualMachinesLimit() {
        return this.maxVirtualMachinesLimit;
    }

    @DataBoundSetter
    public void setMaxVirtualMachinesLimit(int maxVirtualMachinesLimit) {
        this.maxVirtualMachinesLimit = maxVirtualMachinesLimit;
    }

    public int getEffectiveTemplateMaxVirtualMachinesLimit() {
        return this.maxVirtualMachinesLimit > 0 ? this.maxVirtualMachinesLimit : Integer.MAX_VALUE;
    }

    public int getEffectiveMaxVirtualMachinesLimit(int cloudMaxVMs) {
        int effectiveCloudMax = cloudMaxVMs > 0 ? cloudMaxVMs : Integer.MAX_VALUE;
        return Math.min(this.getEffectiveTemplateMaxVirtualMachinesLimit(), effectiveCloudMax);
    }

    public boolean isUseEntraIdForStorageAccount() {
        return this.useEntraIdForStorageAccount;
    }

    @DataBoundSetter
    public void setUseEntraIdForStorageAccount(boolean useEntraIdForStorageAccount) {
        this.useEntraIdForStorageAccount = useEntraIdForStorageAccount;
    }

    public String getJavaPath() {
        return this.javaPath;
    }

    @DataBoundSetter
    public void setJavaPath(String javaPath) {
        this.javaPath = javaPath;
    }

    public String getRemotingOptions() {
        return this.remotingOptions;
    }

    @DataBoundSetter
    public void setRemotingOptions(String remotingOptions) {
        this.remotingOptions = remotingOptions;
    }

    public boolean isSpotInstance() {
        return this.spotInstance;
    }

    @DataBoundSetter
    public void setSpotInstance(boolean spotInstance) {
        this.spotInstance = spotInstance;
    }

    public boolean isTrustedLaunch() {
        return this.trustedLaunch;
    }

    @DataBoundSetter
    public void setTrustedLaunch(boolean trustedLaunch) {
        this.trustedLaunch = trustedLaunch;
    }

    public boolean isAcceleratedNetworking() {
        return this.acceleratedNetworking;
    }

    @DataBoundSetter
    public void setAcceleratedNetworking(boolean acceleratedNetworking) {
        this.acceleratedNetworking = acceleratedNetworking;
    }

    public List<AzureTagPair> getTags() {
        return this.tags;
    }

    @DataBoundSetter
    public void setTags(List<AzureTagPair> tags) {
        this.tags = tags;
    }

    public static Map<String, Object> getTemplateProperties(AzureVMAgentTemplate template) {
        HashMap<String, Object> templateProperties = new HashMap<String, Object>();
        String builtInImage = template.getBuiltInImage();
        Map<String, String> defaultProperties = AzureVMManagementServiceDelegate.DEFAULT_IMAGE_PROPERTIES.get(builtInImage);
        boolean isBasic = template.isTopLevelType("basic");
        String imageSkuName = template.isInstallDocker() ? "defaultDockerImageSku" : "defaultImageSku";
        templateProperties.put("imageId", isBasic ? defaultProperties.get("defaultImageId") : template.getImageReference().getId());
        templateProperties.put("imagePublisher", isBasic ? defaultProperties.get("defaultImagePublisher") : template.getImageReference().getPublisher());
        templateProperties.put("imageOffer", isBasic ? defaultProperties.get("defaultImageOffer") : template.getImageReference().getOffer());
        templateProperties.put("imageSku", isBasic ? defaultProperties.get(imageSkuName) : template.getImageReference().getSku());
        templateProperties.put("imageVersion", isBasic ? defaultProperties.get("defaultImageVersion") : template.getImageReference().getVersion());
        templateProperties.put("galleryName", isBasic ? defaultProperties.get("defaultGalleryName") : template.getImageReference().getGalleryName());
        templateProperties.put("galleryImageDefinition", isBasic ? defaultProperties.get("defaultGalleryImageDefinition") : template.getImageReference().getGalleryImageDefinition());
        templateProperties.put("galleryImageVersion", isBasic ? defaultProperties.get("defaultGalleryImageVersion") : template.getImageReference().getGalleryImageVersion());
        templateProperties.put("gallerySubscriptionId", isBasic ? defaultProperties.get("defaultGallerySubscriptionId") : template.getImageReference().getGallerySubscriptionId());
        templateProperties.put("galleryResourceGroup", isBasic ? defaultProperties.get("defaultGalleryResourceGroup") : template.getImageReference().getGalleryResourceGroup());
        templateProperties.put("osType", isBasic ? defaultProperties.get("defaultOsType") : template.getOsType());
        AzureComputerLauncher launcher = template.getLauncher() == null ? new AzureSSHLauncher() : template.getLauncher();
        boolean isSSH = launcher instanceof AzureSSHLauncher;
        String agentLaunchMethod = isSSH ? "SSH" : "JNLP";
        templateProperties.put("agentLaunchMethod", isBasic ? defaultProperties.get("defaultLaunchMethod") : agentLaunchMethod);
        if (isSSH) {
            templateProperties.put("sshConfig", isBasic ? "" : ((AzureSSHLauncher)launcher).getSshConfig());
        }
        templateProperties.put("initScript", isBasic ? AzureVMAgentTemplate.getBasicInitScript(template) : template.getInitScript());
        templateProperties.put("terminateScript", template.getTerminateScript());
        templateProperties.put("virtualNetworkName", template.getVirtualNetworkName());
        templateProperties.put("virtualNetworkResourceGroupName", template.getVirtualNetworkResourceGroupName());
        templateProperties.put("subnetName", template.getSubnetName());
        templateProperties.put("usePrivateIP", template.getUsePrivateIP());
        templateProperties.put("nsgName", template.getNsgName());
        templateProperties.put("jvmOptions", isBasic ? "" : template.getJvmOptions());
        templateProperties.put("noOfParallelJobs", isBasic ? 1 : template.getNoOfParallelJobs());
        templateProperties.put("templateDisabled", !isBasic && template.isTemplateDisabled());
        templateProperties.put("executeInitScriptAsRoot", isBasic || template.getExecuteInitScriptAsRoot());
        templateProperties.put("doNotUseMachineIfInitFails", isBasic || template.getDoNotUseMachineIfInitFails());
        templateProperties.put("enableMSI", !isBasic && template.isEnableMSI());
        templateProperties.put("enableUAMI", !isBasic && template.isEnableUAMI());
        templateProperties.put("ephemeralOSDisk", template.isEphemeralOSDisk());
        templateProperties.put("encryptionAtHost", template.isEncryptionAtHost());
        templateProperties.put("uamiID", isBasic ? "" : template.getUamiID());
        return templateProperties;
    }

    public static String getBasicInitScript(AzureVMAgentTemplate template) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String builtInImage = template.getBuiltInImage();
            stringBuilder.append(AzureVMManagementServiceDelegate.PRE_INSTALLED_TOOLS_SCRIPT.get(builtInImage).get("Java"));
            if (template.isInstallMaven()) {
                stringBuilder.append(AzureVMAgentTemplate.getSeparator(template.getOsType()));
                stringBuilder.append(AzureVMManagementServiceDelegate.PRE_INSTALLED_TOOLS_SCRIPT.get(builtInImage).get("Maven"));
            }
            if (template.isInstallQemu()) {
                stringBuilder.append(AzureVMAgentTemplate.getSeparator(template.getOsType()));
                stringBuilder.append(AzureVMManagementServiceDelegate.PRE_INSTALLED_TOOLS_SCRIPT.get(builtInImage).get("QEMU"));
            }
            if (template.isInstallGit()) {
                stringBuilder.append(AzureVMAgentTemplate.getSeparator(template.getOsType()));
                stringBuilder.append(AzureVMManagementServiceDelegate.PRE_INSTALLED_TOOLS_SCRIPT.get(builtInImage).get("Git"));
            }
            if ((builtInImage.equals("Ubuntu 20.04 LTS") || builtInImage.equals("Ubuntu 22.04 LTS") || builtInImage.equals("Ubuntu 24.04 LTS")) && template.isInstallDocker()) {
                stringBuilder.append(AzureVMAgentTemplate.getSeparator(template.getOsType()));
                stringBuilder.append(AzureVMManagementServiceDelegate.PRE_INSTALLED_TOOLS_SCRIPT.get(builtInImage).get("Docker").replace("${ADMIN}", template.getVMCredentials().getUsername()));
            }
            if (Util.fixEmpty((String)template.getInitScript()) != null) {
                stringBuilder.append(AzureVMAgentTemplate.getSeparator(template.getOsType()));
                stringBuilder.append(template.getInitScript());
            }
            return stringBuilder.toString();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "AzureVMTemplate: getBasicInitScript: Get pre-installed tools script {0} failed.", e);
            return stringBuilder.toString();
        }
    }

    public static String getSeparator(String osType) {
        if (osType.equals("Windows")) {
            return "\r\n";
        }
        return "\n";
    }

    public boolean isType(String type) {
        if (type == null || this.imageReference == null) {
            return false;
        }
        return this.imageReference.type.getName().equals(type);
    }

    public boolean isTopLevelType(String type) {
        if (this.imageTopLevelType == null && type.equals("basic")) {
            return true;
        }
        return type != null && type.equalsIgnoreCase(this.imageTopLevelType);
    }

    private Object readResolve() {
        this.labelDataSet = Label.parse((String)this.labels);
        this.templateProvisionStrategy = new ProvisionStrategy();
        if (StringUtils.isBlank((CharSequence)this.storageAccountType)) {
            this.storageAccountType = SkuName.STANDARD_LRS.toString();
        }
        if (this.nodeProperties == null) {
            this.nodeProperties = new DescribableList(Saveable.NOOP);
        }
        if (StringUtils.isNotBlank((CharSequence)this.agentLaunchMethod)) {
            if (this.agentLaunchMethod.equalsIgnoreCase("SSH")) {
                AzureSSHLauncher azureSSHLauncher = new AzureSSHLauncher();
                if (StringUtils.isNotBlank((CharSequence)this.sshConfig)) {
                    azureSSHLauncher.setSshConfig(this.sshConfig);
                }
                if (this.preInstallSsh) {
                    azureSSHLauncher.setPreInstallSsh(this.preInstallSsh);
                }
                this.launcher = azureSSHLauncher;
            } else if (this.agentLaunchMethod.equalsIgnoreCase("JNLP")) {
                this.launcher = new AzureInboundLauncher();
            }
            this.agentLaunchMethod = null;
        }
        if (StringUtils.isBlank((CharSequence)this.newStorageAccountName) && StringUtils.isBlank((CharSequence)this.existingStorageAccountName) && StringUtils.isNotBlank((CharSequence)this.storageAccountName)) {
            this.newStorageAccountName = this.storageAccountName;
            this.storageAccountNameReferenceType = "new";
        }
        this.storageAccountName = AzureVMAgentTemplate.getStorageAccountName(this.storageAccountNameReferenceType, this.newStorageAccountName, this.existingStorageAccountName);
        if (StringUtils.isBlank((CharSequence)this.diskType)) {
            this.diskType = "unmanaged";
        }
        if (this.retentionStrategy == null) {
            this.retentionStrategy = new AzureVMCloudRetensionStrategy(0);
        }
        if (this.imageReference == null) {
            this.imageReference = new ImageReferenceTypeClass();
        }
        if (this.availabilityType == null) {
            this.availabilityType = new NoAvailabilityRequired();
        }
        if (this.imageReference.type == null) {
            this.imageReference.type = this.imageReference.determineType();
        }
        if (this.tags == null) {
            this.tags = new ArrayList<AzureTagPair>();
        }
        if (StringUtils.isBlank((CharSequence)this.imageTopLevelType)) {
            this.imageTopLevelType = this.imageReference != null && (StringUtils.isNotBlank((CharSequence)this.imageReference.getUri()) || StringUtils.isNotBlank((CharSequence)this.imageReference.getId()) || StringUtils.isNotBlank((CharSequence)this.imageReference.getOffer()) || StringUtils.isNotBlank((CharSequence)this.imageReference.getSku()) || StringUtils.isNotBlank((CharSequence)this.imageReference.getPublisher())) ? "advanced" : "basic";
            this.builtInImage = "Windows Server 2016";
        }
        return this;
    }

    public String getLabels() {
        return this.labels;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVirtualMachineSize() {
        return this.virtualMachineSize;
    }

    public String getStorageAccountType() {
        return StringUtils.isBlank((CharSequence)this.storageAccountType) ? SkuName.STANDARD_LRS.toString() : this.storageAccountType;
    }

    public String getOsDiskStorageAccountType() {
        if (StringUtils.isBlank((CharSequence)this.osDiskStorageAccountType)) {
            return this.getStorageAccountType();
        }
        return this.osDiskStorageAccountType;
    }

    @DataBoundSetter
    public void setOsDiskStorageAccountType(String osDiskStorageAccountType) {
        this.osDiskStorageAccountType = osDiskStorageAccountType;
    }

    public String getStorageAccountName() {
        return this.storageAccountName;
    }

    public static String getStorageAccountName(String type, String newName, String existingName) {
        if (StringUtils.isBlank((CharSequence)type) && StringUtils.isNotBlank((CharSequence)newName) || StringUtils.isNotBlank((CharSequence)type) && type.equalsIgnoreCase("new")) {
            return newName;
        }
        return existingName;
    }

    public String getDiskType() {
        return this.diskType;
    }

    public boolean isEphemeralOSDisk() {
        return this.ephemeralOSDisk;
    }

    @DataBoundSetter
    public void setEphemeralOSDisk(boolean ephemeralOSDisk) {
        this.ephemeralOSDisk = ephemeralOSDisk;
    }

    public boolean isEncryptionAtHost() {
        return this.encryptionAtHost;
    }

    @DataBoundSetter
    public void setEncryptionAtHost(boolean encryptionAtHost) {
        this.encryptionAtHost = encryptionAtHost;
    }

    @DataBoundSetter
    public void setOsDiskSize(int osDiskSize) {
        this.osDiskSize = osDiskSize;
    }

    public int getOsDiskSize() {
        return this.osDiskSize;
    }

    public String getStorageAccountNameReferenceType() {
        return this.storageAccountNameReferenceType;
    }

    public void setStorageAccountName(String storageAccountName) {
        this.storageAccountName = storageAccountName;
    }

    public String getNewStorageAccountName() {
        return this.newStorageAccountName;
    }

    public String getExistingStorageAccountName() {
        return this.existingStorageAccountName;
    }

    public Node.Mode getUsageMode() {
        return this.usageMode == null ? Node.Mode.NORMAL : this.usageMode;
    }

    public boolean isStorageAccountNameReferenceTypeEquals(String type) {
        if (this.storageAccountNameReferenceType == null && type.equalsIgnoreCase("new")) {
            return true;
        }
        return type != null && type.equalsIgnoreCase(this.storageAccountNameReferenceType);
    }

    @DataBoundSetter
    public void setUsageMode(Node.Mode usageMode) {
        this.usageMode = usageMode;
    }

    @DataBoundSetter
    public void setShutdownOnIdle(boolean shutdownOnIdle) {
        this.shutdownOnIdle = shutdownOnIdle;
    }

    public boolean isShutdownOnIdle() {
        return this.shutdownOnIdle;
    }

    public AzureAvailabilityType getAvailabilityType() {
        return this.availabilityType;
    }

    public ImageReferenceTypeClass getImageReference() {
        return this.imageReference;
    }

    public String getImageTopLevelType() {
        return this.imageTopLevelType;
    }

    public String getBuiltInImage() {
        return this.builtInImage;
    }

    @DataBoundSetter
    public void setInstallGit(boolean installGit) {
        this.installGit = installGit;
    }

    @DataBoundSetter
    public void setInstallMaven(boolean installMaven) {
        this.installMaven = installMaven;
    }

    @DataBoundSetter
    public void setInstallQemu(boolean installQemu) {
        this.installQemu = installQemu;
    }

    @DataBoundSetter
    public void setInstallDocker(boolean installDocker) {
        this.installDocker = installDocker;
    }

    public boolean isInstallGit() {
        return this.installGit;
    }

    public boolean isInstallMaven() {
        return this.installMaven;
    }

    public boolean isInstallDocker() {
        return this.installDocker;
    }

    public boolean isInstallQemu() {
        return this.installQemu;
    }

    public String getOsType() {
        return this.osType;
    }

    public String getInitScript() {
        return this.initScript;
    }

    public String getTerminateScript() {
        return this.terminateScript;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public StandardUsernameCredentials getVMCredentials() throws AzureCloudException {
        return AzureUtil.getCredentials(this.credentialsId);
    }

    public String getVirtualNetworkName() {
        return this.virtualNetworkName;
    }

    public void setVirtualNetworkName(String virtualNetworkName) {
        this.virtualNetworkName = virtualNetworkName;
    }

    public String getVirtualNetworkResourceGroupName() {
        return this.virtualNetworkResourceGroupName;
    }

    public String getSubnetName() {
        return this.subnetName;
    }

    public void setSubnetName(String subnetName) {
        this.subnetName = subnetName;
    }

    @DataBoundSetter
    public void setUsePrivateIP(boolean usePrivateIP) {
        this.usePrivateIP = usePrivateIP;
    }

    public boolean getUsePrivateIP() {
        return this.usePrivateIP;
    }

    public String getNsgName() {
        return this.nsgName;
    }

    public String getAgentWorkspace() {
        return this.agentWorkspace;
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public AzureVMCloud retrieveAzureCloudReference() {
        return this.azureCloud;
    }

    public void addAzureCloudReference(AzureVMCloud cloud) {
        this.azureCloud = cloud;
        if (StringUtils.isBlank((CharSequence)this.storageAccountName)) {
            this.newStorageAccountName = this.storageAccountName = AzureVMAgentTemplate.generateUniqueStorageAccountName(this.azureCloud.getResourceGroupName(), this.templateName);
            this.storageAccountNameReferenceType = "new";
        }
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getTemplateDesc() {
        return this.templateDesc;
    }

    public int getNoOfParallelJobs() {
        return this.noOfParallelJobs;
    }

    public ProvisionStrategy retrieveTemplateProvisionStrategy() {
        return this.templateProvisionStrategy;
    }

    public boolean isTemplateDisabled() {
        return this.templateDisabled;
    }

    @DataBoundSetter
    public void setTemplateDisabled(boolean templateDisabled) {
        this.templateDisabled = templateDisabled;
    }

    public boolean isTemplateVerified() {
        return this.templateVerified;
    }

    public void setTemplateVerified(boolean isValid) {
        this.templateVerified = isValid;
    }

    public String getTemplateStatusDetails() {
        return this.templateStatusDetails;
    }

    public void setTemplateStatusDetails(String templateStatusDetails) {
        this.templateStatusDetails = templateStatusDetails;
    }

    public String getResourceGroupName() {
        return this.retrieveAzureCloudReference().getResourceGroupName();
    }

    public String getResourceGroupReferenceType() {
        return this.retrieveAzureCloudReference().getResourceGroupReferenceType();
    }

    public int getRetentionTimeInMin() {
        return this.retentionTimeInMin;
    }

    public boolean getExecuteInitScriptAsRoot() {
        return this.executeInitScriptAsRoot;
    }

    public void setExecuteInitScriptAsRoot(boolean executeAsRoot) {
        this.executeInitScriptAsRoot = executeAsRoot;
    }

    public boolean getDoNotUseMachineIfInitFails() {
        return this.doNotUseMachineIfInitFails;
    }

    @DataBoundSetter
    public void setEnableMSI(boolean enableMSI) {
        this.enableMSI = enableMSI;
    }

    public boolean isEnableMSI() {
        return this.enableMSI;
    }

    @DataBoundSetter
    public void setEnableUAMI(boolean enableUAMI) {
        this.enableUAMI = enableUAMI;
    }

    public boolean isEnableUAMI() {
        return this.enableUAMI;
    }

    @DataBoundSetter
    public void setUamiID(String uamiID) {
        this.uamiID = uamiID;
    }

    public String getUamiID() {
        return this.uamiID;
    }

    public AzureComputerLauncher getLauncher() {
        return this.launcher;
    }

    @DataBoundSetter
    public void setDoNotUseMachineIfInitFails(boolean doNotUseMachineIfInitFails) {
        this.doNotUseMachineIfInitFails = doNotUseMachineIfInitFails;
    }

    public AdvancedImage getAdvancedImageInside() {
        boolean isSSH = this.launcher instanceof AzureSSHLauncher;
        boolean preInstallSshLocal = this.launcher != null && isSSH && ((AzureSSHLauncher)this.launcher).isPreInstallSsh();
        String sshConfigLocal = this.launcher != null && isSSH ? ((AzureSSHLauncher)this.launcher).getSshConfig() : null;
        return ((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)((AdvancedImageBuilder)new AdvancedImageBuilder().withCustomImage(this.imageReference.uri)).withCustomManagedImage(this.imageReference.id)).withGalleryImage(this.imageReference.galleryName, this.imageReference.galleryImageDefinition, this.imageReference.galleryImageVersion, this.imageReference.galleryImageSpecialized, this.imageReference.gallerySubscriptionId, this.imageReference.galleryResourceGroup)).withReferenceImage(this.imageReference.publisher, this.imageReference.offer, this.imageReference.sku, this.imageReference.version)).withNumberOfExecutors(String.valueOf(this.getNoOfParallelJobs()))).withOsType(this.getOsType())).withLaunchMethod(isSSH ? "SSH" : "JNLP")).withPreInstallSsh(preInstallSshLocal)).withSshConfig(sshConfigLocal)).withInitScript(this.getInitScript())).withVirtualNetworkName(this.getVirtualNetworkName())).withVirtualNetworkResourceGroupName(this.getVirtualNetworkResourceGroupName())).withSubnetName(this.getSubnetName())).withUsePrivateIP(this.getUsePrivateIP())).withNetworkSecurityGroupName(this.getNsgName())).withJvmOptions(this.getJvmOptions())).withDisableTemplate(this.isTemplateDisabled())).withRunScriptAsRoot(this.getExecuteInitScriptAsRoot())).withDoNotUseMachineIfInitFails(this.getDoNotUseMachineIfInitFails())).withEnableMSI(this.isEnableMSI())).withEnableUAMI(this.isEnableUAMI())).withGetUamiID(this.getUamiID())).build();
    }

    public BuiltInImage getBuiltInImageInside() {
        return ((BuiltInImageBuilder)((BuiltInImageBuilder)((BuiltInImageBuilder)((BuiltInImageBuilder)((BuiltInImageBuilder)new BuiltInImageBuilder().withBuiltInImageName(this.getBuiltInImage())).withInstallGit(this.isInstallGit())).withInstallDocker(this.isInstallDocker())).withInstallMaven(this.isInstallMaven())).withInstallQemu(this.isInstallQemu())).build();
    }

    public Descriptor<AzureVMAgentTemplate> getDescriptor() {
        return Jenkins.get().getDescriptor(this.getClass());
    }

    public Set<LabelAtom> getLabelDataSet() {
        return this.labelDataSet;
    }

    public RetentionStrategy getRetentionStrategy() {
        return this.retentionStrategy;
    }

    public int getMaximumDeploymentSize() {
        return this.maximumDeploymentSize;
    }

    @DataBoundSetter
    public void setMaximumDeploymentSize(int maximumDeploymentSize) {
        this.maximumDeploymentSize = maximumDeploymentSize;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    @DataBoundSetter
    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public AzureVMDeploymentInfo provisionAgents(TaskListener listener, int numberOfAgents) throws Exception {
        return this.getServiceDelegate().createDeployment(this, numberOfAgents);
    }

    private AzureVMManagementServiceDelegate getServiceDelegate() {
        return this.retrieveAzureCloudReference().getServiceDelegate();
    }

    public void handleTemplateProvisioningFailure(String message, FailureStage failureStep) {
        this.templateProvisionStrategy.failure();
        this.setTemplateStatusDetails(message);
    }

    public List<String> verifyTemplate() throws Exception {
        return this.getServiceDelegate().verifyTemplate(this.templateName, this.labels, this.location, this.virtualMachineSize, this.storageAccountName, this.storageAccountType, "" + this.noOfParallelJobs, this.imageTopLevelType, this.imageReference, this.builtInImage, this.osType, this.launcher, this.initScript, this.credentialsId, this.virtualNetworkName, this.virtualNetworkResourceGroupName, this.subnetName, (AzureVMCloudBaseRetentionStrategy)this.retentionStrategy, this.jvmOptions, this.getResourceGroupName(), true, this.usePrivateIP, this.nsgName);
    }

    @POST
    public HttpResponse doDoDelete(@AncestorInPath AzureVMCloud azureVMCloud) throws IOException {
        Jenkins j = Jenkins.get();
        j.checkPermission(Jenkins.ADMINISTER);
        if (azureVMCloud == null) {
            throw new IllegalStateException("Cloud could not be found");
        }
        azureVMCloud.removeTemplate(this);
        j.save();
        return new HttpRedirect("../../templates");
    }

    @POST
    public HttpResponse doConfigSubmit(StaplerRequest2 req, @AncestorInPath AzureVMCloud azureVMCloud) throws IOException, ServletException, Descriptor.FormException {
        Jenkins j = Jenkins.get();
        j.checkPermission(Jenkins.ADMINISTER);
        if (azureVMCloud == null) {
            throw new IllegalStateException("Cloud could not be found");
        }
        azureVMCloud.removeTemplate(this);
        AzureVMAgentTemplate newTemplate = this.reconfigure(req, req.getSubmittedForm());
        if (StringUtils.isBlank((CharSequence)newTemplate.getTemplateName())) {
            throw new Descriptor.FormException("Template name is mandatory", "templateName");
        }
        boolean templateNameExists = azureVMCloud.templateNameExists(newTemplate.getTemplateName());
        if (templateNameExists) {
            throw new Descriptor.FormException("Agent template name must be unique", "templateName");
        }
        azureVMCloud.addTemplate(newTemplate);
        j.save();
        return FormApply.success((String)"../../templates");
    }

    private AzureVMAgentTemplate reconfigure(@NonNull StaplerRequest2 req, JSONObject form) throws Descriptor.FormException {
        if (form == null) {
            return null;
        }
        return (AzureVMAgentTemplate)this.getDescriptor().newInstance(req, form);
    }

    public void setVirtualMachineDetails(AzureVMAgent agent) throws Exception {
        this.getServiceDelegate().setVirtualMachineDetails(agent, this);
    }

    public static String generateUniqueStorageAccountName(String resourceGroupName, String templateName) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (null != templateName) {
                md.update(templateName.getBytes(StandardCharsets.UTF_8));
            }
            if (null != resourceGroupName) {
                md.update(resourceGroupName.getBytes(StandardCharsets.UTF_8));
            }
            String uid = Base64.getEncoder().encodeToString(md.digest());
            uid = uid.substring(0, 22);
            uid = uid.toLowerCase();
            uid = uid.replaceAll("[^a-z0-9]", "a");
            return "jn" + uid;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.WARNING, "Could not generate UID from the resource group name. Will fallback on using the resource group name.", e);
            return "";
        }
    }

    public static class ImageReferenceTypeClass
    implements Serializable {
        private String uri;
        private String id;
        private String publisher;
        private String offer;
        private String sku;
        private String version;
        private String galleryName;
        private String galleryImageDefinition;
        private String galleryImageVersion;
        private boolean galleryImageSpecialized;
        private String gallerySubscriptionId;
        private String galleryResourceGroup;
        private ImageReferenceType type;

        @DataBoundConstructor
        public ImageReferenceTypeClass(String uri, String id, String publisher, String offer, String sku, String version, String galleryName, String galleryImageDefinition, String galleryImageVersion, String gallerySubscriptionId, String galleryResourceGroup) {
            this.uri = uri;
            this.id = id;
            this.publisher = publisher;
            this.offer = offer;
            this.sku = sku;
            this.version = version;
            this.galleryName = galleryName;
            this.galleryImageDefinition = galleryImageDefinition;
            this.galleryImageVersion = galleryImageVersion;
            this.gallerySubscriptionId = gallerySubscriptionId;
            this.galleryResourceGroup = galleryResourceGroup;
            this.type = this.determineType();
        }

        private ImageReferenceTypeClass() {
            this.type = this.determineType();
        }

        private ImageReferenceType determineType() {
            if (Util.fixEmpty((String)this.uri) != null) {
                return ImageReferenceType.CUSTOM;
            }
            if (Util.fixEmpty((String)this.id) != null) {
                return ImageReferenceType.CUSTOM_IMAGE;
            }
            if (Util.fixEmpty((String)this.galleryName) != null) {
                return ImageReferenceType.GALLERY;
            }
            return ImageReferenceType.REFERENCE;
        }

        public ImageReferenceType getType() {
            return this.type;
        }

        public String getUri() {
            return this.uri;
        }

        public String getId() {
            return this.id;
        }

        public String getPublisher() {
            return this.publisher;
        }

        public String getOffer() {
            return this.offer;
        }

        public String getSku() {
            return this.sku;
        }

        public String getVersion() {
            return this.version;
        }

        public String getGalleryName() {
            return this.galleryName;
        }

        public String getGalleryImageDefinition() {
            return this.galleryImageDefinition;
        }

        public String getGalleryImageVersion() {
            return this.galleryImageVersion;
        }

        public boolean getGalleryImageSpecialized() {
            return this.galleryImageSpecialized;
        }

        @DataBoundSetter
        public void setGalleryImageSpecialized(boolean galleryImageSpecialized) {
            this.galleryImageSpecialized = galleryImageSpecialized;
        }

        public String getGallerySubscriptionId() {
            return this.gallerySubscriptionId;
        }

        public String getGalleryResourceGroup() {
            return this.galleryResourceGroup;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AzureVMAgentTemplate> {
        private static final Set<String> RECOMMENDED_IMAGES = Set.of("Standard_D2s_v3", "Standard_D4s_v3", "Standard_E2s_v3", "Standard_D2as_v4", "Standard_B2s", "Standard_B2ms", "Standard_DS2_v2", "Standard_B4ms", "Standard_DS3_v2");

        @NonNull
        public String getDisplayName() {
            return "";
        }

        public List<Descriptor<RetentionStrategy<?>>> getAzureVMRetentionStrategy() {
            ArrayList list = new ArrayList();
            list.add(AzureVMCloudRetensionStrategy.DESCRIPTOR);
            list.add(AzureVMCloudPoolRetentionStrategy.DESCRIPTOR);
            list.add(AzureVMCloudOnceRetentionStrategy.DESCRIPTOR);
            return list;
        }

        @POST
        public ListBoxModel doFillNsgNameItems(@QueryParameter(value="cloudName") String cloudName) {
            Jenkins.get().checkPermission(Jenkins.SYSTEM_READ);
            ListBoxModel model = new ListBoxModel();
            model.add("--- Select Network Security Group in current resource group ---", "");
            AzureVMCloud cloud = this.getAzureCloud(cloudName);
            if (cloud == null) {
                return model;
            }
            String azureCredentialsId = cloud.getAzureCredentialsId();
            if (StringUtils.isBlank((CharSequence)azureCredentialsId)) {
                return model;
            }
            String resourceGroupReferenceType = cloud.getResourceGroupReferenceType();
            String newResourceGroupName = cloud.getNewResourceGroupName();
            String existingResourceGroupName = cloud.getExistingResourceGroupName();
            try {
                AzureResourceManager azureClient = AzureResourceManagerCache.get((String)azureCredentialsId);
                if (azureClient == null) {
                    return model;
                }
                String resourceGroupName = AzureVMCloud.getResourceGroupName(resourceGroupReferenceType, newResourceGroupName, existingResourceGroupName);
                PagedIterable nsgs = azureClient.networkSecurityGroups().listByResourceGroup(resourceGroupName);
                for (NetworkSecurityGroup nsg : nsgs) {
                    model.add(nsg.name());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Cannot list availability set: ", e);
            }
            return model;
        }

        @POST
        public AutoCompletionCandidates doAutoCompleteVirtualMachineSize(@QueryParameter String cloudName, @QueryParameter String location, @QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.SYSTEM_READ);
            String azureCredentialsId = this.getAzureCredentialsIdFromCloud(cloudName);
            AutoCompletionCandidates model = new AutoCompletionCandidates();
            if (StringUtils.isBlank((CharSequence)azureCredentialsId)) {
                return model;
            }
            Set<String> vmSizes = AzureClientHolder.getDelegate(azureCredentialsId).getVMSizes(location);
            if (StringUtils.isBlank((CharSequence)value)) {
                vmSizes.stream().filter(RECOMMENDED_IMAGES::contains).forEach(arg_0 -> ((AutoCompletionCandidates)model).add(arg_0));
            } else {
                for (String vmSize : vmSizes) {
                    if (!vmSize.toLowerCase().contains(value.toLowerCase())) continue;
                    model.add(vmSize);
                }
            }
            return model;
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String credentialsId) {
            StandardListBoxModel model = new StandardListBoxModel();
            Jenkins context = Jenkins.get();
            if (!context.hasPermission(Jenkins.ADMINISTER)) {
                return model.includeCurrentValue(credentialsId);
            }
            return model.includeAs(ACL.SYSTEM, (ItemGroup)context, SSHUserPrivateKey.class).includeAs(ACL.SYSTEM, (ItemGroup)context, StandardUsernamePasswordCredentials.class);
        }

        @POST
        public ListBoxModel doFillOsTypeItems() throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            model.add("Linux");
            model.add("Windows");
            return model;
        }

        @POST
        public ListBoxModel doFillLicenseTypeItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("None");
            model.add("Windows_Client");
            model.add("Windows_Server");
            model.add("RHEL_BASE");
            model.add("RHEL_BYOS");
            model.add("RHEL_EUS");
            model.add("RHEL_SAPAPPS");
            model.add("RHEL_SAPHA");
            model.add("RHEL_BASESAPAPPS");
            model.add("RHEL_BASESAPHA");
            model.add("SLES");
            model.add("SLES_BYOS");
            model.add("SLES_SAP");
            model.add("SLES_HPC");
            return model;
        }

        public AzureAvailabilityType getDefaultAvailabilityType() {
            return new NoAvailabilityRequired();
        }

        private String getAzureCredentialsIdFromCloud(String cloudName) {
            AzureVMCloud cloud = this.getAzureCloud(cloudName);
            if (cloud != null) {
                return cloud.getAzureCredentialsId();
            }
            return null;
        }

        private AzureVMCloud getAzureCloud(String cloudName) {
            Cloud cloud = Jenkins.get().getCloud(cloudName);
            if (cloud instanceof AzureVMCloud) {
                return (AzureVMCloud)cloud;
            }
            return null;
        }

        @POST
        public ListBoxModel doFillLocationItems(@QueryParameter(value="cloudName") String cloudName) {
            Jenkins.get().checkPermission(Jenkins.SYSTEM_READ);
            String azureCredentialsId = this.getAzureCredentialsIdFromCloud(cloudName);
            ListBoxModel model = new ListBoxModel();
            if (StringUtils.isBlank((CharSequence)azureCredentialsId)) {
                return model;
            }
            AzureBaseCredentials credential = AzureCredentialUtil.getCredential(null, (String)azureCredentialsId);
            if (credential != null) {
                String envName = credential.getAzureEnvironmentName();
                String managementEndpoint = credential.getManagementEndpoint();
                AzureVMManagementServiceDelegate delegate = AzureClientHolder.getDelegate(azureCredentialsId);
                Set<String> locations = delegate.getVirtualMachineLocations(managementEndpoint != null ? managementEndpoint : envName);
                if (locations != null) {
                    TreeSet<String> sortedLocations = new TreeSet<String>(locations);
                    for (String location : sortedLocations) {
                        model.add(location);
                    }
                }
            }
            return model;
        }

        @Restricted(value={DoNotUse.class})
        public AzureComputerLauncher getDefaultComputerLauncher() {
            return new AzureSSHLauncher();
        }

        @POST
        public ListBoxModel doFillStorageAccountTypeItems(@QueryParameter String virtualMachineSize) {
            ListBoxModel model = new ListBoxModel();
            model.add("--- Select Storage Account Type ---", "");
            model.add(SkuName.STANDARD_LRS.toString());
            if (virtualMachineSize.matches(".*_[a-zA-Z]([0-9]+[aAMm]?[Ss]|[Ss][0-9]+).*")) {
                model.add(SkuName.PREMIUM_LRS.toString());
            }
            return model;
        }

        @POST
        public ListBoxModel doFillOsDiskStorageAccountTypeItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("--- Select Storage Account Type ---", "");
            model.add(DiskSkuTypes.STANDARD_LRS.toString());
            model.add(DiskSkuTypes.STANDARD_SSD_LRS.toString());
            model.add(DiskSkuTypes.PREMIUM_LRS.toString());
            return model;
        }

        @POST
        public ListBoxModel doFillUsageModeItems() throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            for (Node.Mode m : Functions.getNodeModes()) {
                model.add(m.getDescription(), m.getName());
            }
            return model;
        }

        @POST
        public ListBoxModel doFillExistingStorageAccountNameItems(@QueryParameter(value="cloudName") String cloudName, @QueryParameter String storageAccountType) {
            Jenkins.get().checkPermission(Jenkins.SYSTEM_READ);
            AzureVMCloud cloud = this.getAzureCloud(cloudName);
            ListBoxModel model = new ListBoxModel();
            if (cloud == null) {
                return model;
            }
            String azureCredentialsId = cloud.getAzureCredentialsId();
            if (StringUtils.isBlank((CharSequence)azureCredentialsId)) {
                return model;
            }
            String resourceGroupReferenceType = cloud.getResourceGroupReferenceType();
            String newResourceGroupName = cloud.getNewResourceGroupName();
            String existingResourceGroupName = cloud.getExistingResourceGroupName();
            try {
                AzureResourceManager azureClient = AzureResourceManagerCache.get((String)azureCredentialsId);
                if (azureClient == null) {
                    return model;
                }
                String resourceGroupName = AzureVMCloud.getResourceGroupName(resourceGroupReferenceType, newResourceGroupName, existingResourceGroupName);
                PagedIterable storageAccountList = azureClient.storageAccounts().listByResourceGroup(resourceGroupName);
                for (StorageAccount storageAccount : storageAccountList) {
                    if (!storageAccount.skuType().name().toString().equalsIgnoreCase(storageAccountType)) continue;
                    model.add(storageAccount.name());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Cannot list storage account: ", e);
            }
            return model;
        }

        @POST
        public ListBoxModel doFillBuiltInImageItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Ubuntu 24.04 LTS");
            model.add("Ubuntu 22.04 LTS");
            model.add("Ubuntu 20.04 LTS");
            model.add("Windows Server 2025");
            model.add("Windows Server 2022");
            model.add("Windows Server 2019");
            model.add("Windows Server 2016");
            return model;
        }

        @POST
        public FormValidation doCheckStorageAccountType(@QueryParameter String value, @QueryParameter String diskType) {
            if ("managed".equals(diskType) && SkuName.PREMIUM_LRS.toString().equals(value)) {
                return FormValidation.warning((String)Messages.Azure_GC_Template_StorageAccountType());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckSshConfig(@QueryParameter String value) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (!StringUtils.isBlank((CharSequence)value)) {
                try {
                    OpenSSHConfig.parse((String)value);
                }
                catch (IOException e) {
                    return FormValidation.warningWithMarkup((String)Messages.Ssh_Config_Invalid());
                }
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckInitScript(@QueryParameter String value, @QueryParameter String agentLaunchMethod, @QueryParameter String imageTopLevelType) {
            if ("basic".equals(imageTopLevelType)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((CharSequence)value)) {
                return FormValidation.okWithMarkup((String)Messages.Azure_GC_InitScript_Warn_Msg());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckStorageAccountName(@QueryParameter String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return FormValidation.ok((String)Messages.SA_Blank_Create_New());
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillDiskTypeItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Managed Disk", "managed");
            model.add("Unmanaged Disk", "unmanaged");
            return model;
        }

        @POST
        public FormValidation doAgentLaunchMethod(@QueryParameter String value) {
            if ("JNLP".equals(value)) {
                return FormValidation.warning((String)Messages.Azure_GC_LaunchMethod_Warn_Msg());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckTemplateName(@QueryParameter String value, @QueryParameter boolean templateDisabled, @QueryParameter String osType) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            ArrayList<FormValidation> errors = new ArrayList<FormValidation>();
            if (StringUtils.isBlank((CharSequence)value)) {
                return FormValidation.ok();
            }
            if (!AzureUtil.isValidTemplateName(value)) {
                errors.add(FormValidation.error((String)Messages.Azure_GC_Template_Name_Not_Valid()));
            }
            if (templateDisabled) {
                errors.add(FormValidation.warning((String)Messages.Azure_GC_TemplateStatus_Warn_Msg()));
            }
            if (!errors.isEmpty()) {
                return FormValidation.aggregate(errors);
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckNoOfParallelJobs(@QueryParameter String value) {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                String result = AzureVMManagementServiceDelegate.verifyNoOfExecutors(value);
                if (result.equalsIgnoreCase("Success")) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)result);
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckAdminPassword(@QueryParameter String value) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (StringUtils.isNotBlank((CharSequence)value)) {
                if (AzureUtil.isValidPassword(value)) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)Messages.Azure_GC_Password_Err());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckJvmOptions(@QueryParameter String value) {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                if (AzureUtil.isValidJvmOption(value)) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)Messages.Azure_GC_JVM_Option_Err());
            }
            return FormValidation.ok();
        }

        public List<NodePropertyDescriptor> getNodePropertyDescriptors() {
            return NodePropertyDescriptor.for_((List)NodeProperty.all(), AzureVMAgent.class);
        }

        @POST
        public FormValidation doVerifyConfiguration(@QueryParameter String cloudName, @QueryParameter String templateName, @QueryParameter String labels, @QueryParameter String location, @QueryParameter String virtualMachineSize, @QueryParameter String storageAccountNameReferenceType, @QueryParameter String newStorageAccountName, @QueryParameter String existingStorageAccountName, @QueryParameter boolean useEntraIdForStorageAccount, @QueryParameter String uamiID, @QueryParameter String storageAccountType, @QueryParameter String noOfParallelJobs, @QueryParameter String imageTopLevelType, @QueryParameter String builtInImage, @QueryParameter(value="uri") String imageUri, @QueryParameter String osType, @QueryParameter(value="id") String imageId, @QueryParameter(value="publisher") String imagePublisher, @QueryParameter(value="offer") String imageOffer, @QueryParameter(value="sku") String imageSku, @QueryParameter(value="version") String imageVersion, @QueryParameter String galleryName, @QueryParameter String galleryImageDefinition, @QueryParameter String galleryImageVersion, @QueryParameter String gallerySubscriptionId, @QueryParameter String galleryResourceGroup, @RelativePath(value="..") @QueryParameter String sshConfig, @QueryParameter String initScript, @QueryParameter String credentialsId, @QueryParameter String virtualNetworkName, @QueryParameter String virtualNetworkResourceGroupName, @QueryParameter String subnetName, @QueryParameter boolean usePrivateIP, @QueryParameter String nsgName, @QueryParameter String jvmOptions) {
            List<String> errors;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            ImageReferenceTypeClass image = new ImageReferenceTypeClass(imageUri, imageId, imagePublisher, imageOffer, imageSku, imageVersion, galleryName, galleryImageDefinition, galleryImageVersion, gallerySubscriptionId, galleryResourceGroup);
            AzureVMCloud cloud = (AzureVMCloud)Jenkins.get().getCloud(cloudName);
            String storageAccountName = AzureVMAgentTemplate.getStorageAccountName(storageAccountNameReferenceType, newStorageAccountName, existingStorageAccountName);
            if (storageAccountName.trim().isEmpty()) {
                storageAccountName = AzureVMAgentTemplate.generateUniqueStorageAccountName(cloud.getResourceGroupName(), templateName);
            }
            LOGGER.log(Level.INFO, AzureVMAgentTemplate.VALIDATE_DEPLOYMENT_TEMPLATE_MESSAGE, new Object[]{"", "", "", "", cloud.getResourceGroupName(), templateName, labels, location, virtualMachineSize, storageAccountName, noOfParallelJobs, imageTopLevelType, builtInImage, imageUri, osType, imageId, imagePublisher, imageOffer, imageSku, imageVersion, sshConfig, initScript, credentialsId, virtualNetworkName, virtualNetworkResourceGroupName, subnetName, usePrivateIP, nsgName, jvmOptions, galleryName, galleryImageDefinition, galleryImageVersion, galleryResourceGroup, gallerySubscriptionId});
            AzureVMManagementServiceDelegate delegate = AzureClientHolder.getDelegate(cloud.getAzureCredentialsId());
            if (delegate == null) {
                return FormValidation.error((String)"Azure credentials are not configured or are invalid.");
            }
            String result = delegate.verifyConfiguration(cloud.getResourceGroupName(), "existing".equals(cloud.getResourceGroupReferenceType()), String.valueOf(cloud.getDeploymentTimeout()));
            if (!result.equals("Success")) {
                return FormValidation.error((String)result);
            }
            if (useEntraIdForStorageAccount && StringUtils.isBlank((CharSequence)uamiID)) {
                return FormValidation.error((String)"If using Entra ID authentication for storage account user assigned managed identity must be enabled as well.");
            }
            AzureSSHLauncher azureComputerLauncher = new AzureSSHLauncher();
            if (StringUtils.isNotBlank((CharSequence)sshConfig)) {
                azureComputerLauncher.setSshConfig(sshConfig);
            }
            if (!(errors = delegate.verifyTemplate(templateName, labels, location, virtualMachineSize, storageAccountName, storageAccountType, noOfParallelJobs, imageTopLevelType, image, builtInImage, osType, azureComputerLauncher, initScript, credentialsId, virtualNetworkName, virtualNetworkResourceGroupName, subnetName, new AzureVMCloudRetensionStrategy(0), jvmOptions, cloud.getResourceGroupName(), false, usePrivateIP, nsgName)).isEmpty()) {
                StringBuilder errorString = new StringBuilder(Messages.Azure_GC_Template_Error_List()).append("\n");
                for (int i = 0; i < errors.size(); ++i) {
                    errorString.append(i + 1).append(": ").append(errors.get(i)).append("\n");
                }
                return FormValidation.error((String)errorString.toString());
            }
            return FormValidation.ok((String)Messages.Azure_Template_Config_Success());
        }

        public String getDefaultNoOfExecutors() {
            return "1";
        }
    }
}

