/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.ssh.ChannelOpenException;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.ExecutorOperationQueues;
import com.sshtools.common.ssh.ExecutorOperationSupport;
import com.sshtools.common.ssh.GlobalRequest;
import com.sshtools.common.ssh.UnsupportedChannelException;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.synergy.ssh.ChannelNG;
import com.sshtools.synergy.ssh.Connection;
import com.sshtools.synergy.ssh.ConnectionTaskWrapper;
import com.sshtools.synergy.ssh.GlobalRequestHandler;
import com.sshtools.synergy.ssh.Service;
import com.sshtools.synergy.ssh.SshContext;
import com.sshtools.synergy.ssh.TransportProtocol;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ConnectionProtocol<T extends SshContext>
extends ExecutorOperationSupport<SshContext>
implements Service {
    private static final Integer CHANNEL_DATA_IN = ExecutorOperationQueues.generateUniqueQueue((String)"ConnectionProtocol.channelDataIn");
    TransportProtocol<T> transport;
    static final int SSH_MSG_GLOBAL_REQUEST = 80;
    static final int SSH_MSG_GLOBAL_REQUEST_SUCCESS = 81;
    static final int SSH_MSG_GLOBAL_REQUEST_FAILURE = 82;
    static final int SSH_MSG_CHANNEL_OPEN = 90;
    static final int SSH_MSG_CHANNEL_OPEN_CONFIRMATION = 91;
    static final int SSH_MSG_CHANNEL_OPEN_FAILURE = 92;
    static final int SSH_MSG_CHANNEL_WINDOW_ADJUST = 93;
    static final int SSH_MSG_CHANNEL_DATA = 94;
    static final int SSH_MSG_CHANNEL_EXTENDED_DATA = 95;
    static final int SSH_MSG_CHANNEL_EOF = 96;
    static final int SSH_MSG_CHANNEL_CLOSE = 97;
    static final int SSH_MSG_CHANNEL_REQUEST = 98;
    static final int SSH_MSG_CHANNEL_SUCCESS = 99;
    static final int SSH_MSG_CHANNEL_FAILURE = 100;
    public static final String SERVICE_NAME = "ssh-connection";
    Set<Integer> channeIdPool = new HashSet<Integer>();
    Map<Integer, ChannelNG<T>> activeChannels = new ConcurrentHashMap<Integer, ChannelNG<T>>(8, 0.9f, 1);
    Map<String, GlobalRequestHandler<T>> globalRequestHandlers = new ConcurrentHashMap<String, GlobalRequestHandler<T>>(8, 0.9f, 1);
    GlobalRequest currentRequest = null;
    protected String username;
    protected Connection<T> con;

    public ConnectionProtocol(TransportProtocol<T> transport, String username) {
        super("connection-protocol");
        this.username = username;
        this.transport = transport;
        this.con = transport.getConnection();
        for (int i = 0; i < ((SshContext)transport.getSshContext()).getChannelLimit(); ++i) {
            this.channeIdPool.add(i);
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Initialized MaxChannels=" + String.valueOf(((SshContext)transport.getSshContext()).getChannelLimit())), (Object[])new Object[0]);
        }
    }

    public void addGlobalRequestHandler(GlobalRequestHandler<T> handler) {
        if (handler != null) {
            String[] requests = handler.supportedRequests();
            for (int i = 0; i < requests.length; ++i) {
                this.globalRequestHandlers.put(requests[i], handler);
            }
        }
    }

    public SocketAddress getRemoteAddress() {
        return this.transport.getSocketConnection().getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.transport.getSocketConnection().getLocalAddress();
    }

    public int getLocalPort() {
        return this.transport.getSocketConnection().getLocalPort();
    }

    public String getUsername() {
        return this.username;
    }

    protected abstract void onStop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.onStop();
        if (this.activeChannels != null) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Cleaning up connection protocol references", (Object[])new Object[0]);
            }
            Map<Integer, ChannelNG<T>> map = this.activeChannels;
            synchronized (map) {
                for (ChannelNG<T> channel : this.activeChannels.values()) {
                    try {
                        channel.close(true);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    public String getSessionIdentifier() {
        return this.transport.getUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int allocateChannel(ChannelNG<T> channel) {
        Map<Integer, ChannelNG<T>> map = this.activeChannels;
        synchronized (map) {
            if (this.channeIdPool.size() == 0) {
                return -1;
            }
            Integer channelId = this.channeIdPool.iterator().next();
            this.channeIdPool.remove(channelId);
            this.activeChannels.put(channelId, channel);
            return channelId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeChannel(ChannelNG<T> channel) {
        Map<Integer, ChannelNG<T>> map = this.activeChannels;
        synchronized (map) {
            if (channel != null) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Freeing channel=" + String.valueOf(channel.getLocalId())), (Object[])new Object[0]);
                }
                Integer channelId = channel.getLocalId();
                this.activeChannels.remove(channelId);
                this.channeIdPool.add(channelId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openChannel(ChannelNG<T> channel) {
        channel.init(this);
        ChannelNG<T> channelNG = channel;
        synchronized (channelNG) {
            try {
                int channelid = this.allocateChannel(channel);
                if (channelid == -1) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Failed to allocate channel {}", (Object[])new Object[]{channel.getChannelType()});
                    }
                    channel.getOpenFuture().done(false);
                    return;
                }
                this.transport.postMessage(new ChannelOpenMessage(channel, channel.create(channelid)));
            }
            catch (IOException ex1) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Failed to open channel {}", (Throwable)ex1, (Object[])new Object[]{channel.getChannelType()});
                }
                channel.getOpenFuture().done(false);
            }
        }
    }

    boolean isConnected() {
        return this.transport.isConnected();
    }

    void sendMessage(SshMessage msg) {
        this.transport.postMessage(msg);
    }

    public List<ChannelNG<T>> getActiveChannels() {
        return new ArrayList<ChannelNG<T>>(this.activeChannels.values());
    }

    public int getMaxChannels() {
        return ((SshContext)this.transport.getSshContext()).getChannelLimit();
    }

    public void disconnect() {
        this.close(11, "User Disconnected");
    }

    void close(int reason, String description) {
        this.transport.disconnect(reason, description);
    }

    @Override
    public boolean processMessage(byte[] msg) throws IOException {
        switch (msg[0]) {
            case 90: {
                this.processChannelOpen(msg);
                return true;
            }
            case 91: {
                this.processChannelOpenConfirmation(msg);
                return true;
            }
            case 92: {
                this.processChannelOpenFailure(msg);
                return true;
            }
            case 98: {
                this.processChannelRequest(msg);
                return true;
            }
            case 94: {
                this.processChannelData(msg);
                return true;
            }
            case 95: {
                this.processChannelData(msg);
                return true;
            }
            case 93: {
                this.processChannelWindowAdjust(msg);
                return true;
            }
            case 96: {
                this.processChannelEOF(msg);
                return true;
            }
            case 97: {
                this.processChannelClose(msg);
                return true;
            }
            case 80: {
                this.processGlobalRequest(msg);
                return true;
            }
            case 82: {
                this.processGlobalRequestFailure(msg);
                return true;
            }
            case 81: {
                this.processGlobalRequestSuccess(msg);
                return true;
            }
            case 99: {
                this.processChannelRequestResponse(true, msg);
                return true;
            }
            case 100: {
                this.processChannelRequestResponse(false, msg);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processGlobalRequestSuccess(byte[] m) {
        block13: {
            ByteArrayReader msg = new ByteArrayReader(m);
            msg.skip(1L);
            try {
                if (Objects.nonNull(this.currentRequest)) {
                    GlobalRequest globalRequest = this.currentRequest;
                    synchronized (globalRequest) {
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)("Received SSH_MSG_GLOBAL_REQUEST_SUCCESS for " + this.currentRequest.getName()), (Object[])new Object[0]);
                        }
                        if (msg.available() > 0) {
                            byte[] tmp = new byte[msg.available()];
                            try {
                                msg.readFully(tmp);
                                this.currentRequest.setData(tmp);
                            }
                            catch (IOException e) {
                                Log.error((String)("Unexpected error reading global request " + this.currentRequest.getName() + " response"), (Object[])new Object[0]);
                            }
                        } else {
                            this.currentRequest.setData(new byte[0]);
                        }
                        this.currentRequest.complete(true);
                        break block13;
                    }
                }
                if (Log.isDebugEnabled()) {
                    Log.warn((String)"Received SSH_MSG_GLOBAL_REQUEST_SUCCESS but there was no request object waiting. Did the request timeout?", (Object[])new Object[0]);
                }
            }
            finally {
                msg.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processGlobalRequestFailure(byte[] msg) {
        if (Objects.nonNull(this.currentRequest)) {
            GlobalRequest globalRequest = this.currentRequest;
            synchronized (globalRequest) {
                try {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("Received SSH_MSG_GLOBAL_REQUEST_FAILURE for " + this.currentRequest.getName()), (Object[])new Object[0]);
                    }
                    this.currentRequest.complete(false);
                }
                finally {
                    this.currentRequest = null;
                }
            }
        }
        if (Log.isDebugEnabled()) {
            Log.warn((String)"Received SSH_MSG_GLOBAL_REQUEST_FAILURE but there was no request object waiting. Did the request timeout?", (Object[])new Object[0]);
        }
    }

    private void processChannelRequestResponse(boolean success, byte[] msg) {
        ByteArrayReader bar = new ByteArrayReader(msg);
        bar.skip(1L);
        try {
            int channelid = (int)bar.readInt();
            ChannelNG<T> channel = this.getChannel(channelid);
            if (channel == null) {
                if (Log.isErrorEnabled()) {
                    Log.error((String)"Channel response received with invalid channel id {}", (Object[])new Object[]{channelid});
                }
            } else {
                channel.processChannelRequestResponse(success);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            bar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processGlobalRequest(byte[] msg) throws IOException {
        try (ByteArrayReader bar = new ByteArrayReader(msg);){
            bar.skip(1L);
            String name = bar.readString();
            boolean wantreply = bar.read() != 0;
            boolean success = false;
            ByteArrayWriter response = new ByteArrayWriter();
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Received SSH_MSG_GLOBAL_REQUEST request=" + name + " wantReply=" + wantreply), (Object[])new Object[0]);
            }
            if (name.equals("tcpip-forward")) {
                if (this.processTCPIPForward(bar, response)) {
                    success = true;
                }
            } else if (name.equals("cancel-tcpip-forward")) {
                if (this.processTCPIPCancel(bar, response)) {
                    success = true;
                }
            } else if (name.equals("ping@sshtools.com")) {
                success = true;
            } else {
                GlobalRequestHandler<SshContext> handler = this.getContext().getGlobalRequestHandler(name);
                if (handler == null) {
                    handler = this.globalRequestHandlers.get(name);
                }
                if (handler != null) {
                    byte[] requestdata = new byte[bar.available()];
                    bar.read(requestdata);
                    GlobalRequest request = new GlobalRequest(name, this.con, requestdata);
                    try {
                        success = handler.processGlobalRequest(request, this, wantreply, response);
                    }
                    catch (GlobalRequestHandler.GlobalRequestHandlerException globalRequestHandlerException) {
                        // empty catch block
                    }
                }
            }
            if (wantreply) {
                if (success) {
                    this.sendGlobalRequestSuccess(name, response.toByteArray());
                } else {
                    this.sendGlobalRequestFailure(name);
                }
            }
        }
    }

    protected abstract boolean processTCPIPCancel(ByteArrayReader var1, ByteArrayWriter var2) throws IOException;

    protected abstract boolean processTCPIPForward(ByteArrayReader var1, ByteArrayWriter var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processChannelData(byte[] msg) throws IOException {
        block8: {
            try (final ByteArrayReader bar = new ByteArrayReader(msg);){
                int messageid = bar.read();
                int channelid = (int)bar.readInt();
                final ChannelNG<T> channel = this.getChannel(channelid);
                if (channel == null) {
                    if (Log.isErrorEnabled()) {
                        Log.error((String)"Channel data received with invalid channel id {}", (Object[])new Object[]{channelid});
                    }
                    break block8;
                }
                try {
                    if (messageid == 94) {
                        final int count = (int)bar.readInt();
                        this.addTask(CHANNEL_DATA_IN, new ConnectionAwareTask(this.con){

                            protected void doTask() throws Throwable {
                                channel.processChannelData(ByteBuffer.wrap(bar.array(), bar.getPosition(), count));
                            }
                        });
                        break block8;
                    }
                    final int type = (int)bar.readInt();
                    final int count = (int)bar.readInt();
                    this.addTask(CHANNEL_DATA_IN, new ConnectionAwareTask(this.con){

                        protected void doTask() throws Throwable {
                            channel.processExtendedData(type, ByteBuffer.wrap(bar.array(), bar.getPosition(), count));
                        }
                    });
                }
                catch (IOException ex) {
                    Log.error((String)"Error processing channel data", (Throwable)ex, (Object[])new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processChannelWindowAdjust(byte[] msg) throws IOException {
        ByteArrayReader bar = new ByteArrayReader(msg);
        bar.skip(1L);
        try {
            int channelid = (int)bar.readInt();
            UnsignedInteger32 count = bar.readUINT32();
            ChannelNG<T> channel = this.getChannel(channelid);
            if (channel == null) {
                if (Log.isErrorEnabled()) {
                    Log.error((String)"Channel window adjust received with invalid channel id {}", (Object[])new Object[]{channelid});
                }
            } else {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Received SSH_MSG_CHANNEL_WINDOW_ADJUST channel=" + channelid + " remote=" + channel.remoteid + " adjust=" + count), (Object[])new Object[0]);
                }
                channel.adjustWindow(count);
            }
        }
        finally {
            bar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processChannelEOF(byte[] msg) throws IOException {
        ByteArrayReader bar = new ByteArrayReader(msg);
        bar.skip(1L);
        try {
            final int channelid = (int)bar.readInt();
            final ChannelNG<T> channel = this.getChannel(channelid);
            if (channel == null) {
                if (Log.isErrorEnabled()) {
                    Log.error((String)"Channel EOF received with invalid channel id {}", (Object[])new Object[]{channelid});
                }
            } else {
                this.addTask(CHANNEL_DATA_IN, new ConnectionAwareTask(this.con){

                    protected void doTask() throws Throwable {
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)("Received SSH_MSG_CHANNEL_EOF channel=" + channelid + " remote=" + channel.remoteid), (Object[])new Object[0]);
                        }
                        channel.processChannelEOF();
                    }
                });
            }
        }
        finally {
            bar.close();
        }
    }

    ChannelNG<T> getChannel(int channelid) {
        return this.activeChannels.get(channelid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processChannelClose(byte[] msg) throws IOException {
        ByteArrayReader bar = new ByteArrayReader(msg);
        bar.skip(1L);
        try {
            final int channelid = (int)bar.readInt();
            final ChannelNG<T> channel = this.getChannel(channelid);
            if (channel == null) {
                if (Log.isErrorEnabled()) {
                    Log.error((String)"Channel close received with invalid channel id {}", (Object[])new Object[]{channelid});
                }
            } else {
                this.addTask(CHANNEL_DATA_IN, new ConnectionAwareTask(this.con){

                    protected void doTask() throws Throwable {
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)("Received SSH_MSG_CHANNEL_CLOSE channel=" + channelid + " remote=" + channel.remoteid), (Object[])new Object[0]);
                        }
                        channel.processChannelClose();
                    }
                });
            }
        }
        finally {
            bar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processChannelOpenConfirmation(byte[] msg) throws IOException {
        block12: {
            ByteArrayReader bar = new ByteArrayReader(msg);
            bar.skip(1L);
            try {
                int channelid = (int)bar.readInt();
                ChannelNG<T> channel = this.getChannel(channelid);
                if (channel == null) {
                    if (Log.isErrorEnabled()) {
                        Log.error((String)"Channel confirmation received with invalid channel id {}", (Object[])new Object[]{channelid});
                    }
                    break block12;
                }
                int remoteid = (int)bar.readInt();
                UnsignedInteger32 remotewindow = bar.readUINT32();
                int remotepacket = (int)bar.readInt();
                byte[] responsedata = null;
                if (bar.available() > 0) {
                    responsedata = new byte[bar.available()];
                    bar.read(responsedata);
                }
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Received SSH_MSG_CHANNEL_OPEN_CONFIRMATION channel=" + channelid + " remote=" + remoteid + " remotepacket=" + remotepacket + " remotewindow=" + remotewindow), (Object[])new Object[0]);
                }
                if (remotepacket < 4096) {
                    this.transport.postMessage(new ChannelFailureMessage(remoteid, 1, "Maximum remote packet size must be >= 4096 bytes"));
                    return;
                }
                ChannelNG<T> channelNG = channel;
                synchronized (channelNG) {
                    channel.confirmOpen(remoteid, remotewindow, remotepacket);
                }
            }
            finally {
                bar.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processChannelOpenFailure(byte[] msg) throws IOException {
        block9: {
            ByteArrayReader bar = new ByteArrayReader(msg);
            bar.skip(1L);
            try {
                int channelid = (int)bar.readInt();
                ChannelNG<T> channel = this.getChannel(channelid);
                if (channel == null) {
                    if (Log.isErrorEnabled()) {
                        Log.error((String)"Channel open failure received with invalid channel id {}", (Object[])new Object[]{channelid});
                    }
                    break block9;
                }
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Received SSH_MSG_CHANNEL_OPEN_FAILURE channel=" + channelid), (Object[])new Object[0]);
                }
                ChannelNG<T> channelNG = channel;
                synchronized (channelNG) {
                    channel.fail();
                    this.freeChannel(channel);
                }
            }
            finally {
                bar.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    void processChannelOpen(byte[] msg) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract ChannelNG<T> createChannel(String var1, Connection<T> var2) throws UnsupportedChannelException, PermissionDeniedException, ChannelOpenException;

    public void sendGlobalRequest(GlobalRequest request) {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Sending SSH_MSG_GLOBAL_REQUEST request={} wantReply=false", (Object[])new Object[]{request.getName()});
        }
        this.transport.postMessage(new GlobalRequestMessage(request, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendGlobalRequestAndWait(GlobalRequest request, long timeout) {
        GlobalRequest globalRequest = request;
        synchronized (globalRequest) {
            try {
                if (Objects.nonNull(this.currentRequest)) {
                    Log.warn((String)"Request to send {} will override an existing request {}!", (Object[])new Object[]{request.getName(), this.currentRequest.getName()});
                }
                this.currentRequest = request;
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Sending SSH_MSG_GLOBAL_REQUEST request={} wantReply=true", (Object[])new Object[]{request.getName()});
                }
                this.transport.postMessage(new GlobalRequestMessage(request, true));
                request.waitFor(timeout);
            }
            finally {
                this.currentRequest = null;
            }
        }
    }

    public int getQueueSize() {
        return this.transport.getQueueSizes();
    }

    public void sendChannelOpenConfirmation(ChannelNG<T> channel, byte[] responsedata) {
        this.transport.postMessage(new ChannelOpenConfirmationMessage(channel, responsedata));
        channel.confirmOpen();
    }

    public void sendChannelOpenFailure(ChannelNG<T> channel, int reason, String desc) {
        this.transport.postMessage(new ChannelFailureMessage(channel.getRemoteId(), reason, desc));
        this.freeChannel(channel);
    }

    void sendGlobalRequestSuccess(String name, byte[] responsedata) {
        this.transport.postMessage(new GlobalRequestSuccess(name, responsedata));
    }

    void sendGlobalRequestFailure(String name) {
        this.transport.postMessage(new GlobalRequestFailure(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processChannelRequest(byte[] msg) throws IOException {
        ByteArrayReader bar = new ByteArrayReader(msg);
        bar.skip(1L);
        try {
            ChannelNG<T> channel;
            int channelid = (int)bar.readInt();
            String requesttype = bar.readString();
            boolean wantreply = bar.read() != 0;
            byte[] requestdata = null;
            if (bar.available() > 0) {
                requestdata = new byte[bar.available()];
                bar.read(requestdata);
            }
            if ((channel = this.getChannel(channelid)) != null) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Received SSH_MSG_CHANNEL_REQUEST '" + requesttype + "' channel=" + channelid + "  remote=" + channel.remoteid), (Object[])new Object[0]);
                }
                channel.onChannelRequest(requesttype, wantreply, requestdata);
            } else if (Log.isErrorEnabled()) {
                Log.error((String)"Channel request received with invalid channel id {}", (Object[])new Object[]{channelid});
            }
        }
        finally {
            bar.close();
        }
    }

    public T getContext() {
        return this.transport.getSshContext();
    }

    public TransportProtocol<T> getTransport() {
        return this.transport;
    }

    @Override
    public void start() {
        this.onStart();
    }

    protected abstract void onStart();

    public String getUUID() {
        return this.getSessionIdentifier();
    }

    @Override
    public int getIdleTimeoutSeconds() {
        return this.transport.getContext().getKeepAliveInterval();
    }

    @Override
    public boolean idle() {
        for (ChannelNG<T> c : this.activeChannels.values()) {
            try {
                if (Log.isDebugEnabled()) {
                    c.log();
                }
                if (c.getTimeout() <= 0 || System.currentTimeMillis() - c.getLastActivity() <= (long)c.getTimeout()) continue;
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Closing idle channel channel={} remote={}", (Object[])new Object[]{c.getLocalId(), c.getRemoteId()});
                }
                c.close(true);
            }
            catch (Throwable t) {
                Log.error((String)"Error processing channel idle", (Throwable)t, (Object[])new Object[0]);
            }
        }
        if (this.getContext().getIdleConnectionTimeoutSeconds() == 0) {
            this.addTask(ExecutorOperationSupport.CALLBACKS, new ConnectionTaskWrapper(this.getConnection(), new Runnable(){

                @Override
                public void run() {
                    GlobalRequest global = new GlobalRequest("ping@sshtools.com", ConnectionProtocol.this.con, null);
                    long timeout = Long.parseLong(System.getProperty("maverick.pingTimeout", "60000"));
                    ConnectionProtocol.this.sendGlobalRequestAndWait(global, timeout);
                    if (!global.isDone()) {
                        if (Log.isInfoEnabled()) {
                            Log.error((String)"Remote node did not respond to the ping within the timeout period {}ms!", (Object[])new Object[]{timeout});
                        }
                        ConnectionProtocol.this.getTransport().kill();
                    } else if (Log.isDebugEnabled()) {
                        Log.debug((String)"Remote node successfully responded to the ping.", (Object[])new Object[0]);
                    }
                }
            }));
        }
        return false;
    }

    protected abstract boolean isClient();

    public Connection<T> getConnection() {
        return this.con;
    }

    @Override
    public String getIdleLog() {
        return String.format("%d channels currently open", this.activeChannels.size());
    }

    class ChannelOpenMessage
    implements SshMessage {
        ChannelNG<T> channel;
        byte[] requestdata;

        ChannelOpenMessage(ChannelNG<T> channel, byte[] requestdata) {
            this.channel = channel;
            this.requestdata = requestdata;
        }

        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
            buf.put((byte)90);
            buf.putInt(this.channel.getChannelType().length());
            buf.put(this.channel.getChannelType().getBytes());
            buf.putInt(this.channel.getLocalId());
            buf.put(ByteArrayWriter.encodeInt((UnsignedInteger32)this.channel.getLocalWindow()));
            buf.putInt(this.channel.getLocalPacket());
            if (this.requestdata != null) {
                buf.put(this.requestdata);
            }
            return true;
        }

        public void messageSent(Long sequenceNo) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Sent SSH_MSG_CHANNEL_OPEN channel=" + this.channel.getLocalId() + " channelType=" + this.channel.getChannelType()), (Object[])new Object[0]);
            }
        }
    }

    class ChannelFailureMessage
    implements SshMessage {
        int remoteid;
        int reasoncode;
        String description;

        ChannelFailureMessage(int remoteid, int reasoncode, String description) {
            this.remoteid = remoteid;
            this.reasoncode = reasoncode;
            this.description = description;
        }

        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
            buf.put((byte)92);
            buf.putInt(this.remoteid);
            buf.putInt(this.reasoncode);
            buf.putInt(this.description.length());
            buf.put(this.description.getBytes());
            buf.putInt(0);
            return true;
        }

        public void messageSent(Long sequenceNo) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sent SSH_MSG_CHANNEL_OPEN_FAILURE {} {} remote={}", (Object[])new Object[]{this.description, this.reasoncode, this.remoteid});
            }
        }
    }

    class GlobalRequestMessage
    implements SshMessage {
        GlobalRequest request;
        byte[] name;
        boolean wantReply;

        GlobalRequestMessage(GlobalRequest request, boolean wantReply) {
            try {
                this.request = request;
                this.name = request.getName().getBytes(TransportProtocol.CHARSET_ENCODING);
                this.wantReply = wantReply;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("System does not support " + TransportProtocol.CHARSET_ENCODING);
            }
        }

        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
            buf.put((byte)80);
            buf.putInt(this.name.length);
            buf.put(this.name);
            buf.put((byte)(this.wantReply ? 1 : 0));
            if (this.request.getData() != null) {
                buf.put(this.request.getData());
            }
            return true;
        }

        public void messageSent(Long sequenceNo) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Sent SSH_MSG_GLOBAL_REQUEST request=" + this.request.getName() + " wantReply=" + String.valueOf(this.wantReply)), (Object[])new Object[0]);
            }
        }
    }

    class ChannelOpenConfirmationMessage
    implements SshMessage {
        ChannelNG<T> channel;
        byte[] responsedata;

        ChannelOpenConfirmationMessage(ChannelNG<T> channel, byte[] responsedata) {
            this.channel = channel;
            this.responsedata = responsedata;
        }

        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
            buf.put((byte)91);
            buf.putInt(this.channel.remoteid);
            buf.putInt(this.channel.getLocalId());
            buf.put(ByteArrayWriter.encodeInt((UnsignedInteger32)this.channel.getLocalWindow()));
            buf.putInt(this.channel.getLocalPacket());
            if (this.responsedata != null) {
                buf.put(this.responsedata);
            }
            return true;
        }

        public void messageSent(Long sequenceNo) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Sent SSH_MSG_CHANNEL_OPEN_CONFIRMATION channel=" + this.channel.channelid + " remote=" + this.channel.remoteid), (Object[])new Object[0]);
            }
        }
    }

    class GlobalRequestSuccess
    implements SshMessage {
        byte[] responsedata;
        String name;

        GlobalRequestSuccess(String name, byte[] responsedata) {
            this.responsedata = responsedata;
            this.name = name;
        }

        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
            buf.put((byte)81);
            if (this.responsedata != null) {
                buf.put(this.responsedata);
            }
            return true;
        }

        public void messageSent(Long sequenceNo) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Sent SSH_MSG_GLOBAL_REQUEST_SUCCESS request=" + this.name), (Object[])new Object[0]);
            }
        }
    }

    class GlobalRequestFailure
    implements SshMessage {
        String name;

        public GlobalRequestFailure(String name) {
            this.name = name;
        }

        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
            buf.put((byte)82);
            return true;
        }

        public void messageSent(Long sequenceNo) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Sent SSH_MSG_GLOBAL_REQUEST_FAILURE request=" + this.name), (Object[])new Object[0]);
            }
        }
    }
}

