/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

import com.sshtools.common.command.ExecutableCommand;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.ssh.ChannelOpenException;
import com.sshtools.common.ssh.SessionChannel;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.Subsystem;
import com.sshtools.common.ssh.UnsupportedChannelException;
import com.sshtools.common.ssh.components.ComponentFactory;
import com.sshtools.synergy.ssh.ChannelFactory;
import com.sshtools.synergy.ssh.ChannelNG;
import com.sshtools.synergy.ssh.SshContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CompoundChannelFactory<C extends SshContext>
implements ChannelFactory<C> {
    private final List<ChannelFactory<C>> factories = new ArrayList<ChannelFactory<C>>();

    public CompoundChannelFactory() {
    }

    public CompoundChannelFactory(ChannelFactory<C> ... factories) {
        this.factories.addAll(Arrays.asList(factories));
    }

    public CompoundChannelFactory(Collection<ChannelFactory<C>> factories) {
        this.factories.addAll(factories);
    }

    public void addFactory(ChannelFactory<C> factory) {
        this.factories.add(factory);
    }

    public void removeFactory(ChannelFactory<C> factory) {
        this.factories.remove(factory);
    }

    public List<ChannelFactory<C>> getFactories() {
        return Collections.unmodifiableList(this.factories);
    }

    @Override
    public ComponentFactory<ExecutableCommand> supportedCommands() {
        return this.factories.get(0).supportedCommands();
    }

    @Override
    public ChannelNG<C> createChannel(String channeltype, SshConnection con) throws UnsupportedChannelException, PermissionDeniedException, ChannelOpenException {
        for (ChannelFactory<C> f : this.factories) {
            try {
                return f.createChannel(channeltype, con);
            }
            catch (UnsupportedChannelException unsupportedChannelException) {
            }
        }
        throw new UnsupportedChannelException(String.format("%s is not a supported channel type", channeltype));
    }

    @Override
    public Subsystem createSubsystem(String name, SessionChannel session) throws UnsupportedChannelException, PermissionDeniedException {
        for (ChannelFactory<C> f : this.factories) {
            try {
                return f.createSubsystem(name, session);
            }
            catch (UnsupportedChannelException unsupportedChannelException) {
            }
        }
        throw new UnsupportedChannelException(String.format("%s is not a supported subsystem", name));
    }

    @Override
    public ExecutableCommand executeCommand(SessionChannel channel, String[] args, Map<String, String> environment) throws PermissionDeniedException, UnsupportedChannelException {
        for (ChannelFactory<C> f : this.factories) {
            try {
                return f.executeCommand(channel, args, environment);
            }
            catch (UnsupportedChannelException unsupportedChannelException) {
            }
        }
        throw new UnsupportedChannelException(String.format("%s is not a supported command", args[0]));
    }
}

