/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.SessionChannelNG;
import com.sshtools.client.tasks.AbstractSessionTask;
import com.sshtools.common.shell.ShellPolicy;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.synergy.ssh.TerminalModes;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Optional;

public final class CommandTask
extends AbstractSessionTask<SessionChannelNG> {
    private final Optional<CommandTaskEvent> onClose;
    private final Optional<CommandTaskEvent> onBeforeExecute;
    private final Optional<CommandTaskEvent> onBeforeTask;
    private final Optional<CommandTaskEvent> onTask;
    private final String termType;
    private final int rows;
    private final int cols;
    private final boolean withPty;
    private final Optional<TerminalModes> modes;
    private final String command;
    private final String charset;
    private final boolean autoConsume;

    private CommandTask(CommandTaskBuilder builder) {
        super(builder);
        this.command = builder.command.orElseThrow(() -> new IllegalArgumentException("Command must be supplied"));
        this.charset = builder.encoding.map(Charset::name).orElse("UTF-8");
        this.autoConsume = builder.autoConsume;
        this.onClose = builder.onClose;
        this.onBeforeExecute = builder.onBeforeExecute;
        this.onTask = builder.onTask;
        this.onBeforeTask = builder.onBeforeTask;
        this.withPty = builder.withPty;
        this.termType = builder.termType.orElse("dumb");
        this.rows = builder.rows;
        this.cols = builder.cols;
        this.modes = builder.modes;
    }

    @Override
    protected final void onCloseSession(SessionChannelNG session) {
        this.onClose.ifPresent(c -> {
            try {
                c.commandEvent(this, session);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        });
    }

    public int getExitCode() {
        return ((SessionChannelNG)((Object)this.getSession())).getExitCode();
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    protected SessionChannelNG createSession(SshConnection con) {
        return new SessionChannelNG(((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMaxPacketSize(), ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMaxWindowSize(), ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMaxWindowSize(), ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMinWindowSize(), this.getChannelFuture(), this.autoConsume);
    }

    @Override
    protected final void onOpenSession(SessionChannelNG session) throws IOException {
        this.onBeforeTask.ifPresent(c -> {
            try {
                c.commandEvent(this, session);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        });
        this.onTask.ifPresent(c -> {
            try {
                c.commandEvent(this, session);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            finally {
                this.close();
            }
        });
    }

    @Override
    protected final void setupSession(SessionChannelNG session) {
        try {
            if (this.withPty) {
                if (this.modes.isEmpty()) {
                    session.allocatePseudoTerminal(this.termType, this.cols, this.rows);
                } else {
                    session.allocatePseudoTerminal(this.termType, this.cols, this.rows, 0, 0, this.modes.get());
                }
            }
            this.onBeforeExecute.ifPresent(c -> {
                try {
                    c.commandEvent(this, session);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            });
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        session.executeCommand(this.command, this.charset);
    }

    public static final class CommandTaskBuilder
    extends AbstractSessionTask.AbstractSessionTaskBuilder<CommandTaskBuilder, SessionChannelNG, CommandTask> {
        private Optional<CommandTaskEvent> onClose = Optional.empty();
        private Optional<CommandTaskEvent> onBeforeExecute = Optional.empty();
        private Optional<CommandTaskEvent> onBeforeTask = Optional.empty();
        private Optional<CommandTaskEvent> onTask = Optional.empty();
        private Optional<Charset> encoding = Optional.empty();
        private Optional<String> command = Optional.empty();
        private Optional<String> termType = Optional.empty();
        private int cols = 80;
        private int rows = 24;
        private boolean withPty = true;
        private Optional<TerminalModes> modes = Optional.empty();
        private boolean autoConsume;

        private CommandTaskBuilder() {
        }

        public CommandTaskBuilder withAutoConsume() {
            return this.withAutoConsume(true);
        }

        public CommandTaskBuilder withAutoConsume(boolean autoConsume) {
            this.autoConsume = autoConsume;
            return this;
        }

        public final CommandTaskBuilder withTermType(String termType) {
            return this.withTermType(Optional.of(termType));
        }

        public final CommandTaskBuilder withTermType(Optional<String> termType) {
            this.termType = termType;
            return this;
        }

        public final CommandTaskBuilder withColumns(int cols) {
            this.cols = cols;
            return this;
        }

        public final CommandTaskBuilder withRows(int rows) {
            this.rows = rows;
            return this;
        }

        public final CommandTaskBuilder withModes(TerminalModes modes) {
            this.modes = Optional.of(modes);
            return this;
        }

        public CommandTaskBuilder withPty(boolean withPty) {
            this.withPty = withPty;
            return this;
        }

        public CommandTaskBuilder withoutPty() {
            this.withPty = false;
            return this;
        }

        public CommandTaskBuilder withCommand(String command) {
            this.command = Optional.of(command);
            return this;
        }

        public CommandTaskBuilder withEncoding(String encoding) {
            if (encoding == null) {
                this.encoding = Optional.empty();
                return this;
            }
            return this.withEncoding(Charset.forName(encoding));
        }

        public CommandTaskBuilder withEncoding(Charset encoding) {
            this.encoding = Optional.of(encoding);
            return this;
        }

        public static CommandTaskBuilder create() {
            return new CommandTaskBuilder();
        }

        public final CommandTaskBuilder onBeforeExecute(CommandTaskEvent onBeforeExecute) {
            this.onBeforeExecute = Optional.of(onBeforeExecute);
            return this;
        }

        @Deprecated(since="3.2.0", forRemoval=true)
        public final CommandTaskBuilder onClose(CommandTaskEvent onClose) {
            this.onClose = Optional.of(onClose);
            return this;
        }

        public final CommandTaskBuilder onBeforeTask(CommandTaskEvent onOpen) {
            this.onBeforeTask = Optional.of(onOpen);
            return this;
        }

        public final CommandTaskBuilder onTask(CommandTaskEvent onExecute) {
            this.onTask = Optional.of(onExecute);
            return this;
        }

        @Override
        public CommandTask build() {
            return new CommandTask(this);
        }
    }

    @FunctionalInterface
    public static interface CommandTaskEvent {
        public void commandEvent(CommandTask var1, SessionChannelNG var2) throws Exception;
    }
}

