/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.SessionChannelNG;
import com.sshtools.client.SshClientContext;
import com.sshtools.common.shell.ShellPolicy;
import com.sshtools.common.ssh.Channel;
import com.sshtools.common.ssh.ChannelEventListener;
import com.sshtools.common.ssh.ChannelRequestFuture;
import com.sshtools.common.ssh.SessionChannel;
import com.sshtools.synergy.ssh.ChannelNG;
import com.sshtools.synergy.ssh.Connection;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AsyncSessionTask
implements Runnable {
    Connection<SshClientContext> con;
    long timeout = 10000L;
    SessionChannelNG session;
    ChannelRequestFuture future;
    String channelName = "session";

    public AsyncSessionTask(Connection<SshClientContext> con, ChannelRequestFuture future) {
        this.con = con;
        this.future = future;
    }

    public AsyncSessionTask(Connection<SshClientContext> con) {
        this(con, new ChannelRequestFuture());
    }

    protected boolean isAllocatePseudoTerminal() {
        return true;
    }

    public void disconnect() {
        this.con.disconnect();
    }

    public ChannelRequestFuture getChannelFuture() {
        return this.future;
    }

    @Override
    public void run() {
        this.session = new SessionChannelNG(this.channelName, ((ShellPolicy)((SshClientContext)this.con.getContext()).getPolicy(ShellPolicy.class)).getSessionMaxPacketSize(), ((ShellPolicy)((SshClientContext)this.con.getContext()).getPolicy(ShellPolicy.class)).getSessionMaxWindowSize(), ((ShellPolicy)((SshClientContext)this.con.getContext()).getPolicy(ShellPolicy.class)).getSessionMaxWindowSize(), ((ShellPolicy)((SshClientContext)this.con.getContext()).getPolicy(ShellPolicy.class)).getSessionMinWindowSize(), this.future, false);
        this.session.addEventListener(new ChannelEventListener(){

            public void onChannelClose(Channel channel) {
                AsyncSessionTask.this.onCloseSession((SessionChannel)channel);
            }
        });
        this.con.getConnectionProtocol().openChannel((ChannelNG)this.session);
        if (!this.session.getOpenFuture().waitFor(this.timeout).isSuccess()) {
            throw new IllegalStateException("Could not open session channel");
        }
        this.setupSession(this.session);
        this.onOpenSession(this.session);
    }

    protected int getBufferSize() {
        return 65535;
    }

    public OutputStream getOutputStream() {
        return this.session.getOutputStream();
    }

    public InputStream getInputStream() {
        return this.session.getInputStream();
    }

    protected abstract void setupSession(SessionChannel var1);

    protected abstract void onOpenSession(SessionChannel var1);

    protected abstract void onCloseSession(SessionChannel var1);

    public void close() {
        this.session.close();
    }
}

